/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument.receivers;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.apache.accumulo.trace.instrument.receivers.AsyncSpanReceiver;
import org.apache.accumulo.trace.thrift.RemoteSpan;
import org.apache.accumulo.trace.thrift.SpanReceiver;
import org.apache.log4j.Logger;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class SendSpansViaThrift
extends AsyncSpanReceiver<String, SpanReceiver.Client> {
    private static final Logger log = Logger.getLogger(SendSpansViaThrift.class);
    private static final String THRIFT = "thrift://";

    public SendSpansViaThrift(String host, String service, long millis) {
        super(host, service, millis);
    }

    @Override
    protected SpanReceiver.Client createDestination(String destination) throws Exception {
        if (destination == null) {
            return null;
        }
        try {
            String[] hostAddr = destination.split(":", 2);
            log.debug((Object)("Connecting to " + hostAddr[0] + ":" + hostAddr[1]));
            InetSocketAddress addr = new InetSocketAddress(hostAddr[0], Integer.parseInt(hostAddr[1]));
            Socket sock = new Socket();
            sock.connect(addr);
            TSocket transport = new TSocket(sock);
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)transport);
            return new SpanReceiver.Client((TProtocol)prot);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    @Override
    protected void send(SpanReceiver.Client client, RemoteSpan s) throws Exception {
        if (client != null) {
            try {
                client.span(s);
            }
            catch (Exception ex) {
                client.getInputProtocol().getTransport().close();
                client = null;
            }
        }
    }

    @Override
    protected String getSpanKey(Map<String, String> data) {
        String hostAddress;
        String[] hostAddr;
        String dest = data.get("dest");
        if (dest != null && dest.startsWith(THRIFT) && (hostAddr = (hostAddress = dest.substring(THRIFT.length())).split(":", 2)).length == 2) {
            return hostAddress;
        }
        return null;
    }
}

