/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.dynamic;

import com.google.protobuf.DescriptorProtos;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.protobuf.MetaProto;

public class EnumDefinition {
    private DescriptorProtos.EnumDescriptorProto mEnumType;

    public static Builder newBuilder(String enumName) {
        return EnumDefinition.newBuilder(enumName, null, null);
    }

    public static Builder newBuilder(String enumName, Boolean allowAlias, Boolean isDeprecated) {
        return new Builder(enumName, allowAlias, isDeprecated);
    }

    public String toString() {
        return this.mEnumType.toString();
    }

    DescriptorProtos.EnumDescriptorProto getEnumType() {
        return this.mEnumType;
    }

    private EnumDefinition(DescriptorProtos.EnumDescriptorProto enumType) {
        this.mEnumType = enumType;
    }

    public static class Builder {
        private DescriptorProtos.EnumDescriptorProto.Builder mEnumTypeBuilder = DescriptorProtos.EnumDescriptorProto.newBuilder();

        public String getName() {
            return this.mEnumTypeBuilder.getName();
        }

        public Builder addValue(String name, int num) {
            return this.addValue(name, num, null, null);
        }

        public Builder addValue(String name, int num, ProtobufSchema.ProtobufMeta meta, Boolean isDeprecated) {
            MetaProto.Meta m4;
            DescriptorProtos.EnumValueDescriptorProto.Builder enumValBuilder = DescriptorProtos.EnumValueDescriptorProto.newBuilder();
            enumValBuilder.setName(name).setNumber(num);
            if (isDeprecated != null) {
                DescriptorProtos.EnumValueOptions.Builder optionsBuilder = DescriptorProtos.EnumValueOptions.newBuilder();
                optionsBuilder.setDeprecated(isDeprecated);
                enumValBuilder.mergeOptions(optionsBuilder.build());
            }
            if ((m4 = DynamicSchema.toMeta(meta)) != null) {
                DescriptorProtos.EnumValueOptions.Builder optionsBuilder = DescriptorProtos.EnumValueOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.enumValueMeta, m4);
                enumValBuilder.mergeOptions(optionsBuilder.build());
            }
            this.mEnumTypeBuilder.addValue(enumValBuilder.build());
            return this;
        }

        public Builder addReservedName(String reservedName) {
            this.mEnumTypeBuilder.addReservedName(reservedName);
            return this;
        }

        public Builder addReservedRange(int start, int end) {
            DescriptorProtos.EnumDescriptorProto.EnumReservedRange.Builder rangeBuilder = DescriptorProtos.EnumDescriptorProto.EnumReservedRange.newBuilder();
            rangeBuilder.setStart(start).setEnd(end);
            this.mEnumTypeBuilder.addReservedRange(rangeBuilder.build());
            return this;
        }

        public Builder setMeta(ProtobufSchema.ProtobufMeta meta) {
            MetaProto.Meta m4 = DynamicSchema.toMeta(meta);
            if (m4 != null) {
                DescriptorProtos.EnumOptions.Builder optionsBuilder = DescriptorProtos.EnumOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.enumMeta, m4);
                this.mEnumTypeBuilder.mergeOptions(optionsBuilder.build());
            }
            return this;
        }

        public EnumDefinition build() {
            return new EnumDefinition(this.mEnumTypeBuilder.build());
        }

        private Builder(String enumName, Boolean allowAlias, Boolean isDeprecated) {
            DescriptorProtos.EnumOptions.Builder optionsBuilder;
            this.mEnumTypeBuilder.setName(enumName);
            if (allowAlias != null) {
                optionsBuilder = DescriptorProtos.EnumOptions.newBuilder();
                optionsBuilder.setAllowAlias(allowAlias);
                this.mEnumTypeBuilder.mergeOptions(optionsBuilder.build());
            }
            if (isDeprecated != null) {
                optionsBuilder = DescriptorProtos.EnumOptions.newBuilder();
                optionsBuilder.setDeprecated(isDeprecated);
                this.mEnumTypeBuilder.mergeOptions(optionsBuilder.build());
            }
        }
    }
}

