/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.QueryServiceClient;
import com.google.cloud.monitoring.v3.stub.GrpcQueryServiceCallableFactory;
import com.google.cloud.monitoring.v3.stub.QueryServiceStub;
import com.google.cloud.monitoring.v3.stub.QueryServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.monitoring.v3.QueryTimeSeriesRequest;
import com.google.monitoring.v3.QueryTimeSeriesResponse;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcQueryServiceStub
extends QueryServiceStub {
    private static final MethodDescriptor<QueryTimeSeriesRequest, QueryTimeSeriesResponse> queryTimeSeriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.QueryService/QueryTimeSeries").setRequestMarshaller(ProtoUtils.marshaller(QueryTimeSeriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(QueryTimeSeriesResponse.getDefaultInstance())).build();
    private final UnaryCallable<QueryTimeSeriesRequest, QueryTimeSeriesResponse> queryTimeSeriesCallable;
    private final UnaryCallable<QueryTimeSeriesRequest, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcQueryServiceStub create(QueryServiceStubSettings settings) throws IOException {
        return new GrpcQueryServiceStub(settings, ClientContext.create(settings));
    }

    public static final GrpcQueryServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcQueryServiceStub(QueryServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcQueryServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcQueryServiceStub(QueryServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcQueryServiceStub(QueryServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcQueryServiceCallableFactory());
    }

    protected GrpcQueryServiceStub(QueryServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<QueryTimeSeriesRequest, QueryTimeSeriesResponse> queryTimeSeriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryTimeSeriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.queryTimeSeriesCallable = callableFactory.createUnaryCallable(queryTimeSeriesTransportSettings, settings.queryTimeSeriesSettings(), clientContext);
        this.queryTimeSeriesPagedCallable = callableFactory.createPagedCallable(queryTimeSeriesTransportSettings, settings.queryTimeSeriesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<QueryTimeSeriesRequest, QueryTimeSeriesResponse> queryTimeSeriesCallable() {
        return this.queryTimeSeriesCallable;
    }

    @Override
    public UnaryCallable<QueryTimeSeriesRequest, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesPagedCallable() {
        return this.queryTimeSeriesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

