/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ErrorDetails;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.OutOfRangeException;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.storage.AsyncStorageTaskException;
import com.google.cloud.storage.BidiAppendableWrite;
import com.google.cloud.storage.BidiWriteCtx;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.MaxRedirectsExceededException;
import com.google.cloud.storage.ResumableSessionFailureScenario;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import com.google.storage.v2.AppendObjectSpec;
import com.google.storage.v2.BidiWriteHandle;
import com.google.storage.v2.BidiWriteObjectRedirectedError;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.GetObjectRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class GapicBidiUnbufferedAppendableWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write;
    private final UnaryCallable<GetObjectRequest, com.google.storage.v2.Object> get;
    private final Retrying.RetrierWithAlg retrier;
    private final SettableApiFuture<BidiWriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final BidiWriteCtx<BidiAppendableWrite> writeCtx;
    private final GrpcCallContext context;
    private final RedirectHandlingResponseObserver responseObserver;
    private volatile ApiStreamObserver<BidiWriteObjectRequest> stream;
    private boolean open = true;
    private boolean first = true;
    private boolean redirecting = false;
    volatile boolean retry = false;
    private long begin;
    private volatile BidiWriteObjectRequest lastWrittenRequest;
    private final AtomicInteger redirectCounter;
    private final int maxRedirectsAllowed = 3;
    private final AtomicReference<@Nullable BidiWriteHandle> bidiWriteHandle = new AtomicReference();
    private final AtomicReference<@Nullable String> routingToken = new AtomicReference();
    private final AtomicLong generation = new AtomicLong();
    private final ReentrantLock lock = new ReentrantLock();
    private final Supplier<GrpcCallContext> baseContextSupplier;
    private volatile List<BidiWriteObjectRequest> messages;

    GapicBidiUnbufferedAppendableWritableByteChannel(BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write, UnaryCallable<GetObjectRequest, com.google.storage.v2.Object> get, Retrying.RetrierWithAlg retrier, SettableApiFuture<BidiWriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, BidiWriteCtx<BidiAppendableWrite> writeCtx, Supplier<GrpcCallContext> baseContextSupplier) {
        this.write = write;
        this.get = get;
        this.retrier = retrier;
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        this.writeCtx = writeCtx;
        this.responseObserver = new RedirectHandlingResponseObserver(new BidiObserver());
        this.baseContextSupplier = baseContextSupplier;
        this.context = baseContextSupplier.get().withExtraHeaders((Map)this.getHeaders());
        this.redirectCounter = new AtomicInteger();
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        return this.internalWrite(srcs, srcsOffset, srcsLength);
    }

    @Override
    public long writeAndClose(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long written = this.internalWrite(srcs, offset, length);
        this.close();
        return written;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        try {
            if (this.stream != null) {
                this.stream.onCompleted();
                this.responseObserver.await();
            }
        }
        finally {
            this.open = false;
            this.stream = null;
            this.lastWrittenRequest = null;
        }
    }

    public void finalizeWrite() throws IOException {
        BidiWriteObjectRequest message;
        if (this.stream == null) {
            this.restart();
        }
        this.lastWrittenRequest = message = this.finishMessage();
        this.begin = this.writeCtx.getConfirmedBytes().get();
        this.messages = Collections.singletonList(message);
        this.flush();
        this.close();
    }

    @VisibleForTesting
    void restart() {
        Preconditions.checkState(this.stream == null, "attempting to restart stream when stream is already active");
        ReconnectArguments reconnectArguments = this.getReconnectArguments();
        BidiWriteObjectRequest req = reconnectArguments.getReq();
        if (!this.resultFuture.isDone()) {
            ApiStreamObserver<BidiWriteObjectRequest> requestStream1 = this.openedStream(reconnectArguments.getCtx());
            if (req != null) {
                requestStream1.onNext(req);
                this.lastWrittenRequest = req;
                this.responseObserver.await();
                this.first = false;
            } else {
                this.first = true;
            }
        }
    }

    public void startAppendableTakeoverStream() {
        BidiWriteObjectRequest req = this.writeCtx.newRequestBuilder().setFlush(true).setStateLookup(true).build();
        this.generation.set(req.getAppendObjectSpec().getGeneration());
        this.messages = Collections.singletonList(req);
        this.flush();
        this.first = false;
    }

    @VisibleForTesting
    BidiWriteCtx<BidiAppendableWrite> getWriteCtx() {
        return this.writeCtx;
    }

    private long internalWrite(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws ClosedChannelException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        this.begin = this.writeCtx.getConfirmedBytes().get();
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength, true);
        if (data.length == 0) {
            return 0L;
        }
        ImmutableList.Builder messages = new ImmutableList.Builder();
        for (int i = 0; i < data.length; ++i) {
            ChunkSegmenter.ChunkSegment datum = data[i];
            Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
            ByteString b = datum.getB();
            int contentSize = b.size();
            long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
            ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
            if (crc32c != null) {
                checksummedData.setCrc32C(crc32c.getValue());
            }
            BidiWriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder();
            if (!this.first) {
                builder.clearUploadId();
                builder.clearObjectChecksums();
                builder.clearWriteObjectSpec();
                builder.clearAppendObjectSpec();
            } else {
                this.first = false;
            }
            builder.setWriteOffset(offset).setChecksummedData(checksummedData.build());
            if (i == data.length - 1) {
                builder.setFlush(true).setStateLookup(true);
            }
            BidiWriteObjectRequest build = builder.build();
            messages.add(build);
        }
        this.messages = messages.build();
        try {
            this.flush();
        }
        catch (Exception e) {
            this.open = false;
            this.resultFuture.setException(e);
            throw e;
        }
        long end = this.writeCtx.getConfirmedBytes().get();
        long bytesConsumed = end - this.begin;
        return bytesConsumed;
    }

    private @NonNull BidiWriteObjectRequest finishMessage() {
        long offset = this.writeCtx.getTotalSentBytes().get();
        BidiWriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder();
        b.clearUploadId().clearObjectChecksums().clearWriteObjectSpec().clearAppendObjectSpec();
        b.setFinishWrite(true).setWriteOffset(offset);
        BidiWriteObjectRequest message = b.build();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiStreamObserver<BidiWriteObjectRequest> openedStream(@Nullable GrpcCallContext context) {
        if (this.stream == null) {
            GapicBidiUnbufferedAppendableWritableByteChannel gapicBidiUnbufferedAppendableWritableByteChannel = this;
            synchronized (gapicBidiUnbufferedAppendableWritableByteChannel) {
                if (this.stream == null) {
                    this.responseObserver.reset();
                    this.stream = new GracefulOutboundStream(this.write.bidiStreamingCall(this.responseObserver, context));
                }
            }
        }
        return this.stream;
    }

    private void flush() {
        this.retrier.run(() -> {
            if (this.retry) {
                this.retry = false;
                this.restart();
                this.processRetryingMessages();
                if (this.messages.isEmpty()) {
                    return null;
                }
            }
            try {
                ApiStreamObserver<BidiWriteObjectRequest> opened = this.openedStream(this.context);
                for (BidiWriteObjectRequest message : this.messages) {
                    opened.onNext(message);
                    this.lastWrittenRequest = message;
                }
                if (this.lastWrittenRequest.getFinishWrite()) {
                    opened.onCompleted();
                }
                this.responseObserver.await();
                return null;
            }
            catch (Throwable t2) {
                this.retry = true;
                this.stream = null;
                t2.addSuppressed(new AsyncStorageTaskException());
                throw t2;
            }
        }, Conversions.Decoder.identity());
    }

    private void processRetryingMessages() {
        ImmutableList.Builder segmentsToRetry = new ImmutableList.Builder();
        long confirmed = this.writeCtx.getConfirmedBytes().get();
        long bytesSeen = this.begin;
        boolean caughtUp = false;
        for (BidiWriteObjectRequest message : this.messages) {
            if (message.hasAppendObjectSpec() && this.first) continue;
            if (message.hasWriteObjectSpec() && this.redirecting) {
                message = message.toBuilder().clearWriteObjectSpec().clearObjectChecksums().build();
            }
            if (!caughtUp) {
                if ((bytesSeen += (long)message.getChecksummedData().getContent().size()) <= confirmed) continue;
                ByteString before = message.getChecksummedData().getContent();
                long beforeSize = before.size();
                if (bytesSeen - confirmed != beforeSize) {
                    long delta = bytesSeen - confirmed;
                    int bytesToSkip = Math.toIntExact(beforeSize - delta);
                    ByteString after = before.substring(bytesToSkip);
                    if (after.size() == 0) continue;
                    message = message.toBuilder().setChecksummedData(ChecksummedData.newBuilder().setContent(after).build()).setWriteOffset(confirmed).build();
                }
                caughtUp = true;
            }
            segmentsToRetry.add(message);
        }
        this.messages = segmentsToRetry.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReconnectArguments getReconnectArguments() {
        this.lock.lock();
        try {
            long generation;
            BidiWriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder();
            AppendObjectSpec.Builder spec = b.hasAppendObjectSpec() ? b.getAppendObjectSpec().toBuilder() : AppendObjectSpec.newBuilder().setBucket(b.getWriteObjectSpec().getResource().getBucket()).setObject(b.getWriteObjectSpec().getResource().getName());
            b.clearWriteObjectSpec();
            String routingToken = this.routingToken.get();
            if (routingToken != null) {
                spec.setRoutingToken(routingToken);
            }
            if ((generation = this.generation.get()) > 0L) {
                spec.setGeneration(generation);
            } else {
                GetObjectRequest req = GetObjectRequest.newBuilder().setBucket(spec.getBucket()).setObject(spec.getObject()).setReadMask(FieldMask.newBuilder().addPaths(Storage.BlobField.GENERATION.getGrpcName()).build()).build();
                boolean objectNotFound = false;
                try {
                    this.retrier.run(() -> {
                        this.generation.set(this.get.call(req).getGeneration());
                        return null;
                    }, Conversions.Decoder.identity());
                }
                catch (Throwable t2) {
                    if (t2.getCause() instanceof NotFoundException) {
                        objectNotFound = true;
                    }
                    t2.addSuppressed(new AsyncStorageTaskException());
                    throw t2;
                }
                generation = this.generation.get();
                if (generation > 0L) {
                    spec.setGeneration(generation);
                } else if (objectNotFound) {
                    ReconnectArguments reconnectArguments = ReconnectArguments.of((GrpcCallContext)this.baseContextSupplier.get().withExtraHeaders((Map)this.getHeaders()), null);
                    return reconnectArguments;
                }
            }
            BidiWriteHandle bidiWriteHandle = this.bidiWriteHandle.get();
            if (bidiWriteHandle != null) {
                spec.setWriteHandle(bidiWriteHandle);
            }
            b.setAppendObjectSpec(spec.build());
            b.setFlush(true).setStateLookup(true);
            ReconnectArguments reconnectArguments = ReconnectArguments.of((GrpcCallContext)this.baseContextSupplier.get().withExtraHeaders((Map)this.getHeaders()), b.build());
            return reconnectArguments;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Map<String, List<String>> getHeaders() {
        return ImmutableMap.of("x-goog-request-params", ImmutableList.of(Stream.of("bucket=" + this.writeCtx.getRequestFactory().bucketName(), "appendable=true", this.routingToken.get() != null ? "routing_token=" + this.routingToken.get() : null).filter(Objects::nonNull).collect(Collectors.joining("&"))));
    }

    private final class RedirectHandlingResponseObserver
    implements ApiStreamObserver<BidiWriteObjectResponse> {
        private final BidiObserver delegate;

        private RedirectHandlingResponseObserver(BidiObserver delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onNext(BidiWriteObjectResponse response) {
            GapicBidiUnbufferedAppendableWritableByteChannel.this.redirectCounter.set(0);
            this.delegate.onNext(response);
        }

        @Override
        public void onError(Throwable t2) {
            BidiWriteObjectRedirectedError error = GrpcUtils.getBidiWriteObjectRedirectedError(t2);
            if (error == null) {
                this.delegate.onError(t2);
                return;
            }
            GapicBidiUnbufferedAppendableWritableByteChannel.this.redirecting = true;
            GapicBidiUnbufferedAppendableWritableByteChannel.this.stream = null;
            int redirectCount = GapicBidiUnbufferedAppendableWritableByteChannel.this.redirectCounter.incrementAndGet();
            if (redirectCount > 3) {
                GapicBidiUnbufferedAppendableWritableByteChannel.this.redirecting = false;
                t2.addSuppressed(new MaxRedirectsExceededException(3, redirectCount));
                this.delegate.onError(t2);
                GapicBidiUnbufferedAppendableWritableByteChannel.this.resultFuture.setException(t2);
                return;
            }
            if (error.hasWriteHandle()) {
                GapicBidiUnbufferedAppendableWritableByteChannel.this.bidiWriteHandle.set(error.getWriteHandle());
            }
            if (error.hasRoutingToken()) {
                GapicBidiUnbufferedAppendableWritableByteChannel.this.routingToken.set(error.getRoutingToken());
            }
            if (error.hasGeneration()) {
                GapicBidiUnbufferedAppendableWritableByteChannel.this.generation.set(error.getGeneration());
            }
            this.delegate.onError(t2);
        }

        public void await() {
            this.delegate.await();
        }

        public void reset() {
            this.delegate.reset();
        }

        @Override
        public void onCompleted() {
            this.delegate.onCompleted();
        }
    }

    private class BidiObserver
    implements ApiStreamObserver<BidiWriteObjectResponse> {
        private final Semaphore sem = new Semaphore(0);
        private volatile BidiWriteObjectResponse lastResponseWithResource;
        private volatile StorageException clientDetectedError;
        private volatile RuntimeException previousError;

        private BidiObserver() {
        }

        @Override
        public void onNext(BidiWriteObjectResponse value) {
            boolean firstResponse;
            if (value.hasWriteHandle()) {
                GapicBidiUnbufferedAppendableWritableByteChannel.this.bidiWriteHandle.set(value.getWriteHandle());
            }
            if (GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest.hasAppendObjectSpec() && GapicBidiUnbufferedAppendableWritableByteChannel.this.first) {
                long persistedSize = value.hasPersistedSize() ? value.getPersistedSize() : value.getResource().getSize();
                GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getTotalSentBytes().set(persistedSize);
                this.ok(value);
                return;
            }
            boolean finalizing = GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest.getFinishWrite();
            boolean bl = firstResponse = !finalizing && value.hasResource();
            if (firstResponse) {
                GapicBidiUnbufferedAppendableWritableByteChannel.this.generation.set(value.getResource().getGeneration());
            }
            if (!finalizing && (firstResponse || value.hasPersistedSize())) {
                long persistedSize;
                long totalSentBytes = GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                long l = persistedSize = firstResponse ? value.getResource().getSize() : value.getPersistedSize();
                if (GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest.hasAppendObjectSpec()) {
                    GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                    this.ok(value);
                } else if (totalSentBytes == persistedSize) {
                    GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                    this.ok(value);
                } else if (persistedSize < totalSentBytes) {
                    GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                    this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_9.toStorageException(ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest), value, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, null));
                } else {
                    this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_7.toStorageException(ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest), value, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, null));
                }
            } else if (finalizing && value.hasResource()) {
                long finalSize;
                long totalSentBytes = GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                if (totalSentBytes == (finalSize = value.getResource().getSize())) {
                    GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(finalSize);
                    this.ok(value);
                } else if (finalSize < totalSentBytes) {
                    this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_4_1.toStorageException(ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest), value, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, null));
                } else {
                    this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_4_2.toStorageException(ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest), value, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, null));
                }
            } else if (finalizing && value.hasPersistedSize()) {
                long persistedSize;
                long totalSentBytes = GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                if (totalSentBytes == (persistedSize = value.getPersistedSize())) {
                    GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                } else if (persistedSize < totalSentBytes) {
                    this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_3.toStorageException(ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest), value, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, null));
                } else {
                    this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_2.toStorageException(ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest), value, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, null));
                }
            } else {
                this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_0.toStorageException(ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest), value, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, null));
            }
        }

        @Override
        public void onError(Throwable t2) {
            OutOfRangeException oore;
            ErrorDetails ed;
            if (t2 instanceof OutOfRangeException && ((ed = (oore = (OutOfRangeException)t2).getErrorDetails()) == null || ed.getErrorInfo() == null || !ed.getErrorInfo().getReason().equals("GRPC_MISMATCHED_UPLOAD_SIZE"))) {
                this.clientDetectedError(ResumableSessionFailureScenario.SCENARIO_5.toStorageException(ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest), null, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, oore));
                return;
            }
            if (t2 instanceof ApiException) {
                StorageException tmp = StorageException.asStorageException((ApiException)t2);
                this.previousError = ResumableSessionFailureScenario.toStorageException(tmp.getCode(), tmp.getMessage(), tmp.getReason(), GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest != null ? ImmutableList.of(GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest) : ImmutableList.of(), null, GapicBidiUnbufferedAppendableWritableByteChannel.this.context, t2);
                this.sem.release();
            } else if (t2 instanceof RuntimeException) {
                this.previousError = (RuntimeException)t2;
                this.sem.release();
            }
        }

        @Override
        public void onCompleted() {
            if (this.lastResponseWithResource != null) {
                BidiWriteObjectResponse.Builder withSize = this.lastResponseWithResource.toBuilder();
                withSize.getResourceBuilder().setSize(GapicBidiUnbufferedAppendableWritableByteChannel.this.writeCtx.getConfirmedBytes().longValue());
                GapicBidiUnbufferedAppendableWritableByteChannel.this.resultFuture.set(withSize.build());
            }
            this.sem.release();
        }

        private void ok(BidiWriteObjectResponse value) {
            if (value.hasResource()) {
                this.lastResponseWithResource = value;
            }
            GapicBidiUnbufferedAppendableWritableByteChannel.this.first = false;
            this.sem.release();
        }

        private void clientDetectedError(StorageException storageException) {
            this.clientDetectedError = storageException;
            if (this.previousError != null && this.previousError != storageException) {
                storageException.addSuppressed(this.previousError);
                this.previousError = null;
            }
            if (this.previousError == null) {
                this.previousError = storageException;
            }
            this.sem.release();
        }

        void await() {
            try {
                this.sem.acquire();
            }
            catch (InterruptedException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            StorageException e = this.clientDetectedError;
            RuntimeException err = this.previousError;
            this.clientDetectedError = null;
            this.previousError = null;
            if ((e != null || err != null) && GapicBidiUnbufferedAppendableWritableByteChannel.this.stream != null && GapicBidiUnbufferedAppendableWritableByteChannel.this.lastWrittenRequest.getFinishWrite()) {
                GapicBidiUnbufferedAppendableWritableByteChannel.this.stream.onCompleted();
            }
            if (e != null) {
                throw e;
            }
            if (err != null) {
                throw err;
            }
        }

        public void reset() {
            this.sem.drainPermits();
            this.lastResponseWithResource = null;
            this.clientDetectedError = null;
            this.previousError = null;
        }
    }

    static final class ReconnectArguments {
        private final GrpcCallContext ctx;
        private final BidiWriteObjectRequest req;

        private ReconnectArguments(GrpcCallContext ctx, BidiWriteObjectRequest req) {
            this.ctx = ctx;
            this.req = req;
        }

        public GrpcCallContext getCtx() {
            return this.ctx;
        }

        public BidiWriteObjectRequest getReq() {
            return this.req;
        }

        public static ReconnectArguments of(GrpcCallContext ctx, BidiWriteObjectRequest req) {
            return new ReconnectArguments(ctx, req);
        }
    }

    private static final class GracefulOutboundStream
    implements ApiStreamObserver<BidiWriteObjectRequest> {
        private final ApiStreamObserver<BidiWriteObjectRequest> delegate;
        private volatile boolean closing;

        private GracefulOutboundStream(ApiStreamObserver<BidiWriteObjectRequest> delegate) {
            this.delegate = delegate;
            this.closing = false;
        }

        @Override
        public void onNext(BidiWriteObjectRequest value) {
            this.delegate.onNext(value);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.closing) {
                return;
            }
            this.closing = true;
            this.delegate.onError(t2);
        }

        @Override
        public void onCompleted() {
            if (this.closing) {
                return;
            }
            this.closing = true;
            this.delegate.onCompleted();
        }
    }
}

