/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.spi.v1;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Data;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.BucketAccessControls;
import com.google.api.services.storage.model.Buckets;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.HmacKey;
import com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.api.services.storage.model.HmacKeysMetadata;
import com.google.api.services.storage.model.Notification;
import com.google.api.services.storage.model.Notifications;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.ObjectAccessControls;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.Policy;
import com.google.api.services.storage.model.RewriteResponse;
import com.google.api.services.storage.model.ServiceAccount;
import com.google.api.services.storage.model.StorageObject;
import com.google.api.services.storage.model.TestIamPermissionsResponse;
import com.google.cloud.Tuple;
import com.google.cloud.http.CensusHttpModule;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.HttpRpcContext;
import com.google.cloud.storage.spi.v1.HttpStorageRpcSpans;
import com.google.cloud.storage.spi.v1.RpcBatch;
import com.google.cloud.storage.spi.v1.StorageRpc;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.base.Function;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableMap;
import org.apache.pinot.shaded.com.google.common.collect.Iterables;
import org.apache.pinot.shaded.com.google.common.collect.Lists;
import org.apache.pinot.shaded.com.google.common.hash.HashFunction;
import org.apache.pinot.shaded.com.google.common.hash.Hashing;
import org.apache.pinot.shaded.com.google.common.io.BaseEncoding;

public class HttpStorageRpc
implements StorageRpc {
    public static final String DEFAULT_PROJECTION = "full";
    public static final String NO_ACL_PROJECTION = "noAcl";
    private static final String ENCRYPTION_KEY_PREFIX = "x-goog-encryption-";
    private static final String SOURCE_ENCRYPTION_KEY_PREFIX = "x-goog-copy-source-encryption-";
    private static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final boolean IS_RECORD_EVENTS = true;
    private static final String X_GOOG_GCS_IDEMPOTENCY_TOKEN = "x-goog-gcs-idempotency-token";
    private final StorageOptions options;
    private final Storage storage;
    private final Tracer tracer = Tracing.getTracer();
    private final HttpRequestInitializer batchRequestInitializer;
    private static final long MEGABYTE = 0x100000L;
    private static final FileNameMap FILE_NAME_MAP = URLConnection.getFileNameMap();

    public HttpStorageRpc(StorageOptions options) {
        this(options, new JacksonFactory());
    }

    public HttpStorageRpc(StorageOptions options, JsonFactory jsonFactory) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer(options);
        this.options = options;
        boolean isTm = Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(ste -> ste.getClassName().startsWith("com.google.cloud.storage.transfermanager"));
        String tm = isTm ? "gccl-gcs-cmd/tm" : null;
        String applicationName = options.getApplicationName();
        CensusHttpModule censusHttpModule = new CensusHttpModule(this.tracer, true);
        initializer = censusHttpModule.getHttpRequestInitializer(initializer);
        initializer = new InvocationIdInitializer(initializer, applicationName, tm);
        this.batchRequestInitializer = censusHttpModule.getHttpRequestInitializer(null);
        this.storage = new Storage.Builder(transport, jsonFactory, initializer).setRootUrl(options.getHost()).setApplicationName(applicationName).build();
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    private static <T> JsonBatchCallback<T> toJsonCallback(final RpcBatch.Callback<T> callback) {
        return new JsonBatchCallback<T>(){

            @Override
            public void onSuccess(T response, HttpHeaders httpHeaders) throws IOException {
                callback.onSuccess(response);
            }

            @Override
            public void onFailure(GoogleJsonError googleJsonError, HttpHeaders httpHeaders) throws IOException {
                callback.onFailure(googleJsonError);
            }
        };
    }

    private static StorageException translate(IOException exception) {
        return StorageException.translate(exception);
    }

    private static StorageException translate(GoogleJsonError exception) {
        return new StorageException(exception);
    }

    private static void setEncryptionHeaders(HttpHeaders headers, String headerPrefix, Map<StorageRpc.Option, ?> options) {
        String key = StorageRpc.Option.CUSTOMER_SUPPLIED_KEY.getString(options);
        if (key != null) {
            BaseEncoding base64 = BaseEncoding.base64();
            HashFunction hashFunction = Hashing.sha256();
            headers.set(headerPrefix + "algorithm", "AES256");
            headers.set(headerPrefix + "key", key);
            headers.set(headerPrefix + "key-sha256", base64.encode(hashFunction.hashBytes(base64.decode(key)).asBytes()));
        }
    }

    private Span startSpan(String spanName) {
        return this.tracer.spanBuilder(spanName).setRecordEvents(true).startSpan();
    }

    @Override
    public Bucket create(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_BUCKET);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Buckets.Insert insert = this.storage.buckets().insert(this.options.getProjectId(), bucket).setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setPredefinedDefaultObjectAcl(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).setEnableObjectRetention(StorageRpc.Option.ENABLE_OBJECT_RETENTION.getBoolean(options));
            HttpStorageRpc.setExtraHeaders(insert, options);
            Bucket bucket2 = (Bucket)insert.execute();
            return bucket2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public StorageObject create(StorageObject storageObject, InputStream content, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.Insert insert = this.storage.objects().insert(storageObject.getBucket(), storageObject, new InputStreamContent(HttpStorageRpc.detectContentType(storageObject, options), content));
            insert.getMediaHttpUploader().setDirectUploadEnabled(true);
            Boolean disableGzipContent = StorageRpc.Option.IF_DISABLE_GZIP_CONTENT.getBoolean(options);
            if (disableGzipContent != null) {
                insert.setDisableGZipContent(disableGzipContent);
            }
            HttpStorageRpc.setEncryptionHeaders(insert.getRequestHeaders(), ENCRYPTION_KEY_PREFIX, options);
            HttpStorageRpc.setExtraHeaders(insert, options);
            StorageObject storageObject2 = (StorageObject)insert.setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).setKmsKeyName(StorageRpc.Option.KMS_KEY_NAME.getString(options)).execute();
            return storageObject2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Tuple<String, Iterable<Bucket>> list(Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_BUCKETS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Buckets.List list = this.storage.buckets().list(this.options.getProjectId()).setProjection(DEFAULT_PROJECTION).setPrefix(StorageRpc.Option.PREFIX.getString(options)).setMaxResults(StorageRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(StorageRpc.Option.PAGE_TOKEN.getString(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(list, options);
            Buckets buckets = (Buckets)list.execute();
            Tuple<String, Iterable<Bucket>> tuple = Tuple.of(buckets.getNextPageToken(), buckets.getItems());
            return tuple;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Tuple<String, Iterable<StorageObject>> list(String bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_OBJECTS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.List list = this.storage.objects().list(bucket).setProjection(DEFAULT_PROJECTION).setVersions(StorageRpc.Option.VERSIONS.getBoolean(options)).setDelimiter(StorageRpc.Option.DELIMITER.getString(options)).setStartOffset(StorageRpc.Option.START_OFF_SET.getString(options)).setEndOffset(StorageRpc.Option.END_OFF_SET.getString(options)).setMatchGlob(StorageRpc.Option.MATCH_GLOB.getString(options)).setPrefix(StorageRpc.Option.PREFIX.getString(options)).setMaxResults(StorageRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(StorageRpc.Option.PAGE_TOKEN.getString(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).setSoftDeleted(StorageRpc.Option.SOFT_DELETED.getBoolean(options)).setIncludeFoldersAsPrefixes(StorageRpc.Option.INCLUDE_FOLDERS_AS_PREFIXES.getBoolean(options)).setIncludeTrailingDelimiter(StorageRpc.Option.INCLUDE_TRAILING_DELIMITER.getBoolean(options));
            HttpStorageRpc.setExtraHeaders(list, options);
            Objects objects = (Objects)list.execute();
            Iterable storageObjects = Iterables.concat((Iterable)MoreObjects.firstNonNull(objects.getItems(), ImmutableList.of()), objects.getPrefixes() != null ? Lists.transform(objects.getPrefixes(), HttpStorageRpc.objectFromPrefix(bucket)) : ImmutableList.of());
            Tuple<String, Iterable<StorageObject>> tuple = Tuple.of(objects.getNextPageToken(), storageObjects);
            return tuple;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    private static String detectContentType(StorageObject object, Map<StorageRpc.Option, ?> options) {
        String contentType = object.getContentType();
        if (contentType != null) {
            return contentType;
        }
        if (Boolean.TRUE == StorageRpc.Option.DETECT_CONTENT_TYPE.get(options)) {
            contentType = FILE_NAME_MAP.getContentTypeFor(object.getName().toLowerCase(Locale.US));
        }
        return MoreObjects.firstNonNull(contentType, "application/octet-stream");
    }

    private static Function<String, StorageObject> objectFromPrefix(final String bucket) {
        return new Function<String, StorageObject>(){

            @Override
            public StorageObject apply(String prefix) {
                return new StorageObject().set("isDirectory", true).setBucket(bucket).setName(prefix).setSize(BigInteger.ZERO);
            }
        };
    }

    @Override
    public Bucket get(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_BUCKET);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Buckets.Get get = this.storage.buckets().get(bucket.getName()).setProjection(DEFAULT_PROJECTION).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(get, options);
            Bucket bucket2 = (Bucket)get.execute();
            return bucket2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                Bucket bucket3 = null;
                return bucket3;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    private Storage.Objects.Get getCall(StorageObject object, Map<StorageRpc.Option, ?> options) throws IOException {
        Storage.Objects.Get get = this.storage.objects().get(object.getBucket(), object.getName());
        HttpStorageRpc.setEncryptionHeaders(get.getRequestHeaders(), ENCRYPTION_KEY_PREFIX, options);
        HttpStorageRpc.setExtraHeaders(get, options);
        return get.setGeneration(object.getGeneration()).setProjection(DEFAULT_PROJECTION).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).setSoftDeleted(StorageRpc.Option.SOFT_DELETED.getBoolean(options));
    }

    @Override
    public StorageObject get(StorageObject object, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            StorageObject storageObject = (StorageObject)this.getCall(object, options).execute();
            return storageObject;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                StorageObject storageObject = null;
                return storageObject;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public StorageObject restore(StorageObject object, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_RESTORE_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.Restore restore = this.storage.objects().restore(object.getBucket(), object.getName(), object.getGeneration());
            HttpStorageRpc.setExtraHeaders(restore, options);
            StorageObject storageObject = (StorageObject)restore.setProjection(DEFAULT_PROJECTION).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setCopySourceAcl(StorageRpc.Option.COPY_SOURCE_ACL.getBoolean(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).execute();
            return storageObject;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                StorageObject storageObject = null;
                return storageObject;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Bucket patch(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_BUCKET);
        Scope scope = this.tracer.withSpan(span);
        try {
            Bucket.RetentionPolicy retentionPolicy = bucket.getRetentionPolicy();
            if (retentionPolicy != null && retentionPolicy.getRetentionPeriod() == null) {
                bucket.setRetentionPolicy(Data.nullOf(Bucket.RetentionPolicy.class));
            }
            String projection = StorageRpc.Option.PROJECTION.getString(options);
            if (bucket.getIamConfiguration() != null && bucket.getIamConfiguration().getBucketPolicyOnly() != null && bucket.getIamConfiguration().getBucketPolicyOnly().getEnabled() != null && bucket.getIamConfiguration().getBucketPolicyOnly().getEnabled().booleanValue()) {
                bucket.setDefaultObjectAcl(null);
                bucket.setAcl(null);
                if (projection == null) {
                    projection = NO_ACL_PROJECTION;
                }
            }
            Storage.Buckets.Patch patch = this.storage.buckets().patch(bucket.getName(), bucket).setProjection(projection == null ? DEFAULT_PROJECTION : projection).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setPredefinedDefaultObjectAcl(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(patch, options);
            Bucket bucket2 = (Bucket)patch.execute();
            return bucket2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    private Storage.Objects.Patch patchCall(StorageObject storageObject, Map<StorageRpc.Option, ?> options) throws IOException {
        Storage.Objects.Patch patch = this.storage.objects().patch(storageObject.getBucket(), storageObject.getName(), storageObject).setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setOverrideUnlockedRetention(StorageRpc.Option.OVERRIDE_UNLOCKED_RETENTION.getBoolean(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
        HttpStorageRpc.setExtraHeaders(patch, options);
        return patch;
    }

    @Override
    public StorageObject patch(StorageObject storageObject, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            StorageObject storageObject2 = (StorageObject)this.patchCall(storageObject, options).execute();
            return storageObject2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public boolean delete(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_BUCKET);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Buckets.Delete delete = this.storage.buckets().delete(bucket.getName()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(delete, options);
            delete.execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    private Storage.Objects.Delete deleteCall(StorageObject blob, Map<StorageRpc.Option, ?> options) throws IOException {
        Storage.Objects.Delete delete = this.storage.objects().delete(blob.getBucket(), blob.getName()).setGeneration(blob.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
        HttpStorageRpc.setExtraHeaders(delete, options);
        return delete;
    }

    @Override
    public boolean delete(StorageObject blob, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_OBJECT);
        Scope scope = this.tracer.withSpan(span);
        try {
            this.deleteCall(blob, options).execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public StorageObject compose(Iterable<StorageObject> sources, StorageObject target, Map<StorageRpc.Option, ?> targetOptions) {
        ComposeRequest request = new ComposeRequest();
        request.setDestination(target);
        ArrayList<ComposeRequest.SourceObjects> sourceObjects = new ArrayList<ComposeRequest.SourceObjects>();
        for (StorageObject source : sources) {
            ComposeRequest.SourceObjects sourceObject = new ComposeRequest.SourceObjects();
            sourceObject.setName(source.getName());
            Long generation = source.getGeneration();
            if (generation != null) {
                sourceObject.setGeneration(generation);
                sourceObject.setObjectPreconditions(new ComposeRequest.SourceObjects.ObjectPreconditions().setIfGenerationMatch(generation));
            }
            sourceObjects.add(sourceObject);
        }
        request.setSourceObjects(sourceObjects);
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_COMPOSE);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.Compose compose = this.storage.objects().compose(target.getBucket(), target.getName(), request).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(targetOptions)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(targetOptions)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(targetOptions));
            HttpStorageRpc.setEncryptionHeaders(compose.getRequestHeaders(), ENCRYPTION_KEY_PREFIX, targetOptions);
            HttpStorageRpc.setExtraHeaders(compose, targetOptions);
            StorageObject storageObject = (StorageObject)compose.execute();
            return storageObject;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public byte[] load(StorageObject from, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LOAD);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.Get getRequest = this.storage.objects().get(from.getBucket(), from.getName()).setGeneration(from.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setEncryptionHeaders(getRequest.getRequestHeaders(), ENCRYPTION_KEY_PREFIX, options);
            HttpStorageRpc.setExtraHeaders(getRequest, options);
            if (StorageRpc.Option.RETURN_RAW_INPUT_STREAM.getBoolean(options) != null) {
                getRequest.setReturnRawInputStream(StorageRpc.Option.RETURN_RAW_INPUT_STREAM.getBoolean(options));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            getRequest.executeMedia().download(out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RpcBatch createBatch() {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_BATCH);
        Scope scope = this.tracer.withSpan(span);
        try {
            DefaultRpcBatch defaultRpcBatch = new DefaultRpcBatch(this.storage);
            return defaultRpcBatch;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    private Storage.Objects.Get createReadRequest(StorageObject from, Map<StorageRpc.Option, ?> options) throws IOException {
        Storage.Objects.Get req = this.storage.objects().get(from.getBucket(), from.getName()).setGeneration(from.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
        HttpStorageRpc.setEncryptionHeaders(req.getRequestHeaders(), ENCRYPTION_KEY_PREFIX, options);
        HttpStorageRpc.setExtraHeaders(req, options);
        return req;
    }

    @Override
    public long read(StorageObject from, Map<StorageRpc.Option, ?> options, long position, OutputStream outputStream) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_READ);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Objects.Get req = this.createReadRequest(from, options);
            Boolean shouldReturnRawInputStream = StorageRpc.Option.RETURN_RAW_INPUT_STREAM.getBoolean(options);
            if (shouldReturnRawInputStream != null) {
                req.setReturnRawInputStream(shouldReturnRawInputStream);
            } else {
                req.setReturnRawInputStream(false);
            }
            if (position > 0L) {
                req.getRequestHeaders().setRange(String.format(Locale.US, "bytes=%d-", position));
            }
            MediaHttpDownloader mediaHttpDownloader = req.getMediaHttpDownloader();
            mediaHttpDownloader.setDirectDownloadEnabled(true);
            req.executeMedia().download(outputStream);
            long l = mediaHttpDownloader.getNumBytesDownloaded();
            return l;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 416) {
                long l = 0L;
                return l;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Tuple<String, byte[]> read(StorageObject from, Map<StorageRpc.Option, ?> options, long position, int bytes) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_READ);
        Scope scope = this.tracer.withSpan(span);
        try {
            Preconditions.checkArgument(position >= 0L, "Position should be non-negative, is " + position);
            Storage.Objects.Get req = this.createReadRequest(from, options);
            Boolean shouldReturnRawInputStream = StorageRpc.Option.RETURN_RAW_INPUT_STREAM.getBoolean(options);
            if (shouldReturnRawInputStream != null) {
                req.setReturnRawInputStream(shouldReturnRawInputStream);
            } else {
                req.setReturnRawInputStream(true);
            }
            StringBuilder range = new StringBuilder();
            range.append("bytes=").append(position).append("-").append(position + (long)bytes - 1L);
            HttpHeaders requestHeaders = req.getRequestHeaders();
            requestHeaders.setRange(range.toString());
            ByteArrayOutputStream output = new ByteArrayOutputStream(bytes);
            req.executeMedia().download(output);
            String etag = req.getLastResponseHeaders().getETag();
            Tuple<String, byte[]> tuple = Tuple.of(etag, output.toByteArray());
            return tuple;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = StorageException.translate(ex);
            if (serviceException.getCode() == 416) {
                Tuple<Object, byte[]> tuple = Tuple.of(null, new byte[0]);
                return tuple;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public void write(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) {
        this.writeWithResponse(uploadId, toWrite, toWriteOffset, destOffset, length, last);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getCurrentUploadOffset(String uploadId) {
        try {
            GenericUrl url = new GenericUrl(uploadId);
            HttpRequest httpRequest = this.storage.getRequestFactory().buildPutRequest(url, new EmptyContent());
            httpRequest.getHeaders().setContentRange("bytes */*");
            httpRequest.setFollowRedirects(false);
            HttpResponse response = null;
            try {
                response = httpRequest.execute();
                int code = response.getStatusCode();
                if (HttpStatusCodes.isSuccess(code)) {
                    long l = -1L;
                    return l;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Not sure what occurred. Here's debugging information:\n");
                sb.append("Response:\n").append(response.toString()).append("\n\n");
                throw new StorageException(0, sb.toString());
            }
            catch (HttpResponseException ex) {
                int code = ex.getStatusCode();
                if (code != 308) throw HttpStorageRpc.translate(ex);
                if (ex.getHeaders().getRange() == null) {
                    long l = 0L;
                    return l;
                }
                String range = ex.getHeaders().getRange();
                long l = Long.parseLong(range.substring(range.indexOf("-") + 1)) + 1L;
                return l;
            }
            finally {
                if (response != null) {
                    response.disconnect();
                }
            }
        }
        catch (IOException ex) {
            throw HttpStorageRpc.translate(ex);
        }
    }

    @Override
    public StorageObject queryCompletedResumableUpload(String uploadId, long totalBytes) {
        try {
            GenericUrl url = new GenericUrl(uploadId);
            HttpRequest req = this.storage.getRequestFactory().buildPutRequest(url, new EmptyContent());
            req.getHeaders().setContentRange(String.format(Locale.US, "bytes */%s", totalBytes));
            req.setParser(this.storage.getObjectParser());
            HttpResponse response = req.execute();
            if (response.getStatusCode() == 200) {
                return response.parseAs(StorageObject.class);
            }
            throw HttpStorageRpc.buildStorageException(response.getStatusCode(), response.getStatusMessage());
        }
        catch (IOException ex) {
            throw HttpStorageRpc.translate(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageObject writeWithResponse(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_WRITE);
        Scope scope = this.tracer.withSpan(span);
        StorageObject updatedBlob = null;
        try {
            String message;
            int code;
            if (length == 0 && !last) {
                StorageObject storageObject = updatedBlob;
                return storageObject;
            }
            GenericUrl url = new GenericUrl(uploadId);
            HttpRequest httpRequest = this.storage.getRequestFactory().buildPutRequest(url, new ByteArrayContent(null, toWrite, toWriteOffset, length));
            long limit = destOffset + (long)length;
            StringBuilder range = new StringBuilder("bytes ");
            if (length == 0) {
                range.append('*');
            } else {
                range.append(destOffset).append('-').append(limit - 1L);
            }
            range.append('/');
            if (last) {
                range.append(limit);
            } else {
                range.append('*');
            }
            httpRequest.getHeaders().setContentRange(range.toString());
            if (last) {
                httpRequest.setParser(this.storage.getObjectParser());
            }
            HttpResponseException exception = null;
            HttpResponse response = null;
            try {
                response = httpRequest.execute();
                code = response.getStatusCode();
                message = response.getStatusMessage();
                String contentType = response.getContentType();
                if (last && (code == 200 || code == 201) && contentType != null && contentType.startsWith("application/json")) {
                    updatedBlob = response.parseAs(StorageObject.class);
                }
            }
            catch (HttpResponseException ex) {
                exception = ex;
                code = ex.getStatusCode();
                message = ex.getStatusMessage();
            }
            finally {
                if (response != null) {
                    response.disconnect();
                }
            }
            if (!last && code != 308 || last && code != 200 && code != 201) {
                if (exception != null) {
                    throw exception;
                }
                throw HttpStorageRpc.buildStorageException(code, message);
            }
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
        return updatedBlob;
    }

    @Override
    public String open(StorageObject object, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_OPEN);
        Scope scope = this.tracer.withSpan(span);
        try {
            String kmsKeyName = object.getKmsKeyName();
            if (kmsKeyName != null && kmsKeyName.contains("cryptoKeyVersions")) {
                object.setKmsKeyName(Data.nullOf(String.class));
            }
            Storage.Objects.Insert req = this.storage.objects().insert(object.getBucket(), object).setName(object.getName()).setProjection(StorageRpc.Option.PROJECTION.getString(options)).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options)).setKmsKeyName(StorageRpc.Option.KMS_KEY_NAME.getString(options));
            GenericUrl url = req.buildHttpRequestUrl();
            url.setRawPath("/upload" + url.getRawPath());
            url.set("uploadType", "resumable");
            JsonFactory jsonFactory = this.storage.getJsonFactory();
            HttpRequestFactory requestFactory = this.storage.getRequestFactory();
            HttpRequest httpRequest = requestFactory.buildPostRequest(url, new JsonHttpContent(jsonFactory, object));
            HttpHeaders requestHeaders = httpRequest.getHeaders();
            requestHeaders.set("X-Upload-Content-Type", HttpStorageRpc.detectContentType(object, options));
            Long xUploadContentLength = StorageRpc.Option.X_UPLOAD_CONTENT_LENGTH.getLong(options);
            if (xUploadContentLength != null) {
                requestHeaders.set("X-Upload-Content-Length", xUploadContentLength);
            }
            HttpStorageRpc.setEncryptionHeaders(requestHeaders, ENCRYPTION_KEY_PREFIX, options);
            HttpStorageRpc.setExtraHeaders((ImmutableMap)StorageRpc.Option.EXTRA_HEADERS.get(options), requestHeaders);
            HttpResponse response = httpRequest.execute();
            if (response.getStatusCode() != 200) {
                throw HttpStorageRpc.buildStorageException(response.getStatusCode(), response.getStatusMessage());
            }
            String string = response.getHeaders().getLocation();
            return string;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public String open(String signedURL) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_OPEN);
        Scope scope = this.tracer.withSpan(span);
        try {
            GenericUrl url = new GenericUrl(signedURL);
            url.set("uploadType", "resumable");
            String bytesArrayParameters = "";
            byte[] bytesArray = new byte[bytesArrayParameters.length()];
            HttpRequestFactory requestFactory = this.storage.getRequestFactory();
            HttpRequest httpRequest = requestFactory.buildPostRequest(url, new ByteArrayContent("", bytesArray, 0, bytesArray.length));
            HttpHeaders requestHeaders = httpRequest.getHeaders();
            requestHeaders.set("X-Upload-Content-Type", "");
            requestHeaders.set("x-goog-resumable", "start");
            requestHeaders.remove("x-goog-api-client");
            HttpResponse response = httpRequest.execute();
            if (response.getStatusCode() != 201) {
                throw HttpStorageRpc.buildStorageException(response.getStatusCode(), response.getStatusMessage());
            }
            String string = response.getHeaders().getLocation();
            return string;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public StorageObject moveObject(String bucket, String sourceObject, String destinationObject, Map<StorageRpc.Option, ?> sourceOptions, Map<StorageRpc.Option, ?> targetOptions) {
        String userProject = StorageRpc.Option.USER_PROJECT.getString(sourceOptions);
        if (userProject == null) {
            userProject = StorageRpc.Option.USER_PROJECT.getString(targetOptions);
        }
        try {
            Storage.Objects.Move move = this.storage.objects().move(bucket, sourceObject, destinationObject).setIfSourceMetagenerationMatch(StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH.getLong(sourceOptions)).setIfSourceMetagenerationNotMatch(StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH.getLong(sourceOptions)).setIfSourceGenerationMatch(StorageRpc.Option.IF_SOURCE_GENERATION_MATCH.getLong(sourceOptions)).setIfSourceGenerationNotMatch(StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH.getLong(sourceOptions)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(targetOptions)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(targetOptions)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(targetOptions)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(targetOptions)).setUserProject(userProject);
            return (StorageObject)move.execute();
        }
        catch (IOException e) {
            throw HttpStorageRpc.translate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageRpc.RewriteResponse openRewrite(StorageRpc.RewriteRequest rewriteRequest) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_OPEN_REWRITE);
        Scope scope = this.tracer.withSpan(span);
        try {
            StorageRpc.RewriteResponse rewriteResponse = this.rewrite(rewriteRequest, null);
            return rewriteResponse;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageRpc.RewriteResponse continueRewrite(StorageRpc.RewriteResponse previousResponse) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CONTINUE_REWRITE);
        Scope scope = this.tracer.withSpan(span);
        try {
            StorageRpc.RewriteResponse rewriteResponse = this.rewrite(previousResponse.rewriteRequest, previousResponse.rewriteToken);
            return rewriteResponse;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    private StorageRpc.RewriteResponse rewrite(StorageRpc.RewriteRequest req, String token) {
        try {
            String userProject = StorageRpc.Option.USER_PROJECT.getString(req.sourceOptions);
            if (userProject == null) {
                userProject = StorageRpc.Option.USER_PROJECT.getString(req.targetOptions);
            }
            Long maxBytesRewrittenPerCall = req.megabytesRewrittenPerCall != null ? Long.valueOf(req.megabytesRewrittenPerCall * 0x100000L) : null;
            StorageObject content = req.overrideInfo ? req.target : null;
            Storage.Objects.Rewrite rewrite = this.storage.objects().rewrite(req.source.getBucket(), req.source.getName(), req.target.getBucket(), req.target.getName(), content).setSourceGeneration(req.source.getGeneration()).setRewriteToken(token).setMaxBytesRewrittenPerCall(maxBytesRewrittenPerCall).setProjection(DEFAULT_PROJECTION).setIfSourceMetagenerationMatch(StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH.getLong(req.sourceOptions)).setIfSourceMetagenerationNotMatch(StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH.getLong(req.sourceOptions)).setIfSourceGenerationMatch(StorageRpc.Option.IF_SOURCE_GENERATION_MATCH.getLong(req.sourceOptions)).setIfSourceGenerationNotMatch(StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH.getLong(req.sourceOptions)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(req.targetOptions)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(req.targetOptions)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(req.targetOptions)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(req.targetOptions)).setDestinationPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(req.targetOptions)).setUserProject(userProject).setDestinationKmsKeyName(StorageRpc.Option.KMS_KEY_NAME.getString(req.targetOptions));
            rewrite.setDisableGZipContent(content == null);
            HttpHeaders requestHeaders = rewrite.getRequestHeaders();
            HttpStorageRpc.setEncryptionHeaders(requestHeaders, SOURCE_ENCRYPTION_KEY_PREFIX, req.sourceOptions);
            HttpStorageRpc.setEncryptionHeaders(requestHeaders, ENCRYPTION_KEY_PREFIX, req.targetOptions);
            HttpStorageRpc.setExtraHeaders(rewrite, req.sourceOptions);
            HttpStorageRpc.setExtraHeaders(rewrite, req.targetOptions);
            RewriteResponse rewriteResponse = (RewriteResponse)rewrite.execute();
            return new StorageRpc.RewriteResponse(req, rewriteResponse.getResource(), rewriteResponse.getObjectSize(), rewriteResponse.getDone(), rewriteResponse.getRewriteToken(), rewriteResponse.getTotalBytesRewritten());
        }
        catch (IOException ex) {
            this.tracer.getCurrentSpan().setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
    }

    @Override
    public BucketAccessControl getAcl(String bucket, String entity, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_BUCKET_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.BucketAccessControls.Get get = this.storage.bucketAccessControls().get(bucket, entity).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(get, options);
            BucketAccessControl bucketAccessControl = (BucketAccessControl)get.execute();
            return bucketAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                BucketAccessControl bucketAccessControl = null;
                return bucketAccessControl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public boolean deleteAcl(String bucket, String entity, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_BUCKET_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.BucketAccessControls.Delete delete = this.storage.bucketAccessControls().delete(bucket, entity).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(delete, options);
            delete.execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public BucketAccessControl createAcl(BucketAccessControl acl, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_BUCKET_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.BucketAccessControls.Insert insert = this.storage.bucketAccessControls().insert(acl.getBucket(), acl).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(insert, options);
            BucketAccessControl bucketAccessControl = (BucketAccessControl)insert.execute();
            return bucketAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public BucketAccessControl patchAcl(BucketAccessControl acl, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_BUCKET_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.BucketAccessControls.Patch patch = this.storage.bucketAccessControls().patch(acl.getBucket(), acl.getEntity(), acl).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(patch, options);
            BucketAccessControl bucketAccessControl = (BucketAccessControl)patch.execute();
            return bucketAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public List<BucketAccessControl> listAcls(String bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_BUCKET_ACLS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.BucketAccessControls.List list = this.storage.bucketAccessControls().list(bucket).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(list, options);
            List<BucketAccessControl> list2 = ((BucketAccessControls)list.execute()).getItems();
            return list2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ObjectAccessControl getDefaultAcl(String bucket, String entity) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_OBJECT_DEFAULT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.DefaultObjectAccessControls.Get get = this.storage.defaultObjectAccessControls().get(bucket, entity);
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)get.execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                ObjectAccessControl objectAccessControl = null;
                return objectAccessControl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, String entity) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_OBJECT_DEFAULT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.DefaultObjectAccessControls.Delete delete = this.storage.defaultObjectAccessControls().delete(bucket, entity);
            delete.execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ObjectAccessControl createDefaultAcl(ObjectAccessControl acl) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_OBJECT_DEFAULT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.DefaultObjectAccessControls.Insert insert = this.storage.defaultObjectAccessControls().insert(acl.getBucket(), acl);
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)insert.execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ObjectAccessControl patchDefaultAcl(ObjectAccessControl acl) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_OBJECT_DEFAULT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.DefaultObjectAccessControls.Patch patch = this.storage.defaultObjectAccessControls().patch(acl.getBucket(), acl.getEntity(), acl);
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)patch.execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public List<ObjectAccessControl> listDefaultAcls(String bucket) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_OBJECT_DEFAULT_ACLS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.DefaultObjectAccessControls.List list = this.storage.defaultObjectAccessControls().list(bucket);
            List<ObjectAccessControl> list2 = ((ObjectAccessControls)list.execute()).getItems();
            return list2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ObjectAccessControl getAcl(String bucket, String object, Long generation, String entity) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_OBJECT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.ObjectAccessControls.Get get = this.storage.objectAccessControls().get(bucket, object, entity).setGeneration(generation);
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)get.execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                ObjectAccessControl objectAccessControl = null;
                return objectAccessControl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public boolean deleteAcl(String bucket, String object, Long generation, String entity) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_OBJECT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.ObjectAccessControls.Delete delete = this.storage.objectAccessControls().delete(bucket, object, entity).setGeneration(generation);
            delete.execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ObjectAccessControl createAcl(ObjectAccessControl acl) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_OBJECT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.ObjectAccessControls.Insert insert = this.storage.objectAccessControls().insert(acl.getBucket(), acl.getObject(), acl).setGeneration(acl.getGeneration());
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)insert.execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ObjectAccessControl patchAcl(ObjectAccessControl acl) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_PATCH_OBJECT_ACL);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.ObjectAccessControls.Patch patch = this.storage.objectAccessControls().patch(acl.getBucket(), acl.getObject(), acl.getEntity(), acl).setGeneration(acl.getGeneration());
            ObjectAccessControl objectAccessControl = (ObjectAccessControl)patch.execute();
            return objectAccessControl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public List<ObjectAccessControl> listAcls(String bucket, String object, Long generation) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_OBJECT_ACLS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.ObjectAccessControls.List list = this.storage.objectAccessControls().list(bucket, object).setGeneration(generation);
            List<ObjectAccessControl> list2 = ((ObjectAccessControls)list.execute()).getItems();
            return list2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public HmacKey createHmacKey(String serviceAccountEmail, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_HMAC_KEY);
        Scope scope = this.tracer.withSpan(span);
        String projectId = StorageRpc.Option.PROJECT_ID.getString(options);
        if (projectId == null) {
            projectId = this.options.getProjectId();
        }
        try {
            Storage.Projects.HmacKeys.Create create = this.storage.projects().hmacKeys().create(projectId, serviceAccountEmail).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(create, options);
            HmacKey hmacKey = (HmacKey)create.setDisableGZipContent(true).execute();
            return hmacKey;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Tuple<String, Iterable<HmacKeyMetadata>> listHmacKeys(Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_HMAC_KEYS);
        Scope scope = this.tracer.withSpan(span);
        String projectId = StorageRpc.Option.PROJECT_ID.getString(options);
        if (projectId == null) {
            projectId = this.options.getProjectId();
        }
        try {
            Storage.Projects.HmacKeys.List list = this.storage.projects().hmacKeys().list(projectId).setServiceAccountEmail(StorageRpc.Option.SERVICE_ACCOUNT_EMAIL.getString(options)).setPageToken(StorageRpc.Option.PAGE_TOKEN.getString(options)).setMaxResults(StorageRpc.Option.MAX_RESULTS.getLong(options)).setShowDeletedKeys(StorageRpc.Option.SHOW_DELETED_KEYS.getBoolean(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(list, options);
            HmacKeysMetadata hmacKeysMetadata = (HmacKeysMetadata)list.execute();
            Tuple<String, Iterable<HmacKeyMetadata>> tuple = Tuple.of(hmacKeysMetadata.getNextPageToken(), hmacKeysMetadata.getItems());
            return tuple;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public HmacKeyMetadata getHmacKey(String accessId, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_HMAC_KEY);
        Scope scope = this.tracer.withSpan(span);
        String projectId = StorageRpc.Option.PROJECT_ID.getString(options);
        if (projectId == null) {
            projectId = this.options.getProjectId();
        }
        try {
            Storage.Projects.HmacKeys.Get get = this.storage.projects().hmacKeys().get(projectId, accessId).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(get, options);
            HmacKeyMetadata hmacKeyMetadata = (HmacKeyMetadata)get.execute();
            return hmacKeyMetadata;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public HmacKeyMetadata updateHmacKey(HmacKeyMetadata hmacKeyMetadata, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_UPDATE_HMAC_KEY);
        Scope scope = this.tracer.withSpan(span);
        String projectId = hmacKeyMetadata.getProjectId();
        if (projectId == null) {
            projectId = this.options.getProjectId();
        }
        try {
            Storage.Projects.HmacKeys.Update update = this.storage.projects().hmacKeys().update(projectId, hmacKeyMetadata.getAccessId(), hmacKeyMetadata).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(update, options);
            HmacKeyMetadata hmacKeyMetadata2 = (HmacKeyMetadata)update.execute();
            return hmacKeyMetadata2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public void deleteHmacKey(HmacKeyMetadata hmacKeyMetadata, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_HMAC_KEY);
        Scope scope = this.tracer.withSpan(span);
        String projectId = hmacKeyMetadata.getProjectId();
        if (projectId == null) {
            projectId = this.options.getProjectId();
        }
        try {
            Storage.Projects.HmacKeys.Delete delete = this.storage.projects().hmacKeys().delete(projectId, hmacKeyMetadata.getAccessId()).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(delete, options);
            delete.execute();
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Policy getIamPolicy(String bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_BUCKET_IAM_POLICY);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Buckets.GetIamPolicy getIamPolicy = this.storage.buckets().getIamPolicy(bucket).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            if (null != StorageRpc.Option.REQUESTED_POLICY_VERSION.getLong(options)) {
                getIamPolicy.setOptionsRequestedPolicyVersion(StorageRpc.Option.REQUESTED_POLICY_VERSION.getLong(options).intValue());
            }
            HttpStorageRpc.setExtraHeaders(getIamPolicy, options);
            Policy policy = (Policy)getIamPolicy.execute();
            return policy;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_SET_BUCKET_IAM_POLICY);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Buckets.SetIamPolicy setIamPolicy = this.storage.buckets().setIamPolicy(bucket, policy).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(setIamPolicy, options);
            Policy policy2 = (Policy)setIamPolicy.execute();
            return policy2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public TestIamPermissionsResponse testIamPermissions(String bucket, List<String> permissions, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_TEST_BUCKET_IAM_PERMISSIONS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Buckets.TestIamPermissions testIamPermissions = this.storage.buckets().testIamPermissions(bucket, permissions).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(testIamPermissions, options);
            TestIamPermissionsResponse testIamPermissionsResponse = (TestIamPermissionsResponse)testIamPermissions.execute();
            return testIamPermissionsResponse;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public boolean deleteNotification(String bucket, String notification) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_DELETE_NOTIFICATION);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Notifications.Delete delete = this.storage.notifications().delete(bucket, notification);
            delete.execute();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public List<Notification> listNotifications(String bucket) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_LIST_NOTIFICATIONS);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Notifications.List list = this.storage.notifications().list(bucket);
            List<Notification> list2 = ((Notifications)list.execute()).getItems();
            return list2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Notification createNotification(String bucket, Notification notification) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_CREATE_NOTIFICATION);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Notifications.Insert insert = this.storage.notifications().insert(bucket, notification);
            Notification notification2 = (Notification)insert.execute();
            return notification2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public Notification getNotification(String bucket, String notification) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_NOTIFICATION);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Notifications.Get get = this.storage.notifications().get(bucket, notification);
            Notification notification2 = (Notification)get.execute();
            return notification2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            StorageException serviceException = HttpStorageRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                Notification notification3 = null;
                return notification3;
            }
            throw serviceException;
        }
        finally {
            scope.close();
            span.end();
        }
    }

    @Override
    public Bucket lockRetentionPolicy(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_LOCK_RETENTION_POLICY);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Buckets.LockRetentionPolicy lockRetentionPolicy = this.storage.buckets().lockRetentionPolicy(bucket.getName(), StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setUserProject(StorageRpc.Option.USER_PROJECT.getString(options));
            HttpStorageRpc.setExtraHeaders(lockRetentionPolicy, options);
            Bucket bucket2 = (Bucket)lockRetentionPolicy.setDisableGZipContent(true).execute();
            return bucket2;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        Span span = this.startSpan(HttpStorageRpcSpans.SPAN_NAME_GET_SERVICE_ACCOUNT);
        Scope scope = this.tracer.withSpan(span);
        try {
            Storage.Projects.ServiceAccount.Get get = this.storage.projects().serviceAccount().get(projectId);
            ServiceAccount serviceAccount = (ServiceAccount)get.execute();
            return serviceAccount;
        }
        catch (IOException ex) {
            span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
            throw HttpStorageRpc.translate(ex);
        }
        finally {
            scope.close();
            span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
        }
    }

    private static StorageException buildStorageException(int statusCode, String statusMessage) {
        GoogleJsonError error = new GoogleJsonError();
        error.setCode(statusCode);
        error.setMessage(statusMessage);
        return HttpStorageRpc.translate(error);
    }

    private static <Resource, Request extends StorageRequest<Resource>> void setExtraHeaders(Request req, Map<StorageRpc.Option, ?> options) {
        ImmutableMap extraHeaders = (ImmutableMap)StorageRpc.Option.EXTRA_HEADERS.get(options);
        HttpHeaders headers = req.getRequestHeaders();
        HttpStorageRpc.setExtraHeaders(extraHeaders, headers);
    }

    private static void setExtraHeaders(@Nullable ImmutableMap<String, String> extraHeaders, HttpHeaders headers) {
        if (extraHeaders != null) {
            for (Map.Entry e : extraHeaders.entrySet()) {
                String key = (String)e.getKey();
                if (headers.containsKey(key) && !key.equals("authorization")) continue;
                headers.set(key, e.getValue());
            }
        }
    }

    private static final class InvocationIdInitializer
    implements HttpRequestInitializer {
        @Nullable
        HttpRequestInitializer initializer;
        @Nullable
        private final String applicationName;
        @Nullable
        private final String tm;

        private InvocationIdInitializer(@Nullable HttpRequestInitializer initializer, @Nullable String applicationName, String tm) {
            this.initializer = initializer;
            this.applicationName = applicationName;
            this.tm = tm;
        }

        @Override
        public void initialize(HttpRequest request) throws IOException {
            Preconditions.checkNotNull(request);
            if (this.initializer != null) {
                this.initializer.initialize(request);
            }
            request.setInterceptor(new InvocationIdInterceptor(request.getInterceptor(), this.applicationName, this.tm));
        }
    }

    private class DefaultRpcBatch
    implements RpcBatch {
        private static final int MAX_BATCH_SIZE = 100;
        private final Storage storage;
        private final LinkedList<BatchRequest> batches;
        private int currentBatchSize;

        private DefaultRpcBatch(Storage storage) {
            this.storage = storage;
            this.batches = new LinkedList();
            this.batches.add(storage.batch(HttpStorageRpc.this.batchRequestInitializer));
        }

        @Override
        public void addDelete(StorageObject storageObject, RpcBatch.Callback<Void> callback, Map<StorageRpc.Option, ?> options) {
            try {
                if (this.currentBatchSize == 100) {
                    this.batches.add(this.storage.batch());
                    this.currentBatchSize = 0;
                }
                Storage.Objects.Delete call = HttpStorageRpc.this.deleteCall(storageObject, options);
                this.addIdempotencyTokenToCall(call);
                call.queue(this.batches.getLast(), HttpStorageRpc.toJsonCallback(callback));
                ++this.currentBatchSize;
            }
            catch (IOException ex) {
                throw HttpStorageRpc.translate(ex);
            }
        }

        @Override
        public void addPatch(StorageObject storageObject, RpcBatch.Callback<StorageObject> callback, Map<StorageRpc.Option, ?> options) {
            try {
                if (this.currentBatchSize == 100) {
                    this.batches.add(this.storage.batch());
                    this.currentBatchSize = 0;
                }
                Storage.Objects.Patch call = HttpStorageRpc.this.patchCall(storageObject, options);
                this.addIdempotencyTokenToCall(call);
                call.queue(this.batches.getLast(), HttpStorageRpc.toJsonCallback(callback));
                ++this.currentBatchSize;
            }
            catch (IOException ex) {
                throw HttpStorageRpc.translate(ex);
            }
        }

        @Override
        public void addGet(StorageObject storageObject, RpcBatch.Callback<StorageObject> callback, Map<StorageRpc.Option, ?> options) {
            try {
                if (this.currentBatchSize == 100) {
                    this.batches.add(this.storage.batch());
                    this.currentBatchSize = 0;
                }
                Storage.Objects.Get call = HttpStorageRpc.this.getCall(storageObject, options);
                this.addIdempotencyTokenToCall(call);
                call.queue(this.batches.getLast(), HttpStorageRpc.toJsonCallback(callback));
                ++this.currentBatchSize;
            }
            catch (IOException ex) {
                throw HttpStorageRpc.translate(ex);
            }
        }

        @Override
        public void submit() {
            Span span = HttpStorageRpc.this.startSpan(HttpStorageRpcSpans.SPAN_NAME_BATCH_SUBMIT);
            Scope scope = HttpStorageRpc.this.tracer.withSpan(span);
            try {
                span.putAttribute("batch size", AttributeValue.longAttributeValue(this.batches.size()));
                for (BatchRequest batch : this.batches) {
                    span.addAnnotation("Execute batch request");
                    batch.setBatchUrl(new GenericUrl(String.format(Locale.US, "%s/batch/storage/v1", HttpStorageRpc.this.options.getHost())));
                    batch.execute();
                }
            }
            catch (IOException ex) {
                span.setStatus(Status.UNKNOWN.withDescription(ex.getMessage()));
                throw HttpStorageRpc.translate(ex);
            }
            finally {
                scope.close();
                span.end(HttpStorageRpcSpans.END_SPAN_OPTIONS);
            }
        }

        private void addIdempotencyTokenToCall(StorageRequest<?> call) {
            HttpRpcContext instance = HttpRpcContext.getInstance();
            call.getRequestHeaders().set(HttpStorageRpc.X_GOOG_GCS_IDEMPOTENCY_TOKEN, instance.newInvocationId());
            instance.clearInvocationId();
        }
    }

    private static final class InvocationIdInterceptor
    implements HttpExecuteInterceptor {
        private static final Collector<CharSequence, ?, String> JOINER = Collectors.joining(" ");
        @Nullable
        private final HttpExecuteInterceptor interceptor;
        @Nullable
        private final String applicationName;
        @Nullable
        private final String tm;

        private InvocationIdInterceptor(@Nullable HttpExecuteInterceptor interceptor, @Nullable String applicationName, String tm) {
            this.interceptor = interceptor;
            this.applicationName = applicationName;
            this.tm = tm;
        }

        @Override
        public void intercept(HttpRequest request) throws IOException {
            Preconditions.checkNotNull(request);
            if (this.interceptor != null) {
                this.interceptor.intercept(request);
            }
            HttpRpcContext httpRpcContext = HttpRpcContext.getInstance();
            UUID invocationId = httpRpcContext.getInvocationId();
            String signatureKey = "Signature=";
            String builtURL = request.getUrl().build();
            if (invocationId != null && !builtURL.contains("Signature=")) {
                HttpHeaders headers = request.getHeaders();
                String existing = (String)headers.get("x-goog-api-client");
                String invocationEntry = "gccl-invocation-id/" + invocationId;
                String newValue = Stream.of(existing, invocationEntry, this.tm).filter(java.util.Objects::nonNull).collect(JOINER);
                headers.set("x-goog-api-client", newValue);
                headers.set(HttpStorageRpc.X_GOOG_GCS_IDEMPOTENCY_TOKEN, invocationId);
                String userAgent = headers.getUserAgent();
                if (userAgent == null || userAgent.isEmpty() || this.applicationName != null && !userAgent.contains(this.applicationName)) {
                    headers.setUserAgent(this.applicationName);
                }
            }
        }
    }
}

