/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.LoadBalancer;
import io.grpc.xds.ThreadSafeRandom;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.primitives.UnsignedInteger;

final class WeightedRandomPicker
extends LoadBalancer.SubchannelPicker {
    @VisibleForTesting
    final List<WeightedChildPicker> weightedChildPickers;
    private final ThreadSafeRandom random;
    private final long totalWeight;

    WeightedRandomPicker(List<WeightedChildPicker> weightedChildPickers) {
        this(weightedChildPickers, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    WeightedRandomPicker(List<WeightedChildPicker> weightedChildPickers, ThreadSafeRandom random) {
        Preconditions.checkNotNull(weightedChildPickers, "weightedChildPickers in null");
        Preconditions.checkArgument(!weightedChildPickers.isEmpty(), "weightedChildPickers is empty");
        this.weightedChildPickers = Collections.unmodifiableList(weightedChildPickers);
        long totalWeight = 0L;
        for (WeightedChildPicker weightedChildPicker : weightedChildPickers) {
            long weight = weightedChildPicker.getWeight();
            Preconditions.checkArgument(weight >= 0L, "weight is negative");
            Preconditions.checkNotNull(weightedChildPicker.getPicker(), "childPicker is null");
            totalWeight += weight;
        }
        this.totalWeight = totalWeight;
        Preconditions.checkArgument(totalWeight <= UnsignedInteger.MAX_VALUE.longValue(), "total weight greater than unsigned int can hold");
        this.random = random;
    }

    @Override
    public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
        LoadBalancer.SubchannelPicker childPicker = null;
        if (this.totalWeight == 0L) {
            childPicker = this.weightedChildPickers.get(this.random.nextInt(this.weightedChildPickers.size())).getPicker();
        } else {
            long rand = this.random.nextLong(this.totalWeight);
            long accumulatedWeight = 0L;
            for (WeightedChildPicker weightedChildPicker : this.weightedChildPickers) {
                if (rand >= (accumulatedWeight += weightedChildPicker.getWeight())) continue;
                childPicker = weightedChildPicker.getPicker();
                break;
            }
            Preconditions.checkNotNull(childPicker, "childPicker not found");
        }
        return childPicker.pickSubchannel(args);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("weightedChildPickers", this.weightedChildPickers).add("totalWeight", this.totalWeight).toString();
    }

    static final class WeightedChildPicker {
        private final long weight;
        private final LoadBalancer.SubchannelPicker childPicker;

        WeightedChildPicker(long weight, LoadBalancer.SubchannelPicker childPicker) {
            Preconditions.checkArgument(weight >= 0L, "weight is negative");
            Preconditions.checkArgument(weight <= UnsignedInteger.MAX_VALUE.longValue(), "weight is too large");
            Preconditions.checkNotNull(childPicker, "childPicker is null");
            this.weight = weight;
            this.childPicker = childPicker;
        }

        long getWeight() {
            return this.weight;
        }

        LoadBalancer.SubchannelPicker getPicker() {
            return this.childPicker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedChildPicker that = (WeightedChildPicker)o;
            return this.weight == that.weight && Objects.equals(this.childPicker, that.childPicker);
        }

        public int hashCode() {
            return Objects.hash(this.weight, this.childPicker);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("weight", this.weight).add("childPicker", this.childPicker).toString();
        }
    }
}

