/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http;

import io.opencensus.contrib.http.AbstractHttpHandler;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.contrib.http.HttpRequestContext;
import io.opencensus.contrib.http.util.HttpMeasureConstants;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.propagation.TextFormat;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

public class HttpClientHandler<Q, P, C>
extends AbstractHttpHandler<Q, P> {
    private final TextFormat.Setter<C> setter;
    private final TextFormat textFormat;
    private final Tracer tracer;
    private final StatsRecorder statsRecorder;
    private final Tagger tagger;

    public HttpClientHandler(Tracer tracer, HttpExtractor<Q, P> extractor, TextFormat textFormat, TextFormat.Setter<C> setter) {
        super(extractor);
        Preconditions.checkNotNull(setter, "setter");
        Preconditions.checkNotNull(textFormat, "textFormat");
        Preconditions.checkNotNull(tracer, "tracer");
        this.setter = setter;
        this.textFormat = textFormat;
        this.tracer = tracer;
        this.statsRecorder = Stats.getStatsRecorder();
        this.tagger = Tags.getTagger();
    }

    public HttpRequestContext handleStart(@Nullable Span parent, C carrier, Q request) {
        SpanContext spanContext;
        String spanName;
        SpanBuilder builder;
        Span span;
        Preconditions.checkNotNull(carrier, "carrier");
        Preconditions.checkNotNull(request, "request");
        if (parent == null) {
            parent = this.tracer.getCurrentSpan();
        }
        if ((span = (builder = this.tracer.spanBuilderWithExplicitParent(spanName = this.getSpanName(request, this.extractor), parent)).setSpanKind(Span.Kind.CLIENT).startSpan()).getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            this.addSpanRequestAttributes(span, request, this.extractor);
        }
        if (!(spanContext = span.getContext()).equals(SpanContext.INVALID)) {
            this.textFormat.inject(spanContext, carrier, this.setter);
        }
        return this.getNewContext(span, this.tagger.getCurrentTagContext());
    }

    public void handleEnd(HttpRequestContext context, @Nullable Q request, @Nullable P response, @Nullable Throwable error) {
        Preconditions.checkNotNull(context, "context");
        int httpCode = this.extractor.getStatusCode(response);
        this.recordStats(context, request, httpCode);
        this.spanEnd(context.span, httpCode, error);
    }

    private void recordStats(HttpRequestContext context, @Nullable Q request, int httpCode) {
        double requestLatency = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - context.requestStartTime);
        String methodStr = request == null ? "" : this.extractor.getMethod(request);
        String host = request == null ? "null_request" : this.extractor.getHost(request);
        TagContext startCtx = this.tagger.toBuilder(context.tagContext).put(HttpMeasureConstants.HTTP_CLIENT_HOST, TagValue.create(host == null ? "null_host" : host), HttpRequestContext.METADATA_NO_PROPAGATION).put(HttpMeasureConstants.HTTP_CLIENT_METHOD, TagValue.create(methodStr == null ? "" : methodStr), HttpRequestContext.METADATA_NO_PROPAGATION).put(HttpMeasureConstants.HTTP_CLIENT_STATUS, TagValue.create(httpCode == 0 ? "error" : Integer.toString(httpCode)), HttpRequestContext.METADATA_NO_PROPAGATION).build();
        this.statsRecorder.newMeasureMap().put(HttpMeasureConstants.HTTP_CLIENT_ROUNDTRIP_LATENCY, requestLatency).put(HttpMeasureConstants.HTTP_CLIENT_SENT_BYTES, context.sentMessageSize.get()).put(HttpMeasureConstants.HTTP_CLIENT_RECEIVED_BYTES, context.receiveMessageSize.get()).record(startCtx);
    }
}

