/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class AvroSchemaUtil {
    private static final String DECIMAL = "decimal";
    private static final String UUID = "uuid";
    private static final String DATE = "date";
    private static final String TIME_MILLIS = "time-millis";
    private static final String TIME_MICROS = "time-micros";
    private static final String TIMESTAMP_MILLIS = "timestamp-millis";
    private static final String TIMESTAMP_MICROS = "timestamp-micros";
    private static final Map<String, Conversion<?>> CONVERSION_MAP = new HashMap();

    private AvroSchemaUtil() {
    }

    public static Conversion<?> findConversionFor(String typeName) {
        return CONVERSION_MAP.get(typeName);
    }

    public static FieldSpec.DataType valueOf(Schema.Type avroType) {
        switch (avroType) {
            case INT: {
                return FieldSpec.DataType.INT;
            }
            case LONG: {
                return FieldSpec.DataType.LONG;
            }
            case FLOAT: {
                return FieldSpec.DataType.FLOAT;
            }
            case DOUBLE: {
                return FieldSpec.DataType.DOUBLE;
            }
            case BOOLEAN: {
                return FieldSpec.DataType.BOOLEAN;
            }
            case STRING: 
            case ENUM: {
                return FieldSpec.DataType.STRING;
            }
            case BYTES: 
            case FIXED: {
                return FieldSpec.DataType.BYTES;
            }
            case MAP: 
            case ARRAY: 
            case RECORD: 
            case UNION: {
                return FieldSpec.DataType.JSON;
            }
        }
        throw new UnsupportedOperationException("Unsupported Avro type: " + String.valueOf(avroType));
    }

    public static boolean isPrimitiveType(Schema.Type avroType) {
        switch (avroType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case STRING: 
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    public static ObjectNode toAvroSchemaJsonObject(FieldSpec fieldSpec) {
        ObjectNode jsonSchema = JsonUtils.newObjectNode();
        jsonSchema.put("name", fieldSpec.getName());
        switch (fieldSpec.getDataType().getStoredType()) {
            case INT: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "int"));
                return jsonSchema;
            }
            case LONG: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "long"));
                return jsonSchema;
            }
            case FLOAT: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "float"));
                return jsonSchema;
            }
            case DOUBLE: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "double"));
                return jsonSchema;
            }
            case STRING: 
            case JSON: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "string"));
                return jsonSchema;
            }
            case BYTES: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "bytes"));
                return jsonSchema;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static ArrayNode convertStringsToJsonArray(String ... strings) {
        ArrayNode jsonArray = JsonUtils.newArrayNode();
        for (String string : strings) {
            jsonArray.add(string);
        }
        return jsonArray;
    }

    public static Object applyLogicalType(Schema.Field field, Object value) {
        if (field == null || field.schema() == null) {
            return value;
        }
        Schema fieldSchema = AvroSchemaUtil.resolveUnionSchema(field.schema());
        return AvroSchemaUtil.applySchemaTypeLogic(fieldSchema, value);
    }

    private static Schema resolveUnionSchema(Schema schema) {
        if (schema.isUnion()) {
            for (Schema subSchema : schema.getTypes()) {
                if (subSchema.getLogicalType() == null) continue;
                return subSchema;
            }
        }
        return schema;
    }

    private static Object applySchemaTypeLogic(Schema schema, Object value) {
        switch (schema.getType()) {
            case ARRAY: {
                return AvroSchemaUtil.processArraySchema(value, schema);
            }
            case MAP: {
                return AvroSchemaUtil.processMapSchema((Map)value, schema);
            }
            case RECORD: {
                return AvroSchemaUtil.convertLogicalType((GenericRecord)value);
            }
        }
        return AvroSchemaUtil.applyConversion(value, schema);
    }

    private static Object processArraySchema(Object object, Schema schema) {
        Schema elementSchema = schema.getElementType();
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            list.replaceAll(element -> AvroSchemaUtil.processElement(element, elementSchema));
            return list;
        }
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object element2 = Array.get(object, i);
                Array.set(object, i, AvroSchemaUtil.processElement(element2, elementSchema));
            }
            return object;
        }
        GenericData.Array array = (GenericData.Array)object;
        for (int i = 0; i < array.size(); ++i) {
            array.set(i, AvroSchemaUtil.processElement(array.get(i), elementSchema));
        }
        return array;
    }

    private static Object processMapSchema(Map<String, Object> map, Schema schema) {
        Schema valueSchema = schema.getValueType();
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            entry.setValue(AvroSchemaUtil.processElement(entry.getValue(), valueSchema));
        }
        return map;
    }

    private static Object processElement(Object element, Schema schema) {
        if (element instanceof GenericRecord) {
            return AvroSchemaUtil.convertLogicalType((GenericRecord)element);
        }
        return AvroSchemaUtil.applyConversion(element, schema);
    }

    private static Object applyConversion(Object value, Schema schema) {
        Conversion<?> conversion;
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema);
        if (logicalType != null && (conversion = AvroSchemaUtil.findConversionFor(logicalType.getName())) != null) {
            return Conversions.convertToLogicalType((Object)value, (Schema)schema, (LogicalType)logicalType, conversion);
        }
        return value;
    }

    public static GenericRecord convertLogicalType(GenericRecord record) {
        Schema schema = record.getSchema();
        GenericData.Record result = new GenericData.Record(schema);
        for (Schema.Field field : schema.getFields()) {
            Object value = record.get(field.name());
            Object convertedValue = AvroSchemaUtil.applyLogicalType(field, value);
            result.put(field.name(), convertedValue);
        }
        return result;
    }

    static {
        CONVERSION_MAP.put(DECIMAL, (Conversion<?>)new Conversions.DecimalConversion());
        CONVERSION_MAP.put(UUID, (Conversion<?>)new Conversions.UUIDConversion());
        CONVERSION_MAP.put(DATE, (Conversion<?>)new TimeConversions.DateConversion());
        CONVERSION_MAP.put(TIME_MILLIS, (Conversion<?>)new TimeConversions.TimeMillisConversion());
        CONVERSION_MAP.put(TIME_MICROS, (Conversion<?>)new TimeConversions.TimeMicrosConversion());
        CONVERSION_MAP.put(TIMESTAMP_MILLIS, (Conversion<?>)new TimeConversions.TimestampMillisConversion());
        CONVERSION_MAP.put(TIMESTAMP_MICROS, (Conversion<?>)new TimeConversions.TimestampMicrosConversion());
    }
}

