/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SegmentConversionResult {
    private final File _file;
    private final String _tableNameWithType;
    private final String _segmentName;
    private final Map<String, Object> _customProperties;

    private SegmentConversionResult(File file, String tableNameWithType, String segmentName, Map<String, Object> customProperties) {
        this._file = file;
        this._tableNameWithType = tableNameWithType;
        this._segmentName = segmentName;
        this._customProperties = customProperties;
    }

    public File getFile() {
        return this._file;
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public <T> T getCustomProperty(String key) {
        return (T)this._customProperties.get(key);
    }

    public static class Builder {
        private File _file;
        private String _tableNameWithType;
        private String _segmentName;
        private final Map<String, Object> _customProperties = new HashMap<String, Object>();

        public Builder setFile(File file) {
            this._file = file;
            return this;
        }

        public Builder setTableNameWithType(String tableNameWithType) {
            this._tableNameWithType = tableNameWithType;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder setCustomProperty(String key, Object property) {
            this._customProperties.put(key, property);
            return this;
        }

        public SegmentConversionResult build() {
            return new SegmentConversionResult(this._file, this._tableNameWithType, this._segmentName, this._customProperties);
        }
    }
}

