/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.upsertcompaction;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.MinionMeter;
import org.apache.pinot.common.restlet.resources.ValidDocIdsType;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.plugin.minion.tasks.BaseSingleSegmentConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.readers.CompactedPinotSegmentRecordReader;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.utils.Obfuscator;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertCompactionTaskExecutor
extends BaseSingleSegmentConversionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertCompactionTaskExecutor.class);

    @Override
    protected SegmentConversionResult convert(PinotTaskConfig pinotTaskConfig, File indexDir, File workingDir) throws Exception {
        int totalDocsAfterCompaction;
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Compacting segment: " + String.valueOf(indexDir)));
        Map configs = pinotTaskConfig.getConfigs();
        String segmentName = (String)configs.get("segmentName");
        String taskType = pinotTaskConfig.getTaskType();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting task: {} with configs: {}", (Object)taskType, (Object)Obfuscator.DEFAULT.toJsonString((Object)configs));
        }
        long startMillis = System.currentTimeMillis();
        String tableNameWithType = (String)configs.get("tableName");
        TableConfig tableConfig = this.getTableConfig(tableNameWithType);
        String validDocIdsTypeStr = configs.getOrDefault("validDocIdsType", ValidDocIdsType.SNAPSHOT.name());
        SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(indexDir);
        String originalSegmentCrcFromTaskGenerator = (String)configs.get("crc");
        String crcFromDeepStorageSegment = segmentMetadata.getCrc();
        boolean ignoreCrcMismatch = Boolean.parseBoolean(configs.getOrDefault("ignoreCrcMismatch", String.valueOf(false)));
        if (!ignoreCrcMismatch && !originalSegmentCrcFromTaskGenerator.equals(crcFromDeepStorageSegment)) {
            String message = "Crc mismatched between ZK and deepstore copy of segment: " + segmentName + ". Expected crc from ZK: " + originalSegmentCrcFromTaskGenerator + ", crc from deepstore: " + crcFromDeepStorageSegment;
            LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        RoaringBitmap validDocIds = MinionTaskUtils.getValidDocIdFromServerMatchingCrc(tableNameWithType, segmentName, validDocIdsTypeStr, MINION_CONTEXT, originalSegmentCrcFromTaskGenerator);
        if (validDocIds == null) {
            String message = "No validDocIds found from all servers. They either failed to download or did not match crc from segment copy obtained from deepstore / servers. Expected crc: " + originalSegmentCrcFromTaskGenerator;
            LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        if (validDocIds.isEmpty()) {
            LOGGER.info("validDocIds is empty, skip the task. Table: {}, segment: {}", (Object)tableNameWithType, (Object)segmentName);
            if (indexDir.exists() && !FileUtils.deleteQuietly((File)indexDir)) {
                LOGGER.warn("Failed to delete input segment: {}", (Object)indexDir.getAbsolutePath());
            }
            if (!FileUtils.deleteQuietly((File)workingDir)) {
                LOGGER.warn("Failed to delete working directory: {}", (Object)workingDir.getAbsolutePath());
            }
            return new SegmentConversionResult.Builder().setTableNameWithType(tableNameWithType).setSegmentName(segmentName).build();
        }
        try (CompactedPinotSegmentRecordReader compactedRecordReader = new CompactedPinotSegmentRecordReader(validDocIds);){
            compactedRecordReader.init(indexDir, null, null);
            SegmentGeneratorConfig config = UpsertCompactionTaskExecutor.getSegmentGeneratorConfig(workingDir, tableConfig, segmentMetadata, segmentName, this.getSchema(tableNameWithType));
            SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
            driver.init(config, (RecordReader)compactedRecordReader);
            driver.build();
            this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Segment processing stats - incomplete rows:" + driver.getIncompleteRowsFound() + ", dropped rows:" + driver.getSkippedRowsFound() + ", sanitized rows:" + driver.getSanitizedRowsFound()));
            totalDocsAfterCompaction = driver.getSegmentStats().getTotalDocCount();
        }
        File compactedSegmentFile = new File(workingDir, segmentName);
        SegmentConversionResult result = new SegmentConversionResult.Builder().setFile(compactedSegmentFile).setTableNameWithType(tableNameWithType).setSegmentName(segmentName).build();
        this._minionMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)MinionMeter.COMPACTED_RECORDS_COUNT, (long)(segmentMetadata.getTotalDocs() - totalDocsAfterCompaction));
        long endMillis = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished task: {} with configs: {}. Total time: {}ms. Total docs before compaction: {}. Total docs after compaction: {}.", new Object[]{taskType, Obfuscator.DEFAULT.toJsonString((Object)configs), endMillis - startMillis, segmentMetadata.getTotalDocs(), totalDocsAfterCompaction});
        }
        return result;
    }

    private static SegmentGeneratorConfig getSegmentGeneratorConfig(File workingDir, TableConfig tableConfig, SegmentMetadataImpl segmentMetadata, String segmentName, Schema schema) {
        SegmentGeneratorConfig config = new SegmentGeneratorConfig(tableConfig, schema);
        config.setOutDir(workingDir.getPath());
        config.setSegmentName(segmentName);
        config.setCreationTime(String.valueOf(segmentMetadata.getIndexCreationTime()));
        if (segmentMetadata.getTimeInterval() != null) {
            config.setTimeColumnName(tableConfig.getValidationConfig().getTimeColumnName());
            config.setStartTime(Long.toString(segmentMetadata.getStartTime()));
            config.setEndTime(Long.toString(segmentMetadata.getEndTime()));
            config.setSegmentTimeUnit(segmentMetadata.getTimeUnit());
        }
        return config;
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, Collections.singletonMap("UpsertCompactionTask.time", String.valueOf(System.currentTimeMillis())));
    }
}

