/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.upsertcompactmerge;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.restlet.resources.ValidDocIdsType;
import org.apache.pinot.common.utils.SegmentUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.segment.processing.framework.DefaultSegmentNumRowProvider;
import org.apache.pinot.core.segment.processing.framework.SegmentNumRowProvider;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorFramework;
import org.apache.pinot.minion.MinionConf;
import org.apache.pinot.plugin.minion.tasks.BaseMultipleSegmentsConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.segment.local.segment.readers.CompactedPinotSegmentRecordReader;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.UploadedRealtimeSegmentNameGenerator;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderFileConfig;
import org.apache.pinot.spi.utils.Obfuscator;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertCompactMergeTaskExecutor
extends BaseMultipleSegmentsConversionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertCompactMergeTaskExecutor.class);

    public UpsertCompactMergeTaskExecutor(MinionConf minionConf) {
        super(minionConf);
    }

    @Override
    protected List<SegmentConversionResult> convert(PinotTaskConfig pinotTaskConfig, List<File> segmentDirs, File workingDir) throws Exception {
        int numInputSegments = segmentDirs.size();
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Converting segments: " + numInputSegments));
        String taskType = pinotTaskConfig.getTaskType();
        Map configs = pinotTaskConfig.getConfigs();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting task: {} with configs: {}", (Object)taskType, (Object)Obfuscator.DEFAULT.toJsonString((Object)configs));
        }
        long startMillis = System.currentTimeMillis();
        String tableNameWithType = (String)configs.get("tableName");
        TableConfig tableConfig = this.getTableConfig(tableNameWithType);
        Schema schema = this.getSchema(tableNameWithType);
        SegmentProcessorConfig.Builder segmentProcessorConfigBuilder = new SegmentProcessorConfig.Builder().setTableConfig(tableConfig).setSchema(schema);
        segmentProcessorConfigBuilder.setProgressObserver(p -> this._eventObserver.notifyProgress(this._pinotTaskConfig, p));
        List<SegmentMetadataImpl> segmentMetadataList = segmentDirs.stream().map(x -> {
            try {
                return new SegmentMetadataImpl(x);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error fetching segment-metadata for segmentDir: %s", x), e);
            }
        }).collect(Collectors.toList());
        int partitionID = this.getCommonPartitionIDForSegments(segmentMetadataList);
        long maxCreationTimeOfMergingSegments = this.getMaxZKCreationTimeFromConfig(configs);
        List<String> originalSegmentCrcFromTaskGenerator = List.of(((String)configs.get("crc")).split(","));
        this.validateCRCForInputSegments(segmentMetadataList, originalSegmentCrcFromTaskGenerator);
        List recordReaders = segmentMetadataList.stream().map(x -> {
            RoaringBitmap validDocIds = MinionTaskUtils.getValidDocIdFromServerMatchingCrc(tableNameWithType, x.getName(), ValidDocIdsType.SNAPSHOT.name(), MINION_CONTEXT, x.getCrc());
            if (validDocIds == null) {
                String message = String.format("No validDocIds found from all servers. They either failed to download or did not match crc from segment copy obtained from deepstore / servers. Expected crc: %s", "");
                LOGGER.error(message);
                throw new IllegalStateException(message);
            }
            return new CompactedPinotSegmentRecordReader(validDocIds);
        }).collect(Collectors.toList());
        ArrayList<RecordReaderFileConfig> recordReaderFileConfigs = new ArrayList<RecordReaderFileConfig>(recordReaders.size());
        for (int i = 0; i < recordReaders.size(); ++i) {
            RecordReader recordReader = (RecordReader)recordReaders.get(i);
            File segmentDir = segmentDirs.get(i);
            RecordReaderFileConfig recordReaderFileConfig = new RecordReaderFileConfig(null, segmentDir, null, null, recordReader);
            recordReaderFileConfigs.add(recordReaderFileConfig);
        }
        segmentProcessorConfigBuilder.setCustomCreationTime(Long.valueOf(maxCreationTimeOfMergingSegments));
        segmentProcessorConfigBuilder.setSegmentNameGenerator((SegmentNameGenerator)new UploadedRealtimeSegmentNameGenerator(TableNameBuilder.extractRawTableName((String)tableNameWithType), partitionID, System.currentTimeMillis(), "compacted", null));
        SegmentProcessorConfig segmentProcessorConfig = segmentProcessorConfigBuilder.build();
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)"Generating segments");
        SegmentProcessorFramework framework = new SegmentProcessorFramework(segmentProcessorConfig, workingDir, recordReaderFileConfigs, Collections.emptyList(), (SegmentNumRowProvider)new DefaultSegmentNumRowProvider(Integer.parseInt((String)configs.get("maxNumRecordsPerSegment"))));
        List outputSegmentDirs = framework.process();
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("transformation stats - incomplete:" + framework.getIncompleteRowsFound() + ", dropped:" + framework.getSkippedRowsFound() + ", sanitized:" + framework.getSanitizedRowsFound()));
        long endMillis = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished task: {} with configs: {}. Total time: {}ms", new Object[]{taskType, Obfuscator.DEFAULT.toJsonString((Object)configs), endMillis - startMillis});
        }
        ArrayList<SegmentConversionResult> results = new ArrayList<SegmentConversionResult>();
        for (File outputSegmentDir : outputSegmentDirs) {
            String outputSegmentName = outputSegmentDir.getName();
            results.add(new SegmentConversionResult.Builder().setFile(outputSegmentDir).setSegmentName(outputSegmentName).setTableNameWithType(tableNameWithType).build());
        }
        return results;
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        TreeMap<String, String> updateMap = new TreeMap<String, String>();
        updateMap.put("UpsertCompactMergeTask.time", String.valueOf(System.currentTimeMillis()));
        updateMap.put("UpsertCompactMergeTask.mergedSegments", (String)pinotTaskConfig.getConfigs().get("segmentName"));
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, updateMap);
    }

    int getCommonPartitionIDForSegments(List<SegmentMetadataImpl> segmentMetadataList) {
        List segmentNames = segmentMetadataList.stream().map(SegmentMetadataImpl::getName).collect(Collectors.toList());
        Set partitionIDSet = segmentNames.stream().map(x -> {
            Integer segmentPartitionId = SegmentUtils.getPartitionIdFromSegmentName((String)x);
            if (segmentPartitionId == null) {
                throw new IllegalStateException(String.format("Partition id not found for %s", x));
            }
            return segmentPartitionId;
        }).collect(Collectors.toSet());
        if (partitionIDSet.size() > 1) {
            throw new IllegalStateException("Found segments with different partition ids during task execution: " + String.valueOf(partitionIDSet));
        }
        return (Integer)partitionIDSet.iterator().next();
    }

    void validateCRCForInputSegments(List<SegmentMetadataImpl> segmentMetadataList, List<String> expectedCRCList) {
        for (int i = 0; i < segmentMetadataList.size(); ++i) {
            SegmentMetadataImpl segmentMetadata = segmentMetadataList.get(i);
            if (Objects.equals(segmentMetadata.getCrc(), expectedCRCList.get(i))) continue;
            String message = String.format("Crc mismatched between ZK and deepstore copy of segment: %s. Expected crc from ZK: %s, crc from deepstore: %s", segmentMetadata.getName(), expectedCRCList.get(i), segmentMetadata.getCrc());
            LOGGER.error(message);
            throw new IllegalStateException(message);
        }
    }

    long getMaxZKCreationTimeFromConfig(Map<String, String> configs) {
        String maxCreationTimeStr = configs.get("maxZKCreationTimeMillis");
        if (maxCreationTimeStr == null) {
            throw new IllegalStateException("Max creation time configuration is missing from task config.");
        }
        try {
            long maxCreationTime = Long.parseLong(maxCreationTimeStr);
            if (maxCreationTime <= 0L) {
                throw new IllegalStateException("No valid creation time found for the new merged segment. This might be due to missing creation time for merging segments");
            }
            return maxCreationTime;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Invalid max creation time format in task config: " + maxCreationTimeStr, e);
        }
    }
}

