/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import kafka.zk.FeatureZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static BrokerIdZNode$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;
    private final String FeaturesKey;

    static {
        new BrokerIdZNode$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    private String RackKey() {
        return this.RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    private String FeaturesKey() {
        return this.FeaturesKey;
    }

    public String path(int id) {
        return new StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(id).toString();
    }

    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack2, Features<SupportedVersionRange> features) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.VersionKey()), BoxesRunTime.boxToInteger(version)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.HostKey()), host), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.PortKey()), BoxesRunTime.boxToInteger(port)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.EndpointsKey()), CollectionConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)advertisedEndpoints.map((Function1<EndPoint, String> & Serializable & scala.Serializable)x$1 -> x$1.connectionString(), Seq$.MODULE$.canBuildFrom())).toBuffer()).asJava()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.JmxPortKey()), BoxesRunTime.boxToInteger(jmxPort)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TimestampKey()), Long.toString(Time.SYSTEM.milliseconds()))}));
        rack2.foreach((Function1<String, Object> & Serializable & scala.Serializable)rack -> {
            if (version >= 3) {
                return jsonMap.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.RackKey()), rack));
            }
            return BoxedUnit.UNIT;
        });
        if (version >= 4) {
            jsonMap.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ListenerSecurityProtocolMapKey()), CollectionConverters$.MODULE$.mapAsJavaMapConverter(((TraversableOnce)advertisedEndpoints.map((Function1<EndPoint, Tuple2> & Serializable & scala.Serializable)endPoint -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(endPoint.listenerName().value()), endPoint.securityProtocol().name), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()));
        }
        if (version >= 5) {
            jsonMap.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.FeaturesKey()), features.toMap()));
        }
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        EndPoint plaintextEndpoint = (EndPoint)broker.endPoints().find((Function1<EndPoint, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(BrokerIdZNode$.$anonfun$encode$4(x$2))).getOrElse((Function0<EndPoint> & Serializable & scala.Serializable)() -> new EndPoint(null, -1, null, null));
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack(), broker.features());
    }

    public java.util.Map<String, java.util.Map<String, Short>> featuresAsJavaMap(JsonObject brokerInfo) {
        return FeatureZNode$.MODULE$.asJavaMap((Map)brokerInfo.get(this.FeaturesKey()).flatMap((Function1<JsonValue, Option> & Serializable & scala.Serializable)x$3 -> x$3.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$.MODULE$.decodeMap(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeInt$.MODULE$, scala.collection.Map$.MODULE$.canBuildFrom()), scala.collection.Map$.MODULE$.canBuildFrom())))).map((Function1<Map, scala.collection.immutable.Map> & Serializable & scala.Serializable)theMap -> ((TraversableOnce)theMap.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String featureName = (String)x0$1._1();
            Map versionsInfo = (Map)x0$1._2();
            Tuple2 tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(featureName), ((TraversableOnce)versionsInfo.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError((Object)null);
                }
                String label = (String)x0$2._1();
                int version = x0$2._2$mcI$sp();
                Tuple2<String, Short> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(label), BoxesRunTime.boxToShort((short)version));
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0<Map> & Serializable & scala.Serializable)() -> (Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$)));
    }

    public BrokerInfo decode(int id, byte[] jsonBytes) {
        $colon$colon<Nothing$> $colon$colon;
        int jmxPort;
        int version;
        JsonObject brokerInfo;
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            brokerInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            version = BoxesRunTime.unboxToInt(brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            jmxPort = BoxesRunTime.unboxToInt(brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder(44).append("Unsupported version of broker registration: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt(brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol(securityProtocol), securityProtocol);
                $colon$colon = new $colon$colon<Nothing$>((Nothing$)((Object)endPoint), Nil$.MODULE$);
            } else {
                Option securityProtocolMap = brokerInfo.get(this.ListenerSecurityProtocolMapKey()).map((Function1<JsonValue, Map> & Serializable & scala.Serializable)x$4 -> ((TraversableLike)x$4.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeString$.MODULE$, scala.collection.Map$.MODULE$.canBuildFrom()))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError((Object)null);
                    }
                    String listenerName = (String)x0$1._1();
                    String securityProtocol = (String)x0$1._2();
                    Tuple2<ListenerName, SecurityProtocol> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new ListenerName(listenerName)), SecurityProtocol.forName(securityProtocol));
                    return tuple2;
                }, scala.collection.Map$.MODULE$.canBuildFrom()));
                $colon$colon = ((Seq)brokerInfo.apply(this.EndpointsKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).map((Function1<String, EndPoint> & Serializable & scala.Serializable)x$5 -> EndPoint$.MODULE$.createEndPoint((String)x$5, securityProtocolMap), Seq$.MODULE$.canBuildFrom());
            }
        } else {
            if (either instanceof Left) {
                JsonProcessingException e = (JsonProcessingException)((Left)either).value();
                throw new KafkaException(new StringBuilder(52).append("Failed to parse ZooKeeper registration for broker ").append(id).append(": ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), e);
            }
            throw new MatchError(either);
        }
        $colon$colon<Nothing$> endpoints = $colon$colon;
        Option<String> rack = brokerInfo.get(this.RackKey()).flatMap((Function1<JsonValue, Option> & Serializable & scala.Serializable)x$6 -> x$6.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeString$.MODULE$)));
        java.util.Map<String, java.util.Map<String, Short>> features = this.featuresAsJavaMap(brokerInfo);
        BrokerInfo brokerInfo2 = new BrokerInfo(new Broker(id, endpoints, rack, Features.fromSupportedFeaturesMap(features)), version, jmxPort);
        return brokerInfo2;
    }

    public static final /* synthetic */ boolean $anonfun$encode$4(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !((Object)((Object)securityProtocol)).equals((Object)securityProtocol2) : securityProtocol2 != null);
    }

    private BrokerIdZNode$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
        this.FeaturesKey = "features";
    }
}

