/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.io.IOException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.snapshot.RawSnapshotWriter;

public class FollowerState
implements EpochState {
    private final int fetchTimeoutMs;
    private final int epoch;
    private final int leaderId;
    private final Set<Integer> voters;
    private final Timer fetchTimer;
    private Optional<LogOffsetMetadata> highWatermark;
    private Optional<RawSnapshotWriter> fetchingSnapshot;

    public FollowerState(Time time, int epoch, int leaderId, Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark, int fetchTimeoutMs) {
        this.fetchTimeoutMs = fetchTimeoutMs;
        this.epoch = epoch;
        this.leaderId = leaderId;
        this.voters = voters;
        this.fetchTimer = time.timer(fetchTimeoutMs);
        this.highWatermark = highWatermark;
        this.fetchingSnapshot = Optional.empty();
    }

    @Override
    public ElectionState election() {
        return new ElectionState(this.epoch, OptionalInt.of(this.leaderId), OptionalInt.empty(), this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public String name() {
        return "Follower";
    }

    public long remainingFetchTimeMs(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        return this.fetchTimer.remainingMs();
    }

    public int leaderId() {
        return this.leaderId;
    }

    public boolean hasFetchTimeoutExpired(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        return this.fetchTimer.isExpired();
    }

    public void resetFetchTimeout(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        this.fetchTimer.reset(this.fetchTimeoutMs);
    }

    public void overrideFetchTimeout(long currentTimeMs, long timeoutMs) {
        this.fetchTimer.update(currentTimeMs);
        this.fetchTimer.reset(timeoutMs);
    }

    public boolean updateHighWatermark(OptionalLong highWatermark) {
        if (!highWatermark.isPresent() && this.highWatermark.isPresent()) {
            throw new IllegalArgumentException("Attempt to overwrite current high watermark " + this.highWatermark + " with unknown value");
        }
        if (this.highWatermark.isPresent()) {
            long previousHighWatermark = this.highWatermark.get().offset;
            long updatedHighWatermark = highWatermark.getAsLong();
            if (updatedHighWatermark < 0L) {
                throw new IllegalArgumentException("Illegal negative high watermark update");
            }
            if (previousHighWatermark > updatedHighWatermark) {
                throw new IllegalArgumentException("Non-monotonic update of high watermark attempted");
            }
            if (previousHighWatermark == updatedHighWatermark) {
                return false;
            }
        }
        this.highWatermark = highWatermark.isPresent() ? Optional.of(new LogOffsetMetadata(highWatermark.getAsLong())) : Optional.empty();
        return true;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    public Optional<RawSnapshotWriter> fetchingSnapshot() {
        return this.fetchingSnapshot;
    }

    public void setFetchingSnapshot(Optional<RawSnapshotWriter> fetchingSnapshot) throws IOException {
        if (fetchingSnapshot.isPresent()) {
            fetchingSnapshot.get().close();
        }
        this.fetchingSnapshot = fetchingSnapshot;
    }

    public String toString() {
        return "FollowerState(fetchTimeoutMs=" + this.fetchTimeoutMs + ", epoch=" + this.epoch + ", leaderId=" + this.leaderId + ", voters=" + this.voters + ')';
    }

    @Override
    public void close() throws IOException {
        if (this.fetchingSnapshot.isPresent()) {
            this.fetchingSnapshot.get().close();
        }
    }
}

