/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufFieldInfo;
import org.apache.pinot.shaded.com.google.common.collect.Maps;
import org.apache.pinot.spi.data.readers.BaseRecordExtractor;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;

public class ProtoBufRecordExtractor
extends BaseRecordExtractor<Message> {
    private Set<String> _fields;
    private boolean _extractAll = false;

    public void init(@Nullable Set<String> fields, RecordExtractorConfig recordExtractorConfig) {
        if (fields == null || fields.isEmpty()) {
            this._extractAll = true;
            this._fields = Set.of();
        } else {
            this._fields = Set.copyOf(fields);
        }
    }

    private Object getFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Message message) {
        if (!fieldDescriptor.hasPresence() || message.hasField(fieldDescriptor)) {
            return message.getField(fieldDescriptor);
        }
        return null;
    }

    public GenericRow extract(Message from, GenericRow to) {
        Descriptors.Descriptor descriptor = from.getDescriptorForType();
        if (this._extractAll) {
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                Object fieldValue = this.getFieldValue(fieldDescriptor, from);
                if (fieldValue != null) {
                    fieldValue = this.convert(new ProtoBufFieldInfo(fieldValue, fieldDescriptor));
                }
                to.putValue(fieldDescriptor.getName(), fieldValue);
            }
        } else {
            for (String fieldName : this._fields) {
                Object fieldValue;
                Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(fieldName);
                Object object = fieldValue = fieldDescriptor == null ? null : this.getFieldValue(fieldDescriptor, from);
                if (fieldValue != null) {
                    fieldValue = this.convert(new ProtoBufFieldInfo(fieldValue, descriptor.findFieldByName(fieldName)));
                }
                to.putValue(fieldName, fieldValue);
            }
        }
        return to;
    }

    protected boolean isRecord(Object value) {
        return ((ProtoBufFieldInfo)value).getFieldValue() instanceof Message;
    }

    protected boolean isMultiValue(Object value) {
        ProtoBufFieldInfo protoBufFieldInfo = (ProtoBufFieldInfo)value;
        return protoBufFieldInfo.getFieldValue() instanceof Collection && !protoBufFieldInfo.getFieldDescriptor().isMapField();
    }

    protected boolean isMap(Object value) {
        ProtoBufFieldInfo protoBufFieldInfo = (ProtoBufFieldInfo)value;
        return protoBufFieldInfo.getFieldValue() instanceof Collection && protoBufFieldInfo.getFieldDescriptor().isMapField();
    }

    protected Map<Object, Object> convertMap(Object value) {
        ProtoBufFieldInfo protoBufFieldInfo = (ProtoBufFieldInfo)value;
        List<Descriptors.FieldDescriptor> fieldDescriptors = protoBufFieldInfo.getFieldDescriptor().getMessageType().getFields();
        Descriptors.FieldDescriptor keyDescriptor = fieldDescriptors.get(0);
        Descriptors.FieldDescriptor valueDescriptor = fieldDescriptors.get(1);
        Collection messages = (Collection)protoBufFieldInfo.getFieldValue();
        HashMap convertedMap = Maps.newHashMapWithExpectedSize((int)messages.size());
        for (Message message : messages) {
            Object fieldKey = message.getField(keyDescriptor);
            if (fieldKey == null) continue;
            Object fieldValue = message.getField(valueDescriptor);
            Object convertedValue = fieldValue != null ? this.convert(new ProtoBufFieldInfo(fieldValue, valueDescriptor)) : null;
            convertedMap.put(this.convertSingleValue(new ProtoBufFieldInfo(fieldKey, keyDescriptor)), convertedValue);
        }
        return convertedMap;
    }

    protected Object[] convertMultiValue(Object value) {
        ProtoBufFieldInfo protoBufFieldInfo = (ProtoBufFieldInfo)value;
        Descriptors.FieldDescriptor fieldDescriptor = protoBufFieldInfo.getFieldDescriptor();
        Collection values = (Collection)protoBufFieldInfo.getFieldValue();
        int numValues = values.size();
        Object[] convertedValues = new Object[numValues];
        int index = 0;
        for (Object fieldValue : values) {
            Object convertedValue = fieldValue != null ? this.convert(new ProtoBufFieldInfo(fieldValue, fieldDescriptor)) : null;
            convertedValues[index++] = convertedValue;
        }
        return convertedValues;
    }

    protected Object convertSingleValue(Object value) {
        Object fieldValue = ((ProtoBufFieldInfo)value).getFieldValue();
        if (fieldValue instanceof ByteString) {
            return ((ByteString)fieldValue).toByteArray();
        }
        if (fieldValue instanceof Number) {
            return fieldValue;
        }
        return fieldValue.toString();
    }

    protected Map<Object, Object> convertRecord(Object value) {
        ProtoBufFieldInfo record = (ProtoBufFieldInfo)value;
        Map<Descriptors.FieldDescriptor, Object> fields = ((Message)record.getFieldValue()).getAllFields();
        HashMap convertedMap = Maps.newHashMapWithExpectedSize((int)fields.size());
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object fieldValue = entry.getValue();
            Object convertedValue = fieldValue != null ? this.convert(new ProtoBufFieldInfo(fieldValue, fieldDescriptor)) : null;
            convertedMap.put(fieldDescriptor.getName(), convertedValue);
        }
        return convertedMap;
    }
}

