/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import java.math.BigDecimal;
import java.util.Objects;
import org.everit.json.schema.NumberSchema;

class NumberSchemaDiff {
    NumberSchemaDiff() {
    }

    static void compare(Context ctx2, NumberSchema original, NumberSchema update) {
        BigDecimal originalMultipleOf;
        if (!Objects.equals(original.getMaximum(), update.getMaximum())) {
            if (original.getMaximum() == null && update.getMaximum() != null) {
                ctx2.addDifference("maximum", Difference.Type.MAXIMUM_ADDED);
            } else if (original.getMaximum() != null && update.getMaximum() == null) {
                ctx2.addDifference("maximum", Difference.Type.MAXIMUM_REMOVED);
            } else if (original.getMaximum().doubleValue() < update.getMaximum().doubleValue()) {
                ctx2.addDifference("maximum", Difference.Type.MAXIMUM_INCREASED);
            } else if (original.getMaximum().doubleValue() > update.getMaximum().doubleValue()) {
                ctx2.addDifference("maximum", Difference.Type.MAXIMUM_DECREASED);
            }
        }
        if (!Objects.equals(original.getMinimum(), update.getMinimum())) {
            if (original.getMinimum() == null && update.getMinimum() != null) {
                ctx2.addDifference("minimum", Difference.Type.MINIMUM_ADDED);
            } else if (original.getMinimum() != null && update.getMinimum() == null) {
                ctx2.addDifference("minimum", Difference.Type.MINIMUM_REMOVED);
            } else if (original.getMinimum().doubleValue() < update.getMinimum().doubleValue()) {
                ctx2.addDifference("minimum", Difference.Type.MINIMUM_INCREASED);
            } else if (original.getMinimum().doubleValue() > update.getMinimum().doubleValue()) {
                ctx2.addDifference("minimum", Difference.Type.MINIMUM_DECREASED);
            }
        }
        if (!Objects.equals(original.getExclusiveMaximumLimit(), update.getExclusiveMaximumLimit())) {
            if (original.getExclusiveMaximumLimit() == null && update.getExclusiveMaximumLimit() != null) {
                ctx2.addDifference("exclusiveMaximum", Difference.Type.EXCLUSIVE_MAXIMUM_ADDED);
            } else if (original.getExclusiveMaximumLimit() != null && update.getExclusiveMaximumLimit() == null) {
                ctx2.addDifference("exclusiveMaximum", Difference.Type.EXCLUSIVE_MAXIMUM_REMOVED);
            } else if (original.getExclusiveMaximumLimit().doubleValue() < update.getExclusiveMaximumLimit().doubleValue()) {
                ctx2.addDifference("exclusiveMaximum", Difference.Type.EXCLUSIVE_MAXIMUM_INCREASED);
            } else if (original.getExclusiveMaximumLimit().doubleValue() > update.getMaximum().doubleValue()) {
                ctx2.addDifference("exclusiveMaximum", Difference.Type.EXCLUSIVE_MAXIMUM_DECREASED);
            }
        }
        if (!Objects.equals(original.getExclusiveMinimumLimit(), update.getExclusiveMinimumLimit())) {
            if (original.getExclusiveMinimumLimit() == null && update.getExclusiveMinimumLimit() != null) {
                ctx2.addDifference("exclusiveMinimum", Difference.Type.EXCLUSIVE_MINIMUM_ADDED);
            } else if (original.getExclusiveMinimumLimit() != null && update.getExclusiveMinimumLimit() == null) {
                ctx2.addDifference("exclusiveMinimum", Difference.Type.EXCLUSIVE_MINIMUM_REMOVED);
            } else if (original.getExclusiveMinimumLimit().doubleValue() < update.getExclusiveMinimumLimit().doubleValue()) {
                ctx2.addDifference("exclusiveMinimum", Difference.Type.EXCLUSIVE_MINIMUM_INCREASED);
            } else if (original.getExclusiveMinimumLimit().doubleValue() > update.getExclusiveMinimumLimit().doubleValue()) {
                ctx2.addDifference("exclusiveMinimum", Difference.Type.EXCLUSIVE_MINIMUM_DECREASED);
            }
        }
        BigDecimal updateMultipleOf = update.getMultipleOf() != null ? new BigDecimal(update.getMultipleOf().toString()) : null;
        BigDecimal bigDecimal = originalMultipleOf = original.getMultipleOf() != null ? new BigDecimal(original.getMultipleOf().toString()) : null;
        if (!Objects.equals(originalMultipleOf, updateMultipleOf)) {
            if (originalMultipleOf == null) {
                ctx2.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_ADDED);
            } else if (updateMultipleOf == null) {
                ctx2.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_REMOVED);
            } else if (update.getMultipleOf().intValue() % original.getMultipleOf().intValue() == 0) {
                ctx2.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_EXPANDED);
            } else if (original.getMultipleOf().intValue() % update.getMultipleOf().intValue() == 0) {
                ctx2.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_REDUCED);
            } else {
                ctx2.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_CHANGED);
            }
        }
        if (original.requiresInteger() != update.requiresInteger()) {
            if (original.requiresInteger()) {
                ctx2.addDifference(Difference.Type.TYPE_EXTENDED);
            } else {
                ctx2.addDifference(Difference.Type.TYPE_NARROWED);
            }
        }
    }
}

