/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.json.confluent;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.pinot.plugin.inputformat.json.JSONRecordExtractor;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractor;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfluentSchemaRegistryJsonMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConfluentSchemaRegistryJsonMessageDecoder.class);
    private static final String SCHEMA_REGISTRY_REST_URL = "schema.registry.rest.url";
    private static final String SCHEMA_REGISTRY_OPTS_PREFIX = "schema.registry.";
    public static final String CACHED_SCHEMA_MAP_CAPACITY = "cached.schema.map.capacity";
    public static final String DEFAULT_CACHED_SCHEMA_MAP_CAPACITY = "1000";
    private KafkaJsonSchemaDeserializer _deserializer;
    private RecordExtractor<Map<String, Object>> _jsonRecordExtractor;
    private String _topicName;
    @Nullable
    private final Consumer<Map<String, Object>> _onMessage;

    public KafkaConfluentSchemaRegistryJsonMessageDecoder() {
        this._onMessage = null;
    }

    @VisibleForTesting
    KafkaConfluentSchemaRegistryJsonMessageDecoder(@Nullable Consumer<Map<String, Object>> onMessage) {
        this._onMessage = onMessage;
    }

    private RestService createRestService(String schemaRegistryUrl, Map<String, String> configs) {
        RestService restService = new RestService(schemaRegistryUrl);
        ConfigDef configDef = new ConfigDef();
        SslConfigs.addClientSslSupport(configDef);
        Map<String, ConfigDef.ConfigKey> configKeyMap = configDef.configKeys();
        HashMap<String, Object> sslConfigs = new HashMap<String, Object>();
        for (String key : configs.keySet()) {
            if (key.equals(SCHEMA_REGISTRY_REST_URL) || !key.startsWith(SCHEMA_REGISTRY_OPTS_PREFIX)) continue;
            String value = configs.get(key);
            String schemaRegistryOptKey = key.substring(SCHEMA_REGISTRY_OPTS_PREFIX.length());
            if (!configKeyMap.containsKey(schemaRegistryOptKey)) continue;
            if (configKeyMap.get((Object)schemaRegistryOptKey).type == ConfigDef.Type.PASSWORD) {
                sslConfigs.put(schemaRegistryOptKey, new Password(value));
                continue;
            }
            sslConfigs.put(schemaRegistryOptKey, value);
        }
        if (!sslConfigs.isEmpty()) {
            DefaultSslEngineFactory sslFactory = new DefaultSslEngineFactory();
            sslFactory.configure(sslConfigs);
            restService.setSslSocketFactory(sslFactory.sslContext().getSocketFactory());
        }
        return restService;
    }

    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        Preconditions.checkState(props.containsKey(SCHEMA_REGISTRY_REST_URL), "Missing required property '%s'", (Object)SCHEMA_REGISTRY_REST_URL);
        String schemaRegistryUrl = props.get(SCHEMA_REGISTRY_REST_URL);
        JsonSchemaProvider jsonSchemaProvider = new JsonSchemaProvider();
        int identityMapCapacity = Integer.parseInt(props.getOrDefault(CACHED_SCHEMA_MAP_CAPACITY, DEFAULT_CACHED_SCHEMA_MAP_CAPACITY));
        CachedSchemaRegistryClient schemaRegistryClient = new CachedSchemaRegistryClient(this.createRestService(schemaRegistryUrl, props), identityMapCapacity, Collections.singletonList(jsonSchemaProvider), props, null);
        this._deserializer = new KafkaJsonSchemaDeserializer(schemaRegistryClient);
        Preconditions.checkNotNull(topicName, "Topic must be provided");
        this._topicName = topicName;
        this._jsonRecordExtractor = (RecordExtractor)PluginManager.get().createInstance(JSONRecordExtractor.class.getName());
        this._jsonRecordExtractor.init(fieldsToRead, null);
    }

    public GenericRow decode(byte[] payload, GenericRow destination) {
        try {
            JsonNode jsonRecord = (JsonNode)this._deserializer.deserialize(this._topicName, payload);
            Map from = JsonUtils.jsonNodeToMap((JsonNode)jsonRecord);
            return this._jsonRecordExtractor.extract((Object)from, destination);
        }
        catch (IOException | RuntimeException e) {
            this.ignoreOrRethrowException(e);
            return null;
        }
    }

    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        return this.decode(Arrays.copyOfRange(payload, offset, offset + length), destination);
    }

    private void ignoreOrRethrowException(RuntimeException e) {
        if (this.isUnknownMagicByte(e) || this.isUnknownMagicByte(e.getCause())) {
            LOGGER.error("Caught exception while decoding row in topic {}, discarding row", (Object)this._topicName, (Object)e);
            return;
        }
        throw e;
    }

    private void ignoreOrRethrowException(Exception e) {
        if (this.isUnknownMagicByte(e) || e.getCause() != null && this.isUnknownMagicByte(e.getCause())) {
            LOGGER.error("Caught IOexception while mapping jsonNode in topic {}, discarding row", (Object)this._topicName, (Object)e);
            return;
        }
        throw new RuntimeException(e);
    }

    private boolean isUnknownMagicByte(Throwable e) {
        return e != null && e instanceof SerializationException && e.getMessage() != null && e.getMessage().toLowerCase().contains("unknown magic byte");
    }
}

