/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.std.MapSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.MapType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.pinot.shaded.com.google.common.collect.Table;

public class TableSerializer
extends ContainerSerializer<Table<?, ?, ?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final MapLikeType _type;
    private final BeanProperty _property;
    private final JsonSerializer<Object> _rowSerializer;
    private final JsonSerializer<Object> _columnSerializer;
    private final TypeSerializer _valueTypeSerializer;
    private final JsonSerializer<Object> _valueSerializer;
    private final MapSerializer _rowMapSerializer;

    public TableSerializer(MapLikeType type) {
        super(type);
        this._type = type;
        this._property = null;
        this._rowSerializer = null;
        this._columnSerializer = null;
        this._valueTypeSerializer = null;
        this._valueSerializer = null;
        this._rowMapSerializer = null;
    }

    protected TableSerializer(TableSerializer src, BeanProperty property, TypeFactory typeFactory, JsonSerializer<?> rowKeySerializer, JsonSerializer<?> columnKeySerializer, TypeSerializer valueTypeSerializer, JsonSerializer<?> valueSerializer) {
        super(src);
        this._type = src._type;
        this._property = property;
        this._rowSerializer = rowKeySerializer;
        this._columnSerializer = columnKeySerializer;
        this._valueTypeSerializer = valueTypeSerializer;
        this._valueSerializer = valueSerializer;
        MapLikeType columnValueType = (MapLikeType)this._type.getContentType();
        MapType columnAndValueType = typeFactory.constructMapType(Map.class, columnValueType.getKeyType(), columnValueType.getContentType());
        MapSerializer columnAndValueSerializer = MapSerializer.construct((Set<String>)null, (JavaType)columnAndValueType, false, this._valueTypeSerializer, this._columnSerializer, this._valueSerializer, null);
        MapType rowMapType = typeFactory.constructMapType(Map.class, columnValueType.getKeyType(), columnAndValueType);
        this._rowMapSerializer = MapSerializer.construct((Set<String>)null, (JavaType)rowMapType, false, null, this._rowSerializer, (JsonSerializer<Object>)columnAndValueSerializer, null);
    }

    protected TableSerializer(TableSerializer src, TypeSerializer typeSer) {
        super(src);
        this._type = src._type;
        this._property = src._property;
        this._rowSerializer = src._rowSerializer;
        this._columnSerializer = src._columnSerializer;
        this._valueTypeSerializer = typeSer;
        this._valueSerializer = src._valueSerializer;
        this._rowMapSerializer = src._rowMapSerializer;
    }

    protected TableSerializer withResolved(BeanProperty property, TypeFactory typeFactory, JsonSerializer<?> rowKeySer, JsonSerializer<?> columnKeySer, TypeSerializer vts, JsonSerializer<?> valueSer) {
        return new TableSerializer(this, property, typeFactory, rowKeySer, columnKeySer, vts, valueSer);
    }

    @Override
    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSer) {
        return new TableSerializer(this, typeSer);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> valueSer = this._valueSerializer;
        MapLikeType columnValueType = (MapLikeType)this._type.getContentType();
        if (valueSer == null) {
            JavaType valueType = columnValueType.getContentType();
            if (valueType.isFinal()) {
                valueSer = provider.findValueSerializer(valueType, property);
            }
        } else if (valueSer instanceof ContextualSerializer) {
            valueSer = ((ContextualSerializer)((Object)valueSer)).createContextual(provider, property);
        }
        JsonSerializer<Object> rowKeySer = this._rowSerializer;
        if (rowKeySer == null) {
            rowKeySer = provider.findKeySerializer(this._type.getKeyType(), property);
        } else if (rowKeySer instanceof ContextualSerializer) {
            rowKeySer = ((ContextualSerializer)((Object)rowKeySer)).createContextual(provider, property);
        }
        JsonSerializer<Object> columnKeySer = this._columnSerializer;
        if (columnKeySer == null) {
            columnKeySer = provider.findKeySerializer(columnValueType.getKeyType(), property);
        } else if (columnKeySer instanceof ContextualSerializer) {
            columnKeySer = ((ContextualSerializer)((Object)columnKeySer)).createContextual(provider, property);
        }
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
        }
        return this.withResolved(property, provider.getTypeFactory(), rowKeySer, columnKeySer, typeSer, valueSer);
    }

    @Override
    public JavaType getContentType() {
        return this._type.getContentType().getContentType();
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Table<?, ?, ?> table) {
        return table.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Table<?, ?, ?> table) {
        return table.size() == 1;
    }

    @Override
    public void serialize(Table<?, ?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject(value);
        if (!value.isEmpty()) {
            this.serializeFields(value, gen, provider);
        }
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Table<?, ?, ?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.assignCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        this.serializeFields(value, gen, provider);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    private final void serializeFields(Table<?, ?, ?> table, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this._rowMapSerializer.serializeFields(table.rowMap(), jgen, provider);
    }
}

