/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.irstream;

import com.yscope.clp.compressorfrontend.NativeLibraryLoader;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class AbstractClpIrOutputStream
implements AutoCloseable,
Flushable {
    protected long nativeStateAddress = this.createNativeState();
    protected String timestampPattern;
    protected String timeZoneId;
    private final OutputStream outputStream;

    public AbstractClpIrOutputStream(String timestampPattern, String timeZoneId, OutputStream outputStream) {
        this.timestampPattern = timestampPattern;
        this.timeZoneId = timeZoneId;
        this.outputStream = outputStream;
    }

    @Override
    public void close() throws IOException {
        if (null != this.timestampPattern) {
            this.writePreamble(0L);
        }
        this.outputStream.write(this.getEofByte());
        this.outputStream.close();
        this.destroyNativeState(this.nativeStateAddress);
        this.nativeStateAddress = 0L;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void writeLogEvent(long timestamp, ByteBuffer message) throws IOException {
        if (0L == this.nativeStateAddress) {
            throw new IOException("Stream closed.");
        }
        if (null != this.timestampPattern) {
            this.writePreamble(timestamp);
        }
        byte[] encodedLogEvent = this.encodeLogEvent(timestamp, message);
        this.outputStream.write(encodedLogEvent);
    }

    protected abstract byte[] encodePreamble(long var1) throws IOException;

    protected abstract byte[] encodeLogEvent(long var1, ByteBuffer var3) throws IOException;

    private void writePreamble(long firstMessageTimestamp) throws IOException {
        this.outputStream.write(this.encodePreamble(firstMessageTimestamp));
        this.timestampPattern = null;
        this.timeZoneId = null;
    }

    private native long createNativeState();

    private native void destroyNativeState(long var1);

    private native byte getEofByte();

    static {
        NativeLibraryLoader.load();
    }
}

