/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.EntryFileIO;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.OutputValidationException;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateRenamedFilesStage
extends AbstractJobOrTaskStage<Path, List<FileEntry>> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateRenamedFilesStage.class);
    private List<FileEntry> filesCommitted = new ArrayList<FileEntry>();

    public ValidateRenamedFilesStage(StageConfig stageConfig) {
        super(false, stageConfig, "job_stage_optional_validate_output", true);
    }

    private synchronized List<FileEntry> getFilesCommitted() {
        return this.filesCommitted;
    }

    private synchronized void addFileCommitted(FileEntry entry) {
        this.filesCommitted.add(entry);
    }

    @Override
    protected List<FileEntry> executeStage(Path entryFile) throws IOException {
        EntryFileIO entryFileIO = new EntryFileIO(this.getStageConfig().getConf());
        try (SequenceFile.Reader reader = entryFileIO.createReader(entryFile);){
            TaskPool.foreach(entryFileIO.iterateOver(reader)).executeWith(this.getIOProcessors()).stopOnFailure().run(this::validateOneFile);
            List<FileEntry> list = this.getFilesCommitted();
            return list;
        }
    }

    private void validateOneFile(FileEntry entry) throws IOException {
        this.updateAuditContext("job_stage_optional_validate_output");
        this.progress();
        Path sourcePath = entry.getSourcePath();
        Path destPath = entry.getDestPath();
        try {
            String destEtag;
            FileStatus destStatus = this.getFileStatus(destPath);
            if (!destStatus.isFile()) {
                throw new OutputValidationException(destPath, "Expected a file renamed from " + sourcePath + "; found " + destStatus);
            }
            long sourceSize = entry.getSize();
            long destSize = destStatus.getLen();
            String sourceEtag = entry.getEtag();
            if (this.getOperations().storePreservesEtagsThroughRenames(destStatus.getPath()) && StringUtils.isNotBlank(sourceEtag) && !sourceEtag.equals(destEtag = ManifestCommitterSupport.getEtag(destStatus))) {
                LOG.warn("Etag of dest file {}: {} does not match that of manifest entry {}", destPath, destStatus, entry);
                throw new OutputValidationException(destPath, String.format("Expected the file renamed from %s with etag %s and length %s but found a file with etag %s and length %d", sourcePath, sourceEtag, sourceSize, destEtag, destSize));
            }
            if (destSize != sourceSize) {
                LOG.warn("Length of dest file {}: {} does not match that of manifest entry {}", destPath, destStatus, entry);
                throw new OutputValidationException(destPath, String.format("Expected the file renamed from %s with length %d but found a file of length %d", sourcePath, sourceSize, destSize));
            }
        }
        catch (FileNotFoundException e) {
            throw new OutputValidationException(destPath, "Expected a file, but it was not found", e);
        }
        this.addFileCommitted(entry);
    }
}

