/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro.confluent;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractor;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractorConfig;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractor;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfluentSchemaRegistryAvroMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConfluentSchemaRegistryAvroMessageDecoder.class);
    private static final String SCHEMA_REGISTRY_REST_URL = "schema.registry.rest.url";
    private static final String SCHEMA_REGISTRY_OPTS_PREFIX = "schema.registry.";
    private KafkaAvroDeserializer _deserializer;
    private RecordExtractor<GenericData.Record> _avroRecordExtractor;
    private String _topicName;

    public RestService createRestService(String schemaRegistryUrl, Map<String, String> configs) {
        RestService restService = new RestService(schemaRegistryUrl);
        ConfigDef configDef = new ConfigDef();
        SslConfigs.addClientSslSupport(configDef);
        Map<String, ConfigDef.ConfigKey> configKeyMap = configDef.configKeys();
        HashMap<String, Object> sslConfigs = new HashMap<String, Object>();
        for (String key : configs.keySet()) {
            if (key.equals(SCHEMA_REGISTRY_REST_URL) || !key.startsWith(SCHEMA_REGISTRY_OPTS_PREFIX)) continue;
            String value = configs.get(key);
            String schemaRegistryOptKey = key.substring(SCHEMA_REGISTRY_OPTS_PREFIX.length());
            if (!configKeyMap.containsKey(schemaRegistryOptKey)) continue;
            if (configKeyMap.get((Object)schemaRegistryOptKey).type == ConfigDef.Type.PASSWORD) {
                sslConfigs.put(schemaRegistryOptKey, new Password(value));
                continue;
            }
            sslConfigs.put(schemaRegistryOptKey, value);
        }
        if (!sslConfigs.isEmpty()) {
            DefaultSslEngineFactory sslFactory = new DefaultSslEngineFactory();
            sslFactory.configure(sslConfigs);
            restService.setSslSocketFactory(sslFactory.sslContext().getSocketFactory());
        }
        return restService;
    }

    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        Preconditions.checkState(props.containsKey(SCHEMA_REGISTRY_REST_URL), "Missing required property '%s'", (Object)SCHEMA_REGISTRY_REST_URL);
        String schemaRegistryUrl = props.get(SCHEMA_REGISTRY_REST_URL);
        CachedSchemaRegistryClient schemaRegistryClient = new CachedSchemaRegistryClient(this.createRestService(schemaRegistryUrl, props), 1000, props);
        this._deserializer = new KafkaAvroDeserializer(schemaRegistryClient);
        Preconditions.checkNotNull(topicName, "Topic must be provided");
        this._topicName = topicName;
        AvroRecordExtractorConfig config = new AvroRecordExtractorConfig();
        config.init(props);
        this._avroRecordExtractor = (RecordExtractor)PluginManager.get().createInstance(AvroRecordExtractor.class.getName());
        this._avroRecordExtractor.init(fieldsToRead, (RecordExtractorConfig)config);
    }

    public GenericRow decode(byte[] payload, GenericRow destination) {
        try {
            GenericData.Record avroRecord = (GenericData.Record)this._deserializer.deserialize(this._topicName, payload);
            return this._avroRecordExtractor.extract((Object)avroRecord, destination);
        }
        catch (RuntimeException e) {
            this.ignoreOrRethrowException(e);
            return null;
        }
    }

    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        return this.decode(Arrays.copyOfRange(payload, offset, offset + length), destination);
    }

    private void ignoreOrRethrowException(RuntimeException e) {
        if (this.isUnknownMagicByte(e) || this.isUnknownMagicByte(e.getCause())) {
            LOGGER.error("Caught exception while decoding row in topic {}, discarding row", (Object)this._topicName, (Object)e);
            return;
        }
        throw e;
    }

    private boolean isUnknownMagicByte(Throwable e) {
        return e != null && e instanceof SerializationException && e.getMessage() != null && e.getMessage().toLowerCase().contains("unknown magic byte");
    }
}

