/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.standalone;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.segment.generation.SegmentGenerationUtils;
import org.apache.pinot.common.utils.TarCompressionUtils;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.plugin.ingestion.batch.common.SegmentGenerationJobUtils;
import org.apache.pinot.plugin.ingestion.batch.common.SegmentGenerationTaskRunner;
import org.apache.pinot.plugin.ingestion.batch.standalone.JobUtils;
import org.apache.pinot.segment.local.utils.ConsistentDataPushUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.runner.IngestionJobRunner;
import org.apache.pinot.spi.ingestion.batch.spec.PinotClusterSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationTaskSpec;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentGenerationJobRunner
implements IngestionJobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentGenerationJobRunner.class);
    private SegmentGenerationJobSpec _spec;
    private ExecutorService _executorService;
    private PinotFS _inputDirFS;
    private PinotFS _outputDirFS;
    private URI _inputDirURI;
    private URI _outputDirURI;
    private CountDownLatch _segmentCreationTaskCountDownLatch;
    private Schema _schema;
    private TableConfig _tableConfig;
    private AtomicReference<Exception> _failure;
    private boolean _consistentPushEnabled;

    public SegmentGenerationJobRunner() {
    }

    public SegmentGenerationJobRunner(SegmentGenerationJobSpec spec) {
        this.init(spec);
    }

    public void init(SegmentGenerationJobSpec spec) {
        PinotClusterSpec pinotClusterSpec;
        this._spec = spec;
        if (this._spec.getInputDirURI() == null) {
            throw new RuntimeException("Missing property 'inputDirURI' in 'jobSpec' file");
        }
        try {
            this._inputDirURI = SegmentGenerationUtils.getDirectoryURI((String)this._spec.getInputDirURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid property: 'inputDirURI'", e);
        }
        if (this._spec.getOutputDirURI() == null) {
            throw new RuntimeException("Missing property 'outputDirURI' in 'jobSpec' file");
        }
        try {
            this._outputDirURI = SegmentGenerationUtils.getDirectoryURI((String)this._spec.getOutputDirURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid property: 'outputDirURI'", e);
        }
        if (this._spec.getRecordReaderSpec() == null) {
            throw new RuntimeException("Missing property 'recordReaderSpec' in 'jobSpec' file");
        }
        if (this._spec.getTableSpec() == null) {
            throw new RuntimeException("Missing property 'tableSpec' in 'jobSpec' file");
        }
        if (this._spec.getTableSpec().getTableName() == null) {
            throw new RuntimeException("Missing property 'tableName' in 'tableSpec'");
        }
        List pinotFSSpecs = this._spec.getPinotFSSpecs();
        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
        }
        this._inputDirFS = PinotFSFactory.create((String)this._inputDirURI.getScheme());
        this._outputDirFS = PinotFSFactory.create((String)this._outputDirURI.getScheme());
        try {
            if (!this._outputDirFS.exists(this._outputDirURI)) {
                this._outputDirFS.mkdir(this._outputDirURI);
            } else if (!this._outputDirFS.isDirectory(this._outputDirURI)) {
                throw new RuntimeException("Output Directory URI: " + String.valueOf(this._outputDirURI) + " is not a directory");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to validate output 'outputDirURI': " + String.valueOf(this._outputDirURI), e);
        }
        if (this._spec.getTableSpec().getSchemaURI() == null) {
            if (this._spec.getPinotClusterSpecs() == null || this._spec.getPinotClusterSpecs().length == 0) {
                throw new RuntimeException("Missing property 'schemaURI' in 'tableSpec'");
            }
            pinotClusterSpec = this._spec.getPinotClusterSpecs()[0];
            String schemaURI = SegmentGenerationUtils.generateSchemaURI((String)pinotClusterSpec.getControllerURI(), (String)this._spec.getTableSpec().getTableName());
            this._spec.getTableSpec().setSchemaURI(schemaURI);
        }
        this._schema = SegmentGenerationUtils.getSchema((String)this._spec.getTableSpec().getSchemaURI(), (String)this._spec.getAuthToken());
        if (this._spec.getTableSpec().getTableConfigURI() == null) {
            if (this._spec.getPinotClusterSpecs() == null || this._spec.getPinotClusterSpecs().length == 0) {
                throw new RuntimeException("Missing property 'tableConfigURI' in 'tableSpec'");
            }
            pinotClusterSpec = this._spec.getPinotClusterSpecs()[0];
            String tableConfigURI = SegmentGenerationUtils.generateTableConfigURI((String)pinotClusterSpec.getControllerURI(), (String)this._spec.getTableSpec().getTableName());
            this._spec.getTableSpec().setTableConfigURI(tableConfigURI);
        }
        this._tableConfig = SegmentGenerationUtils.getTableConfig((String)this._spec.getTableSpec().getTableConfigURI(), (String)spec.getAuthToken());
        this._consistentPushEnabled = ConsistentDataPushUtils.consistentDataPushEnabled((TableConfig)this._tableConfig);
        int jobParallelism = this._spec.getSegmentCreationJobParallelism();
        int numThreads = JobUtils.getNumThreads(jobParallelism);
        LOGGER.info("Creating an executor service with {} threads(Job parallelism: {}, available cores: {}.)", new Object[]{numThreads, jobParallelism, Runtime.getRuntime().availableProcessors()});
        this._executorService = Executors.newFixedThreadPool(numThreads);
        this._failure = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        List filteredFiles = SegmentGenerationUtils.listMatchedFilesWithRecursiveOption((PinotFS)this._inputDirFS, (URI)this._inputDirURI, (String)this._spec.getIncludeFileNamePattern(), (String)this._spec.getExcludeFileNamePattern(), (boolean)this._spec.isSearchRecursively());
        if (this._consistentPushEnabled) {
            ConsistentDataPushUtils.configureSegmentPostfix((SegmentGenerationJobSpec)this._spec);
        }
        File localTempDir = new File(FileUtils.getTempDirectory(), "pinot-" + String.valueOf(UUID.randomUUID()));
        try {
            int numInputFiles = filteredFiles.size();
            this._segmentCreationTaskCountDownLatch = new CountDownLatch(numInputFiles);
            if (!SegmentGenerationJobUtils.useGlobalDirectorySequenceId(this._spec.getSegmentNameGeneratorSpec())) {
                HashMap<String, List> localDirIndex = new HashMap<String, List>();
                for (String filteredFile : filteredFiles) {
                    Path filteredParentPath = Paths.get(filteredFile, new String[0]).getParent();
                    localDirIndex.computeIfAbsent(filteredParentPath.toString(), k -> new ArrayList()).add(filteredFile);
                }
                for (String parentPath : localDirIndex.keySet()) {
                    List siblingFiles = (List)localDirIndex.get(parentPath);
                    Collections.sort(siblingFiles);
                    for (int i = 0; i < siblingFiles.size(); ++i) {
                        URI inputFileURI = SegmentGenerationUtils.getFileURI((String)((String)siblingFiles.get(i)), (URI)SegmentGenerationUtils.getDirectoryURI((String)parentPath));
                        this.submitSegmentGenTask(localTempDir, inputFileURI, i);
                    }
                }
            } else {
                for (int i = 0; i < numInputFiles; ++i) {
                    URI inputFileURI = SegmentGenerationUtils.getFileURI((String)((String)filteredFiles.get(i)), (URI)this._inputDirURI);
                    this.submitSegmentGenTask(localTempDir, inputFileURI, i);
                }
            }
            this._segmentCreationTaskCountDownLatch.await();
            if (this._failure.get() != null) {
                this._executorService.shutdownNow();
                throw this._failure.get();
            }
        }
        finally {
            FileUtils.deleteQuietly((File)localTempDir);
            this._executorService.shutdown();
        }
    }

    private void submitSegmentGenTask(File localTempDir, URI inputFileURI, int seqId) throws Exception {
        File localInputTempDir = new File(localTempDir, "input");
        FileUtils.forceMkdir((File)localInputTempDir);
        File localOutputTempDir = new File(localTempDir, "output");
        FileUtils.forceMkdir((File)localOutputTempDir);
        File localInputDataFile = this.createLocalInputDateFile(inputFileURI, localInputTempDir);
        this._inputDirFS.copyToLocalFile(inputFileURI, localInputDataFile);
        SegmentGenerationTaskSpec taskSpec = new SegmentGenerationTaskSpec();
        taskSpec.setOutputDirectoryPath(localOutputTempDir.getAbsolutePath());
        taskSpec.setRecordReaderSpec(this._spec.getRecordReaderSpec());
        taskSpec.setSchema(this._schema);
        taskSpec.setTableConfig(this._tableConfig);
        taskSpec.setSegmentNameGeneratorSpec(this._spec.getSegmentNameGeneratorSpec());
        taskSpec.setInputFilePath(localInputDataFile.getAbsolutePath());
        taskSpec.setSequenceId(seqId);
        taskSpec.setFailOnEmptySegment(this._spec.isFailOnEmptySegment());
        taskSpec.setCreateMetadataTarGz(this._spec.isCreateMetadataTarGz());
        taskSpec.setCustomProperty("input.data.file.uri", inputFileURI.toString());
        if (this._failure.get() != null) {
            LOGGER.info("Skipping Segment Generation Task for {} due to previous failures", (Object)inputFileURI);
            return;
        }
        LOGGER.info("Submitting one Segment Generation Task for {}", (Object)inputFileURI);
        this._executorService.submit(() -> {
            File localSegmentDir = null;
            File localSegmentTarFile = null;
            try {
                SegmentGenerationTaskRunner taskRunner = new SegmentGenerationTaskRunner(taskSpec);
                String segmentName = taskRunner.run();
                localSegmentDir = new File(localOutputTempDir, segmentName);
                String segmentTarFileName = URIUtils.encode((String)(segmentName + ".tar.gz"));
                localSegmentTarFile = new File(localOutputTempDir, segmentTarFileName);
                LOGGER.info("Tarring segment from: {} to: {}", (Object)localSegmentDir, (Object)localSegmentTarFile);
                TarCompressionUtils.createCompressedTarFile((File)localSegmentDir, (File)localSegmentTarFile);
                long uncompressedSegmentSize = FileUtils.sizeOf((File)localSegmentDir);
                long compressedSegmentSize = FileUtils.sizeOf((File)localSegmentTarFile);
                LOGGER.info("Size for segment: {}, uncompressed: {}, compressed: {}", new Object[]{segmentName, DataSizeUtils.fromBytes((long)uncompressedSegmentSize), DataSizeUtils.fromBytes((long)compressedSegmentSize)});
                URI outputSegmentTarURI = SegmentGenerationUtils.getRelativeOutputPath((URI)this._inputDirURI, (URI)inputFileURI, (URI)this._outputDirURI).resolve(segmentTarFileName);
                if (!this._spec.isOverwriteOutput() && this._outputDirFS.exists(outputSegmentTarURI)) {
                    LOGGER.warn("Not overwrite existing output segment tar file: {}", (Object)this._outputDirFS.exists(outputSegmentTarURI));
                } else {
                    this._outputDirFS.copyFromLocalFile(localSegmentTarFile, outputSegmentTarURI);
                }
                this._segmentCreationTaskCountDownLatch.countDown();
            }
            catch (Throwable e) {
                try {
                    String msg = "Failed to generate Pinot segment for file - " + String.valueOf(inputFileURI);
                    this._failure.compareAndSet(null, new RuntimeException(msg, e));
                    long count = this._segmentCreationTaskCountDownLatch.getCount();
                    int i = 0;
                    while ((long)i < count) {
                        this._segmentCreationTaskCountDownLatch.countDown();
                        ++i;
                    }
                    this._segmentCreationTaskCountDownLatch.countDown();
                }
                catch (Throwable throwable) {
                    this._segmentCreationTaskCountDownLatch.countDown();
                    FileUtils.deleteQuietly(localSegmentDir);
                    FileUtils.deleteQuietly(localSegmentTarFile);
                    FileUtils.deleteQuietly((File)localInputDataFile);
                    throw throwable;
                }
                FileUtils.deleteQuietly((File)localSegmentDir);
                FileUtils.deleteQuietly((File)localSegmentTarFile);
                FileUtils.deleteQuietly((File)localInputDataFile);
            }
            FileUtils.deleteQuietly((File)localSegmentDir);
            FileUtils.deleteQuietly((File)localSegmentTarFile);
            FileUtils.deleteQuietly((File)localInputDataFile);
        });
    }

    private File createLocalInputDateFile(URI inputFileURI, File localInputTempDir) {
        String inputFileURIPath = inputFileURI.getPath();
        File localInputFileDir = new File(localInputTempDir, UUID.randomUUID().toString());
        return new File(localInputFileDir, new File(inputFileURIPath).getName());
    }
}

