/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.netty.implementation.AzureNettyHttpClientContext;
import com.azure.core.util.ProgressReporter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class AzureSdkHandler
extends ChannelDuplexHandler {
    public static final String HANDLER_NAME = "azureSdkHandler";
    private final long writeTimeoutMillis;
    private final ProgressReporter progressReporter;
    private long lastWriteMillis;
    private long lastWriteProgress;
    private boolean writeTrackingStarted;
    private ScheduledFuture<?> writeTimeoutWatcher;
    private final long responseTimeoutMillis;
    private boolean responseTrackingStarted;
    private ScheduledFuture<?> responseTimeoutWatcher;
    private final long readTimeoutMillis;
    private long lastReadMillis;
    private boolean lastRead;
    private boolean readTrackingStarted;
    private ScheduledFuture<?> readTimeoutWatcher;
    private ChannelHandlerContext ctx;
    private boolean closed;

    public AzureSdkHandler(AzureNettyHttpClientContext context, long writeTimeoutMillis, long responseTimeoutMillis, long readTimeoutMillis) {
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.progressReporter = context != null ? context.getProgressReporter() : null;
        this.responseTimeoutMillis = context != null && context.getResponseTimeoutOverride() != null ? context.getResponseTimeoutOverride() : responseTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    public boolean isSharable() {
        return false;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.disposeWriteTimeoutWatcher();
        this.disposeResponseTimeoutWatcher();
        this.disposeReadTimeoutWatcher();
    }

    public void startWriteTracking() {
        this.writeTrackingStarted = true;
        if (this.ctx != null && this.writeTimeoutMillis > 0L) {
            this.writeTimeoutWatcher = this.ctx.executor().scheduleAtFixedRate(() -> this.writeTimeoutRunnable(this.ctx), this.writeTimeoutMillis, this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void endWriteTracking() {
        this.writeTrackingStarted = false;
        this.disposeWriteTimeoutWatcher();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!this.writeTrackingStarted) {
            this.startWriteTracking();
        }
        if (this.progressReporter != null) {
            if (msg instanceof ByteBuf) {
                this.progressReporter.reportProgress(((ByteBuf)msg).readableBytes());
            } else if (msg instanceof ByteBufHolder) {
                this.progressReporter.reportProgress(((ByteBufHolder)msg).content().readableBytes());
            } else if (msg instanceof FileRegion) {
                this.progressReporter.reportProgress(((FileRegion)msg).count());
            }
        }
        if (this.writeTimeoutMillis > 0L) {
            ctx.write(msg, promise.unvoid()).addListener(future -> {
                this.lastWriteMillis = System.currentTimeMillis();
                if (msg instanceof LastHttpContent) {
                    this.endWriteTracking();
                    this.startResponseTracking();
                }
            });
        } else {
            ctx.write(msg, promise.unvoid());
        }
    }

    void writeTimeoutRunnable(ChannelHandlerContext ctx) {
        long writeProgress;
        if (this.writeTimeoutMillis - (System.currentTimeMillis() - this.lastWriteMillis) > 0L) {
            return;
        }
        ChannelOutboundBuffer buffer = ctx.channel().unsafe().outboundBuffer();
        if (buffer != null && (writeProgress = buffer.currentProgress()) != this.lastWriteProgress) {
            this.lastWriteProgress = writeProgress;
            return;
        }
        if (!this.closed) {
            this.disposeWriteTimeoutWatcher();
            ctx.fireExceptionCaught(new TimeoutException("Channel write operation timed out after " + this.writeTimeoutMillis + " milliseconds."));
            ctx.close();
            this.closed = true;
        }
    }

    private void disposeWriteTimeoutWatcher() {
        if (this.writeTimeoutWatcher != null && !this.writeTimeoutWatcher.isDone()) {
            this.writeTimeoutWatcher.cancel(false);
            this.writeTimeoutWatcher = null;
        }
    }

    public void startResponseTracking() {
        this.responseTrackingStarted = true;
        if (this.ctx != null && this.responseTimeoutMillis > 0L) {
            this.responseTimeoutWatcher = this.ctx.executor().schedule(() -> this.responseTimedOut(this.ctx), this.responseTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void endResponseTracking() {
        this.responseTrackingStarted = false;
        this.disposeResponseTimeoutWatcher();
    }

    void responseTimedOut(ChannelHandlerContext ctx) {
        if (!this.closed) {
            this.disposeResponseTimeoutWatcher();
            ctx.fireExceptionCaught(new TimeoutException("Channel response timed out after " + this.responseTimeoutMillis + " milliseconds."));
            ctx.close();
            this.closed = true;
        }
    }

    private void disposeResponseTimeoutWatcher() {
        if (this.responseTimeoutWatcher != null && !this.responseTimeoutWatcher.isDone()) {
            this.responseTimeoutWatcher.cancel(false);
            this.responseTimeoutWatcher = null;
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.responseTrackingStarted) {
            this.endResponseTracking();
            this.startReadTracking();
        }
        this.lastRead = msg instanceof LastHttpContent;
        ctx.fireChannelRead(msg);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.lastReadMillis = System.currentTimeMillis();
        if (this.lastRead && this.readTrackingStarted) {
            this.endReadTracking();
        }
        ctx.fireChannelReadComplete();
    }

    public void startReadTracking() {
        this.readTrackingStarted = true;
        if (this.ctx != null && this.readTimeoutMillis > 0L) {
            this.readTimeoutWatcher = this.ctx.executor().scheduleAtFixedRate(() -> this.readTimeoutRunnable(this.ctx), this.readTimeoutMillis, this.readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void endReadTracking() {
        this.readTrackingStarted = false;
        this.disposeReadTimeoutWatcher();
    }

    void readTimeoutRunnable(ChannelHandlerContext ctx) {
        if (this.readTimeoutMillis - (System.currentTimeMillis() - this.lastReadMillis) > 0L) {
            return;
        }
        if (!this.closed) {
            this.disposeReadTimeoutWatcher();
            ctx.fireExceptionCaught(new TimeoutException("Channel read timed out after " + this.readTimeoutMillis + " milliseconds."));
            ctx.close();
            this.closed = true;
        }
    }

    private void disposeReadTimeoutWatcher() {
        if (this.readTimeoutWatcher != null && !this.readTimeoutWatcher.isDone()) {
            this.readTimeoutWatcher.cancel(false);
            this.readTimeoutWatcher = null;
        }
    }
}

