/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.internal.avro.implementation.AvroObject;
import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSimpleSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroType;
import com.azure.storage.internal.avro.implementation.schema.file.AvroBlockSchema;
import com.azure.storage.internal.avro.implementation.schema.file.AvroHeaderSchema;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AvroSyncParser {
    private static final ClientLogger LOGGER = new ClientLogger(AvroSyncParser.class);
    private AvroParserState state = new AvroParserState();
    private byte[] syncMarker;
    private AvroType objectType;
    private List<AvroObject> objects = new ArrayList<AvroObject>();
    private final boolean partialRead;

    AvroSyncParser(boolean partialRead) {
        this.partialRead = partialRead;
        AvroHeaderSchema headerSchema = new AvroHeaderSchema(this.state, this::onFilteredHeader);
        headerSchema.pushToStack();
    }

    void prepareParserToReadBody(long sourceOffset, long thresholdIndex) {
        if (!this.partialRead) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("This method should only be called when parsing header and body separately."));
        }
        if (this.objectType == null || this.syncMarker == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Expected to read entire header before preparing parser to read body."));
        }
        this.state = new AvroParserState(sourceOffset);
        this.objects = new ArrayList<AvroObject>();
        this.onBlock(thresholdIndex);
    }

    public Iterable<AvroObject> parse(ByteBuffer buffer) {
        ByteBuffer allocatedBuffer = ByteBuffer.allocate(buffer.remaining());
        allocatedBuffer.put(buffer);
        allocatedBuffer.position(0);
        this.state.write(allocatedBuffer);
        if (this.partialRead && this.state.isStackEmpty()) {
            return Collections.emptyList();
        }
        AvroSchema schema = this.state.peekFromStack();
        while (schema instanceof AvroCompositeSchema || schema instanceof AvroSimpleSchema && ((AvroSimpleSchema)schema).canProgress()) {
            if (schema instanceof AvroSimpleSchema) {
                ((AvroSimpleSchema)schema).progress();
            }
            if (schema.isDone()) {
                this.state.popOffStack();
                schema.publishResult();
            } else if (schema instanceof AvroCompositeSchema) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Expected composite type to be done."));
            }
            if (this.partialRead && this.state.isStackEmpty()) break;
            schema = this.state.peekFromStack();
        }
        if (this.objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AvroObject> result = new ArrayList<AvroObject>(this.objects);
        this.objects.clear();
        return result;
    }

    private void onFilteredHeader(Object header) {
        AvroSchema.checkType("header", header, Map.class);
        Map h = (Map)header;
        Object type = h.get("meta");
        AvroSchema.checkType("type", type, AvroType.class);
        this.objectType = (AvroType)type;
        Object sync = h.get("sync");
        AvroSchema.checkType("sync", sync, byte[].class);
        this.syncMarker = (byte[])sync;
        if (!this.partialRead) {
            this.onBlock(0L);
        }
    }

    private void onBlock(Object beginObjectIndex) {
        AvroSchema.checkType("beginObjectIndex", beginObjectIndex, Long.class);
        AvroBlockSchema blockSchema = new AvroBlockSchema(this.objectType, (Long)beginObjectIndex, o -> {
            AvroSchema.checkType("object", o, AvroObject.class);
            this.objects.add((AvroObject)o);
        }, this.syncMarker, this.state, this::onBlock);
        blockSchema.pushToStack();
    }
}

