/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <string.h>
#include <plc4c/driver_s7_static.h>

#include "szl_sublist.h"

// Code generated by code-generation. DO NOT EDIT.


// Create an empty NULL-struct
static const plc4c_s7_read_write_szl_sublist plc4c_s7_read_write_szl_sublist_null_const;

plc4c_s7_read_write_szl_sublist plc4c_s7_read_write_szl_sublist_null() {
  return plc4c_s7_read_write_szl_sublist_null_const;
}

// Parse function.
plc4c_return_code plc4c_s7_read_write_szl_sublist_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_szl_sublist* _message) {
    plc4c_return_code _res = OK;

    uint8_t value;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &value);
    *_message = plc4c_s7_read_write_szl_sublist_for_value(value);

    return _res;
}

plc4c_return_code plc4c_s7_read_write_szl_sublist_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_szl_sublist* _message) {
    plc4c_return_code _res = OK;

    _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, *_message);

    return _res;
}

plc4c_s7_read_write_szl_sublist plc4c_s7_read_write_szl_sublist_for_value(uint8_t value) {
    for(int i = 0; i < plc4c_s7_read_write_szl_sublist_num_values(); i++) {
        if(plc4c_s7_read_write_szl_sublist_value_for_index(i) == value) {
            return plc4c_s7_read_write_szl_sublist_value_for_index(i);
        }
    }
    return -1;
}

plc4c_s7_read_write_szl_sublist plc4c_s7_read_write_szl_sublist_value_of(char* value_string) {
    if(strcmp(value_string, "NONE") == 0) {
        return plc4c_s7_read_write_szl_sublist_NONE;
    }
    if(strcmp(value_string, "MODULE_IDENTIFICATION") == 0) {
        return plc4c_s7_read_write_szl_sublist_MODULE_IDENTIFICATION;
    }
    if(strcmp(value_string, "CPU_FEATURES") == 0) {
        return plc4c_s7_read_write_szl_sublist_CPU_FEATURES;
    }
    if(strcmp(value_string, "USER_MEMORY_AREA") == 0) {
        return plc4c_s7_read_write_szl_sublist_USER_MEMORY_AREA;
    }
    if(strcmp(value_string, "SYSTEM_AREAS") == 0) {
        return plc4c_s7_read_write_szl_sublist_SYSTEM_AREAS;
    }
    if(strcmp(value_string, "BLOCK_TYPES") == 0) {
        return plc4c_s7_read_write_szl_sublist_BLOCK_TYPES;
    }
    if(strcmp(value_string, "STATUS_MODULE_LEDS") == 0) {
        return plc4c_s7_read_write_szl_sublist_STATUS_MODULE_LEDS;
    }
    if(strcmp(value_string, "COMPONENT_IDENTIFICATION") == 0) {
        return plc4c_s7_read_write_szl_sublist_COMPONENT_IDENTIFICATION;
    }
    if(strcmp(value_string, "INTERRUPT_STATUS") == 0) {
        return plc4c_s7_read_write_szl_sublist_INTERRUPT_STATUS;
    }
    if(strcmp(value_string, "ASSIGNMENT_BETWEEN_PROCESS_IMAGE_PARTITIONS_AND_OBS") == 0) {
        return plc4c_s7_read_write_szl_sublist_ASSIGNMENT_BETWEEN_PROCESS_IMAGE_PARTITIONS_AND_OBS;
    }
    if(strcmp(value_string, "COMMUNICATION_STATUS_DATA") == 0) {
        return plc4c_s7_read_write_szl_sublist_COMMUNICATION_STATUS_DATA;
    }
    if(strcmp(value_string, "H_CPU_GROUP_INFORMATION") == 0) {
        return plc4c_s7_read_write_szl_sublist_H_CPU_GROUP_INFORMATION;
    }
    if(strcmp(value_string, "STATUS_SINGLE_MODULE_LED") == 0) {
        return plc4c_s7_read_write_szl_sublist_STATUS_SINGLE_MODULE_LED;
    }
    if(strcmp(value_string, "SWITCHED_DP_SLAVES_H_SYSTEM") == 0) {
        return plc4c_s7_read_write_szl_sublist_SWITCHED_DP_SLAVES_H_SYSTEM;
    }
    if(strcmp(value_string, "DP_MASTER_SYSTEM_INFORMATION") == 0) {
        return plc4c_s7_read_write_szl_sublist_DP_MASTER_SYSTEM_INFORMATION;
    }
    if(strcmp(value_string, "MODULE_STATUS_INFORMATION") == 0) {
        return plc4c_s7_read_write_szl_sublist_MODULE_STATUS_INFORMATION;
    }
    if(strcmp(value_string, "RACK_OR_STATION_STATUS_INFORMATION") == 0) {
        return plc4c_s7_read_write_szl_sublist_RACK_OR_STATION_STATUS_INFORMATION;
    }
    if(strcmp(value_string, "RACK_OR_STATION_STATUS_INFORMATION_2") == 0) {
        return plc4c_s7_read_write_szl_sublist_RACK_OR_STATION_STATUS_INFORMATION_2;
    }
    if(strcmp(value_string, "ADDITIONAL_DP_MASTER_SYSTEM_OR_PROFINET_IO_SYSTEM_INFORMATION") == 0) {
        return plc4c_s7_read_write_szl_sublist_ADDITIONAL_DP_MASTER_SYSTEM_OR_PROFINET_IO_SYSTEM_INFORMATION;
    }
    if(strcmp(value_string, "MODULE_STATUS_INFORMATION_PROFINET_IO_AND_PROFIBUS_DP") == 0) {
        return plc4c_s7_read_write_szl_sublist_MODULE_STATUS_INFORMATION_PROFINET_IO_AND_PROFIBUS_DP;
    }
    if(strcmp(value_string, "TOOL_CHANGER_INFORMATION_PROFINET") == 0) {
        return plc4c_s7_read_write_szl_sublist_TOOL_CHANGER_INFORMATION_PROFINET;
    }
    if(strcmp(value_string, "DIAGNOSTIC_BUFFER") == 0) {
        return plc4c_s7_read_write_szl_sublist_DIAGNOSTIC_BUFFER;
    }
    if(strcmp(value_string, "MODULE_DIAGNOSTIC_INFORMATION_DR0") == 0) {
        return plc4c_s7_read_write_szl_sublist_MODULE_DIAGNOSTIC_INFORMATION_DR0;
    }
    if(strcmp(value_string, "MODULE_DIAGNOSTIC_INFORMATION_DR1_GI") == 0) {
        return plc4c_s7_read_write_szl_sublist_MODULE_DIAGNOSTIC_INFORMATION_DR1_GI;
    }
    if(strcmp(value_string, "MODULE_DIAGNOSTIC_INFORMATION_DR1_LA") == 0) {
        return plc4c_s7_read_write_szl_sublist_MODULE_DIAGNOSTIC_INFORMATION_DR1_LA;
    }
    if(strcmp(value_string, "DIAGNOSTIC_DATA_DP_SLAVE") == 0) {
        return plc4c_s7_read_write_szl_sublist_DIAGNOSTIC_DATA_DP_SLAVE;
    }
    return -1;
}

int plc4c_s7_read_write_szl_sublist_num_values() {
  return 26;
}

plc4c_s7_read_write_szl_sublist plc4c_s7_read_write_szl_sublist_value_for_index(int index) {
    switch(index) {
      case 0: {
        return plc4c_s7_read_write_szl_sublist_NONE;
      }
      case 1: {
        return plc4c_s7_read_write_szl_sublist_MODULE_IDENTIFICATION;
      }
      case 2: {
        return plc4c_s7_read_write_szl_sublist_CPU_FEATURES;
      }
      case 3: {
        return plc4c_s7_read_write_szl_sublist_USER_MEMORY_AREA;
      }
      case 4: {
        return plc4c_s7_read_write_szl_sublist_SYSTEM_AREAS;
      }
      case 5: {
        return plc4c_s7_read_write_szl_sublist_BLOCK_TYPES;
      }
      case 6: {
        return plc4c_s7_read_write_szl_sublist_STATUS_MODULE_LEDS;
      }
      case 7: {
        return plc4c_s7_read_write_szl_sublist_COMPONENT_IDENTIFICATION;
      }
      case 8: {
        return plc4c_s7_read_write_szl_sublist_INTERRUPT_STATUS;
      }
      case 9: {
        return plc4c_s7_read_write_szl_sublist_ASSIGNMENT_BETWEEN_PROCESS_IMAGE_PARTITIONS_AND_OBS;
      }
      case 10: {
        return plc4c_s7_read_write_szl_sublist_COMMUNICATION_STATUS_DATA;
      }
      case 11: {
        return plc4c_s7_read_write_szl_sublist_H_CPU_GROUP_INFORMATION;
      }
      case 12: {
        return plc4c_s7_read_write_szl_sublist_STATUS_SINGLE_MODULE_LED;
      }
      case 13: {
        return plc4c_s7_read_write_szl_sublist_SWITCHED_DP_SLAVES_H_SYSTEM;
      }
      case 14: {
        return plc4c_s7_read_write_szl_sublist_DP_MASTER_SYSTEM_INFORMATION;
      }
      case 15: {
        return plc4c_s7_read_write_szl_sublist_MODULE_STATUS_INFORMATION;
      }
      case 16: {
        return plc4c_s7_read_write_szl_sublist_RACK_OR_STATION_STATUS_INFORMATION;
      }
      case 17: {
        return plc4c_s7_read_write_szl_sublist_RACK_OR_STATION_STATUS_INFORMATION_2;
      }
      case 18: {
        return plc4c_s7_read_write_szl_sublist_ADDITIONAL_DP_MASTER_SYSTEM_OR_PROFINET_IO_SYSTEM_INFORMATION;
      }
      case 19: {
        return plc4c_s7_read_write_szl_sublist_MODULE_STATUS_INFORMATION_PROFINET_IO_AND_PROFIBUS_DP;
      }
      case 20: {
        return plc4c_s7_read_write_szl_sublist_TOOL_CHANGER_INFORMATION_PROFINET;
      }
      case 21: {
        return plc4c_s7_read_write_szl_sublist_DIAGNOSTIC_BUFFER;
      }
      case 22: {
        return plc4c_s7_read_write_szl_sublist_MODULE_DIAGNOSTIC_INFORMATION_DR0;
      }
      case 23: {
        return plc4c_s7_read_write_szl_sublist_MODULE_DIAGNOSTIC_INFORMATION_DR1_GI;
      }
      case 24: {
        return plc4c_s7_read_write_szl_sublist_MODULE_DIAGNOSTIC_INFORMATION_DR1_LA;
      }
      case 25: {
        return plc4c_s7_read_write_szl_sublist_DIAGNOSTIC_DATA_DP_SLAVE;
      }
      default: {
        return -1;
      }
    }
}

uint16_t plc4c_s7_read_write_szl_sublist_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_szl_sublist* _message) {
    return plc4c_s7_read_write_szl_sublist_length_in_bits(ctx, _message) / 8;
}

uint16_t plc4c_s7_read_write_szl_sublist_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_szl_sublist* _message) {
    return 8;
}
