/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReturnCode is an enum
type ReturnCode uint32

type IReturnCode interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	ReturnCode_OK                                 ReturnCode = 0x00
	ReturnCode_INTERNAL_ERROR                     ReturnCode = 0x01
	ReturnCode_NO_REALTIME                        ReturnCode = 0x02
	ReturnCode_SAVE_ERROR                         ReturnCode = 0x03
	ReturnCode_MAILBOX_FULL                       ReturnCode = 0x04
	ReturnCode_WRONG_HMSG                         ReturnCode = 0x05
	ReturnCode_TARGET_PORT_NOT_FOUND              ReturnCode = 0x06
	ReturnCode_TARGET_HOST_NOT_FOUND              ReturnCode = 0x07
	ReturnCode_UNKNOWN_COMMAND_ID                 ReturnCode = 0x08
	ReturnCode_UNKNOWN_TASK_ID                    ReturnCode = 0x09
	ReturnCode_NO_IO                              ReturnCode = 0x0A
	ReturnCode_UNKNOWN_ADS_COMMAND                ReturnCode = 0x0B
	ReturnCode_WIN32_ERROR                        ReturnCode = 0x0C
	ReturnCode_PORT_NOT_CONNECTED                 ReturnCode = 0x0D
	ReturnCode_INVALID_ADS_LENGTH                 ReturnCode = 0x0E
	ReturnCode_INVALID_AMS_NET_ID                 ReturnCode = 0x0F
	ReturnCode_LOW_INSTALLATION_LEVEL             ReturnCode = 0x10
	ReturnCode_NO_DEBUGGING_AVAILABLE             ReturnCode = 0x11
	ReturnCode_PORT_DEACTIVATED                   ReturnCode = 0x12
	ReturnCode_PORT_ALREADY_CONNECTED             ReturnCode = 0x13
	ReturnCode_ADS_SYNC_WIN32_ERROR               ReturnCode = 0x14
	ReturnCode_ADS_SYNC_TIMEOUT                   ReturnCode = 0x15
	ReturnCode_ADS_SYNC_AMS_ERROR                 ReturnCode = 0x16
	ReturnCode_NO_INDEX_MAP_FOR_ADS_AVAILABLE     ReturnCode = 0x17
	ReturnCode_INVALID_ADS_PORT                   ReturnCode = 0x18
	ReturnCode_NO_MEMORY                          ReturnCode = 0x19
	ReturnCode_TCP_SENDING_ERROR                  ReturnCode = 0x1A
	ReturnCode_HOST_NOT_REACHABLE                 ReturnCode = 0x1B
	ReturnCode_INVALID_AMS_FRAGMENT               ReturnCode = 0x1C
	ReturnCode_ROUTERERR_NOLOCKEDMEMORY           ReturnCode = 0x500
	ReturnCode_ROUTERERR_RESIZEMEMORY             ReturnCode = 0x501
	ReturnCode_ROUTERERR_MAILBOXFULL              ReturnCode = 0x502
	ReturnCode_ROUTERERR_DEBUGBOXFULL             ReturnCode = 0x503
	ReturnCode_ROUTERERR_UNKNOWNPORTTYPE          ReturnCode = 0x504
	ReturnCode_ROUTERERR_NOTINITIALIZED           ReturnCode = 0x505
	ReturnCode_ROUTERERR_PORTALREADYINUSE         ReturnCode = 0x506
	ReturnCode_ROUTERERR_NOTREGISTERED            ReturnCode = 0x507
	ReturnCode_ROUTERERR_NOMOREQUEUES             ReturnCode = 0x508
	ReturnCode_ROUTERERR_INVALIDPORT              ReturnCode = 0x509
	ReturnCode_ROUTERERR_NOTACTIVATED             ReturnCode = 0x50A
	ReturnCode_ADSERR_DEVICE_ERROR                ReturnCode = 0x700
	ReturnCode_ADSERR_DEVICE_SRVNOTSUPP           ReturnCode = 0x701
	ReturnCode_ADSERR_DEVICE_INVALIDGRP           ReturnCode = 0x702
	ReturnCode_ADSERR_DEVICE_INVALIDOFFSET        ReturnCode = 0x703
	ReturnCode_ADSERR_DEVICE_INVALIDACCESS        ReturnCode = 0x704
	ReturnCode_ADSERR_DEVICE_INVALIDSIZE          ReturnCode = 0x705
	ReturnCode_ADSERR_DEVICE_INVALIDDATA          ReturnCode = 0x706
	ReturnCode_ADSERR_DEVICE_NOTREADY             ReturnCode = 0x707
	ReturnCode_ADSERR_DEVICE_BUSY                 ReturnCode = 0x708
	ReturnCode_ADSERR_DEVICE_INVALIDCONTEXT       ReturnCode = 0x709
	ReturnCode_ADSERR_DEVICE_NOMEMORY             ReturnCode = 0x70A
	ReturnCode_ADSERR_DEVICE_INVALIDPARM          ReturnCode = 0x70B
	ReturnCode_ADSERR_DEVICE_NOTFOUND             ReturnCode = 0x70C
	ReturnCode_ADSERR_DEVICE_SYNTAX               ReturnCode = 0x70D
	ReturnCode_ADSERR_DEVICE_INCOMPATIBLE         ReturnCode = 0x70E
	ReturnCode_ADSERR_DEVICE_EXISTS               ReturnCode = 0x70F
	ReturnCode_ADSERR_DEVICE_SYMBOLNOTFOUND       ReturnCode = 0x710
	ReturnCode_ADSERR_DEVICE_SYMBOLVERSIONINVALID ReturnCode = 0x711
	ReturnCode_ADSERR_DEVICE_INVALIDSTATE         ReturnCode = 0x712
	ReturnCode_ADSERR_DEVICE_TRANSMODENOTSUPP     ReturnCode = 0x713
	ReturnCode_ADSERR_DEVICE_NOTIFYHNDINVALID     ReturnCode = 0x714
	ReturnCode_ADSERR_DEVICE_CLIENTUNKNOWN        ReturnCode = 0x715
	ReturnCode_ADSERR_DEVICE_NOMOREHDLS           ReturnCode = 0x716
	ReturnCode_ADSERR_DEVICE_INVALIDWATCHSIZE     ReturnCode = 0x717
	ReturnCode_ADSERR_DEVICE_NOTINIT              ReturnCode = 0x718
	ReturnCode_ADSERR_DEVICE_TIMEOUT              ReturnCode = 0x719
	ReturnCode_ADSERR_DEVICE_NOINTERFACE          ReturnCode = 0x71A
	ReturnCode_ADSERR_DEVICE_INVALIDINTERFACE     ReturnCode = 0x71B
	ReturnCode_ADSERR_DEVICE_INVALIDCLSID         ReturnCode = 0x71C
	ReturnCode_ADSERR_DEVICE_INVALIDOBJID         ReturnCode = 0x71D
	ReturnCode_ADSERR_DEVICE_PENDING              ReturnCode = 0x71E
	ReturnCode_ADSERR_DEVICE_ABORTED              ReturnCode = 0x71F
	ReturnCode_ADSERR_DEVICE_WARNING              ReturnCode = 0x720
	ReturnCode_ADSERR_DEVICE_INVALIDARRAYIDX      ReturnCode = 0x721
	ReturnCode_ADSERR_DEVICE_SYMBOLNOTACTIVE      ReturnCode = 0x722
	ReturnCode_ADSERR_DEVICE_ACCESSDENIED         ReturnCode = 0x723
	ReturnCode_ADSERR_DEVICE_LICENSENOTFOUND      ReturnCode = 0x724
	ReturnCode_ADSERR_DEVICE_LICENSEEXPIRED       ReturnCode = 0x725
	ReturnCode_ADSERR_DEVICE_LICENSEEXCEEDED      ReturnCode = 0x726
	ReturnCode_ADSERR_DEVICE_LICENSEINVALID       ReturnCode = 0x727
	ReturnCode_ADSERR_DEVICE_LICENSESYSTEMID      ReturnCode = 0x728
	ReturnCode_ADSERR_DEVICE_LICENSENOTIMELIMIT   ReturnCode = 0x729
	ReturnCode_ADSERR_DEVICE_LICENSEFUTUREISSUE   ReturnCode = 0x72A
	ReturnCode_ADSERR_DEVICE_LICENSETIMETOLONG    ReturnCode = 0x72B
	ReturnCode_ADSERR_DEVICE_EXCEPTION            ReturnCode = 0x72c
	ReturnCode_ADSERR_DEVICE_LICENSEDUPLICATED    ReturnCode = 0x72D
	ReturnCode_ADSERR_DEVICE_SIGNATUREINVALID     ReturnCode = 0x72E
	ReturnCode_ADSERR_DEVICE_CERTIFICATEINVALID   ReturnCode = 0x72F
	ReturnCode_ADSERR_CLIENT_ERROR                ReturnCode = 0x740
	ReturnCode_ADSERR_CLIENT_INVALIDPARM          ReturnCode = 0x741
	ReturnCode_ADSERR_CLIENT_LISTEMPTY            ReturnCode = 0x742
	ReturnCode_ADSERR_CLIENT_VARUSED              ReturnCode = 0x743
	ReturnCode_ADSERR_CLIENT_DUPLINVOKEID         ReturnCode = 0x744
	ReturnCode_ADSERR_CLIENT_SYNCTIMEOUT          ReturnCode = 0x745
	ReturnCode_ADSERR_CLIENT_W32ERROR             ReturnCode = 0x746
	ReturnCode_ADSERR_CLIENT_TIMEOUTINVALID       ReturnCode = 0x747
	ReturnCode_ADSERR_CLIENT_PORTNOTOPEN          ReturnCode = 0x748
	ReturnCode_ADSERR_CLIENT_NOAMSADDR            ReturnCode = 0x750
	ReturnCode_ADSERR_CLIENT_SYNCINTERNAL         ReturnCode = 0x751
	ReturnCode_ADSERR_CLIENT_ADDHASH              ReturnCode = 0x752
	ReturnCode_ADSERR_CLIENT_REMOVEHASH           ReturnCode = 0x753
	ReturnCode_ADSERR_CLIENT_NOMORESYM            ReturnCode = 0x754
	ReturnCode_ADSERR_CLIENT_SYNCRESINVALID       ReturnCode = 0x755
	ReturnCode_RTERR_INTERNAL                     ReturnCode = 0x1000
	ReturnCode_RTERR_BADTIMERPERIODS              ReturnCode = 0x1001
	ReturnCode_RTERR_INVALIDTASKPTR               ReturnCode = 0x1002
	ReturnCode_RTERR_INVALIDSTACKPTR              ReturnCode = 0x1003
	ReturnCode_RTERR_PRIOEXISTS                   ReturnCode = 0x1004
	ReturnCode_RTERR_NOMORETCB                    ReturnCode = 0x1005
	ReturnCode_RTERR_NOMORESEMAS                  ReturnCode = 0x1006
	ReturnCode_RTERR_NOMOREQUEUES                 ReturnCode = 0x1007
	ReturnCode_RTERR_EXTIRQALREADYDEF             ReturnCode = 0x100D
	ReturnCode_RTERR_EXTIRQNOTDEF                 ReturnCode = 0x100E
	ReturnCode_RTERR_EXTIRQINSTALLFAILED          ReturnCode = 0x100F
	ReturnCode_RTERR_IRQLNOTLESSOREQUAL           ReturnCode = 0x1010
	ReturnCode_RTERR_VMXNOTSUPPORTED              ReturnCode = 0x1017
	ReturnCode_RTERR_VMXDISABLED                  ReturnCode = 0x1018
	ReturnCode_RTERR_VMXCONTROLSMISSING           ReturnCode = 0x1019
	ReturnCode_RTERR_VMXENABLEFAILS               ReturnCode = 0x101A
	ReturnCode_WSAETIMEDOUT                       ReturnCode = 0x274C
	ReturnCode_WSAECONNREFUSED                    ReturnCode = 0x274D
	ReturnCode_WSAEHOSTUNREACH                    ReturnCode = 0x2751
)

var ReturnCodeValues []ReturnCode

func init() {
	_ = errors.New
	ReturnCodeValues = []ReturnCode{
		ReturnCode_OK,
		ReturnCode_INTERNAL_ERROR,
		ReturnCode_NO_REALTIME,
		ReturnCode_SAVE_ERROR,
		ReturnCode_MAILBOX_FULL,
		ReturnCode_WRONG_HMSG,
		ReturnCode_TARGET_PORT_NOT_FOUND,
		ReturnCode_TARGET_HOST_NOT_FOUND,
		ReturnCode_UNKNOWN_COMMAND_ID,
		ReturnCode_UNKNOWN_TASK_ID,
		ReturnCode_NO_IO,
		ReturnCode_UNKNOWN_ADS_COMMAND,
		ReturnCode_WIN32_ERROR,
		ReturnCode_PORT_NOT_CONNECTED,
		ReturnCode_INVALID_ADS_LENGTH,
		ReturnCode_INVALID_AMS_NET_ID,
		ReturnCode_LOW_INSTALLATION_LEVEL,
		ReturnCode_NO_DEBUGGING_AVAILABLE,
		ReturnCode_PORT_DEACTIVATED,
		ReturnCode_PORT_ALREADY_CONNECTED,
		ReturnCode_ADS_SYNC_WIN32_ERROR,
		ReturnCode_ADS_SYNC_TIMEOUT,
		ReturnCode_ADS_SYNC_AMS_ERROR,
		ReturnCode_NO_INDEX_MAP_FOR_ADS_AVAILABLE,
		ReturnCode_INVALID_ADS_PORT,
		ReturnCode_NO_MEMORY,
		ReturnCode_TCP_SENDING_ERROR,
		ReturnCode_HOST_NOT_REACHABLE,
		ReturnCode_INVALID_AMS_FRAGMENT,
		ReturnCode_ROUTERERR_NOLOCKEDMEMORY,
		ReturnCode_ROUTERERR_RESIZEMEMORY,
		ReturnCode_ROUTERERR_MAILBOXFULL,
		ReturnCode_ROUTERERR_DEBUGBOXFULL,
		ReturnCode_ROUTERERR_UNKNOWNPORTTYPE,
		ReturnCode_ROUTERERR_NOTINITIALIZED,
		ReturnCode_ROUTERERR_PORTALREADYINUSE,
		ReturnCode_ROUTERERR_NOTREGISTERED,
		ReturnCode_ROUTERERR_NOMOREQUEUES,
		ReturnCode_ROUTERERR_INVALIDPORT,
		ReturnCode_ROUTERERR_NOTACTIVATED,
		ReturnCode_ADSERR_DEVICE_ERROR,
		ReturnCode_ADSERR_DEVICE_SRVNOTSUPP,
		ReturnCode_ADSERR_DEVICE_INVALIDGRP,
		ReturnCode_ADSERR_DEVICE_INVALIDOFFSET,
		ReturnCode_ADSERR_DEVICE_INVALIDACCESS,
		ReturnCode_ADSERR_DEVICE_INVALIDSIZE,
		ReturnCode_ADSERR_DEVICE_INVALIDDATA,
		ReturnCode_ADSERR_DEVICE_NOTREADY,
		ReturnCode_ADSERR_DEVICE_BUSY,
		ReturnCode_ADSERR_DEVICE_INVALIDCONTEXT,
		ReturnCode_ADSERR_DEVICE_NOMEMORY,
		ReturnCode_ADSERR_DEVICE_INVALIDPARM,
		ReturnCode_ADSERR_DEVICE_NOTFOUND,
		ReturnCode_ADSERR_DEVICE_SYNTAX,
		ReturnCode_ADSERR_DEVICE_INCOMPATIBLE,
		ReturnCode_ADSERR_DEVICE_EXISTS,
		ReturnCode_ADSERR_DEVICE_SYMBOLNOTFOUND,
		ReturnCode_ADSERR_DEVICE_SYMBOLVERSIONINVALID,
		ReturnCode_ADSERR_DEVICE_INVALIDSTATE,
		ReturnCode_ADSERR_DEVICE_TRANSMODENOTSUPP,
		ReturnCode_ADSERR_DEVICE_NOTIFYHNDINVALID,
		ReturnCode_ADSERR_DEVICE_CLIENTUNKNOWN,
		ReturnCode_ADSERR_DEVICE_NOMOREHDLS,
		ReturnCode_ADSERR_DEVICE_INVALIDWATCHSIZE,
		ReturnCode_ADSERR_DEVICE_NOTINIT,
		ReturnCode_ADSERR_DEVICE_TIMEOUT,
		ReturnCode_ADSERR_DEVICE_NOINTERFACE,
		ReturnCode_ADSERR_DEVICE_INVALIDINTERFACE,
		ReturnCode_ADSERR_DEVICE_INVALIDCLSID,
		ReturnCode_ADSERR_DEVICE_INVALIDOBJID,
		ReturnCode_ADSERR_DEVICE_PENDING,
		ReturnCode_ADSERR_DEVICE_ABORTED,
		ReturnCode_ADSERR_DEVICE_WARNING,
		ReturnCode_ADSERR_DEVICE_INVALIDARRAYIDX,
		ReturnCode_ADSERR_DEVICE_SYMBOLNOTACTIVE,
		ReturnCode_ADSERR_DEVICE_ACCESSDENIED,
		ReturnCode_ADSERR_DEVICE_LICENSENOTFOUND,
		ReturnCode_ADSERR_DEVICE_LICENSEEXPIRED,
		ReturnCode_ADSERR_DEVICE_LICENSEEXCEEDED,
		ReturnCode_ADSERR_DEVICE_LICENSEINVALID,
		ReturnCode_ADSERR_DEVICE_LICENSESYSTEMID,
		ReturnCode_ADSERR_DEVICE_LICENSENOTIMELIMIT,
		ReturnCode_ADSERR_DEVICE_LICENSEFUTUREISSUE,
		ReturnCode_ADSERR_DEVICE_LICENSETIMETOLONG,
		ReturnCode_ADSERR_DEVICE_EXCEPTION,
		ReturnCode_ADSERR_DEVICE_LICENSEDUPLICATED,
		ReturnCode_ADSERR_DEVICE_SIGNATUREINVALID,
		ReturnCode_ADSERR_DEVICE_CERTIFICATEINVALID,
		ReturnCode_ADSERR_CLIENT_ERROR,
		ReturnCode_ADSERR_CLIENT_INVALIDPARM,
		ReturnCode_ADSERR_CLIENT_LISTEMPTY,
		ReturnCode_ADSERR_CLIENT_VARUSED,
		ReturnCode_ADSERR_CLIENT_DUPLINVOKEID,
		ReturnCode_ADSERR_CLIENT_SYNCTIMEOUT,
		ReturnCode_ADSERR_CLIENT_W32ERROR,
		ReturnCode_ADSERR_CLIENT_TIMEOUTINVALID,
		ReturnCode_ADSERR_CLIENT_PORTNOTOPEN,
		ReturnCode_ADSERR_CLIENT_NOAMSADDR,
		ReturnCode_ADSERR_CLIENT_SYNCINTERNAL,
		ReturnCode_ADSERR_CLIENT_ADDHASH,
		ReturnCode_ADSERR_CLIENT_REMOVEHASH,
		ReturnCode_ADSERR_CLIENT_NOMORESYM,
		ReturnCode_ADSERR_CLIENT_SYNCRESINVALID,
		ReturnCode_RTERR_INTERNAL,
		ReturnCode_RTERR_BADTIMERPERIODS,
		ReturnCode_RTERR_INVALIDTASKPTR,
		ReturnCode_RTERR_INVALIDSTACKPTR,
		ReturnCode_RTERR_PRIOEXISTS,
		ReturnCode_RTERR_NOMORETCB,
		ReturnCode_RTERR_NOMORESEMAS,
		ReturnCode_RTERR_NOMOREQUEUES,
		ReturnCode_RTERR_EXTIRQALREADYDEF,
		ReturnCode_RTERR_EXTIRQNOTDEF,
		ReturnCode_RTERR_EXTIRQINSTALLFAILED,
		ReturnCode_RTERR_IRQLNOTLESSOREQUAL,
		ReturnCode_RTERR_VMXNOTSUPPORTED,
		ReturnCode_RTERR_VMXDISABLED,
		ReturnCode_RTERR_VMXCONTROLSMISSING,
		ReturnCode_RTERR_VMXENABLEFAILS,
		ReturnCode_WSAETIMEDOUT,
		ReturnCode_WSAECONNREFUSED,
		ReturnCode_WSAEHOSTUNREACH,
	}
}

func ReturnCodeByValue(value uint32) (enum ReturnCode, ok bool) {
	switch value {
	case 0x00:
		return ReturnCode_OK, true
	case 0x01:
		return ReturnCode_INTERNAL_ERROR, true
	case 0x02:
		return ReturnCode_NO_REALTIME, true
	case 0x03:
		return ReturnCode_SAVE_ERROR, true
	case 0x04:
		return ReturnCode_MAILBOX_FULL, true
	case 0x05:
		return ReturnCode_WRONG_HMSG, true
	case 0x06:
		return ReturnCode_TARGET_PORT_NOT_FOUND, true
	case 0x07:
		return ReturnCode_TARGET_HOST_NOT_FOUND, true
	case 0x08:
		return ReturnCode_UNKNOWN_COMMAND_ID, true
	case 0x09:
		return ReturnCode_UNKNOWN_TASK_ID, true
	case 0x0A:
		return ReturnCode_NO_IO, true
	case 0x0B:
		return ReturnCode_UNKNOWN_ADS_COMMAND, true
	case 0x0C:
		return ReturnCode_WIN32_ERROR, true
	case 0x0D:
		return ReturnCode_PORT_NOT_CONNECTED, true
	case 0x0E:
		return ReturnCode_INVALID_ADS_LENGTH, true
	case 0x0F:
		return ReturnCode_INVALID_AMS_NET_ID, true
	case 0x10:
		return ReturnCode_LOW_INSTALLATION_LEVEL, true
	case 0x1000:
		return ReturnCode_RTERR_INTERNAL, true
	case 0x1001:
		return ReturnCode_RTERR_BADTIMERPERIODS, true
	case 0x1002:
		return ReturnCode_RTERR_INVALIDTASKPTR, true
	case 0x1003:
		return ReturnCode_RTERR_INVALIDSTACKPTR, true
	case 0x1004:
		return ReturnCode_RTERR_PRIOEXISTS, true
	case 0x1005:
		return ReturnCode_RTERR_NOMORETCB, true
	case 0x1006:
		return ReturnCode_RTERR_NOMORESEMAS, true
	case 0x1007:
		return ReturnCode_RTERR_NOMOREQUEUES, true
	case 0x100D:
		return ReturnCode_RTERR_EXTIRQALREADYDEF, true
	case 0x100E:
		return ReturnCode_RTERR_EXTIRQNOTDEF, true
	case 0x100F:
		return ReturnCode_RTERR_EXTIRQINSTALLFAILED, true
	case 0x1010:
		return ReturnCode_RTERR_IRQLNOTLESSOREQUAL, true
	case 0x1017:
		return ReturnCode_RTERR_VMXNOTSUPPORTED, true
	case 0x1018:
		return ReturnCode_RTERR_VMXDISABLED, true
	case 0x1019:
		return ReturnCode_RTERR_VMXCONTROLSMISSING, true
	case 0x101A:
		return ReturnCode_RTERR_VMXENABLEFAILS, true
	case 0x11:
		return ReturnCode_NO_DEBUGGING_AVAILABLE, true
	case 0x12:
		return ReturnCode_PORT_DEACTIVATED, true
	case 0x13:
		return ReturnCode_PORT_ALREADY_CONNECTED, true
	case 0x14:
		return ReturnCode_ADS_SYNC_WIN32_ERROR, true
	case 0x15:
		return ReturnCode_ADS_SYNC_TIMEOUT, true
	case 0x16:
		return ReturnCode_ADS_SYNC_AMS_ERROR, true
	case 0x17:
		return ReturnCode_NO_INDEX_MAP_FOR_ADS_AVAILABLE, true
	case 0x18:
		return ReturnCode_INVALID_ADS_PORT, true
	case 0x19:
		return ReturnCode_NO_MEMORY, true
	case 0x1A:
		return ReturnCode_TCP_SENDING_ERROR, true
	case 0x1B:
		return ReturnCode_HOST_NOT_REACHABLE, true
	case 0x1C:
		return ReturnCode_INVALID_AMS_FRAGMENT, true
	case 0x274C:
		return ReturnCode_WSAETIMEDOUT, true
	case 0x274D:
		return ReturnCode_WSAECONNREFUSED, true
	case 0x2751:
		return ReturnCode_WSAEHOSTUNREACH, true
	case 0x500:
		return ReturnCode_ROUTERERR_NOLOCKEDMEMORY, true
	case 0x501:
		return ReturnCode_ROUTERERR_RESIZEMEMORY, true
	case 0x502:
		return ReturnCode_ROUTERERR_MAILBOXFULL, true
	case 0x503:
		return ReturnCode_ROUTERERR_DEBUGBOXFULL, true
	case 0x504:
		return ReturnCode_ROUTERERR_UNKNOWNPORTTYPE, true
	case 0x505:
		return ReturnCode_ROUTERERR_NOTINITIALIZED, true
	case 0x506:
		return ReturnCode_ROUTERERR_PORTALREADYINUSE, true
	case 0x507:
		return ReturnCode_ROUTERERR_NOTREGISTERED, true
	case 0x508:
		return ReturnCode_ROUTERERR_NOMOREQUEUES, true
	case 0x509:
		return ReturnCode_ROUTERERR_INVALIDPORT, true
	case 0x50A:
		return ReturnCode_ROUTERERR_NOTACTIVATED, true
	case 0x700:
		return ReturnCode_ADSERR_DEVICE_ERROR, true
	case 0x701:
		return ReturnCode_ADSERR_DEVICE_SRVNOTSUPP, true
	case 0x702:
		return ReturnCode_ADSERR_DEVICE_INVALIDGRP, true
	case 0x703:
		return ReturnCode_ADSERR_DEVICE_INVALIDOFFSET, true
	case 0x704:
		return ReturnCode_ADSERR_DEVICE_INVALIDACCESS, true
	case 0x705:
		return ReturnCode_ADSERR_DEVICE_INVALIDSIZE, true
	case 0x706:
		return ReturnCode_ADSERR_DEVICE_INVALIDDATA, true
	case 0x707:
		return ReturnCode_ADSERR_DEVICE_NOTREADY, true
	case 0x708:
		return ReturnCode_ADSERR_DEVICE_BUSY, true
	case 0x709:
		return ReturnCode_ADSERR_DEVICE_INVALIDCONTEXT, true
	case 0x70A:
		return ReturnCode_ADSERR_DEVICE_NOMEMORY, true
	case 0x70B:
		return ReturnCode_ADSERR_DEVICE_INVALIDPARM, true
	case 0x70C:
		return ReturnCode_ADSERR_DEVICE_NOTFOUND, true
	case 0x70D:
		return ReturnCode_ADSERR_DEVICE_SYNTAX, true
	case 0x70E:
		return ReturnCode_ADSERR_DEVICE_INCOMPATIBLE, true
	case 0x70F:
		return ReturnCode_ADSERR_DEVICE_EXISTS, true
	case 0x710:
		return ReturnCode_ADSERR_DEVICE_SYMBOLNOTFOUND, true
	case 0x711:
		return ReturnCode_ADSERR_DEVICE_SYMBOLVERSIONINVALID, true
	case 0x712:
		return ReturnCode_ADSERR_DEVICE_INVALIDSTATE, true
	case 0x713:
		return ReturnCode_ADSERR_DEVICE_TRANSMODENOTSUPP, true
	case 0x714:
		return ReturnCode_ADSERR_DEVICE_NOTIFYHNDINVALID, true
	case 0x715:
		return ReturnCode_ADSERR_DEVICE_CLIENTUNKNOWN, true
	case 0x716:
		return ReturnCode_ADSERR_DEVICE_NOMOREHDLS, true
	case 0x717:
		return ReturnCode_ADSERR_DEVICE_INVALIDWATCHSIZE, true
	case 0x718:
		return ReturnCode_ADSERR_DEVICE_NOTINIT, true
	case 0x719:
		return ReturnCode_ADSERR_DEVICE_TIMEOUT, true
	case 0x71A:
		return ReturnCode_ADSERR_DEVICE_NOINTERFACE, true
	case 0x71B:
		return ReturnCode_ADSERR_DEVICE_INVALIDINTERFACE, true
	case 0x71C:
		return ReturnCode_ADSERR_DEVICE_INVALIDCLSID, true
	case 0x71D:
		return ReturnCode_ADSERR_DEVICE_INVALIDOBJID, true
	case 0x71E:
		return ReturnCode_ADSERR_DEVICE_PENDING, true
	case 0x71F:
		return ReturnCode_ADSERR_DEVICE_ABORTED, true
	case 0x720:
		return ReturnCode_ADSERR_DEVICE_WARNING, true
	case 0x721:
		return ReturnCode_ADSERR_DEVICE_INVALIDARRAYIDX, true
	case 0x722:
		return ReturnCode_ADSERR_DEVICE_SYMBOLNOTACTIVE, true
	case 0x723:
		return ReturnCode_ADSERR_DEVICE_ACCESSDENIED, true
	case 0x724:
		return ReturnCode_ADSERR_DEVICE_LICENSENOTFOUND, true
	case 0x725:
		return ReturnCode_ADSERR_DEVICE_LICENSEEXPIRED, true
	case 0x726:
		return ReturnCode_ADSERR_DEVICE_LICENSEEXCEEDED, true
	case 0x727:
		return ReturnCode_ADSERR_DEVICE_LICENSEINVALID, true
	case 0x728:
		return ReturnCode_ADSERR_DEVICE_LICENSESYSTEMID, true
	case 0x729:
		return ReturnCode_ADSERR_DEVICE_LICENSENOTIMELIMIT, true
	case 0x72A:
		return ReturnCode_ADSERR_DEVICE_LICENSEFUTUREISSUE, true
	case 0x72B:
		return ReturnCode_ADSERR_DEVICE_LICENSETIMETOLONG, true
	case 0x72D:
		return ReturnCode_ADSERR_DEVICE_LICENSEDUPLICATED, true
	case 0x72E:
		return ReturnCode_ADSERR_DEVICE_SIGNATUREINVALID, true
	case 0x72F:
		return ReturnCode_ADSERR_DEVICE_CERTIFICATEINVALID, true
	case 0x72c:
		return ReturnCode_ADSERR_DEVICE_EXCEPTION, true
	case 0x740:
		return ReturnCode_ADSERR_CLIENT_ERROR, true
	case 0x741:
		return ReturnCode_ADSERR_CLIENT_INVALIDPARM, true
	case 0x742:
		return ReturnCode_ADSERR_CLIENT_LISTEMPTY, true
	case 0x743:
		return ReturnCode_ADSERR_CLIENT_VARUSED, true
	case 0x744:
		return ReturnCode_ADSERR_CLIENT_DUPLINVOKEID, true
	case 0x745:
		return ReturnCode_ADSERR_CLIENT_SYNCTIMEOUT, true
	case 0x746:
		return ReturnCode_ADSERR_CLIENT_W32ERROR, true
	case 0x747:
		return ReturnCode_ADSERR_CLIENT_TIMEOUTINVALID, true
	case 0x748:
		return ReturnCode_ADSERR_CLIENT_PORTNOTOPEN, true
	case 0x750:
		return ReturnCode_ADSERR_CLIENT_NOAMSADDR, true
	case 0x751:
		return ReturnCode_ADSERR_CLIENT_SYNCINTERNAL, true
	case 0x752:
		return ReturnCode_ADSERR_CLIENT_ADDHASH, true
	case 0x753:
		return ReturnCode_ADSERR_CLIENT_REMOVEHASH, true
	case 0x754:
		return ReturnCode_ADSERR_CLIENT_NOMORESYM, true
	case 0x755:
		return ReturnCode_ADSERR_CLIENT_SYNCRESINVALID, true
	}
	return 0, false
}

func ReturnCodeByName(value string) (enum ReturnCode, ok bool) {
	switch value {
	case "OK":
		return ReturnCode_OK, true
	case "INTERNAL_ERROR":
		return ReturnCode_INTERNAL_ERROR, true
	case "NO_REALTIME":
		return ReturnCode_NO_REALTIME, true
	case "SAVE_ERROR":
		return ReturnCode_SAVE_ERROR, true
	case "MAILBOX_FULL":
		return ReturnCode_MAILBOX_FULL, true
	case "WRONG_HMSG":
		return ReturnCode_WRONG_HMSG, true
	case "TARGET_PORT_NOT_FOUND":
		return ReturnCode_TARGET_PORT_NOT_FOUND, true
	case "TARGET_HOST_NOT_FOUND":
		return ReturnCode_TARGET_HOST_NOT_FOUND, true
	case "UNKNOWN_COMMAND_ID":
		return ReturnCode_UNKNOWN_COMMAND_ID, true
	case "UNKNOWN_TASK_ID":
		return ReturnCode_UNKNOWN_TASK_ID, true
	case "NO_IO":
		return ReturnCode_NO_IO, true
	case "UNKNOWN_ADS_COMMAND":
		return ReturnCode_UNKNOWN_ADS_COMMAND, true
	case "WIN32_ERROR":
		return ReturnCode_WIN32_ERROR, true
	case "PORT_NOT_CONNECTED":
		return ReturnCode_PORT_NOT_CONNECTED, true
	case "INVALID_ADS_LENGTH":
		return ReturnCode_INVALID_ADS_LENGTH, true
	case "INVALID_AMS_NET_ID":
		return ReturnCode_INVALID_AMS_NET_ID, true
	case "LOW_INSTALLATION_LEVEL":
		return ReturnCode_LOW_INSTALLATION_LEVEL, true
	case "RTERR_INTERNAL":
		return ReturnCode_RTERR_INTERNAL, true
	case "RTERR_BADTIMERPERIODS":
		return ReturnCode_RTERR_BADTIMERPERIODS, true
	case "RTERR_INVALIDTASKPTR":
		return ReturnCode_RTERR_INVALIDTASKPTR, true
	case "RTERR_INVALIDSTACKPTR":
		return ReturnCode_RTERR_INVALIDSTACKPTR, true
	case "RTERR_PRIOEXISTS":
		return ReturnCode_RTERR_PRIOEXISTS, true
	case "RTERR_NOMORETCB":
		return ReturnCode_RTERR_NOMORETCB, true
	case "RTERR_NOMORESEMAS":
		return ReturnCode_RTERR_NOMORESEMAS, true
	case "RTERR_NOMOREQUEUES":
		return ReturnCode_RTERR_NOMOREQUEUES, true
	case "RTERR_EXTIRQALREADYDEF":
		return ReturnCode_RTERR_EXTIRQALREADYDEF, true
	case "RTERR_EXTIRQNOTDEF":
		return ReturnCode_RTERR_EXTIRQNOTDEF, true
	case "RTERR_EXTIRQINSTALLFAILED":
		return ReturnCode_RTERR_EXTIRQINSTALLFAILED, true
	case "RTERR_IRQLNOTLESSOREQUAL":
		return ReturnCode_RTERR_IRQLNOTLESSOREQUAL, true
	case "RTERR_VMXNOTSUPPORTED":
		return ReturnCode_RTERR_VMXNOTSUPPORTED, true
	case "RTERR_VMXDISABLED":
		return ReturnCode_RTERR_VMXDISABLED, true
	case "RTERR_VMXCONTROLSMISSING":
		return ReturnCode_RTERR_VMXCONTROLSMISSING, true
	case "RTERR_VMXENABLEFAILS":
		return ReturnCode_RTERR_VMXENABLEFAILS, true
	case "NO_DEBUGGING_AVAILABLE":
		return ReturnCode_NO_DEBUGGING_AVAILABLE, true
	case "PORT_DEACTIVATED":
		return ReturnCode_PORT_DEACTIVATED, true
	case "PORT_ALREADY_CONNECTED":
		return ReturnCode_PORT_ALREADY_CONNECTED, true
	case "ADS_SYNC_WIN32_ERROR":
		return ReturnCode_ADS_SYNC_WIN32_ERROR, true
	case "ADS_SYNC_TIMEOUT":
		return ReturnCode_ADS_SYNC_TIMEOUT, true
	case "ADS_SYNC_AMS_ERROR":
		return ReturnCode_ADS_SYNC_AMS_ERROR, true
	case "NO_INDEX_MAP_FOR_ADS_AVAILABLE":
		return ReturnCode_NO_INDEX_MAP_FOR_ADS_AVAILABLE, true
	case "INVALID_ADS_PORT":
		return ReturnCode_INVALID_ADS_PORT, true
	case "NO_MEMORY":
		return ReturnCode_NO_MEMORY, true
	case "TCP_SENDING_ERROR":
		return ReturnCode_TCP_SENDING_ERROR, true
	case "HOST_NOT_REACHABLE":
		return ReturnCode_HOST_NOT_REACHABLE, true
	case "INVALID_AMS_FRAGMENT":
		return ReturnCode_INVALID_AMS_FRAGMENT, true
	case "WSAETIMEDOUT":
		return ReturnCode_WSAETIMEDOUT, true
	case "WSAECONNREFUSED":
		return ReturnCode_WSAECONNREFUSED, true
	case "WSAEHOSTUNREACH":
		return ReturnCode_WSAEHOSTUNREACH, true
	case "ROUTERERR_NOLOCKEDMEMORY":
		return ReturnCode_ROUTERERR_NOLOCKEDMEMORY, true
	case "ROUTERERR_RESIZEMEMORY":
		return ReturnCode_ROUTERERR_RESIZEMEMORY, true
	case "ROUTERERR_MAILBOXFULL":
		return ReturnCode_ROUTERERR_MAILBOXFULL, true
	case "ROUTERERR_DEBUGBOXFULL":
		return ReturnCode_ROUTERERR_DEBUGBOXFULL, true
	case "ROUTERERR_UNKNOWNPORTTYPE":
		return ReturnCode_ROUTERERR_UNKNOWNPORTTYPE, true
	case "ROUTERERR_NOTINITIALIZED":
		return ReturnCode_ROUTERERR_NOTINITIALIZED, true
	case "ROUTERERR_PORTALREADYINUSE":
		return ReturnCode_ROUTERERR_PORTALREADYINUSE, true
	case "ROUTERERR_NOTREGISTERED":
		return ReturnCode_ROUTERERR_NOTREGISTERED, true
	case "ROUTERERR_NOMOREQUEUES":
		return ReturnCode_ROUTERERR_NOMOREQUEUES, true
	case "ROUTERERR_INVALIDPORT":
		return ReturnCode_ROUTERERR_INVALIDPORT, true
	case "ROUTERERR_NOTACTIVATED":
		return ReturnCode_ROUTERERR_NOTACTIVATED, true
	case "ADSERR_DEVICE_ERROR":
		return ReturnCode_ADSERR_DEVICE_ERROR, true
	case "ADSERR_DEVICE_SRVNOTSUPP":
		return ReturnCode_ADSERR_DEVICE_SRVNOTSUPP, true
	case "ADSERR_DEVICE_INVALIDGRP":
		return ReturnCode_ADSERR_DEVICE_INVALIDGRP, true
	case "ADSERR_DEVICE_INVALIDOFFSET":
		return ReturnCode_ADSERR_DEVICE_INVALIDOFFSET, true
	case "ADSERR_DEVICE_INVALIDACCESS":
		return ReturnCode_ADSERR_DEVICE_INVALIDACCESS, true
	case "ADSERR_DEVICE_INVALIDSIZE":
		return ReturnCode_ADSERR_DEVICE_INVALIDSIZE, true
	case "ADSERR_DEVICE_INVALIDDATA":
		return ReturnCode_ADSERR_DEVICE_INVALIDDATA, true
	case "ADSERR_DEVICE_NOTREADY":
		return ReturnCode_ADSERR_DEVICE_NOTREADY, true
	case "ADSERR_DEVICE_BUSY":
		return ReturnCode_ADSERR_DEVICE_BUSY, true
	case "ADSERR_DEVICE_INVALIDCONTEXT":
		return ReturnCode_ADSERR_DEVICE_INVALIDCONTEXT, true
	case "ADSERR_DEVICE_NOMEMORY":
		return ReturnCode_ADSERR_DEVICE_NOMEMORY, true
	case "ADSERR_DEVICE_INVALIDPARM":
		return ReturnCode_ADSERR_DEVICE_INVALIDPARM, true
	case "ADSERR_DEVICE_NOTFOUND":
		return ReturnCode_ADSERR_DEVICE_NOTFOUND, true
	case "ADSERR_DEVICE_SYNTAX":
		return ReturnCode_ADSERR_DEVICE_SYNTAX, true
	case "ADSERR_DEVICE_INCOMPATIBLE":
		return ReturnCode_ADSERR_DEVICE_INCOMPATIBLE, true
	case "ADSERR_DEVICE_EXISTS":
		return ReturnCode_ADSERR_DEVICE_EXISTS, true
	case "ADSERR_DEVICE_SYMBOLNOTFOUND":
		return ReturnCode_ADSERR_DEVICE_SYMBOLNOTFOUND, true
	case "ADSERR_DEVICE_SYMBOLVERSIONINVALID":
		return ReturnCode_ADSERR_DEVICE_SYMBOLVERSIONINVALID, true
	case "ADSERR_DEVICE_INVALIDSTATE":
		return ReturnCode_ADSERR_DEVICE_INVALIDSTATE, true
	case "ADSERR_DEVICE_TRANSMODENOTSUPP":
		return ReturnCode_ADSERR_DEVICE_TRANSMODENOTSUPP, true
	case "ADSERR_DEVICE_NOTIFYHNDINVALID":
		return ReturnCode_ADSERR_DEVICE_NOTIFYHNDINVALID, true
	case "ADSERR_DEVICE_CLIENTUNKNOWN":
		return ReturnCode_ADSERR_DEVICE_CLIENTUNKNOWN, true
	case "ADSERR_DEVICE_NOMOREHDLS":
		return ReturnCode_ADSERR_DEVICE_NOMOREHDLS, true
	case "ADSERR_DEVICE_INVALIDWATCHSIZE":
		return ReturnCode_ADSERR_DEVICE_INVALIDWATCHSIZE, true
	case "ADSERR_DEVICE_NOTINIT":
		return ReturnCode_ADSERR_DEVICE_NOTINIT, true
	case "ADSERR_DEVICE_TIMEOUT":
		return ReturnCode_ADSERR_DEVICE_TIMEOUT, true
	case "ADSERR_DEVICE_NOINTERFACE":
		return ReturnCode_ADSERR_DEVICE_NOINTERFACE, true
	case "ADSERR_DEVICE_INVALIDINTERFACE":
		return ReturnCode_ADSERR_DEVICE_INVALIDINTERFACE, true
	case "ADSERR_DEVICE_INVALIDCLSID":
		return ReturnCode_ADSERR_DEVICE_INVALIDCLSID, true
	case "ADSERR_DEVICE_INVALIDOBJID":
		return ReturnCode_ADSERR_DEVICE_INVALIDOBJID, true
	case "ADSERR_DEVICE_PENDING":
		return ReturnCode_ADSERR_DEVICE_PENDING, true
	case "ADSERR_DEVICE_ABORTED":
		return ReturnCode_ADSERR_DEVICE_ABORTED, true
	case "ADSERR_DEVICE_WARNING":
		return ReturnCode_ADSERR_DEVICE_WARNING, true
	case "ADSERR_DEVICE_INVALIDARRAYIDX":
		return ReturnCode_ADSERR_DEVICE_INVALIDARRAYIDX, true
	case "ADSERR_DEVICE_SYMBOLNOTACTIVE":
		return ReturnCode_ADSERR_DEVICE_SYMBOLNOTACTIVE, true
	case "ADSERR_DEVICE_ACCESSDENIED":
		return ReturnCode_ADSERR_DEVICE_ACCESSDENIED, true
	case "ADSERR_DEVICE_LICENSENOTFOUND":
		return ReturnCode_ADSERR_DEVICE_LICENSENOTFOUND, true
	case "ADSERR_DEVICE_LICENSEEXPIRED":
		return ReturnCode_ADSERR_DEVICE_LICENSEEXPIRED, true
	case "ADSERR_DEVICE_LICENSEEXCEEDED":
		return ReturnCode_ADSERR_DEVICE_LICENSEEXCEEDED, true
	case "ADSERR_DEVICE_LICENSEINVALID":
		return ReturnCode_ADSERR_DEVICE_LICENSEINVALID, true
	case "ADSERR_DEVICE_LICENSESYSTEMID":
		return ReturnCode_ADSERR_DEVICE_LICENSESYSTEMID, true
	case "ADSERR_DEVICE_LICENSENOTIMELIMIT":
		return ReturnCode_ADSERR_DEVICE_LICENSENOTIMELIMIT, true
	case "ADSERR_DEVICE_LICENSEFUTUREISSUE":
		return ReturnCode_ADSERR_DEVICE_LICENSEFUTUREISSUE, true
	case "ADSERR_DEVICE_LICENSETIMETOLONG":
		return ReturnCode_ADSERR_DEVICE_LICENSETIMETOLONG, true
	case "ADSERR_DEVICE_LICENSEDUPLICATED":
		return ReturnCode_ADSERR_DEVICE_LICENSEDUPLICATED, true
	case "ADSERR_DEVICE_SIGNATUREINVALID":
		return ReturnCode_ADSERR_DEVICE_SIGNATUREINVALID, true
	case "ADSERR_DEVICE_CERTIFICATEINVALID":
		return ReturnCode_ADSERR_DEVICE_CERTIFICATEINVALID, true
	case "ADSERR_DEVICE_EXCEPTION":
		return ReturnCode_ADSERR_DEVICE_EXCEPTION, true
	case "ADSERR_CLIENT_ERROR":
		return ReturnCode_ADSERR_CLIENT_ERROR, true
	case "ADSERR_CLIENT_INVALIDPARM":
		return ReturnCode_ADSERR_CLIENT_INVALIDPARM, true
	case "ADSERR_CLIENT_LISTEMPTY":
		return ReturnCode_ADSERR_CLIENT_LISTEMPTY, true
	case "ADSERR_CLIENT_VARUSED":
		return ReturnCode_ADSERR_CLIENT_VARUSED, true
	case "ADSERR_CLIENT_DUPLINVOKEID":
		return ReturnCode_ADSERR_CLIENT_DUPLINVOKEID, true
	case "ADSERR_CLIENT_SYNCTIMEOUT":
		return ReturnCode_ADSERR_CLIENT_SYNCTIMEOUT, true
	case "ADSERR_CLIENT_W32ERROR":
		return ReturnCode_ADSERR_CLIENT_W32ERROR, true
	case "ADSERR_CLIENT_TIMEOUTINVALID":
		return ReturnCode_ADSERR_CLIENT_TIMEOUTINVALID, true
	case "ADSERR_CLIENT_PORTNOTOPEN":
		return ReturnCode_ADSERR_CLIENT_PORTNOTOPEN, true
	case "ADSERR_CLIENT_NOAMSADDR":
		return ReturnCode_ADSERR_CLIENT_NOAMSADDR, true
	case "ADSERR_CLIENT_SYNCINTERNAL":
		return ReturnCode_ADSERR_CLIENT_SYNCINTERNAL, true
	case "ADSERR_CLIENT_ADDHASH":
		return ReturnCode_ADSERR_CLIENT_ADDHASH, true
	case "ADSERR_CLIENT_REMOVEHASH":
		return ReturnCode_ADSERR_CLIENT_REMOVEHASH, true
	case "ADSERR_CLIENT_NOMORESYM":
		return ReturnCode_ADSERR_CLIENT_NOMORESYM, true
	case "ADSERR_CLIENT_SYNCRESINVALID":
		return ReturnCode_ADSERR_CLIENT_SYNCRESINVALID, true
	}
	return 0, false
}

func ReturnCodeKnows(value uint32) bool {
	for _, typeValue := range ReturnCodeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastReturnCode(structType any) ReturnCode {
	castFunc := func(typ any) ReturnCode {
		if sReturnCode, ok := typ.(ReturnCode); ok {
			return sReturnCode
		}
		return 0
	}
	return castFunc(structType)
}

func (m ReturnCode) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m ReturnCode) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ReturnCodeParse(ctx context.Context, theBytes []byte) (ReturnCode, error) {
	return ReturnCodeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ReturnCodeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ReturnCode, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("ReturnCode", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ReturnCode")
	}
	if enum, ok := ReturnCodeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for ReturnCode")
		return ReturnCode(val), nil
	} else {
		return enum, nil
	}
}

func (e ReturnCode) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e ReturnCode) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("ReturnCode", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e ReturnCode) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ReturnCode) PLC4XEnumName() string {
	switch e {
	case ReturnCode_OK:
		return "OK"
	case ReturnCode_INTERNAL_ERROR:
		return "INTERNAL_ERROR"
	case ReturnCode_NO_REALTIME:
		return "NO_REALTIME"
	case ReturnCode_SAVE_ERROR:
		return "SAVE_ERROR"
	case ReturnCode_MAILBOX_FULL:
		return "MAILBOX_FULL"
	case ReturnCode_WRONG_HMSG:
		return "WRONG_HMSG"
	case ReturnCode_TARGET_PORT_NOT_FOUND:
		return "TARGET_PORT_NOT_FOUND"
	case ReturnCode_TARGET_HOST_NOT_FOUND:
		return "TARGET_HOST_NOT_FOUND"
	case ReturnCode_UNKNOWN_COMMAND_ID:
		return "UNKNOWN_COMMAND_ID"
	case ReturnCode_UNKNOWN_TASK_ID:
		return "UNKNOWN_TASK_ID"
	case ReturnCode_NO_IO:
		return "NO_IO"
	case ReturnCode_UNKNOWN_ADS_COMMAND:
		return "UNKNOWN_ADS_COMMAND"
	case ReturnCode_WIN32_ERROR:
		return "WIN32_ERROR"
	case ReturnCode_PORT_NOT_CONNECTED:
		return "PORT_NOT_CONNECTED"
	case ReturnCode_INVALID_ADS_LENGTH:
		return "INVALID_ADS_LENGTH"
	case ReturnCode_INVALID_AMS_NET_ID:
		return "INVALID_AMS_NET_ID"
	case ReturnCode_LOW_INSTALLATION_LEVEL:
		return "LOW_INSTALLATION_LEVEL"
	case ReturnCode_RTERR_INTERNAL:
		return "RTERR_INTERNAL"
	case ReturnCode_RTERR_BADTIMERPERIODS:
		return "RTERR_BADTIMERPERIODS"
	case ReturnCode_RTERR_INVALIDTASKPTR:
		return "RTERR_INVALIDTASKPTR"
	case ReturnCode_RTERR_INVALIDSTACKPTR:
		return "RTERR_INVALIDSTACKPTR"
	case ReturnCode_RTERR_PRIOEXISTS:
		return "RTERR_PRIOEXISTS"
	case ReturnCode_RTERR_NOMORETCB:
		return "RTERR_NOMORETCB"
	case ReturnCode_RTERR_NOMORESEMAS:
		return "RTERR_NOMORESEMAS"
	case ReturnCode_RTERR_NOMOREQUEUES:
		return "RTERR_NOMOREQUEUES"
	case ReturnCode_RTERR_EXTIRQALREADYDEF:
		return "RTERR_EXTIRQALREADYDEF"
	case ReturnCode_RTERR_EXTIRQNOTDEF:
		return "RTERR_EXTIRQNOTDEF"
	case ReturnCode_RTERR_EXTIRQINSTALLFAILED:
		return "RTERR_EXTIRQINSTALLFAILED"
	case ReturnCode_RTERR_IRQLNOTLESSOREQUAL:
		return "RTERR_IRQLNOTLESSOREQUAL"
	case ReturnCode_RTERR_VMXNOTSUPPORTED:
		return "RTERR_VMXNOTSUPPORTED"
	case ReturnCode_RTERR_VMXDISABLED:
		return "RTERR_VMXDISABLED"
	case ReturnCode_RTERR_VMXCONTROLSMISSING:
		return "RTERR_VMXCONTROLSMISSING"
	case ReturnCode_RTERR_VMXENABLEFAILS:
		return "RTERR_VMXENABLEFAILS"
	case ReturnCode_NO_DEBUGGING_AVAILABLE:
		return "NO_DEBUGGING_AVAILABLE"
	case ReturnCode_PORT_DEACTIVATED:
		return "PORT_DEACTIVATED"
	case ReturnCode_PORT_ALREADY_CONNECTED:
		return "PORT_ALREADY_CONNECTED"
	case ReturnCode_ADS_SYNC_WIN32_ERROR:
		return "ADS_SYNC_WIN32_ERROR"
	case ReturnCode_ADS_SYNC_TIMEOUT:
		return "ADS_SYNC_TIMEOUT"
	case ReturnCode_ADS_SYNC_AMS_ERROR:
		return "ADS_SYNC_AMS_ERROR"
	case ReturnCode_NO_INDEX_MAP_FOR_ADS_AVAILABLE:
		return "NO_INDEX_MAP_FOR_ADS_AVAILABLE"
	case ReturnCode_INVALID_ADS_PORT:
		return "INVALID_ADS_PORT"
	case ReturnCode_NO_MEMORY:
		return "NO_MEMORY"
	case ReturnCode_TCP_SENDING_ERROR:
		return "TCP_SENDING_ERROR"
	case ReturnCode_HOST_NOT_REACHABLE:
		return "HOST_NOT_REACHABLE"
	case ReturnCode_INVALID_AMS_FRAGMENT:
		return "INVALID_AMS_FRAGMENT"
	case ReturnCode_WSAETIMEDOUT:
		return "WSAETIMEDOUT"
	case ReturnCode_WSAECONNREFUSED:
		return "WSAECONNREFUSED"
	case ReturnCode_WSAEHOSTUNREACH:
		return "WSAEHOSTUNREACH"
	case ReturnCode_ROUTERERR_NOLOCKEDMEMORY:
		return "ROUTERERR_NOLOCKEDMEMORY"
	case ReturnCode_ROUTERERR_RESIZEMEMORY:
		return "ROUTERERR_RESIZEMEMORY"
	case ReturnCode_ROUTERERR_MAILBOXFULL:
		return "ROUTERERR_MAILBOXFULL"
	case ReturnCode_ROUTERERR_DEBUGBOXFULL:
		return "ROUTERERR_DEBUGBOXFULL"
	case ReturnCode_ROUTERERR_UNKNOWNPORTTYPE:
		return "ROUTERERR_UNKNOWNPORTTYPE"
	case ReturnCode_ROUTERERR_NOTINITIALIZED:
		return "ROUTERERR_NOTINITIALIZED"
	case ReturnCode_ROUTERERR_PORTALREADYINUSE:
		return "ROUTERERR_PORTALREADYINUSE"
	case ReturnCode_ROUTERERR_NOTREGISTERED:
		return "ROUTERERR_NOTREGISTERED"
	case ReturnCode_ROUTERERR_NOMOREQUEUES:
		return "ROUTERERR_NOMOREQUEUES"
	case ReturnCode_ROUTERERR_INVALIDPORT:
		return "ROUTERERR_INVALIDPORT"
	case ReturnCode_ROUTERERR_NOTACTIVATED:
		return "ROUTERERR_NOTACTIVATED"
	case ReturnCode_ADSERR_DEVICE_ERROR:
		return "ADSERR_DEVICE_ERROR"
	case ReturnCode_ADSERR_DEVICE_SRVNOTSUPP:
		return "ADSERR_DEVICE_SRVNOTSUPP"
	case ReturnCode_ADSERR_DEVICE_INVALIDGRP:
		return "ADSERR_DEVICE_INVALIDGRP"
	case ReturnCode_ADSERR_DEVICE_INVALIDOFFSET:
		return "ADSERR_DEVICE_INVALIDOFFSET"
	case ReturnCode_ADSERR_DEVICE_INVALIDACCESS:
		return "ADSERR_DEVICE_INVALIDACCESS"
	case ReturnCode_ADSERR_DEVICE_INVALIDSIZE:
		return "ADSERR_DEVICE_INVALIDSIZE"
	case ReturnCode_ADSERR_DEVICE_INVALIDDATA:
		return "ADSERR_DEVICE_INVALIDDATA"
	case ReturnCode_ADSERR_DEVICE_NOTREADY:
		return "ADSERR_DEVICE_NOTREADY"
	case ReturnCode_ADSERR_DEVICE_BUSY:
		return "ADSERR_DEVICE_BUSY"
	case ReturnCode_ADSERR_DEVICE_INVALIDCONTEXT:
		return "ADSERR_DEVICE_INVALIDCONTEXT"
	case ReturnCode_ADSERR_DEVICE_NOMEMORY:
		return "ADSERR_DEVICE_NOMEMORY"
	case ReturnCode_ADSERR_DEVICE_INVALIDPARM:
		return "ADSERR_DEVICE_INVALIDPARM"
	case ReturnCode_ADSERR_DEVICE_NOTFOUND:
		return "ADSERR_DEVICE_NOTFOUND"
	case ReturnCode_ADSERR_DEVICE_SYNTAX:
		return "ADSERR_DEVICE_SYNTAX"
	case ReturnCode_ADSERR_DEVICE_INCOMPATIBLE:
		return "ADSERR_DEVICE_INCOMPATIBLE"
	case ReturnCode_ADSERR_DEVICE_EXISTS:
		return "ADSERR_DEVICE_EXISTS"
	case ReturnCode_ADSERR_DEVICE_SYMBOLNOTFOUND:
		return "ADSERR_DEVICE_SYMBOLNOTFOUND"
	case ReturnCode_ADSERR_DEVICE_SYMBOLVERSIONINVALID:
		return "ADSERR_DEVICE_SYMBOLVERSIONINVALID"
	case ReturnCode_ADSERR_DEVICE_INVALIDSTATE:
		return "ADSERR_DEVICE_INVALIDSTATE"
	case ReturnCode_ADSERR_DEVICE_TRANSMODENOTSUPP:
		return "ADSERR_DEVICE_TRANSMODENOTSUPP"
	case ReturnCode_ADSERR_DEVICE_NOTIFYHNDINVALID:
		return "ADSERR_DEVICE_NOTIFYHNDINVALID"
	case ReturnCode_ADSERR_DEVICE_CLIENTUNKNOWN:
		return "ADSERR_DEVICE_CLIENTUNKNOWN"
	case ReturnCode_ADSERR_DEVICE_NOMOREHDLS:
		return "ADSERR_DEVICE_NOMOREHDLS"
	case ReturnCode_ADSERR_DEVICE_INVALIDWATCHSIZE:
		return "ADSERR_DEVICE_INVALIDWATCHSIZE"
	case ReturnCode_ADSERR_DEVICE_NOTINIT:
		return "ADSERR_DEVICE_NOTINIT"
	case ReturnCode_ADSERR_DEVICE_TIMEOUT:
		return "ADSERR_DEVICE_TIMEOUT"
	case ReturnCode_ADSERR_DEVICE_NOINTERFACE:
		return "ADSERR_DEVICE_NOINTERFACE"
	case ReturnCode_ADSERR_DEVICE_INVALIDINTERFACE:
		return "ADSERR_DEVICE_INVALIDINTERFACE"
	case ReturnCode_ADSERR_DEVICE_INVALIDCLSID:
		return "ADSERR_DEVICE_INVALIDCLSID"
	case ReturnCode_ADSERR_DEVICE_INVALIDOBJID:
		return "ADSERR_DEVICE_INVALIDOBJID"
	case ReturnCode_ADSERR_DEVICE_PENDING:
		return "ADSERR_DEVICE_PENDING"
	case ReturnCode_ADSERR_DEVICE_ABORTED:
		return "ADSERR_DEVICE_ABORTED"
	case ReturnCode_ADSERR_DEVICE_WARNING:
		return "ADSERR_DEVICE_WARNING"
	case ReturnCode_ADSERR_DEVICE_INVALIDARRAYIDX:
		return "ADSERR_DEVICE_INVALIDARRAYIDX"
	case ReturnCode_ADSERR_DEVICE_SYMBOLNOTACTIVE:
		return "ADSERR_DEVICE_SYMBOLNOTACTIVE"
	case ReturnCode_ADSERR_DEVICE_ACCESSDENIED:
		return "ADSERR_DEVICE_ACCESSDENIED"
	case ReturnCode_ADSERR_DEVICE_LICENSENOTFOUND:
		return "ADSERR_DEVICE_LICENSENOTFOUND"
	case ReturnCode_ADSERR_DEVICE_LICENSEEXPIRED:
		return "ADSERR_DEVICE_LICENSEEXPIRED"
	case ReturnCode_ADSERR_DEVICE_LICENSEEXCEEDED:
		return "ADSERR_DEVICE_LICENSEEXCEEDED"
	case ReturnCode_ADSERR_DEVICE_LICENSEINVALID:
		return "ADSERR_DEVICE_LICENSEINVALID"
	case ReturnCode_ADSERR_DEVICE_LICENSESYSTEMID:
		return "ADSERR_DEVICE_LICENSESYSTEMID"
	case ReturnCode_ADSERR_DEVICE_LICENSENOTIMELIMIT:
		return "ADSERR_DEVICE_LICENSENOTIMELIMIT"
	case ReturnCode_ADSERR_DEVICE_LICENSEFUTUREISSUE:
		return "ADSERR_DEVICE_LICENSEFUTUREISSUE"
	case ReturnCode_ADSERR_DEVICE_LICENSETIMETOLONG:
		return "ADSERR_DEVICE_LICENSETIMETOLONG"
	case ReturnCode_ADSERR_DEVICE_LICENSEDUPLICATED:
		return "ADSERR_DEVICE_LICENSEDUPLICATED"
	case ReturnCode_ADSERR_DEVICE_SIGNATUREINVALID:
		return "ADSERR_DEVICE_SIGNATUREINVALID"
	case ReturnCode_ADSERR_DEVICE_CERTIFICATEINVALID:
		return "ADSERR_DEVICE_CERTIFICATEINVALID"
	case ReturnCode_ADSERR_DEVICE_EXCEPTION:
		return "ADSERR_DEVICE_EXCEPTION"
	case ReturnCode_ADSERR_CLIENT_ERROR:
		return "ADSERR_CLIENT_ERROR"
	case ReturnCode_ADSERR_CLIENT_INVALIDPARM:
		return "ADSERR_CLIENT_INVALIDPARM"
	case ReturnCode_ADSERR_CLIENT_LISTEMPTY:
		return "ADSERR_CLIENT_LISTEMPTY"
	case ReturnCode_ADSERR_CLIENT_VARUSED:
		return "ADSERR_CLIENT_VARUSED"
	case ReturnCode_ADSERR_CLIENT_DUPLINVOKEID:
		return "ADSERR_CLIENT_DUPLINVOKEID"
	case ReturnCode_ADSERR_CLIENT_SYNCTIMEOUT:
		return "ADSERR_CLIENT_SYNCTIMEOUT"
	case ReturnCode_ADSERR_CLIENT_W32ERROR:
		return "ADSERR_CLIENT_W32ERROR"
	case ReturnCode_ADSERR_CLIENT_TIMEOUTINVALID:
		return "ADSERR_CLIENT_TIMEOUTINVALID"
	case ReturnCode_ADSERR_CLIENT_PORTNOTOPEN:
		return "ADSERR_CLIENT_PORTNOTOPEN"
	case ReturnCode_ADSERR_CLIENT_NOAMSADDR:
		return "ADSERR_CLIENT_NOAMSADDR"
	case ReturnCode_ADSERR_CLIENT_SYNCINTERNAL:
		return "ADSERR_CLIENT_SYNCINTERNAL"
	case ReturnCode_ADSERR_CLIENT_ADDHASH:
		return "ADSERR_CLIENT_ADDHASH"
	case ReturnCode_ADSERR_CLIENT_REMOVEHASH:
		return "ADSERR_CLIENT_REMOVEHASH"
	case ReturnCode_ADSERR_CLIENT_NOMORESYM:
		return "ADSERR_CLIENT_NOMORESYM"
	case ReturnCode_ADSERR_CLIENT_SYNCRESINVALID:
		return "ADSERR_CLIENT_SYNCRESINVALID"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e ReturnCode) String() string {
	return e.PLC4XEnumName()
}
