/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBitstringValueAll is the corresponding interface of BACnetConstructedDataBitstringValueAll
type BACnetConstructedDataBitstringValueAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataBitstringValueAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBitstringValueAll()
	// CreateBuilder creates a BACnetConstructedDataBitstringValueAllBuilder
	CreateBACnetConstructedDataBitstringValueAllBuilder() BACnetConstructedDataBitstringValueAllBuilder
}

// _BACnetConstructedDataBitstringValueAll is the data-structure of this message
type _BACnetConstructedDataBitstringValueAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataBitstringValueAll = (*_BACnetConstructedDataBitstringValueAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBitstringValueAll)(nil)

// NewBACnetConstructedDataBitstringValueAll factory function for _BACnetConstructedDataBitstringValueAll
func NewBACnetConstructedDataBitstringValueAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBitstringValueAll {
	_result := &_BACnetConstructedDataBitstringValueAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBitstringValueAllBuilder is a builder for BACnetConstructedDataBitstringValueAll
type BACnetConstructedDataBitstringValueAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataBitstringValueAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBitstringValueAll or returns an error if something is wrong
	Build() (BACnetConstructedDataBitstringValueAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBitstringValueAll
}

// NewBACnetConstructedDataBitstringValueAllBuilder() creates a BACnetConstructedDataBitstringValueAllBuilder
func NewBACnetConstructedDataBitstringValueAllBuilder() BACnetConstructedDataBitstringValueAllBuilder {
	return &_BACnetConstructedDataBitstringValueAllBuilder{_BACnetConstructedDataBitstringValueAll: new(_BACnetConstructedDataBitstringValueAll)}
}

type _BACnetConstructedDataBitstringValueAllBuilder struct {
	*_BACnetConstructedDataBitstringValueAll

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataBitstringValueAllBuilder) = (*_BACnetConstructedDataBitstringValueAllBuilder)(nil)

func (b *_BACnetConstructedDataBitstringValueAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBitstringValueAll
}

func (b *_BACnetConstructedDataBitstringValueAllBuilder) WithMandatoryFields() BACnetConstructedDataBitstringValueAllBuilder {
	return b
}

func (b *_BACnetConstructedDataBitstringValueAllBuilder) Build() (BACnetConstructedDataBitstringValueAll, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataBitstringValueAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataBitstringValueAllBuilder) MustBuild() BACnetConstructedDataBitstringValueAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBitstringValueAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBitstringValueAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBitstringValueAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBitstringValueAllBuilder().(*_BACnetConstructedDataBitstringValueAllBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataBitstringValueAllBuilder creates a BACnetConstructedDataBitstringValueAllBuilder
func (b *_BACnetConstructedDataBitstringValueAll) CreateBACnetConstructedDataBitstringValueAllBuilder() BACnetConstructedDataBitstringValueAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataBitstringValueAllBuilder()
	}
	return &_BACnetConstructedDataBitstringValueAllBuilder{_BACnetConstructedDataBitstringValueAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBitstringValueAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_BITSTRING_VALUE
}

func (m *_BACnetConstructedDataBitstringValueAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBitstringValueAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBitstringValueAll(structType any) BACnetConstructedDataBitstringValueAll {
	if casted, ok := structType.(BACnetConstructedDataBitstringValueAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBitstringValueAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBitstringValueAll) GetTypeName() string {
	return "BACnetConstructedDataBitstringValueAll"
}

func (m *_BACnetConstructedDataBitstringValueAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataBitstringValueAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBitstringValueAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBitstringValueAll BACnetConstructedDataBitstringValueAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBitstringValueAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBitstringValueAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBitstringValueAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBitstringValueAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBitstringValueAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBitstringValueAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBitstringValueAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBitstringValueAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBitstringValueAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBitstringValueAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBitstringValueAll) IsBACnetConstructedDataBitstringValueAll() {}

func (m *_BACnetConstructedDataBitstringValueAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBitstringValueAll) deepCopy() *_BACnetConstructedDataBitstringValueAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBitstringValueAllCopy := &_BACnetConstructedDataBitstringValueAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataBitstringValueAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBitstringValueAllCopy
}

func (m *_BACnetConstructedDataBitstringValueAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
