/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBufferSize is the corresponding interface of BACnetConstructedDataBufferSize
type BACnetConstructedDataBufferSize interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetBufferSize returns BufferSize (property field)
	GetBufferSize() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataBufferSize is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBufferSize()
	// CreateBuilder creates a BACnetConstructedDataBufferSizeBuilder
	CreateBACnetConstructedDataBufferSizeBuilder() BACnetConstructedDataBufferSizeBuilder
}

// _BACnetConstructedDataBufferSize is the data-structure of this message
type _BACnetConstructedDataBufferSize struct {
	BACnetConstructedDataContract
	BufferSize BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataBufferSize = (*_BACnetConstructedDataBufferSize)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBufferSize)(nil)

// NewBACnetConstructedDataBufferSize factory function for _BACnetConstructedDataBufferSize
func NewBACnetConstructedDataBufferSize(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, bufferSize BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBufferSize {
	if bufferSize == nil {
		panic("bufferSize of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataBufferSize must not be nil")
	}
	_result := &_BACnetConstructedDataBufferSize{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		BufferSize:                    bufferSize,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBufferSizeBuilder is a builder for BACnetConstructedDataBufferSize
type BACnetConstructedDataBufferSizeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(bufferSize BACnetApplicationTagUnsignedInteger) BACnetConstructedDataBufferSizeBuilder
	// WithBufferSize adds BufferSize (property field)
	WithBufferSize(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataBufferSizeBuilder
	// WithBufferSizeBuilder adds BufferSize (property field) which is build by the builder
	WithBufferSizeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataBufferSizeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBufferSize or returns an error if something is wrong
	Build() (BACnetConstructedDataBufferSize, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBufferSize
}

// NewBACnetConstructedDataBufferSizeBuilder() creates a BACnetConstructedDataBufferSizeBuilder
func NewBACnetConstructedDataBufferSizeBuilder() BACnetConstructedDataBufferSizeBuilder {
	return &_BACnetConstructedDataBufferSizeBuilder{_BACnetConstructedDataBufferSize: new(_BACnetConstructedDataBufferSize)}
}

type _BACnetConstructedDataBufferSizeBuilder struct {
	*_BACnetConstructedDataBufferSize

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataBufferSizeBuilder) = (*_BACnetConstructedDataBufferSizeBuilder)(nil)

func (b *_BACnetConstructedDataBufferSizeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBufferSize
}

func (b *_BACnetConstructedDataBufferSizeBuilder) WithMandatoryFields(bufferSize BACnetApplicationTagUnsignedInteger) BACnetConstructedDataBufferSizeBuilder {
	return b.WithBufferSize(bufferSize)
}

func (b *_BACnetConstructedDataBufferSizeBuilder) WithBufferSize(bufferSize BACnetApplicationTagUnsignedInteger) BACnetConstructedDataBufferSizeBuilder {
	b.BufferSize = bufferSize
	return b
}

func (b *_BACnetConstructedDataBufferSizeBuilder) WithBufferSizeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataBufferSizeBuilder {
	builder := builderSupplier(b.BufferSize.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.BufferSize, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBufferSizeBuilder) Build() (BACnetConstructedDataBufferSize, error) {
	if b.BufferSize == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'bufferSize' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataBufferSize.deepCopy(), nil
}

func (b *_BACnetConstructedDataBufferSizeBuilder) MustBuild() BACnetConstructedDataBufferSize {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBufferSizeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBufferSizeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBufferSizeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBufferSizeBuilder().(*_BACnetConstructedDataBufferSizeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataBufferSizeBuilder creates a BACnetConstructedDataBufferSizeBuilder
func (b *_BACnetConstructedDataBufferSize) CreateBACnetConstructedDataBufferSizeBuilder() BACnetConstructedDataBufferSizeBuilder {
	if b == nil {
		return NewBACnetConstructedDataBufferSizeBuilder()
	}
	return &_BACnetConstructedDataBufferSizeBuilder{_BACnetConstructedDataBufferSize: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBufferSize) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataBufferSize) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_BUFFER_SIZE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBufferSize) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataBufferSize) GetBufferSize() BACnetApplicationTagUnsignedInteger {
	return m.BufferSize
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataBufferSize) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetBufferSize())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBufferSize(structType any) BACnetConstructedDataBufferSize {
	if casted, ok := structType.(BACnetConstructedDataBufferSize); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBufferSize); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBufferSize) GetTypeName() string {
	return "BACnetConstructedDataBufferSize"
}

func (m *_BACnetConstructedDataBufferSize) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (bufferSize)
	lengthInBits += m.BufferSize.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataBufferSize) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBufferSize) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBufferSize BACnetConstructedDataBufferSize, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBufferSize"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBufferSize")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	bufferSize, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "bufferSize", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bufferSize' field"))
	}
	m.BufferSize = bufferSize

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), bufferSize)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBufferSize"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBufferSize")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBufferSize) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBufferSize) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBufferSize"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBufferSize")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "bufferSize", m.GetBufferSize(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'bufferSize' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBufferSize"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBufferSize")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBufferSize) IsBACnetConstructedDataBufferSize() {}

func (m *_BACnetConstructedDataBufferSize) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBufferSize) deepCopy() *_BACnetConstructedDataBufferSize {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBufferSizeCopy := &_BACnetConstructedDataBufferSize{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.BufferSize),
	}
	_BACnetConstructedDataBufferSizeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBufferSizeCopy
}

func (m *_BACnetConstructedDataBufferSize) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
