/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataClientCOVIncrement is the corresponding interface of BACnetConstructedDataClientCOVIncrement
type BACnetConstructedDataClientCOVIncrement interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetCovIncrement returns CovIncrement (property field)
	GetCovIncrement() BACnetClientCOV
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetClientCOV
	// IsBACnetConstructedDataClientCOVIncrement is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataClientCOVIncrement()
	// CreateBuilder creates a BACnetConstructedDataClientCOVIncrementBuilder
	CreateBACnetConstructedDataClientCOVIncrementBuilder() BACnetConstructedDataClientCOVIncrementBuilder
}

// _BACnetConstructedDataClientCOVIncrement is the data-structure of this message
type _BACnetConstructedDataClientCOVIncrement struct {
	BACnetConstructedDataContract
	CovIncrement BACnetClientCOV
}

var _ BACnetConstructedDataClientCOVIncrement = (*_BACnetConstructedDataClientCOVIncrement)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataClientCOVIncrement)(nil)

// NewBACnetConstructedDataClientCOVIncrement factory function for _BACnetConstructedDataClientCOVIncrement
func NewBACnetConstructedDataClientCOVIncrement(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, covIncrement BACnetClientCOV, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataClientCOVIncrement {
	if covIncrement == nil {
		panic("covIncrement of type BACnetClientCOV for BACnetConstructedDataClientCOVIncrement must not be nil")
	}
	_result := &_BACnetConstructedDataClientCOVIncrement{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		CovIncrement:                  covIncrement,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataClientCOVIncrementBuilder is a builder for BACnetConstructedDataClientCOVIncrement
type BACnetConstructedDataClientCOVIncrementBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(covIncrement BACnetClientCOV) BACnetConstructedDataClientCOVIncrementBuilder
	// WithCovIncrement adds CovIncrement (property field)
	WithCovIncrement(BACnetClientCOV) BACnetConstructedDataClientCOVIncrementBuilder
	// WithCovIncrementBuilder adds CovIncrement (property field) which is build by the builder
	WithCovIncrementBuilder(func(BACnetClientCOVBuilder) BACnetClientCOVBuilder) BACnetConstructedDataClientCOVIncrementBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataClientCOVIncrement or returns an error if something is wrong
	Build() (BACnetConstructedDataClientCOVIncrement, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataClientCOVIncrement
}

// NewBACnetConstructedDataClientCOVIncrementBuilder() creates a BACnetConstructedDataClientCOVIncrementBuilder
func NewBACnetConstructedDataClientCOVIncrementBuilder() BACnetConstructedDataClientCOVIncrementBuilder {
	return &_BACnetConstructedDataClientCOVIncrementBuilder{_BACnetConstructedDataClientCOVIncrement: new(_BACnetConstructedDataClientCOVIncrement)}
}

type _BACnetConstructedDataClientCOVIncrementBuilder struct {
	*_BACnetConstructedDataClientCOVIncrement

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataClientCOVIncrementBuilder) = (*_BACnetConstructedDataClientCOVIncrementBuilder)(nil)

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataClientCOVIncrement
}

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) WithMandatoryFields(covIncrement BACnetClientCOV) BACnetConstructedDataClientCOVIncrementBuilder {
	return b.WithCovIncrement(covIncrement)
}

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) WithCovIncrement(covIncrement BACnetClientCOV) BACnetConstructedDataClientCOVIncrementBuilder {
	b.CovIncrement = covIncrement
	return b
}

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) WithCovIncrementBuilder(builderSupplier func(BACnetClientCOVBuilder) BACnetClientCOVBuilder) BACnetConstructedDataClientCOVIncrementBuilder {
	builder := builderSupplier(b.CovIncrement.CreateBACnetClientCOVBuilder())
	var err error
	b.CovIncrement, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClientCOVBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) Build() (BACnetConstructedDataClientCOVIncrement, error) {
	if b.CovIncrement == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'covIncrement' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataClientCOVIncrement.deepCopy(), nil
}

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) MustBuild() BACnetConstructedDataClientCOVIncrement {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataClientCOVIncrementBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataClientCOVIncrementBuilder().(*_BACnetConstructedDataClientCOVIncrementBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataClientCOVIncrementBuilder creates a BACnetConstructedDataClientCOVIncrementBuilder
func (b *_BACnetConstructedDataClientCOVIncrement) CreateBACnetConstructedDataClientCOVIncrementBuilder() BACnetConstructedDataClientCOVIncrementBuilder {
	if b == nil {
		return NewBACnetConstructedDataClientCOVIncrementBuilder()
	}
	return &_BACnetConstructedDataClientCOVIncrementBuilder{_BACnetConstructedDataClientCOVIncrement: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataClientCOVIncrement) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataClientCOVIncrement) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_CLIENT_COV_INCREMENT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataClientCOVIncrement) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataClientCOVIncrement) GetCovIncrement() BACnetClientCOV {
	return m.CovIncrement
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataClientCOVIncrement) GetActualValue() BACnetClientCOV {
	ctx := context.Background()
	_ = ctx
	return CastBACnetClientCOV(m.GetCovIncrement())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataClientCOVIncrement(structType any) BACnetConstructedDataClientCOVIncrement {
	if casted, ok := structType.(BACnetConstructedDataClientCOVIncrement); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataClientCOVIncrement); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataClientCOVIncrement) GetTypeName() string {
	return "BACnetConstructedDataClientCOVIncrement"
}

func (m *_BACnetConstructedDataClientCOVIncrement) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (covIncrement)
	lengthInBits += m.CovIncrement.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataClientCOVIncrement) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataClientCOVIncrement) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataClientCOVIncrement BACnetConstructedDataClientCOVIncrement, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataClientCOVIncrement"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataClientCOVIncrement")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	covIncrement, err := ReadSimpleField[BACnetClientCOV](ctx, "covIncrement", ReadComplex[BACnetClientCOV](BACnetClientCOVParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'covIncrement' field"))
	}
	m.CovIncrement = covIncrement

	actualValue, err := ReadVirtualField[BACnetClientCOV](ctx, "actualValue", (*BACnetClientCOV)(nil), covIncrement)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataClientCOVIncrement"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataClientCOVIncrement")
	}

	return m, nil
}

func (m *_BACnetConstructedDataClientCOVIncrement) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataClientCOVIncrement) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataClientCOVIncrement"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataClientCOVIncrement")
		}

		if err := WriteSimpleField[BACnetClientCOV](ctx, "covIncrement", m.GetCovIncrement(), WriteComplex[BACnetClientCOV](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'covIncrement' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataClientCOVIncrement"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataClientCOVIncrement")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataClientCOVIncrement) IsBACnetConstructedDataClientCOVIncrement() {}

func (m *_BACnetConstructedDataClientCOVIncrement) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataClientCOVIncrement) deepCopy() *_BACnetConstructedDataClientCOVIncrement {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataClientCOVIncrementCopy := &_BACnetConstructedDataClientCOVIncrement{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetClientCOV](m.CovIncrement),
	}
	_BACnetConstructedDataClientCOVIncrementCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataClientCOVIncrementCopy
}

func (m *_BACnetConstructedDataClientCOVIncrement) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
