/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventTransitionBits is an enum
type BACnetEventTransitionBits uint8

type IBACnetEventTransitionBits interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	BACnetEventTransitionBits_TO_OFFNORMAL BACnetEventTransitionBits = 0
	BACnetEventTransitionBits_TO_FAULT     BACnetEventTransitionBits = 1
	BACnetEventTransitionBits_TO_NORMAL    BACnetEventTransitionBits = 2
)

var BACnetEventTransitionBitsValues []BACnetEventTransitionBits

func init() {
	_ = errors.New
	BACnetEventTransitionBitsValues = []BACnetEventTransitionBits{
		BACnetEventTransitionBits_TO_OFFNORMAL,
		BACnetEventTransitionBits_TO_FAULT,
		BACnetEventTransitionBits_TO_NORMAL,
	}
}

func BACnetEventTransitionBitsByValue(value uint8) (enum BACnetEventTransitionBits, ok bool) {
	switch value {
	case 0:
		return BACnetEventTransitionBits_TO_OFFNORMAL, true
	case 1:
		return BACnetEventTransitionBits_TO_FAULT, true
	case 2:
		return BACnetEventTransitionBits_TO_NORMAL, true
	}
	return 0, false
}

func BACnetEventTransitionBitsByName(value string) (enum BACnetEventTransitionBits, ok bool) {
	switch value {
	case "TO_OFFNORMAL":
		return BACnetEventTransitionBits_TO_OFFNORMAL, true
	case "TO_FAULT":
		return BACnetEventTransitionBits_TO_FAULT, true
	case "TO_NORMAL":
		return BACnetEventTransitionBits_TO_NORMAL, true
	}
	return 0, false
}

func BACnetEventTransitionBitsKnows(value uint8) bool {
	for _, typeValue := range BACnetEventTransitionBitsValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastBACnetEventTransitionBits(structType any) BACnetEventTransitionBits {
	castFunc := func(typ any) BACnetEventTransitionBits {
		if sBACnetEventTransitionBits, ok := typ.(BACnetEventTransitionBits); ok {
			return sBACnetEventTransitionBits
		}
		return 0
	}
	return castFunc(structType)
}

func (m BACnetEventTransitionBits) GetLengthInBits(ctx context.Context) uint16 {
	return 8
}

func (m BACnetEventTransitionBits) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEventTransitionBitsParse(ctx context.Context, theBytes []byte) (BACnetEventTransitionBits, error) {
	return BACnetEventTransitionBitsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetEventTransitionBitsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventTransitionBits, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("BACnetEventTransitionBits", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading BACnetEventTransitionBits")
	}
	if enum, ok := BACnetEventTransitionBitsByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for BACnetEventTransitionBits")
		return BACnetEventTransitionBits(val), nil
	} else {
		return enum, nil
	}
}

func (e BACnetEventTransitionBits) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e BACnetEventTransitionBits) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint8("BACnetEventTransitionBits", 8, uint8(uint8(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e BACnetEventTransitionBits) GetValue() uint8 {
	return uint8(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e BACnetEventTransitionBits) PLC4XEnumName() string {
	switch e {
	case BACnetEventTransitionBits_TO_OFFNORMAL:
		return "TO_OFFNORMAL"
	case BACnetEventTransitionBits_TO_FAULT:
		return "TO_FAULT"
	case BACnetEventTransitionBits_TO_NORMAL:
		return "TO_NORMAL"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e BACnetEventTransitionBits) String() string {
	return e.PLC4XEnumName()
}
