/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLifeSafetyModeTagged is the corresponding interface of BACnetLifeSafetyModeTagged
type BACnetLifeSafetyModeTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetLifeSafetyMode
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetLifeSafetyModeTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLifeSafetyModeTagged()
	// CreateBuilder creates a BACnetLifeSafetyModeTaggedBuilder
	CreateBACnetLifeSafetyModeTaggedBuilder() BACnetLifeSafetyModeTaggedBuilder
}

// _BACnetLifeSafetyModeTagged is the data-structure of this message
type _BACnetLifeSafetyModeTagged struct {
	Header           BACnetTagHeader
	Value            BACnetLifeSafetyMode
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetLifeSafetyModeTagged = (*_BACnetLifeSafetyModeTagged)(nil)

// NewBACnetLifeSafetyModeTagged factory function for _BACnetLifeSafetyModeTagged
func NewBACnetLifeSafetyModeTagged(header BACnetTagHeader, value BACnetLifeSafetyMode, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetLifeSafetyModeTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetLifeSafetyModeTagged must not be nil")
	}
	return &_BACnetLifeSafetyModeTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLifeSafetyModeTaggedBuilder is a builder for BACnetLifeSafetyModeTagged
type BACnetLifeSafetyModeTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetLifeSafetyMode, proprietaryValue uint32) BACnetLifeSafetyModeTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetLifeSafetyModeTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLifeSafetyModeTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetLifeSafetyMode) BACnetLifeSafetyModeTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetLifeSafetyModeTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetLifeSafetyModeTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetLifeSafetyModeTaggedBuilder
	// Build builds the BACnetLifeSafetyModeTagged or returns an error if something is wrong
	Build() (BACnetLifeSafetyModeTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLifeSafetyModeTagged
}

// NewBACnetLifeSafetyModeTaggedBuilder() creates a BACnetLifeSafetyModeTaggedBuilder
func NewBACnetLifeSafetyModeTaggedBuilder() BACnetLifeSafetyModeTaggedBuilder {
	return &_BACnetLifeSafetyModeTaggedBuilder{_BACnetLifeSafetyModeTagged: new(_BACnetLifeSafetyModeTagged)}
}

type _BACnetLifeSafetyModeTaggedBuilder struct {
	*_BACnetLifeSafetyModeTagged

	collectedErr []error
}

var _ (BACnetLifeSafetyModeTaggedBuilder) = (*_BACnetLifeSafetyModeTaggedBuilder)(nil)

func (b *_BACnetLifeSafetyModeTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetLifeSafetyMode, proprietaryValue uint32) BACnetLifeSafetyModeTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetLifeSafetyModeTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetLifeSafetyModeTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetLifeSafetyModeTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLifeSafetyModeTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLifeSafetyModeTaggedBuilder) WithValue(value BACnetLifeSafetyMode) BACnetLifeSafetyModeTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetLifeSafetyModeTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetLifeSafetyModeTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetLifeSafetyModeTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetLifeSafetyModeTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetLifeSafetyModeTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetLifeSafetyModeTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetLifeSafetyModeTaggedBuilder) Build() (BACnetLifeSafetyModeTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetLifeSafetyModeTagged.deepCopy(), nil
}

func (b *_BACnetLifeSafetyModeTaggedBuilder) MustBuild() BACnetLifeSafetyModeTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLifeSafetyModeTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLifeSafetyModeTaggedBuilder().(*_BACnetLifeSafetyModeTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetLifeSafetyModeTaggedBuilder creates a BACnetLifeSafetyModeTaggedBuilder
func (b *_BACnetLifeSafetyModeTagged) CreateBACnetLifeSafetyModeTaggedBuilder() BACnetLifeSafetyModeTaggedBuilder {
	if b == nil {
		return NewBACnetLifeSafetyModeTaggedBuilder()
	}
	return &_BACnetLifeSafetyModeTaggedBuilder{_BACnetLifeSafetyModeTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLifeSafetyModeTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetLifeSafetyModeTagged) GetValue() BACnetLifeSafetyMode {
	return m.Value
}

func (m *_BACnetLifeSafetyModeTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetLifeSafetyModeTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetLifeSafetyMode_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLifeSafetyModeTagged(structType any) BACnetLifeSafetyModeTagged {
	if casted, ok := structType.(BACnetLifeSafetyModeTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLifeSafetyModeTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLifeSafetyModeTagged) GetTypeName() string {
	return "BACnetLifeSafetyModeTagged"
}

func (m *_BACnetLifeSafetyModeTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetLifeSafetyModeTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLifeSafetyModeTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetLifeSafetyModeTagged, error) {
	return BACnetLifeSafetyModeTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetLifeSafetyModeTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLifeSafetyModeTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLifeSafetyModeTagged, error) {
		return BACnetLifeSafetyModeTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetLifeSafetyModeTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetLifeSafetyModeTagged, error) {
	v, err := (&_BACnetLifeSafetyModeTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLifeSafetyModeTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetLifeSafetyModeTagged BACnetLifeSafetyModeTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLifeSafetyModeTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLifeSafetyModeTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetLifeSafetyMode](ctx, "value", readBuffer, EnsureType[BACnetLifeSafetyMode](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetLifeSafetyMode_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetLifeSafetyMode_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetLifeSafetyModeTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLifeSafetyModeTagged")
	}

	return m, nil
}

func (m *_BACnetLifeSafetyModeTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLifeSafetyModeTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLifeSafetyModeTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLifeSafetyModeTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetLifeSafetyMode](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLifeSafetyModeTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLifeSafetyModeTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetLifeSafetyModeTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetLifeSafetyModeTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetLifeSafetyModeTagged) IsBACnetLifeSafetyModeTagged() {}

func (m *_BACnetLifeSafetyModeTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLifeSafetyModeTagged) deepCopy() *_BACnetLifeSafetyModeTagged {
	if m == nil {
		return nil
	}
	_BACnetLifeSafetyModeTaggedCopy := &_BACnetLifeSafetyModeTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetLifeSafetyModeTaggedCopy
}

func (m *_BACnetLifeSafetyModeTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
