/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPriorityValueReal is the corresponding interface of BACnetPriorityValueReal
type BACnetPriorityValueReal interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPriorityValue
	// GetRealValue returns RealValue (property field)
	GetRealValue() BACnetApplicationTagReal
	// IsBACnetPriorityValueReal is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPriorityValueReal()
	// CreateBuilder creates a BACnetPriorityValueRealBuilder
	CreateBACnetPriorityValueRealBuilder() BACnetPriorityValueRealBuilder
}

// _BACnetPriorityValueReal is the data-structure of this message
type _BACnetPriorityValueReal struct {
	BACnetPriorityValueContract
	RealValue BACnetApplicationTagReal
}

var _ BACnetPriorityValueReal = (*_BACnetPriorityValueReal)(nil)
var _ BACnetPriorityValueRequirements = (*_BACnetPriorityValueReal)(nil)

// NewBACnetPriorityValueReal factory function for _BACnetPriorityValueReal
func NewBACnetPriorityValueReal(peekedTagHeader BACnetTagHeader, realValue BACnetApplicationTagReal, objectTypeArgument BACnetObjectType) *_BACnetPriorityValueReal {
	if realValue == nil {
		panic("realValue of type BACnetApplicationTagReal for BACnetPriorityValueReal must not be nil")
	}
	_result := &_BACnetPriorityValueReal{
		BACnetPriorityValueContract: NewBACnetPriorityValue(peekedTagHeader, objectTypeArgument),
		RealValue:                   realValue,
	}
	_result.BACnetPriorityValueContract.(*_BACnetPriorityValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPriorityValueRealBuilder is a builder for BACnetPriorityValueReal
type BACnetPriorityValueRealBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(realValue BACnetApplicationTagReal) BACnetPriorityValueRealBuilder
	// WithRealValue adds RealValue (property field)
	WithRealValue(BACnetApplicationTagReal) BACnetPriorityValueRealBuilder
	// WithRealValueBuilder adds RealValue (property field) which is build by the builder
	WithRealValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetPriorityValueRealBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPriorityValueBuilder
	// Build builds the BACnetPriorityValueReal or returns an error if something is wrong
	Build() (BACnetPriorityValueReal, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPriorityValueReal
}

// NewBACnetPriorityValueRealBuilder() creates a BACnetPriorityValueRealBuilder
func NewBACnetPriorityValueRealBuilder() BACnetPriorityValueRealBuilder {
	return &_BACnetPriorityValueRealBuilder{_BACnetPriorityValueReal: new(_BACnetPriorityValueReal)}
}

type _BACnetPriorityValueRealBuilder struct {
	*_BACnetPriorityValueReal

	parentBuilder *_BACnetPriorityValueBuilder

	collectedErr []error
}

var _ (BACnetPriorityValueRealBuilder) = (*_BACnetPriorityValueRealBuilder)(nil)

func (b *_BACnetPriorityValueRealBuilder) setParent(contract BACnetPriorityValueContract) {
	b.BACnetPriorityValueContract = contract
	contract.(*_BACnetPriorityValue)._SubType = b._BACnetPriorityValueReal
}

func (b *_BACnetPriorityValueRealBuilder) WithMandatoryFields(realValue BACnetApplicationTagReal) BACnetPriorityValueRealBuilder {
	return b.WithRealValue(realValue)
}

func (b *_BACnetPriorityValueRealBuilder) WithRealValue(realValue BACnetApplicationTagReal) BACnetPriorityValueRealBuilder {
	b.RealValue = realValue
	return b
}

func (b *_BACnetPriorityValueRealBuilder) WithRealValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetPriorityValueRealBuilder {
	builder := builderSupplier(b.RealValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.RealValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetPriorityValueRealBuilder) Build() (BACnetPriorityValueReal, error) {
	if b.RealValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'realValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPriorityValueReal.deepCopy(), nil
}

func (b *_BACnetPriorityValueRealBuilder) MustBuild() BACnetPriorityValueReal {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPriorityValueRealBuilder) Done() BACnetPriorityValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPriorityValueBuilder().(*_BACnetPriorityValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPriorityValueRealBuilder) buildForBACnetPriorityValue() (BACnetPriorityValue, error) {
	return b.Build()
}

func (b *_BACnetPriorityValueRealBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPriorityValueRealBuilder().(*_BACnetPriorityValueRealBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPriorityValueRealBuilder creates a BACnetPriorityValueRealBuilder
func (b *_BACnetPriorityValueReal) CreateBACnetPriorityValueRealBuilder() BACnetPriorityValueRealBuilder {
	if b == nil {
		return NewBACnetPriorityValueRealBuilder()
	}
	return &_BACnetPriorityValueRealBuilder{_BACnetPriorityValueReal: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPriorityValueReal) GetParent() BACnetPriorityValueContract {
	return m.BACnetPriorityValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPriorityValueReal) GetRealValue() BACnetApplicationTagReal {
	return m.RealValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPriorityValueReal(structType any) BACnetPriorityValueReal {
	if casted, ok := structType.(BACnetPriorityValueReal); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPriorityValueReal); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPriorityValueReal) GetTypeName() string {
	return "BACnetPriorityValueReal"
}

func (m *_BACnetPriorityValueReal) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPriorityValueContract.(*_BACnetPriorityValue).getLengthInBits(ctx))

	// Simple field (realValue)
	lengthInBits += m.RealValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPriorityValueReal) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPriorityValueReal) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPriorityValue, objectTypeArgument BACnetObjectType) (__bACnetPriorityValueReal BACnetPriorityValueReal, err error) {
	m.BACnetPriorityValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPriorityValueReal"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPriorityValueReal")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	realValue, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "realValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'realValue' field"))
	}
	m.RealValue = realValue

	if closeErr := readBuffer.CloseContext("BACnetPriorityValueReal"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPriorityValueReal")
	}

	return m, nil
}

func (m *_BACnetPriorityValueReal) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPriorityValueReal) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPriorityValueReal"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPriorityValueReal")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "realValue", m.GetRealValue(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'realValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPriorityValueReal"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPriorityValueReal")
		}
		return nil
	}
	return m.BACnetPriorityValueContract.(*_BACnetPriorityValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPriorityValueReal) IsBACnetPriorityValueReal() {}

func (m *_BACnetPriorityValueReal) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPriorityValueReal) deepCopy() *_BACnetPriorityValueReal {
	if m == nil {
		return nil
	}
	_BACnetPriorityValueRealCopy := &_BACnetPriorityValueReal{
		m.BACnetPriorityValueContract.(*_BACnetPriorityValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.RealValue),
	}
	_BACnetPriorityValueRealCopy.BACnetPriorityValueContract.(*_BACnetPriorityValue)._SubType = m
	return _BACnetPriorityValueRealCopy
}

func (m *_BACnetPriorityValueReal) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
