/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesProtocolLevel is the corresponding interface of BACnetPropertyStatesProtocolLevel
type BACnetPropertyStatesProtocolLevel interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetProtocolLevel returns ProtocolLevel (property field)
	GetProtocolLevel() BACnetProtocolLevelTagged
	// IsBACnetPropertyStatesProtocolLevel is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesProtocolLevel()
	// CreateBuilder creates a BACnetPropertyStatesProtocolLevelBuilder
	CreateBACnetPropertyStatesProtocolLevelBuilder() BACnetPropertyStatesProtocolLevelBuilder
}

// _BACnetPropertyStatesProtocolLevel is the data-structure of this message
type _BACnetPropertyStatesProtocolLevel struct {
	BACnetPropertyStatesContract
	ProtocolLevel BACnetProtocolLevelTagged
}

var _ BACnetPropertyStatesProtocolLevel = (*_BACnetPropertyStatesProtocolLevel)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesProtocolLevel)(nil)

// NewBACnetPropertyStatesProtocolLevel factory function for _BACnetPropertyStatesProtocolLevel
func NewBACnetPropertyStatesProtocolLevel(peekedTagHeader BACnetTagHeader, protocolLevel BACnetProtocolLevelTagged) *_BACnetPropertyStatesProtocolLevel {
	if protocolLevel == nil {
		panic("protocolLevel of type BACnetProtocolLevelTagged for BACnetPropertyStatesProtocolLevel must not be nil")
	}
	_result := &_BACnetPropertyStatesProtocolLevel{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		ProtocolLevel:                protocolLevel,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesProtocolLevelBuilder is a builder for BACnetPropertyStatesProtocolLevel
type BACnetPropertyStatesProtocolLevelBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(protocolLevel BACnetProtocolLevelTagged) BACnetPropertyStatesProtocolLevelBuilder
	// WithProtocolLevel adds ProtocolLevel (property field)
	WithProtocolLevel(BACnetProtocolLevelTagged) BACnetPropertyStatesProtocolLevelBuilder
	// WithProtocolLevelBuilder adds ProtocolLevel (property field) which is build by the builder
	WithProtocolLevelBuilder(func(BACnetProtocolLevelTaggedBuilder) BACnetProtocolLevelTaggedBuilder) BACnetPropertyStatesProtocolLevelBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesProtocolLevel or returns an error if something is wrong
	Build() (BACnetPropertyStatesProtocolLevel, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesProtocolLevel
}

// NewBACnetPropertyStatesProtocolLevelBuilder() creates a BACnetPropertyStatesProtocolLevelBuilder
func NewBACnetPropertyStatesProtocolLevelBuilder() BACnetPropertyStatesProtocolLevelBuilder {
	return &_BACnetPropertyStatesProtocolLevelBuilder{_BACnetPropertyStatesProtocolLevel: new(_BACnetPropertyStatesProtocolLevel)}
}

type _BACnetPropertyStatesProtocolLevelBuilder struct {
	*_BACnetPropertyStatesProtocolLevel

	parentBuilder *_BACnetPropertyStatesBuilder

	collectedErr []error
}

var _ (BACnetPropertyStatesProtocolLevelBuilder) = (*_BACnetPropertyStatesProtocolLevelBuilder)(nil)

func (b *_BACnetPropertyStatesProtocolLevelBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesProtocolLevel
}

func (b *_BACnetPropertyStatesProtocolLevelBuilder) WithMandatoryFields(protocolLevel BACnetProtocolLevelTagged) BACnetPropertyStatesProtocolLevelBuilder {
	return b.WithProtocolLevel(protocolLevel)
}

func (b *_BACnetPropertyStatesProtocolLevelBuilder) WithProtocolLevel(protocolLevel BACnetProtocolLevelTagged) BACnetPropertyStatesProtocolLevelBuilder {
	b.ProtocolLevel = protocolLevel
	return b
}

func (b *_BACnetPropertyStatesProtocolLevelBuilder) WithProtocolLevelBuilder(builderSupplier func(BACnetProtocolLevelTaggedBuilder) BACnetProtocolLevelTaggedBuilder) BACnetPropertyStatesProtocolLevelBuilder {
	builder := builderSupplier(b.ProtocolLevel.CreateBACnetProtocolLevelTaggedBuilder())
	var err error
	b.ProtocolLevel, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetProtocolLevelTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesProtocolLevelBuilder) Build() (BACnetPropertyStatesProtocolLevel, error) {
	if b.ProtocolLevel == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'protocolLevel' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyStatesProtocolLevel.deepCopy(), nil
}

func (b *_BACnetPropertyStatesProtocolLevelBuilder) MustBuild() BACnetPropertyStatesProtocolLevel {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesProtocolLevelBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesProtocolLevelBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesProtocolLevelBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesProtocolLevelBuilder().(*_BACnetPropertyStatesProtocolLevelBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyStatesProtocolLevelBuilder creates a BACnetPropertyStatesProtocolLevelBuilder
func (b *_BACnetPropertyStatesProtocolLevel) CreateBACnetPropertyStatesProtocolLevelBuilder() BACnetPropertyStatesProtocolLevelBuilder {
	if b == nil {
		return NewBACnetPropertyStatesProtocolLevelBuilder()
	}
	return &_BACnetPropertyStatesProtocolLevelBuilder{_BACnetPropertyStatesProtocolLevel: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesProtocolLevel) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesProtocolLevel) GetProtocolLevel() BACnetProtocolLevelTagged {
	return m.ProtocolLevel
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesProtocolLevel(structType any) BACnetPropertyStatesProtocolLevel {
	if casted, ok := structType.(BACnetPropertyStatesProtocolLevel); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesProtocolLevel); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesProtocolLevel) GetTypeName() string {
	return "BACnetPropertyStatesProtocolLevel"
}

func (m *_BACnetPropertyStatesProtocolLevel) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (protocolLevel)
	lengthInBits += m.ProtocolLevel.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesProtocolLevel) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesProtocolLevel) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesProtocolLevel BACnetPropertyStatesProtocolLevel, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesProtocolLevel"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesProtocolLevel")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	protocolLevel, err := ReadSimpleField[BACnetProtocolLevelTagged](ctx, "protocolLevel", ReadComplex[BACnetProtocolLevelTagged](BACnetProtocolLevelTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'protocolLevel' field"))
	}
	m.ProtocolLevel = protocolLevel

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesProtocolLevel"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesProtocolLevel")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesProtocolLevel) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesProtocolLevel) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesProtocolLevel"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesProtocolLevel")
		}

		if err := WriteSimpleField[BACnetProtocolLevelTagged](ctx, "protocolLevel", m.GetProtocolLevel(), WriteComplex[BACnetProtocolLevelTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'protocolLevel' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesProtocolLevel"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesProtocolLevel")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesProtocolLevel) IsBACnetPropertyStatesProtocolLevel() {}

func (m *_BACnetPropertyStatesProtocolLevel) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesProtocolLevel) deepCopy() *_BACnetPropertyStatesProtocolLevel {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesProtocolLevelCopy := &_BACnetPropertyStatesProtocolLevel{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetProtocolLevelTagged](m.ProtocolLevel),
	}
	_BACnetPropertyStatesProtocolLevelCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesProtocolLevelCopy
}

func (m *_BACnetPropertyStatesProtocolLevel) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
