/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// GroupObjectDescriptorRealisationType7 is the corresponding interface of GroupObjectDescriptorRealisationType7
type GroupObjectDescriptorRealisationType7 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetDataAddress returns DataAddress (property field)
	GetDataAddress() uint16
	// GetUpdateEnable returns UpdateEnable (property field)
	GetUpdateEnable() bool
	// GetTransmitEnable returns TransmitEnable (property field)
	GetTransmitEnable() bool
	// GetSegmentSelectorEnable returns SegmentSelectorEnable (property field)
	GetSegmentSelectorEnable() bool
	// GetWriteEnable returns WriteEnable (property field)
	GetWriteEnable() bool
	// GetReadEnable returns ReadEnable (property field)
	GetReadEnable() bool
	// GetCommunicationEnable returns CommunicationEnable (property field)
	GetCommunicationEnable() bool
	// GetPriority returns Priority (property field)
	GetPriority() CEMIPriority
	// GetValueType returns ValueType (property field)
	GetValueType() ComObjectValueType
	// IsGroupObjectDescriptorRealisationType7 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsGroupObjectDescriptorRealisationType7()
	// CreateBuilder creates a GroupObjectDescriptorRealisationType7Builder
	CreateGroupObjectDescriptorRealisationType7Builder() GroupObjectDescriptorRealisationType7Builder
}

// _GroupObjectDescriptorRealisationType7 is the data-structure of this message
type _GroupObjectDescriptorRealisationType7 struct {
	DataAddress           uint16
	UpdateEnable          bool
	TransmitEnable        bool
	SegmentSelectorEnable bool
	WriteEnable           bool
	ReadEnable            bool
	CommunicationEnable   bool
	Priority              CEMIPriority
	ValueType             ComObjectValueType
}

var _ GroupObjectDescriptorRealisationType7 = (*_GroupObjectDescriptorRealisationType7)(nil)

// NewGroupObjectDescriptorRealisationType7 factory function for _GroupObjectDescriptorRealisationType7
func NewGroupObjectDescriptorRealisationType7(dataAddress uint16, updateEnable bool, transmitEnable bool, segmentSelectorEnable bool, writeEnable bool, readEnable bool, communicationEnable bool, priority CEMIPriority, valueType ComObjectValueType) *_GroupObjectDescriptorRealisationType7 {
	return &_GroupObjectDescriptorRealisationType7{DataAddress: dataAddress, UpdateEnable: updateEnable, TransmitEnable: transmitEnable, SegmentSelectorEnable: segmentSelectorEnable, WriteEnable: writeEnable, ReadEnable: readEnable, CommunicationEnable: communicationEnable, Priority: priority, ValueType: valueType}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// GroupObjectDescriptorRealisationType7Builder is a builder for GroupObjectDescriptorRealisationType7
type GroupObjectDescriptorRealisationType7Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataAddress uint16, updateEnable bool, transmitEnable bool, segmentSelectorEnable bool, writeEnable bool, readEnable bool, communicationEnable bool, priority CEMIPriority, valueType ComObjectValueType) GroupObjectDescriptorRealisationType7Builder
	// WithDataAddress adds DataAddress (property field)
	WithDataAddress(uint16) GroupObjectDescriptorRealisationType7Builder
	// WithUpdateEnable adds UpdateEnable (property field)
	WithUpdateEnable(bool) GroupObjectDescriptorRealisationType7Builder
	// WithTransmitEnable adds TransmitEnable (property field)
	WithTransmitEnable(bool) GroupObjectDescriptorRealisationType7Builder
	// WithSegmentSelectorEnable adds SegmentSelectorEnable (property field)
	WithSegmentSelectorEnable(bool) GroupObjectDescriptorRealisationType7Builder
	// WithWriteEnable adds WriteEnable (property field)
	WithWriteEnable(bool) GroupObjectDescriptorRealisationType7Builder
	// WithReadEnable adds ReadEnable (property field)
	WithReadEnable(bool) GroupObjectDescriptorRealisationType7Builder
	// WithCommunicationEnable adds CommunicationEnable (property field)
	WithCommunicationEnable(bool) GroupObjectDescriptorRealisationType7Builder
	// WithPriority adds Priority (property field)
	WithPriority(CEMIPriority) GroupObjectDescriptorRealisationType7Builder
	// WithValueType adds ValueType (property field)
	WithValueType(ComObjectValueType) GroupObjectDescriptorRealisationType7Builder
	// Build builds the GroupObjectDescriptorRealisationType7 or returns an error if something is wrong
	Build() (GroupObjectDescriptorRealisationType7, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() GroupObjectDescriptorRealisationType7
}

// NewGroupObjectDescriptorRealisationType7Builder() creates a GroupObjectDescriptorRealisationType7Builder
func NewGroupObjectDescriptorRealisationType7Builder() GroupObjectDescriptorRealisationType7Builder {
	return &_GroupObjectDescriptorRealisationType7Builder{_GroupObjectDescriptorRealisationType7: new(_GroupObjectDescriptorRealisationType7)}
}

type _GroupObjectDescriptorRealisationType7Builder struct {
	*_GroupObjectDescriptorRealisationType7

	collectedErr []error
}

var _ (GroupObjectDescriptorRealisationType7Builder) = (*_GroupObjectDescriptorRealisationType7Builder)(nil)

func (b *_GroupObjectDescriptorRealisationType7Builder) WithMandatoryFields(dataAddress uint16, updateEnable bool, transmitEnable bool, segmentSelectorEnable bool, writeEnable bool, readEnable bool, communicationEnable bool, priority CEMIPriority, valueType ComObjectValueType) GroupObjectDescriptorRealisationType7Builder {
	return b.WithDataAddress(dataAddress).WithUpdateEnable(updateEnable).WithTransmitEnable(transmitEnable).WithSegmentSelectorEnable(segmentSelectorEnable).WithWriteEnable(writeEnable).WithReadEnable(readEnable).WithCommunicationEnable(communicationEnable).WithPriority(priority).WithValueType(valueType)
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithDataAddress(dataAddress uint16) GroupObjectDescriptorRealisationType7Builder {
	b.DataAddress = dataAddress
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithUpdateEnable(updateEnable bool) GroupObjectDescriptorRealisationType7Builder {
	b.UpdateEnable = updateEnable
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithTransmitEnable(transmitEnable bool) GroupObjectDescriptorRealisationType7Builder {
	b.TransmitEnable = transmitEnable
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithSegmentSelectorEnable(segmentSelectorEnable bool) GroupObjectDescriptorRealisationType7Builder {
	b.SegmentSelectorEnable = segmentSelectorEnable
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithWriteEnable(writeEnable bool) GroupObjectDescriptorRealisationType7Builder {
	b.WriteEnable = writeEnable
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithReadEnable(readEnable bool) GroupObjectDescriptorRealisationType7Builder {
	b.ReadEnable = readEnable
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithCommunicationEnable(communicationEnable bool) GroupObjectDescriptorRealisationType7Builder {
	b.CommunicationEnable = communicationEnable
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithPriority(priority CEMIPriority) GroupObjectDescriptorRealisationType7Builder {
	b.Priority = priority
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) WithValueType(valueType ComObjectValueType) GroupObjectDescriptorRealisationType7Builder {
	b.ValueType = valueType
	return b
}

func (b *_GroupObjectDescriptorRealisationType7Builder) Build() (GroupObjectDescriptorRealisationType7, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._GroupObjectDescriptorRealisationType7.deepCopy(), nil
}

func (b *_GroupObjectDescriptorRealisationType7Builder) MustBuild() GroupObjectDescriptorRealisationType7 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_GroupObjectDescriptorRealisationType7Builder) DeepCopy() any {
	_copy := b.CreateGroupObjectDescriptorRealisationType7Builder().(*_GroupObjectDescriptorRealisationType7Builder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateGroupObjectDescriptorRealisationType7Builder creates a GroupObjectDescriptorRealisationType7Builder
func (b *_GroupObjectDescriptorRealisationType7) CreateGroupObjectDescriptorRealisationType7Builder() GroupObjectDescriptorRealisationType7Builder {
	if b == nil {
		return NewGroupObjectDescriptorRealisationType7Builder()
	}
	return &_GroupObjectDescriptorRealisationType7Builder{_GroupObjectDescriptorRealisationType7: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_GroupObjectDescriptorRealisationType7) GetDataAddress() uint16 {
	return m.DataAddress
}

func (m *_GroupObjectDescriptorRealisationType7) GetUpdateEnable() bool {
	return m.UpdateEnable
}

func (m *_GroupObjectDescriptorRealisationType7) GetTransmitEnable() bool {
	return m.TransmitEnable
}

func (m *_GroupObjectDescriptorRealisationType7) GetSegmentSelectorEnable() bool {
	return m.SegmentSelectorEnable
}

func (m *_GroupObjectDescriptorRealisationType7) GetWriteEnable() bool {
	return m.WriteEnable
}

func (m *_GroupObjectDescriptorRealisationType7) GetReadEnable() bool {
	return m.ReadEnable
}

func (m *_GroupObjectDescriptorRealisationType7) GetCommunicationEnable() bool {
	return m.CommunicationEnable
}

func (m *_GroupObjectDescriptorRealisationType7) GetPriority() CEMIPriority {
	return m.Priority
}

func (m *_GroupObjectDescriptorRealisationType7) GetValueType() ComObjectValueType {
	return m.ValueType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastGroupObjectDescriptorRealisationType7(structType any) GroupObjectDescriptorRealisationType7 {
	if casted, ok := structType.(GroupObjectDescriptorRealisationType7); ok {
		return casted
	}
	if casted, ok := structType.(*GroupObjectDescriptorRealisationType7); ok {
		return *casted
	}
	return nil
}

func (m *_GroupObjectDescriptorRealisationType7) GetTypeName() string {
	return "GroupObjectDescriptorRealisationType7"
}

func (m *_GroupObjectDescriptorRealisationType7) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (dataAddress)
	lengthInBits += 16

	// Simple field (updateEnable)
	lengthInBits += 1

	// Simple field (transmitEnable)
	lengthInBits += 1

	// Simple field (segmentSelectorEnable)
	lengthInBits += 1

	// Simple field (writeEnable)
	lengthInBits += 1

	// Simple field (readEnable)
	lengthInBits += 1

	// Simple field (communicationEnable)
	lengthInBits += 1

	// Simple field (priority)
	lengthInBits += 2

	// Simple field (valueType)
	lengthInBits += 8

	return lengthInBits
}

func (m *_GroupObjectDescriptorRealisationType7) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func GroupObjectDescriptorRealisationType7Parse(ctx context.Context, theBytes []byte) (GroupObjectDescriptorRealisationType7, error) {
	return GroupObjectDescriptorRealisationType7ParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func GroupObjectDescriptorRealisationType7ParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (GroupObjectDescriptorRealisationType7, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (GroupObjectDescriptorRealisationType7, error) {
		return GroupObjectDescriptorRealisationType7ParseWithBuffer(ctx, readBuffer)
	}
}

func GroupObjectDescriptorRealisationType7ParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (GroupObjectDescriptorRealisationType7, error) {
	v, err := (&_GroupObjectDescriptorRealisationType7{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_GroupObjectDescriptorRealisationType7) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__groupObjectDescriptorRealisationType7 GroupObjectDescriptorRealisationType7, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("GroupObjectDescriptorRealisationType7"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for GroupObjectDescriptorRealisationType7")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataAddress, err := ReadSimpleField(ctx, "dataAddress", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataAddress' field"))
	}
	m.DataAddress = dataAddress

	updateEnable, err := ReadSimpleField(ctx, "updateEnable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'updateEnable' field"))
	}
	m.UpdateEnable = updateEnable

	transmitEnable, err := ReadSimpleField(ctx, "transmitEnable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transmitEnable' field"))
	}
	m.TransmitEnable = transmitEnable

	segmentSelectorEnable, err := ReadSimpleField(ctx, "segmentSelectorEnable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'segmentSelectorEnable' field"))
	}
	m.SegmentSelectorEnable = segmentSelectorEnable

	writeEnable, err := ReadSimpleField(ctx, "writeEnable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeEnable' field"))
	}
	m.WriteEnable = writeEnable

	readEnable, err := ReadSimpleField(ctx, "readEnable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'readEnable' field"))
	}
	m.ReadEnable = readEnable

	communicationEnable, err := ReadSimpleField(ctx, "communicationEnable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'communicationEnable' field"))
	}
	m.CommunicationEnable = communicationEnable

	priority, err := ReadEnumField[CEMIPriority](ctx, "priority", "CEMIPriority", ReadEnum(CEMIPriorityByValue, ReadUnsignedByte(readBuffer, uint8(2))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'priority' field"))
	}
	m.Priority = priority

	valueType, err := ReadEnumField[ComObjectValueType](ctx, "valueType", "ComObjectValueType", ReadEnum(ComObjectValueTypeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'valueType' field"))
	}
	m.ValueType = valueType

	if closeErr := readBuffer.CloseContext("GroupObjectDescriptorRealisationType7"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for GroupObjectDescriptorRealisationType7")
	}

	return m, nil
}

func (m *_GroupObjectDescriptorRealisationType7) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_GroupObjectDescriptorRealisationType7) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("GroupObjectDescriptorRealisationType7"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for GroupObjectDescriptorRealisationType7")
	}

	if err := WriteSimpleField[uint16](ctx, "dataAddress", m.GetDataAddress(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'dataAddress' field")
	}

	if err := WriteSimpleField[bool](ctx, "updateEnable", m.GetUpdateEnable(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'updateEnable' field")
	}

	if err := WriteSimpleField[bool](ctx, "transmitEnable", m.GetTransmitEnable(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'transmitEnable' field")
	}

	if err := WriteSimpleField[bool](ctx, "segmentSelectorEnable", m.GetSegmentSelectorEnable(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'segmentSelectorEnable' field")
	}

	if err := WriteSimpleField[bool](ctx, "writeEnable", m.GetWriteEnable(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'writeEnable' field")
	}

	if err := WriteSimpleField[bool](ctx, "readEnable", m.GetReadEnable(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'readEnable' field")
	}

	if err := WriteSimpleField[bool](ctx, "communicationEnable", m.GetCommunicationEnable(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'communicationEnable' field")
	}

	if err := WriteSimpleEnumField[CEMIPriority](ctx, "priority", "CEMIPriority", m.GetPriority(), WriteEnum[CEMIPriority, uint8](CEMIPriority.GetValue, CEMIPriority.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 2))); err != nil {
		return errors.Wrap(err, "Error serializing 'priority' field")
	}

	if err := WriteSimpleEnumField[ComObjectValueType](ctx, "valueType", "ComObjectValueType", m.GetValueType(), WriteEnum[ComObjectValueType, uint8](ComObjectValueType.GetValue, ComObjectValueType.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'valueType' field")
	}

	if popErr := writeBuffer.PopContext("GroupObjectDescriptorRealisationType7"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for GroupObjectDescriptorRealisationType7")
	}
	return nil
}

func (m *_GroupObjectDescriptorRealisationType7) IsGroupObjectDescriptorRealisationType7() {}

func (m *_GroupObjectDescriptorRealisationType7) DeepCopy() any {
	return m.deepCopy()
}

func (m *_GroupObjectDescriptorRealisationType7) deepCopy() *_GroupObjectDescriptorRealisationType7 {
	if m == nil {
		return nil
	}
	_GroupObjectDescriptorRealisationType7Copy := &_GroupObjectDescriptorRealisationType7{
		m.DataAddress,
		m.UpdateEnable,
		m.TransmitEnable,
		m.SegmentSelectorEnable,
		m.WriteEnable,
		m.ReadEnable,
		m.CommunicationEnable,
		m.Priority,
		m.ValueType,
	}
	return _GroupObjectDescriptorRealisationType7Copy
}

func (m *_GroupObjectDescriptorRealisationType7) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
