/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ChassisIdSubtype is an enum
type ChassisIdSubtype uint32

type IChassisIdSubtype interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	ChassisIdSubtype_chassisIdSubtypeChassisComponent ChassisIdSubtype = 1
	ChassisIdSubtype_chassisIdSubtypeInterfaceAlias   ChassisIdSubtype = 2
	ChassisIdSubtype_chassisIdSubtypePortComponent    ChassisIdSubtype = 3
	ChassisIdSubtype_chassisIdSubtypeMacAddress       ChassisIdSubtype = 4
	ChassisIdSubtype_chassisIdSubtypeNetworkAddress   ChassisIdSubtype = 5
	ChassisIdSubtype_chassisIdSubtypeInterfaceName    ChassisIdSubtype = 6
	ChassisIdSubtype_chassisIdSubtypeLocal            ChassisIdSubtype = 7
)

var ChassisIdSubtypeValues []ChassisIdSubtype

func init() {
	_ = errors.New
	ChassisIdSubtypeValues = []ChassisIdSubtype{
		ChassisIdSubtype_chassisIdSubtypeChassisComponent,
		ChassisIdSubtype_chassisIdSubtypeInterfaceAlias,
		ChassisIdSubtype_chassisIdSubtypePortComponent,
		ChassisIdSubtype_chassisIdSubtypeMacAddress,
		ChassisIdSubtype_chassisIdSubtypeNetworkAddress,
		ChassisIdSubtype_chassisIdSubtypeInterfaceName,
		ChassisIdSubtype_chassisIdSubtypeLocal,
	}
}

func ChassisIdSubtypeByValue(value uint32) (enum ChassisIdSubtype, ok bool) {
	switch value {
	case 1:
		return ChassisIdSubtype_chassisIdSubtypeChassisComponent, true
	case 2:
		return ChassisIdSubtype_chassisIdSubtypeInterfaceAlias, true
	case 3:
		return ChassisIdSubtype_chassisIdSubtypePortComponent, true
	case 4:
		return ChassisIdSubtype_chassisIdSubtypeMacAddress, true
	case 5:
		return ChassisIdSubtype_chassisIdSubtypeNetworkAddress, true
	case 6:
		return ChassisIdSubtype_chassisIdSubtypeInterfaceName, true
	case 7:
		return ChassisIdSubtype_chassisIdSubtypeLocal, true
	}
	return 0, false
}

func ChassisIdSubtypeByName(value string) (enum ChassisIdSubtype, ok bool) {
	switch value {
	case "chassisIdSubtypeChassisComponent":
		return ChassisIdSubtype_chassisIdSubtypeChassisComponent, true
	case "chassisIdSubtypeInterfaceAlias":
		return ChassisIdSubtype_chassisIdSubtypeInterfaceAlias, true
	case "chassisIdSubtypePortComponent":
		return ChassisIdSubtype_chassisIdSubtypePortComponent, true
	case "chassisIdSubtypeMacAddress":
		return ChassisIdSubtype_chassisIdSubtypeMacAddress, true
	case "chassisIdSubtypeNetworkAddress":
		return ChassisIdSubtype_chassisIdSubtypeNetworkAddress, true
	case "chassisIdSubtypeInterfaceName":
		return ChassisIdSubtype_chassisIdSubtypeInterfaceName, true
	case "chassisIdSubtypeLocal":
		return ChassisIdSubtype_chassisIdSubtypeLocal, true
	}
	return 0, false
}

func ChassisIdSubtypeKnows(value uint32) bool {
	for _, typeValue := range ChassisIdSubtypeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastChassisIdSubtype(structType any) ChassisIdSubtype {
	castFunc := func(typ any) ChassisIdSubtype {
		if sChassisIdSubtype, ok := typ.(ChassisIdSubtype); ok {
			return sChassisIdSubtype
		}
		return 0
	}
	return castFunc(structType)
}

func (m ChassisIdSubtype) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m ChassisIdSubtype) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ChassisIdSubtypeParse(ctx context.Context, theBytes []byte) (ChassisIdSubtype, error) {
	return ChassisIdSubtypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ChassisIdSubtypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ChassisIdSubtype, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("ChassisIdSubtype", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ChassisIdSubtype")
	}
	if enum, ok := ChassisIdSubtypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for ChassisIdSubtype")
		return ChassisIdSubtype(val), nil
	} else {
		return enum, nil
	}
}

func (e ChassisIdSubtype) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e ChassisIdSubtype) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("ChassisIdSubtype", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e ChassisIdSubtype) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ChassisIdSubtype) PLC4XEnumName() string {
	switch e {
	case ChassisIdSubtype_chassisIdSubtypeChassisComponent:
		return "chassisIdSubtypeChassisComponent"
	case ChassisIdSubtype_chassisIdSubtypeInterfaceAlias:
		return "chassisIdSubtypeInterfaceAlias"
	case ChassisIdSubtype_chassisIdSubtypePortComponent:
		return "chassisIdSubtypePortComponent"
	case ChassisIdSubtype_chassisIdSubtypeMacAddress:
		return "chassisIdSubtypeMacAddress"
	case ChassisIdSubtype_chassisIdSubtypeNetworkAddress:
		return "chassisIdSubtypeNetworkAddress"
	case ChassisIdSubtype_chassisIdSubtypeInterfaceName:
		return "chassisIdSubtypeInterfaceName"
	case ChassisIdSubtype_chassisIdSubtypeLocal:
		return "chassisIdSubtypeLocal"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e ChassisIdSubtype) String() string {
	return e.PLC4XEnumName()
}
