/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// HistoryUpdateResult is the corresponding interface of HistoryUpdateResult
type HistoryUpdateResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetStatusCode returns StatusCode (property field)
	GetStatusCode() StatusCode
	// GetOperationResults returns OperationResults (property field)
	GetOperationResults() []StatusCode
	// GetDiagnosticInfos returns DiagnosticInfos (property field)
	GetDiagnosticInfos() []DiagnosticInfo
	// IsHistoryUpdateResult is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsHistoryUpdateResult()
	// CreateBuilder creates a HistoryUpdateResultBuilder
	CreateHistoryUpdateResultBuilder() HistoryUpdateResultBuilder
}

// _HistoryUpdateResult is the data-structure of this message
type _HistoryUpdateResult struct {
	ExtensionObjectDefinitionContract
	StatusCode       StatusCode
	OperationResults []StatusCode
	DiagnosticInfos  []DiagnosticInfo
}

var _ HistoryUpdateResult = (*_HistoryUpdateResult)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_HistoryUpdateResult)(nil)

// NewHistoryUpdateResult factory function for _HistoryUpdateResult
func NewHistoryUpdateResult(statusCode StatusCode, operationResults []StatusCode, diagnosticInfos []DiagnosticInfo) *_HistoryUpdateResult {
	if statusCode == nil {
		panic("statusCode of type StatusCode for HistoryUpdateResult must not be nil")
	}
	_result := &_HistoryUpdateResult{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		StatusCode:                        statusCode,
		OperationResults:                  operationResults,
		DiagnosticInfos:                   diagnosticInfos,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// HistoryUpdateResultBuilder is a builder for HistoryUpdateResult
type HistoryUpdateResultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(statusCode StatusCode, operationResults []StatusCode, diagnosticInfos []DiagnosticInfo) HistoryUpdateResultBuilder
	// WithStatusCode adds StatusCode (property field)
	WithStatusCode(StatusCode) HistoryUpdateResultBuilder
	// WithStatusCodeBuilder adds StatusCode (property field) which is build by the builder
	WithStatusCodeBuilder(func(StatusCodeBuilder) StatusCodeBuilder) HistoryUpdateResultBuilder
	// WithOperationResults adds OperationResults (property field)
	WithOperationResults(...StatusCode) HistoryUpdateResultBuilder
	// WithDiagnosticInfos adds DiagnosticInfos (property field)
	WithDiagnosticInfos(...DiagnosticInfo) HistoryUpdateResultBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the HistoryUpdateResult or returns an error if something is wrong
	Build() (HistoryUpdateResult, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() HistoryUpdateResult
}

// NewHistoryUpdateResultBuilder() creates a HistoryUpdateResultBuilder
func NewHistoryUpdateResultBuilder() HistoryUpdateResultBuilder {
	return &_HistoryUpdateResultBuilder{_HistoryUpdateResult: new(_HistoryUpdateResult)}
}

type _HistoryUpdateResultBuilder struct {
	*_HistoryUpdateResult

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (HistoryUpdateResultBuilder) = (*_HistoryUpdateResultBuilder)(nil)

func (b *_HistoryUpdateResultBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._HistoryUpdateResult
}

func (b *_HistoryUpdateResultBuilder) WithMandatoryFields(statusCode StatusCode, operationResults []StatusCode, diagnosticInfos []DiagnosticInfo) HistoryUpdateResultBuilder {
	return b.WithStatusCode(statusCode).WithOperationResults(operationResults...).WithDiagnosticInfos(diagnosticInfos...)
}

func (b *_HistoryUpdateResultBuilder) WithStatusCode(statusCode StatusCode) HistoryUpdateResultBuilder {
	b.StatusCode = statusCode
	return b
}

func (b *_HistoryUpdateResultBuilder) WithStatusCodeBuilder(builderSupplier func(StatusCodeBuilder) StatusCodeBuilder) HistoryUpdateResultBuilder {
	builder := builderSupplier(b.StatusCode.CreateStatusCodeBuilder())
	var err error
	b.StatusCode, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "StatusCodeBuilder failed"))
	}
	return b
}

func (b *_HistoryUpdateResultBuilder) WithOperationResults(operationResults ...StatusCode) HistoryUpdateResultBuilder {
	b.OperationResults = operationResults
	return b
}

func (b *_HistoryUpdateResultBuilder) WithDiagnosticInfos(diagnosticInfos ...DiagnosticInfo) HistoryUpdateResultBuilder {
	b.DiagnosticInfos = diagnosticInfos
	return b
}

func (b *_HistoryUpdateResultBuilder) Build() (HistoryUpdateResult, error) {
	if b.StatusCode == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'statusCode' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._HistoryUpdateResult.deepCopy(), nil
}

func (b *_HistoryUpdateResultBuilder) MustBuild() HistoryUpdateResult {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_HistoryUpdateResultBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_HistoryUpdateResultBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_HistoryUpdateResultBuilder) DeepCopy() any {
	_copy := b.CreateHistoryUpdateResultBuilder().(*_HistoryUpdateResultBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateHistoryUpdateResultBuilder creates a HistoryUpdateResultBuilder
func (b *_HistoryUpdateResult) CreateHistoryUpdateResultBuilder() HistoryUpdateResultBuilder {
	if b == nil {
		return NewHistoryUpdateResultBuilder()
	}
	return &_HistoryUpdateResultBuilder{_HistoryUpdateResult: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_HistoryUpdateResult) GetExtensionId() int32 {
	return int32(697)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_HistoryUpdateResult) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_HistoryUpdateResult) GetStatusCode() StatusCode {
	return m.StatusCode
}

func (m *_HistoryUpdateResult) GetOperationResults() []StatusCode {
	return m.OperationResults
}

func (m *_HistoryUpdateResult) GetDiagnosticInfos() []DiagnosticInfo {
	return m.DiagnosticInfos
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastHistoryUpdateResult(structType any) HistoryUpdateResult {
	if casted, ok := structType.(HistoryUpdateResult); ok {
		return casted
	}
	if casted, ok := structType.(*HistoryUpdateResult); ok {
		return *casted
	}
	return nil
}

func (m *_HistoryUpdateResult) GetTypeName() string {
	return "HistoryUpdateResult"
}

func (m *_HistoryUpdateResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (statusCode)
	lengthInBits += m.StatusCode.GetLengthInBits(ctx)

	// Implicit Field (noOfOperationResults)
	lengthInBits += 32

	// Array field
	if len(m.OperationResults) > 0 {
		for _curItem, element := range m.OperationResults {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.OperationResults), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfDiagnosticInfos)
	lengthInBits += 32

	// Array field
	if len(m.DiagnosticInfos) > 0 {
		for _curItem, element := range m.DiagnosticInfos {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DiagnosticInfos), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_HistoryUpdateResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_HistoryUpdateResult) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__historyUpdateResult HistoryUpdateResult, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("HistoryUpdateResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for HistoryUpdateResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	statusCode, err := ReadSimpleField[StatusCode](ctx, "statusCode", ReadComplex[StatusCode](StatusCodeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'statusCode' field"))
	}
	m.StatusCode = statusCode

	noOfOperationResults, err := ReadImplicitField[int32](ctx, "noOfOperationResults", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfOperationResults' field"))
	}
	_ = noOfOperationResults

	operationResults, err := ReadCountArrayField[StatusCode](ctx, "operationResults", ReadComplex[StatusCode](StatusCodeParseWithBuffer, readBuffer), uint64(noOfOperationResults))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'operationResults' field"))
	}
	m.OperationResults = operationResults

	noOfDiagnosticInfos, err := ReadImplicitField[int32](ctx, "noOfDiagnosticInfos", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfDiagnosticInfos' field"))
	}
	_ = noOfDiagnosticInfos

	diagnosticInfos, err := ReadCountArrayField[DiagnosticInfo](ctx, "diagnosticInfos", ReadComplex[DiagnosticInfo](DiagnosticInfoParseWithBuffer, readBuffer), uint64(noOfDiagnosticInfos))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'diagnosticInfos' field"))
	}
	m.DiagnosticInfos = diagnosticInfos

	if closeErr := readBuffer.CloseContext("HistoryUpdateResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for HistoryUpdateResult")
	}

	return m, nil
}

func (m *_HistoryUpdateResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_HistoryUpdateResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("HistoryUpdateResult"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for HistoryUpdateResult")
		}

		if err := WriteSimpleField[StatusCode](ctx, "statusCode", m.GetStatusCode(), WriteComplex[StatusCode](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'statusCode' field")
		}
		noOfOperationResults := int32(utils.InlineIf(bool((m.GetOperationResults()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetOperationResults()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfOperationResults", noOfOperationResults, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfOperationResults' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "operationResults", m.GetOperationResults(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'operationResults' field")
		}
		noOfDiagnosticInfos := int32(utils.InlineIf(bool((m.GetDiagnosticInfos()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetDiagnosticInfos()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfDiagnosticInfos", noOfDiagnosticInfos, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfDiagnosticInfos' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "diagnosticInfos", m.GetDiagnosticInfos(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'diagnosticInfos' field")
		}

		if popErr := writeBuffer.PopContext("HistoryUpdateResult"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for HistoryUpdateResult")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_HistoryUpdateResult) IsHistoryUpdateResult() {}

func (m *_HistoryUpdateResult) DeepCopy() any {
	return m.deepCopy()
}

func (m *_HistoryUpdateResult) deepCopy() *_HistoryUpdateResult {
	if m == nil {
		return nil
	}
	_HistoryUpdateResultCopy := &_HistoryUpdateResult{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[StatusCode](m.StatusCode),
		utils.DeepCopySlice[StatusCode, StatusCode](m.OperationResults),
		utils.DeepCopySlice[DiagnosticInfo, DiagnosticInfo](m.DiagnosticInfos),
	}
	_HistoryUpdateResultCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _HistoryUpdateResultCopy
}

func (m *_HistoryUpdateResult) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
