/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetServiceAckReadPropertyMultiple extends BACnetServiceAck implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.READ_PROPERTY_MULTIPLE;
  }

  // Properties.
  protected final List<BACnetReadAccessResult> data;

  // Arguments.
  protected final Long serviceAckPayloadLength;
  protected final Long serviceAckLength;

  public BACnetServiceAckReadPropertyMultiple(
      List<BACnetReadAccessResult> data, Long serviceAckPayloadLength, Long serviceAckLength) {
    super(serviceAckLength);
    this.data = data;
    this.serviceAckPayloadLength = serviceAckPayloadLength;
    this.serviceAckLength = serviceAckLength;
  }

  public List<BACnetReadAccessResult> getData() {
    return data;
  }

  @Override
  protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetServiceAckReadPropertyMultiple");

    // Array Field (data)
    writeComplexTypeArrayField("data", data, writeBuffer);

    writeBuffer.popContext("BACnetServiceAckReadPropertyMultiple");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetServiceAckReadPropertyMultiple _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Array field
    if (data != null) {
      for (Message element : data) {
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(
      ReadBuffer readBuffer, Long serviceAckPayloadLength, Long serviceAckLength)
      throws ParseException {
    readBuffer.pullContext("BACnetServiceAckReadPropertyMultiple");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    List<BACnetReadAccessResult> data =
        readLengthArrayField(
            "data",
            readComplex(() -> BACnetReadAccessResult.staticParse(readBuffer), readBuffer),
            serviceAckPayloadLength);

    readBuffer.closeContext("BACnetServiceAckReadPropertyMultiple");
    // Create the instance
    return new BACnetServiceAckReadPropertyMultipleBuilderImpl(
        data, serviceAckPayloadLength, serviceAckLength);
  }

  public static class BACnetServiceAckReadPropertyMultipleBuilderImpl
      implements BACnetServiceAck.BACnetServiceAckBuilder {
    private final List<BACnetReadAccessResult> data;
    private final Long serviceAckPayloadLength;
    private final Long serviceAckLength;

    public BACnetServiceAckReadPropertyMultipleBuilderImpl(
        List<BACnetReadAccessResult> data, Long serviceAckPayloadLength, Long serviceAckLength) {
      this.data = data;
      this.serviceAckPayloadLength = serviceAckPayloadLength;
      this.serviceAckLength = serviceAckLength;
    }

    public BACnetServiceAckReadPropertyMultiple build(Long serviceAckLength) {

      BACnetServiceAckReadPropertyMultiple bACnetServiceAckReadPropertyMultiple =
          new BACnetServiceAckReadPropertyMultiple(data, serviceAckPayloadLength, serviceAckLength);
      return bACnetServiceAckReadPropertyMultiple;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetServiceAckReadPropertyMultiple)) {
      return false;
    }
    BACnetServiceAckReadPropertyMultiple that = (BACnetServiceAckReadPropertyMultiple) o;
    return (getData() == that.getData()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
