/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetTagPayloadTime implements Message {

  // Properties.
  protected final short hour;
  protected final short minute;
  protected final short second;
  protected final short fractional;

  public BACnetTagPayloadTime(short hour, short minute, short second, short fractional) {
    super();
    this.hour = hour;
    this.minute = minute;
    this.second = second;
    this.fractional = fractional;
  }

  public short getHour() {
    return hour;
  }

  public short getMinute() {
    return minute;
  }

  public short getSecond() {
    return second;
  }

  public short getFractional() {
    return fractional;
  }

  public short getWildcard() {
    return (short) (0xFF);
  }

  public boolean getHourIsWildcard() {
    return (boolean) ((getHour()) == (getWildcard()));
  }

  public boolean getMinuteIsWildcard() {
    return (boolean) ((getMinute()) == (getWildcard()));
  }

  public boolean getSecondIsWildcard() {
    return (boolean) ((getSecond()) == (getWildcard()));
  }

  public boolean getFractionalIsWildcard() {
    return (boolean) ((getFractional()) == (getWildcard()));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetTagPayloadTime");

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short wildcard = getWildcard();
    writeBuffer.writeVirtual("wildcard", wildcard);

    // Simple Field (hour)
    writeSimpleField("hour", hour, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean hourIsWildcard = getHourIsWildcard();
    writeBuffer.writeVirtual("hourIsWildcard", hourIsWildcard);

    // Simple Field (minute)
    writeSimpleField("minute", minute, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean minuteIsWildcard = getMinuteIsWildcard();
    writeBuffer.writeVirtual("minuteIsWildcard", minuteIsWildcard);

    // Simple Field (second)
    writeSimpleField("second", second, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean secondIsWildcard = getSecondIsWildcard();
    writeBuffer.writeVirtual("secondIsWildcard", secondIsWildcard);

    // Simple Field (fractional)
    writeSimpleField("fractional", fractional, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean fractionalIsWildcard = getFractionalIsWildcard();
    writeBuffer.writeVirtual("fractionalIsWildcard", fractionalIsWildcard);

    writeBuffer.popContext("BACnetTagPayloadTime");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetTagPayloadTime _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // A virtual field doesn't have any in- or output.

    // Simple field (hour)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Simple field (minute)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Simple field (second)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Simple field (fractional)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static BACnetTagPayloadTime staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetTagPayloadTime");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    short wildcard = readVirtualField("wildcard", short.class, 0xFF);

    short hour = readSimpleField("hour", readUnsignedShort(readBuffer, 8));
    boolean hourIsWildcard =
        readVirtualField("hourIsWildcard", boolean.class, (hour) == (wildcard));

    short minute = readSimpleField("minute", readUnsignedShort(readBuffer, 8));
    boolean minuteIsWildcard =
        readVirtualField("minuteIsWildcard", boolean.class, (minute) == (wildcard));

    short second = readSimpleField("second", readUnsignedShort(readBuffer, 8));
    boolean secondIsWildcard =
        readVirtualField("secondIsWildcard", boolean.class, (second) == (wildcard));

    short fractional = readSimpleField("fractional", readUnsignedShort(readBuffer, 8));
    boolean fractionalIsWildcard =
        readVirtualField("fractionalIsWildcard", boolean.class, (fractional) == (wildcard));

    readBuffer.closeContext("BACnetTagPayloadTime");
    // Create the instance
    BACnetTagPayloadTime _bACnetTagPayloadTime;
    _bACnetTagPayloadTime = new BACnetTagPayloadTime(hour, minute, second, fractional);
    return _bACnetTagPayloadTime;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetTagPayloadTime)) {
      return false;
    }
    BACnetTagPayloadTime that = (BACnetTagPayloadTime) o;
    return (getHour() == that.getHour())
        && (getMinute() == that.getMinute())
        && (getSecond() == that.getSecond())
        && (getFractional() == that.getFractional())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getHour(), getMinute(), getSecond(), getFractional());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
