/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HVACStartTime implements Message {

  // Properties.
  protected final int minutesSinceSunday12AM;

  public HVACStartTime(int minutesSinceSunday12AM) {
    super();
    this.minutesSinceSunday12AM = minutesSinceSunday12AM;
  }

  public int getMinutesSinceSunday12AM() {
    return minutesSinceSunday12AM;
  }

  public float getHoursSinceSunday12AM() {
    return (float) ((getMinutesSinceSunday12AM()) / (60F));
  }

  public float getDaysSinceSunday12AM() {
    return (float) ((getHoursSinceSunday12AM()) / (24F));
  }

  public short getDayOfWeek() {
    return (short) ((getDaysSinceSunday12AM()) + (1));
  }

  public short getHour() {
    return (short) ((getHoursSinceSunday12AM()) % (24));
  }

  public short getMinute() {
    return (short) ((getMinutesSinceSunday12AM()) % (60));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HVACStartTime");

    // Simple Field (minutesSinceSunday12AM)
    writeSimpleField(
        "minutesSinceSunday12AM", minutesSinceSunday12AM, writeUnsignedInt(writeBuffer, 16));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    float hoursSinceSunday12AM = getHoursSinceSunday12AM();
    writeBuffer.writeVirtual("hoursSinceSunday12AM", hoursSinceSunday12AM);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    float daysSinceSunday12AM = getDaysSinceSunday12AM();
    writeBuffer.writeVirtual("daysSinceSunday12AM", daysSinceSunday12AM);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short dayOfWeek = getDayOfWeek();
    writeBuffer.writeVirtual("dayOfWeek", dayOfWeek);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short hour = getHour();
    writeBuffer.writeVirtual("hour", hour);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short minute = getMinute();
    writeBuffer.writeVirtual("minute", minute);

    writeBuffer.popContext("HVACStartTime");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    HVACStartTime _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (minutesSinceSunday12AM)
    lengthInBits += 16;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static HVACStartTime staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("HVACStartTime");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int minutesSinceSunday12AM =
        readSimpleField("minutesSinceSunday12AM", readUnsignedInt(readBuffer, 16));
    float hoursSinceSunday12AM =
        readVirtualField("hoursSinceSunday12AM", float.class, (minutesSinceSunday12AM) / (60F));
    float daysSinceSunday12AM =
        readVirtualField("daysSinceSunday12AM", float.class, (hoursSinceSunday12AM) / (24F));
    short dayOfWeek = readVirtualField("dayOfWeek", short.class, (daysSinceSunday12AM) + (1));
    short hour = readVirtualField("hour", short.class, (hoursSinceSunday12AM) % (24));
    short minute = readVirtualField("minute", short.class, (minutesSinceSunday12AM) % (60));

    readBuffer.closeContext("HVACStartTime");
    // Create the instance
    HVACStartTime _hVACStartTime;
    _hVACStartTime = new HVACStartTime(minutesSinceSunday12AM);
    return _hVACStartTime;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HVACStartTime)) {
      return false;
    }
    HVACStartTime that = (HVACStartTime) o;
    return (getMinutesSinceSunday12AM() == that.getMinutesSinceSunday12AM()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getMinutesSinceSunday12AM());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
