/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToTimeCast {
    private TimestampToTimeCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision)") long timestamp) {
        long epochSeconds = DateTimes.scaleEpochMicrosToSeconds(timestamp);
        long microOfSecond = timestamp % 1000000L;
        long microOfDay = Math.multiplyExact(TimestampToTimeCast.getSecondOfDay(epochSeconds), 1000000) + microOfSecond;
        if (targetPrecision < 6L) {
            microOfDay = DateTimes.round(microOfDay, (int)(6L - targetPrecision));
        }
        return DateTimes.rescale(microOfDay, 6, 12) % 86400000000000000L;
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision)") LongTimestamp timestamp) {
        long epochSeconds = DateTimes.scaleEpochMicrosToSeconds(timestamp.getEpochMicros());
        long secondOfDay = TimestampToTimeCast.getSecondOfDay(epochSeconds);
        long picoOfDay = Math.multiplyExact(secondOfDay, 1000000000000L) + Math.multiplyExact(timestamp.getEpochMicros() % 1000000L, 1000000) + (long)timestamp.getPicosOfMicro();
        return DateTimes.round(picoOfDay, (int)(12L - targetPrecision)) % 86400000000000000L;
    }

    private static long getSecondOfDay(long epochSeconds) {
        return LocalDateTime.ofEpochSecond(epochSeconds, 0, ZoneOffset.UTC).toLocalTime().toSecondOfDay();
    }
}

