/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import java.time.Instant;
import java.time.ZoneId;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToTimeCast {
    private TimestampWithTimeZoneToTimeCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") long packedEpochMillis) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        ZoneId zoneId = DateTimeEncoding.unpackZoneKey((long)packedEpochMillis).getZoneId();
        return TimestampWithTimeZoneToTimeCast.convert(targetPrecision, epochMillis, 0L, zoneId);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        return TimestampWithTimeZoneToTimeCast.convert(targetPrecision, timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()).getZoneId());
    }

    private static long convert(long targetPrecision, long epochMillis, long picosOfMilli, ZoneId zoneId) {
        long nanoOfDay = Instant.ofEpochMilli(epochMillis).atZone(zoneId).toLocalDateTime().toLocalTime().toNanoOfDay();
        long picoOfDay = DateTimes.rescale(nanoOfDay, 9, 12) + picosOfMilli;
        return DateTimes.round(picoOfDay, (int)(12L - targetPrecision)) % 86400000000000000L;
    }
}

