/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SetTimeZone
extends Statement {
    private final Optional<Expression> timeZone;

    public SetTimeZone(NodeLocation location, Optional<Expression> timeZone) {
        super(Optional.of(location));
        Objects.requireNonNull(timeZone, "timeZone is null");
        this.timeZone = timeZone;
    }

    public Optional<Expression> getTimeZone() {
        return this.timeZone;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetTimeZone(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.timeZone.isPresent() ? ImmutableList.of((Object)this.timeZone.get()) : ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTimeZone that = (SetTimeZone)o;
        return Objects.equals(this.timeZone, that.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timeZone);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timeZone", this.timeZone.isPresent() ? this.timeZone : "LOCAL").toString();
    }
}

