# PIP-249: Pulsar website redesign

Apache Pulsar is a unique, modern, cutting edge messaging platform in its category (Messaging/Streaming systems). Yet, its website doesn't reflect that, and relays a completely different message. People can be mistaken thinking Pulsar is old, unmaintained technology.

Pulsar, although donated to ASF in June 2017 (and actually created in 2012), is still considered to be in the Early Adopter stage (See [Adoption Curve stages](https://en.wikipedia.org/wiki/Technology_adoption_life_cycle)).  I believe everybody in the community working on Pulsar or working with it, would like to see it move to the next stage. In my opinion, this can't happen without the website reflecting a modern look and feel.

# Goal
Make pulsar website have a modern look and feel (i.e. theme), that would:
1. Reflect how modern and cutting edge Pulsar is.
2. "Invite" people to look and stay longer on the site, to learn more.
3. "Feel good" when browsing the documentation to learn more or solve a problem.

# Design Details

## Designer
The brilliant designer making this design is @emidio-cardeira

## Scope
In general there are many elements on the website that needs changing, yet making a very big change is hard for everyone involved, hence this PIP has a very constrained scope:

* Visual branding
* Accessibility
* Typography
* Homepage structure

## Screenshots
The following are screenshots of the design, featuring the landing page. The work done towards this proposal is the design work (using Figma). If approved, it will be converted to an actual site changes (using proper PRs).

**Entire top-to-bottom screenshot**
(updated March 9th: improved footer based on comments)
![image](https://user-images.githubusercontent.com/989425/224023898-71313585-c944-4e52-ac39-83b7a2680436.png)


You can look at the entire home page via this [public link](https://www.figma.com/proto/0jERoA2DTlfQoj1uH09FxQ/Pulsar-website?page-id=368%3A658&node-id=368%3A659&scaling=min-zoom&hide-ui=1).

## Changes

### Visual branding

#### Language

**Current**
* The visuals seem a bit outdated and old, contradicting the actual technology.
* We want to attract more people to pulsar.
* Visuals look a bit cold.

**Proposal**
* Increase the color spectrum to look more modern and contemporary.
* Add more visual richness and allow visual expansion of the branding elements.
* Make Pulsar and its website more approachable and friendly.

#### Pulsar compared to other players

**Current**
* There’s no a clear distinction between Pulsar and other similar technology which blocks Pulsar to stand on its own
* Makes the branding less identity and distinct

Apache Kafka
![image](https://user-images.githubusercontent.com/989425/220940383-666812d0-d97c-46a0-b0e8-67183fbfa76e.png)

Apache Pulsar
![image](https://user-images.githubusercontent.com/989425/220940562-7664ae1e-19b7-48f9-ae2c-b33990f016ca.png)

**Proposal**
Create a new and unique language with meaning that also improves Pulsar branding and identity

![image](https://user-images.githubusercontent.com/989425/220940763-da503739-bbdf-4cea-9ad4-233dec111a96.png)

### Accessibility

#### Buttons

**Current**
Good accessibility practices advise distinguishing UI elements not only with colors (specially if the tone is too close) but also the way they are represented

![image](https://user-images.githubusercontent.com/989425/220940885-d9fbdc50-b545-45b2-8e9d-a6d6ffd81a4b.png)

**Proposal**
Make a clear achromatic distinction between main and secondary action

![image](https://user-images.githubusercontent.com/989425/220940965-572e23b2-4bb7-445a-aa6e-4d8f6c18871b.png)

#### Background

**Current**
* Background color creates some legibility, accessibility and contrast issues with other colors (see green vs background blue in the image)
* Background has too much presence for something that should be more neutral

![image](https://user-images.githubusercontent.com/989425/220941495-d6acf30e-3923-4ceb-8b3a-63336217d492.png)

**Proposal**
Make the background a more neutral color to avoid contrast issues on all website and increase functionality.

![image](https://user-images.githubusercontent.com/989425/220941623-d8150d33-6d72-4fbe-bc40-cab0139c873b.png)

#### Dark theme

**Current**
Graphics, text colors, actions are not optimized for a dark theme creating legibility and accessibility issues

Examples:
* Text is not readable on dark background
* Logo doesn’t have enough contrast on dark background
* Contrast issues with Information banner green background color

![image](https://user-images.githubusercontent.com/989425/220943948-5996449e-1f31-4c2c-be73-98fbaf22319b.png)

![image](https://user-images.githubusercontent.com/989425/220944099-5ad6744f-2f85-46c8-91d3-d70d38d2e639.png)

**Proposal**
* Make a v1 iteration only in Light theme
* (In the future) Have a v2 with components optimized for the dark theme

### Typography

**Current: Arial**
* Very limited weights (only bold, regular and Italic)
* Making the website more bland
* Website looses versatility in information hierarchy
* Arial is more suited for body text and doesn’t work very well in larger titles.

![image](https://user-images.githubusercontent.com/989425/220964829-f0b5c2b9-594a-4ec6-b320-00efa8d5c48e.png)


**Proposal: Work Sans**
* Different weights that give more personality to the website and versatility to create information hierarchy: https://fonts.google.com/specimen/Work+Sans
* Works Sans was created and optimized for screen reading, but the different weights make it also a great use case for headings and highlights (https://fonts.google.com/specimen/Work+Sans/about)
* Works sans is also an opens source font which conceptually also fits the Pulsar spirit

![image](https://user-images.githubusercontent.com/989425/220964926-fb96e611-92ea-439f-809d-439b7372bb7e.png)

### Homepage structure

#### News banner

**Current**
* The news banner gets lost in the homepage and visitors need to scroll to see it.
* Returning users, who just want to go to Docs and don’t scroll, miss the important news about Pulsar.

First section
![image](https://user-images.githubusercontent.com/989425/220939503-34fc172e-d832-4c05-a676-48e2f674b8e4.png)

As you scroll, you lose the news banner
![image](https://user-images.githubusercontent.com/989425/220939661-9c9ba3ae-97a9-427d-a129-f303311cd1d5.png)

**Proposal**
Move the banner to the top of the page, to a more prominent position where users can see it without scrolling.

Home page
![image](https://user-images.githubusercontent.com/989425/220965132-3352fc5b-103d-46dc-85f4-e3a2a525c523.png)

Then after you scroll, the news banner is still there
![image](https://user-images.githubusercontent.com/989425/220965295-669f5d39-6995-41df-8b50-77003d312db7.png)


#### Testimonials

**Current**
We show a single testimonial, and users need to refresh the page to see a new one, which is not very user-friendly, and it’s an obstacle for visitors to discover other opinions about Pulsar.

![image](https://user-images.githubusercontent.com/989425/220965389-0bce771a-790a-49a5-9ac9-9a4297c315cb.png)

**Proposal**
Create a new section highlighting different testimonials about pulsar

![image](https://user-images.githubusercontent.com/989425/220965516-d2086af1-a0be-46a6-8f5e-61e1960aac6f.png)

#### Menu

**Current**
* Navigation is one of the most critical components of a website
* Considering the amount of information, the menu should be always present, so that it’s easier for the visitor/user to navigate and not get lost.
* Research study confirms that sticky menus are 22% quicker to navigate and users do prefer to have a sticky menu https://www.smashingmagazine.com/2012/09/sticky-menus-are-quicker-to-navigate/

![image](https://user-images.githubusercontent.com/989425/220965635-670bdcb6-aa30-4e72-a52f-a27867606269.png)


**Proposal**
* Make the menu sticky to the top.
* Since it’s always visible design a more neutral menu, so it doesn't compete visually with the content

![image](https://user-images.githubusercontent.com/989425/220933898-5dd9f0a8-eff4-40be-bb8a-bbbb59e92de8.png)

#### Footer

**Current**
* The current footer has only links for Apache foundation, damaging the discoverability of the Apache Pulsar website.
* No links for GitHub or Slack

![image](https://user-images.githubusercontent.com/989425/220965794-b2898afa-8aad-4e47-ad9c-45958720f05d.png)

**Proposal**
Follow up-to-date standards, by using a fat footer, where visitor can easily have a glimpse of the whole website structure/content with links to social media

![image](https://user-images.githubusercontent.com/989425/224024408-e81ef77f-36b1-4245-9a37-aa04f7cbfe8a.png)
(updated March 9th: footer updated based on discussion comments)

# Links
Dev mailing list discussion thread: https://lists.apache.org/thread/3of7dfhn4qk033hqlqpvbc8so6bcolz4
Dev mailing list voting thread: https://lists.apache.org/thread/ph25f3p405ky78w91r08hd8f0jmkdwh0
