/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Flags;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameListener;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2LocalFlowController;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.grpc.netty.shaded.io.netty.handler.timeout.IdleStateEvent;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.Nullable;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.impl.VertxByteBufAllocator;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.GoAway;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.Http2Settings;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClosedException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpConnection;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.StreamPriority;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpFrameImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpUtils;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.VertxHttp2Stream;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future.PromiseInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.Logger;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.ConnectionBase;

abstract class Http2ConnectionBase
extends ConnectionBase
implements Http2FrameListener,
HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(Http2ConnectionBase.class);
    protected final ChannelHandlerContext handlerContext;
    protected final VertxHttp2ConnectionHandler handler;
    protected final Http2Connection.PropertyKey streamKey;
    private boolean shutdown;
    private Handler<Http2Settings> remoteSettingsHandler;
    private final ArrayDeque<Handler<Void>> updateSettingsHandlers = new ArrayDeque();
    private final ArrayDeque<Promise<Buffer>> pongHandlers = new ArrayDeque();
    private io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings localSettings;
    private io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings remoteSettings;
    private Handler<GoAway> goAwayHandler;
    private Handler<Void> shutdownHandler;
    private Handler<Buffer> pingHandler;
    private GoAway goAwayStatus;
    private int windowSize;
    private long maxConcurrentStreams;

    private static ByteBuf safeBuffer(ByteBuf buf) {
        ByteBuf buffer = VertxByteBufAllocator.DEFAULT.heapBuffer(buf.readableBytes());
        buffer.writeBytes(buf);
        return buffer;
    }

    public Http2ConnectionBase(ContextInternal context, VertxHttp2ConnectionHandler handler) {
        super(context, handler.context());
        this.handler = handler;
        this.handlerContext = this.chctx;
        this.windowSize = ((Http2LocalFlowController)handler.connection().local().flowController()).windowSize(handler.connection().connectionStream());
        this.maxConcurrentStreams = 0xFFFFFFFFL;
        this.streamKey = handler.connection().newKey();
        this.localSettings = handler.initialSettings();
    }

    VertxInternal vertx() {
        return this.vertx;
    }

    @Override
    public void handleClosed() {
        super.handleClosed();
    }

    @Override
    protected void handleInterestedOpsChanged() {
    }

    @Override
    protected void handleIdle(IdleStateEvent event) {
        super.handleIdle(event);
    }

    synchronized void onConnectionError(Throwable cause) {
        ArrayList streams = new ArrayList();
        try {
            this.handler.connection().forEachActiveStream(stream -> {
                streams.add(stream.getProperty(this.streamKey));
                return true;
            });
        }
        catch (Http2Exception e) {
            log.error("Could not get the list of active streams", e);
        }
        for (VertxHttp2Stream stream2 : streams) {
            stream2.context.dispatch(v -> stream2.handleException(cause));
        }
        this.handleException(cause);
    }

    VertxHttp2Stream<?> stream(int id) {
        Http2Stream s = this.handler.connection().stream(id);
        if (s == null) {
            return null;
        }
        return (VertxHttp2Stream)s.getProperty(this.streamKey);
    }

    void onStreamError(int streamId, Throwable cause) {
        VertxHttp2Stream<?> stream = this.stream(streamId);
        if (stream != null) {
            stream.onException(cause);
        }
    }

    void onStreamWritabilityChanged(Http2Stream s) {
        VertxHttp2Stream stream = (VertxHttp2Stream)s.getProperty(this.streamKey);
        if (stream != null) {
            stream.onWritabilityChanged();
        }
    }

    void onStreamClosed(Http2Stream s) {
        VertxHttp2Stream stream = (VertxHttp2Stream)s.getProperty(this.streamKey);
        if (stream != null) {
            boolean active = this.chctx.channel().isActive();
            if (this.goAwayStatus != null) {
                stream.onException(new HttpClosedException(this.goAwayStatus));
            } else if (!active) {
                stream.onException(HttpUtils.STREAM_CLOSED_EXCEPTION);
            }
            stream.onClose();
        }
        this.checkShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onGoAwaySent(GoAway goAway) {
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            if (this.goAwayStatus != null) {
                return false;
            }
            this.goAwayStatus = goAway;
        }
        this.checkShutdown();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onGoAwayReceived(GoAway goAway) {
        Handler<GoAway> handler;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            if (this.goAwayStatus != null) {
                return false;
            }
            this.goAwayStatus = goAway;
            handler = this.goAwayHandler;
        }
        if (handler != null) {
            this.context.dispatch(new GoAway(goAway), handler);
        }
        this.checkShutdown();
        return true;
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        VertxHttp2Stream<?> stream = this.stream(streamId);
        if (stream != null) {
            StreamPriority streamPriority = new StreamPriority().setDependency(streamDependency).setWeight(weight).setExclusive(exclusive);
            stream.onPriorityChange(streamPriority);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        if (this.goAwayStatus == null) {
            StreamPriority streamPriority = new StreamPriority().setDependency(streamDependency).setWeight(weight).setExclusive(exclusive);
            this.onHeadersRead(streamId, headers, streamPriority, endOfStream);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        if (this.goAwayStatus == null) {
            this.onHeadersRead(streamId, headers, null, endOfStream);
        }
    }

    protected abstract void onHeadersRead(int var1, Http2Headers var2, StreamPriority var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSettingsAckRead(ChannelHandlerContext ctx) {
        Handler<Void> handler;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            handler = this.updateSettingsHandlers.poll();
        }
        if (handler != null) {
            this.context.emit(handler);
        }
    }

    protected void concurrencyChanged(long concurrency) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSettingsRead(ChannelHandlerContext ctx, io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings settings) {
        Handler<Http2Settings> handler;
        boolean changed;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            Long val = settings.maxConcurrentStreams();
            if (val != null) {
                changed = this.remoteSettings != null ? val != this.maxConcurrentStreams : false;
                this.maxConcurrentStreams = val;
            } else {
                changed = false;
            }
            this.remoteSettings = settings;
            handler = this.remoteSettingsHandler;
        }
        if (handler != null) {
            this.context.dispatch(HttpUtils.toVertxSettings(settings), handler);
        }
        if (changed) {
            this.concurrencyChanged(this.maxConcurrentStreams);
        }
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
        Handler<Buffer> handler = this.pingHandler;
        if (handler != null) {
            Buffer buff = Buffer.buffer().appendLong(data);
            this.context.dispatch(v -> handler.handle(buff));
        }
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
        Promise<Buffer> handler = this.pongHandlers.poll();
        if (handler != null) {
            Buffer buff = Buffer.buffer().appendLong(data);
            handler.complete(buff);
        }
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
        VertxHttp2Stream<?> stream = this.stream(streamId);
        if (stream != null) {
            Buffer buff = Buffer.buffer(Http2ConnectionBase.safeBuffer(payload));
            stream.onCustomFrame(new HttpFrameImpl(frameType, flags.value(), buff));
        }
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        VertxHttp2Stream<?> stream = this.stream(streamId);
        if (stream != null) {
            stream.onReset(errorCode);
        }
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        VertxHttp2Stream<?> stream = this.stream(streamId);
        if (stream != null) {
            data = Http2ConnectionBase.safeBuffer(data);
            Buffer buff = Buffer.buffer(data);
            stream.onData(buff);
            if (endOfStream) {
                stream.onEnd();
            }
        }
        return padding;
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public HttpConnection setWindowSize(int windowSize) {
        try {
            Http2Stream stream = this.handler.encoder().connection().connectionStream();
            int delta = windowSize - this.windowSize;
            this.handler.decoder().flowController().incrementWindowSize(stream, delta);
            this.windowSize = windowSize;
            return this;
        }
        catch (Http2Exception e) {
            throw new VertxException(e);
        }
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        if (errorCode < 0L) {
            throw new IllegalArgumentException();
        }
        if (lastStreamId < 0) {
            lastStreamId = this.handler.connection().remote().lastStreamCreated();
        }
        this.handler.writeGoAway(errorCode, lastStreamId, debugData != null ? debugData.getByteBuf() : Unpooled.EMPTY_BUFFER);
        return this;
    }

    @Override
    public synchronized HttpConnection goAwayHandler(Handler<GoAway> handler) {
        this.goAwayHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpConnection shutdownHandler(Handler<Void> handler) {
        this.shutdownHandler = handler;
        return this;
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        PromiseInternal<Void> promise = this.vertx.promise();
        this.shutdown(unit.toMillis(timeout), promise);
        return promise.future();
    }

    private void shutdown(long timeout, PromiseInternal<Void> promise) {
        if (timeout < 0L) {
            promise.fail("Invalid timeout value " + timeout);
            return;
        }
        this.handler.gracefulShutdownTimeoutMillis(timeout);
        ChannelFuture fut = this.channel().close();
        fut.addListener(promise);
    }

    @Override
    public Http2ConnectionBase closeHandler(Handler<Void> handler) {
        return (Http2ConnectionBase)super.closeHandler(handler);
    }

    @Override
    public Future<Void> close() {
        PromiseInternal promise = this.context.promise();
        ChannelPromise pr = this.chctx.newPromise();
        ChannelPromise channelPromise = pr.addListener(promise);
        this.handlerContext.writeAndFlush((Object)Unpooled.EMPTY_BUFFER, pr);
        channelPromise.addListener((GenericFutureListener)((ChannelFutureListener)future -> this.shutdown(0L)));
        return promise.future();
    }

    @Override
    public synchronized HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.remoteSettingsHandler = handler;
        return this;
    }

    @Override
    public synchronized Http2Settings remoteSettings() {
        return HttpUtils.toVertxSettings(this.remoteSettings);
    }

    @Override
    public synchronized Http2Settings settings() {
        return HttpUtils.toVertxSettings(this.localSettings);
    }

    @Override
    public Future<Void> updateSettings(Http2Settings settings) {
        PromiseInternal<Void> promise = this.context.promise();
        io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings settingsUpdate = HttpUtils.fromVertxSettings(settings);
        this.updateSettings(settingsUpdate, promise);
        return promise.future();
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, @Nullable Handler<AsyncResult<Void>> completionHandler) {
        this.updateSettings(settings).onComplete(completionHandler);
        return this;
    }

    protected void updateSettings(io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings settingsUpdate, Handler<AsyncResult<Void>> completionHandler) {
        io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings current = this.handler.decoder().localSettings();
        for (Map.Entry entry : current.entrySet()) {
            Character key = (Character)entry.getKey();
            if (!Objects.equals(settingsUpdate.get((Object)key), entry.getValue())) continue;
            settingsUpdate.remove((Object)key);
        }
        Handler<Void> pending = v -> {
            Http2ConnectionBase http2ConnectionBase = this;
            synchronized (http2ConnectionBase) {
                this.localSettings.putAll((Map)settingsUpdate);
            }
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
        };
        this.updateSettingsHandlers.add(pending);
        this.handler.writeSettings(settingsUpdate).addListener(fut -> {
            if (!fut.isSuccess()) {
                Http2ConnectionBase http2ConnectionBase = this;
                synchronized (http2ConnectionBase) {
                    this.updateSettingsHandlers.remove(pending);
                }
                if (completionHandler != null) {
                    completionHandler.handle(Future.failedFuture(fut.cause()));
                }
            }
        });
    }

    @Override
    public Future<Buffer> ping(Buffer data) {
        if (data.length() != 8) {
            throw new IllegalArgumentException("Ping data must be exactly 8 bytes");
        }
        PromiseInternal promise = this.context.promise();
        this.handler.writePing(data.getLong(0)).addListener(fut -> {
            if (fut.isSuccess()) {
                Http2ConnectionBase http2ConnectionBase = this;
                synchronized (http2ConnectionBase) {
                    this.pongHandlers.add(promise);
                }
            } else {
                promise.fail(fut.cause());
            }
        });
        return promise.future();
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        Future<Buffer> fut = this.ping(data);
        if (pongHandler != null) {
            fut.onComplete(pongHandler);
        }
        return this;
    }

    @Override
    public synchronized HttpConnection pingHandler(Handler<Buffer> handler) {
        this.pingHandler = handler;
        return this;
    }

    @Override
    public Http2ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        return (Http2ConnectionBase)super.exceptionHandler(handler);
    }

    void consumeCredits(Http2Stream stream, int numBytes) {
        this.handler.consume(stream, numBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdown() {
        Handler<Void> shutdownHandler;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            if (this.shutdown) {
                return;
            }
            Http2Connection conn = this.handler.connection();
            if (!conn.goAwayReceived() && !conn.goAwaySent() || conn.numActiveStreams() > 0) {
                return;
            }
            this.shutdown = true;
            shutdownHandler = this.shutdownHandler;
        }
        this.doShutdown(shutdownHandler);
    }

    protected void doShutdown(Handler<Void> shutdownHandler) {
        if (shutdownHandler != null) {
            this.context.dispatch(shutdownHandler);
        }
    }
}

