/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.instrumentation.transformer;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.instrumentation.metadata.MemberDescription;
import org.apache.qpid.server.instrumentation.metadata.MethodDescription;
import org.apache.qpid.server.instrumentation.transformer.QpidTransformer;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class AbstractQpidTransformer<T extends MemberDescription>
implements QpidTransformer<T> {
    protected static final Boolean FALSE = Boolean.FALSE;
    protected static final Boolean TRUE = Boolean.TRUE;
    protected static final String ARRAYS = Type.getInternalName(Arrays.class);
    protected static final String BOOLEAN = Type.getInternalName(Boolean.class);
    protected static final String BYTE = Type.getInternalName(Byte.class);
    protected static final String CALLSITE = Type.getInternalName(CallSite.class);
    protected static final String CHARACTER = Type.getInternalName(Character.class);
    protected static final String CLASS = Type.getInternalName(Class.class);
    protected static final String CO = "org/apache/qpid/server/model/ConfiguredObject";
    protected static final String CO_TYPE_REGISTRY = "org/apache/qpid/server/model/ConfiguredObjectTypeRegistry";
    protected static final String COLLECTOR = Type.getInternalName(Collector.class);
    protected static final String COLLECTORS = Type.getInternalName(Collectors.class);
    protected static final String DOUBLE = Type.getInternalName(Double.class);
    protected static final String FIELD = Type.getInternalName(Field.class);
    protected static final String FLOAT = Type.getInternalName(Float.class);
    protected static final String FUNCTION = Type.getInternalName(Function.class);
    protected static final String INTEGER = Type.getInternalName(Integer.class);
    protected static final String LAMBDAMETAFACTORY = Type.getInternalName(LambdaMetafactory.class);
    protected static final String LONG = Type.getInternalName(Long.class);
    protected static final String LOOKUP = Type.getInternalName(MethodHandles.Lookup.class);
    protected static final String MAP = Type.getInternalName(Map.class);
    protected static final String METHOD = Type.getInternalName(Method.class);
    protected static final String METHOD_HANDLE = Type.getInternalName(MethodHandle.class);
    protected static final String METHOD_HANDLES = Type.getInternalName(MethodHandles.class);
    protected static final String METHODTYPE = Type.getInternalName(MethodType.class);
    protected static final String OBJECT = Type.getInternalName(Object.class);
    protected static final String SHORT = Type.getInternalName(Short.class);
    protected static final String SSRE = "org/apache/qpid/server/util/ServerScopedRuntimeException";
    protected static final String STREAM = Type.getInternalName(Stream.class);
    protected static final String STRING = Type.getInternalName(String.class);
    protected static final String STRING_BUILDER = Type.getInternalName(StringBuilder.class);
    protected static final String THROWABLE = Type.getInternalName(Throwable.class);
    protected static final String VOID = Type.getInternalName(Void.class);
    protected static final String TYPE_BOOLEAN = "Z";
    protected static final String TYPE_BYTE = "B";
    protected static final String TYPE_CHARACTER = "C";
    protected static final String TYPE_DOUBLE = "D";
    protected static final String TYPE_FLOAT = "F";
    protected static final String TYPE_INT = "I";
    protected static final String TYPE_LONG = "J";
    protected static final String TYPE_SHORT = "S";
    protected static final String TYPE_VOID = "V";
    private static final Map<String, Supplier<String>> TYPES = Map.of("Z", () -> BOOLEAN, "B", () -> BYTE, "C", () -> CHARACTER, "D", () -> DOUBLE, "F", () -> FLOAT, "I", () -> INTEGER, "J", () -> LONG, "S", () -> SHORT, "V", () -> VOID);
    protected static final String FIELD_FIELD = "_field";
    protected static final String FIELD_HASHCODE = "_hashcode";
    protected static final String FIELD_SIGNATURE = "_signature";
    protected static final String TYPE = "TYPE";
    protected static final String APPEND = "append";
    protected static final String APPLY = "apply";
    protected static final String CLINIT = "<clinit>";
    protected static final String COLLECT = "collect";
    protected static final String FORMAT = "format";
    protected static final String GET_CANONICAL_NAME = "getCanonicalName";
    protected static final String GET_DECLARING_CLASS = "getDeclaringClass";
    protected static final String GET_NAME = "getName";
    protected static final String GET_PARAM_TYPES = "getParameterTypes";
    protected static final String GET_SIMPLE_NAME = "getSimpleName";
    protected static final String HASHCODE = "hashCode";
    protected static final String INIT = "<init>";
    protected static final String INVOKE = "invoke";
    protected static final String INVOKE_EXACT = "invokeExact";
    protected static final String JOINING = "joining";
    protected static final String METAFACTORY = "metafactory";
    protected static final String METHOD_LOOKUP = "lookup";
    protected static final String METHOD_MAP = "map";
    protected static final String SET = "set";
    protected static final String SET_ACCESSIBLE = "setAccessible";
    protected static final String METHOD_STREAM = "stream";
    protected static final String TO_STRING = "toString";
    protected static final String VALUE_OF = "valueOf";
    protected static final String NO_ARGS = "()%s";
    protected static final String ONE_ARG = "(%s)%s";
    protected static final String DESC_APPEND = String.format("(%s)%s", AbstractQpidTransformer.referenceName(STRING), AbstractQpidTransformer.referenceName(STRING_BUILDER));
    protected static final String DESC_APPLY = String.format("()%s", AbstractQpidTransformer.referenceName(FUNCTION));
    protected static final String DESC_COLLECT = String.format("(%s)%s", AbstractQpidTransformer.referenceName(COLLECTOR), AbstractQpidTransformer.referenceName(OBJECT));
    protected static final String DESC_GET_CLASS = String.format("()%s", AbstractQpidTransformer.referenceName(CLASS));
    protected static final String DESC_GET_STRING = String.format("()%s", AbstractQpidTransformer.referenceName(STRING));
    protected static final String DESC_GET_PARAM_TYPES = String.format("()[%s", AbstractQpidTransformer.referenceName(CLASS));
    protected static final String DESC_HASHCODE = "()I";
    protected static final String DESC_JOINING = String.format("()%s", AbstractQpidTransformer.referenceName(COLLECTOR));
    protected static final String DESC_METAFACTORY = String.format("(%s%s%s%s%s%s)%s", AbstractQpidTransformer.referenceName(LOOKUP), AbstractQpidTransformer.referenceName(STRING), AbstractQpidTransformer.referenceName(METHODTYPE), AbstractQpidTransformer.referenceName(METHODTYPE), AbstractQpidTransformer.referenceName(METHOD_HANDLE), AbstractQpidTransformer.referenceName(METHODTYPE), AbstractQpidTransformer.referenceName(CALLSITE));
    protected static final String DESC_LOOKUP = String.format("()%s", AbstractQpidTransformer.referenceName(LOOKUP));
    protected static final String DESC_MAP = String.format("(%s)%s", AbstractQpidTransformer.referenceName(FUNCTION), AbstractQpidTransformer.referenceName(STREAM));
    protected static final String DESC_EXCEPTION1 = String.format("(%s)V", AbstractQpidTransformer.referenceName(STRING));
    protected static final String DESC_EXCEPTION2 = String.format("(%s%s)V", AbstractQpidTransformer.referenceName(STRING), AbstractQpidTransformer.referenceName(THROWABLE));
    protected static final String DESC_FORMAT = String.format("(%s[%s)%s", AbstractQpidTransformer.referenceName(STRING), AbstractQpidTransformer.referenceName(OBJECT), AbstractQpidTransformer.referenceName(STRING));
    protected static final String DESC_FORNAME = String.format("(%s)%s", AbstractQpidTransformer.referenceName(STRING), AbstractQpidTransformer.referenceName(CLASS));
    protected static final String DESC_GET_DECLARED_METHOD = String.format("(%s[%s)%s", AbstractQpidTransformer.referenceName(STRING), AbstractQpidTransformer.referenceName(CLASS), AbstractQpidTransformer.referenceName(METHOD));
    protected static final String DESC_PRIVATE_LOOKUP = String.format("(%s%s)%s", AbstractQpidTransformer.referenceName(CLASS), AbstractQpidTransformer.referenceName(LOOKUP), AbstractQpidTransformer.referenceName(LOOKUP));
    protected static final String DESC_SET = String.format("(%s%s)V", AbstractQpidTransformer.referenceName(OBJECT), AbstractQpidTransformer.referenceName(OBJECT));
    protected static final String DESC_STREAM = String.format("([%s)%s", AbstractQpidTransformer.referenceName(OBJECT), AbstractQpidTransformer.referenceName(STREAM));
    protected static final String DESC_UNREFLECT = String.format("(%s)%s", AbstractQpidTransformer.referenceName(METHOD), AbstractQpidTransformer.referenceName(METHOD_HANDLE));
    protected static final Type TYPE_LAMBDAMETAFACTORY = Type.getType((String)String.format("(%s)%s", AbstractQpidTransformer.referenceName(OBJECT), AbstractQpidTransformer.referenceName(OBJECT)));
    protected static final Type TYPE_GET_SIMPLE_NAME = Type.getType((String)String.format("(%s)%s", AbstractQpidTransformer.referenceName(CLASS), AbstractQpidTransformer.referenceName(STRING)));
    protected static final Handle HANDLE_LAMBDAMETAFACTORY = new Handle(6, LAMBDAMETAFACTORY, "metafactory", DESC_METAFACTORY, FALSE.booleanValue());
    protected static final Handle HANDLE_GET_SIMPLE_NAME = new Handle(5, CLASS, "getSimpleName", DESC_GET_STRING, FALSE.booleanValue());

    @Override
    public byte[] generate(byte[] bytes) {
        try {
            ClassReader classReader = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(classReader, 2);
            classReader.accept(this.getTransformer((ClassVisitor)cw), 8);
            return cw.toByteArray();
        }
        catch (Throwable t) {
            this.getLogger().error("Error during code instrumentation", t);
            throw new ServerScopedRuntimeException(t);
        }
    }

    protected static String referenceName(String type) {
        if (type.charAt(0) == '[' || type.charAt(0) == 'L' && type.endsWith(";")) {
            return type;
        }
        return TYPES.containsKey(type) ? type : String.format("L%s;", type.replace('.', '/'));
    }

    protected static String sig(MethodDescription methodDescription) {
        return "(" + AbstractQpidTransformer.referenceName(methodDescription.getDeclaringClass()) + methodDescription.getParameters().stream().map(AbstractQpidTransformer::referenceName).collect(Collectors.joining()) + ")" + AbstractQpidTransformer.referenceName(methodDescription.getReturnType());
    }

    protected void visitMethodHandleFields(int size, ClassWriter cw) {
        int access = 24;
        for (int i = 0; i < size; ++i) {
            cw.visitField(24, "MH_" + i, AbstractQpidTransformer.referenceName(METHOD_HANDLE), null, null).visitEnd();
        }
    }

    protected void visitStaticInitializer(List<MethodDescription> methods, String internalClassName, String className, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(8, CLINIT, "()V", null, null);
        mv.visitCode();
        int varIndex = 0;
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchStart = new Label();
        mv.visitTryCatchBlock(tryStart, tryEnd, catchStart, THROWABLE);
        mv.visitLabel(tryStart);
        mv.visitMethodInsn(184, METHOD_HANDLES, METHOD_LOOKUP, DESC_LOOKUP, FALSE.booleanValue());
        mv.visitVarInsn(58, varIndex);
        int lookupIndex = varIndex;
        String previousClassName = "";
        int declaringClassIndex = varIndex;
        for (int i = 0; i < methods.size(); ++i) {
            MethodDescription method = methods.get(i);
            String declaringClass = method.getDeclaringClass().replace('/', '.');
            String methodName = method.getName();
            if (!Objects.equals(previousClassName, declaringClass)) {
                mv.visitLdcInsn((Object)declaringClass);
                mv.visitMethodInsn(184, CLASS, "forName", DESC_FORNAME, FALSE.booleanValue());
                mv.visitVarInsn(58, ++varIndex);
                declaringClassIndex = varIndex;
                mv.visitVarInsn(25, declaringClassIndex);
                mv.visitVarInsn(25, lookupIndex);
                mv.visitMethodInsn(184, METHOD_HANDLES, "privateLookupIn", DESC_PRIVATE_LOOKUP, FALSE.booleanValue());
                mv.visitVarInsn(58, lookupIndex);
            }
            mv.visitIntInsn(16, method.getParameterCount());
            mv.visitTypeInsn(189, CLASS);
            mv.visitVarInsn(58, ++varIndex);
            int paramsIndex = varIndex;
            for (int j = 0; j < method.getParameterCount(); ++j) {
                mv.visitVarInsn(25, paramsIndex);
                mv.visitIntInsn(16, j);
                this.autoboxFieldIfNeeded(method.getParameter(j), mv);
                mv.visitVarInsn(58, varIndex + 1 + j);
                mv.visitVarInsn(25, varIndex + 1 + j);
                mv.visitInsn(83);
            }
            varIndex = varIndex + method.getParameterCount() + 1;
            mv.visitVarInsn(25, declaringClassIndex);
            mv.visitLdcInsn((Object)methodName);
            mv.visitVarInsn(25, paramsIndex);
            mv.visitMethodInsn(182, CLASS, "getDeclaredMethod", DESC_GET_DECLARED_METHOD, FALSE.booleanValue());
            mv.visitVarInsn(58, ++varIndex);
            mv.visitVarInsn(25, varIndex);
            mv.visitInsn(4);
            mv.visitMethodInsn(182, METHOD, SET_ACCESSIBLE, "(Z)V", FALSE.booleanValue());
            mv.visitVarInsn(25, lookupIndex);
            mv.visitVarInsn(25, varIndex);
            mv.visitMethodInsn(182, LOOKUP, "unreflect", DESC_UNREFLECT, FALSE.booleanValue());
            mv.visitFieldInsn(179, internalClassName, "MH_" + i, AbstractQpidTransformer.referenceName(METHOD_HANDLE));
            previousClassName = declaringClass;
        }
        mv.visitLabel(tryEnd);
        mv.visitInsn(177);
        this.visitCatchBlock("Failed to initialize getters for " + className, catchStart, varIndex, mv);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void visitCatchBlock(String errorMessage, Label catchStart, int varIndex, MethodVisitor mv) {
        mv.visitLabel(catchStart);
        mv.visitFrame(4, 0, null, 1, new Object[]{THROWABLE});
        mv.visitVarInsn(58, varIndex);
        mv.visitTypeInsn(187, SSRE);
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)errorMessage);
        mv.visitVarInsn(25, varIndex);
        mv.visitMethodInsn(183, SSRE, INIT, DESC_EXCEPTION2, FALSE.booleanValue());
        mv.visitInsn(191);
        Label catchEnd = new Label();
        mv.visitLabel(catchEnd);
        mv.visitLocalVariable("throwable", AbstractQpidTransformer.referenceName(THROWABLE), null, catchStart, catchEnd, varIndex);
    }

    protected void autoboxFieldIfNeeded(String type, MethodVisitor visitor) {
        if (TYPES.containsKey(type) && !TYPE_VOID.equals(type)) {
            visitor.visitFieldInsn(178, TYPES.get(type).get(), TYPE, AbstractQpidTransformer.referenceName(CLASS));
        } else {
            visitor.visitLdcInsn((Object)Type.getType((String)this.autoboxType(type)));
        }
    }

    protected void autoboxIfNeeded(String in, String out, MethodVisitor visitor) {
        this.unboxOrAutobox(in, out, TYPE_BOOLEAN, "booleanValue", visitor);
        this.unboxOrAutobox(in, out, TYPE_BYTE, "byteValue", visitor);
        this.unboxOrAutobox(in, out, TYPE_CHARACTER, "charValue", visitor);
        this.unboxOrAutobox(in, out, TYPE_DOUBLE, "doubleValue", visitor);
        this.unboxOrAutobox(in, out, TYPE_FLOAT, "floatValue", visitor);
        this.unboxOrAutobox(in, out, TYPE_INT, "intValue", visitor);
        this.unboxOrAutobox(in, out, TYPE_LONG, "longValue", visitor);
        this.unboxOrAutobox(in, out, TYPE_SHORT, "shortValue", visitor);
    }

    private void unboxOrAutobox(String in, String out, String type, String name, MethodVisitor methodVisitor) {
        String wrapper = TYPES.get(type).get();
        if (wrapper.equals(in) && type.equals(out)) {
            methodVisitor.visitMethodInsn(182, wrapper, name, "()" + type, FALSE.booleanValue());
        } else if (type.equals(in) && wrapper.equals(out)) {
            String desc = "(" + type + ")L" + wrapper + ";";
            methodVisitor.visitMethodInsn(184, wrapper, VALUE_OF, desc, FALSE.booleanValue());
        }
    }

    protected String autoboxType(String unboxed) {
        return TYPES.getOrDefault(unboxed, () -> AbstractQpidTransformer.referenceName(unboxed)).get();
    }

    protected Map<String, AttributeStackAddress> createAttributesStackMap(List<? extends MemberDescription> methods) {
        return methods.stream().collect(Collectors.toMap(MemberDescription::getSignature, method -> new AttributeStackAddress(method.getSignature().hashCode()), (key1, key2) -> key2));
    }

    protected void fillHashesAndLabels(Map<String, AttributeStackAddress> stackMap, int[] hashes, Label[] switchJumpLabels) {
        ArrayList<AttributeStackAddress> stackAddresses = new ArrayList<AttributeStackAddress>(stackMap.values());
        Collections.sort(stackAddresses);
        for (int i = 0; i < stackAddresses.size(); ++i) {
            AttributeStackAddress propertyStackAddress = (AttributeStackAddress)stackAddresses.get(i);
            hashes[i] = propertyStackAddress.getHash();
            switchJumpLabels[i] = propertyStackAddress.getLabel();
        }
    }

    protected static void generateSignature(MethodVisitor mv, int methodIndex, String internalClassName, String signatureField) {
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, STRING_BUILDER);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, STRING_BUILDER, INIT, "()V", FALSE.booleanValue());
        mv.visitVarInsn(25, methodIndex);
        mv.visitMethodInsn(182, METHOD, GET_DECLARING_CLASS, DESC_GET_CLASS, FALSE.booleanValue());
        mv.visitMethodInsn(182, CLASS, GET_CANONICAL_NAME, DESC_GET_STRING, FALSE.booleanValue());
        mv.visitMethodInsn(182, STRING_BUILDER, APPEND, DESC_APPEND, FALSE.booleanValue());
        mv.visitLdcInsn((Object)"#");
        mv.visitMethodInsn(182, STRING_BUILDER, APPEND, DESC_APPEND, FALSE.booleanValue());
        mv.visitVarInsn(25, methodIndex);
        mv.visitMethodInsn(182, METHOD, GET_NAME, DESC_GET_STRING, FALSE.booleanValue());
        mv.visitMethodInsn(182, STRING_BUILDER, APPEND, DESC_APPEND, FALSE.booleanValue());
        mv.visitVarInsn(25, methodIndex);
        mv.visitMethodInsn(182, METHOD, GET_PARAM_TYPES, DESC_GET_PARAM_TYPES, FALSE.booleanValue());
        mv.visitMethodInsn(184, ARRAYS, METHOD_STREAM, DESC_STREAM, FALSE.booleanValue());
        mv.visitInvokeDynamicInsn(APPLY, DESC_APPLY, HANDLE_LAMBDAMETAFACTORY, new Object[]{TYPE_LAMBDAMETAFACTORY, HANDLE_GET_SIMPLE_NAME, TYPE_GET_SIMPLE_NAME});
        mv.visitMethodInsn(185, STREAM, METHOD_MAP, DESC_MAP, TRUE.booleanValue());
        mv.visitMethodInsn(184, COLLECTORS, JOINING, DESC_JOINING, FALSE.booleanValue());
        mv.visitMethodInsn(185, STREAM, COLLECT, DESC_COLLECT, TRUE.booleanValue());
        mv.visitTypeInsn(192, STRING);
        mv.visitMethodInsn(182, STRING_BUILDER, APPEND, DESC_APPEND, FALSE.booleanValue());
        mv.visitMethodInsn(182, STRING_BUILDER, TO_STRING, DESC_GET_STRING, FALSE.booleanValue());
        mv.visitFieldInsn(181, internalClassName, signatureField, AbstractQpidTransformer.referenceName(STRING));
    }

    protected static void generateHashCode(MethodVisitor mv, String internalClassName, String signatureField, String hashCodeField) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalClassName, signatureField, AbstractQpidTransformer.referenceName(STRING));
        mv.visitMethodInsn(182, STRING, HASHCODE, DESC_HASHCODE, FALSE.booleanValue());
        mv.visitFieldInsn(181, internalClassName, hashCodeField, TYPE_INT);
    }

    protected static class AttributeStackAddress
    implements Comparable<AttributeStackAddress> {
        private final Label label = new Label();
        private final int hash;

        private AttributeStackAddress(int hash) {
            this.hash = hash;
        }

        protected Label getLabel() {
            return this.label;
        }

        private int getHash() {
            return this.hash;
        }

        @Override
        public int compareTo(AttributeStackAddress attributeStackAddress) {
            return Integer.compare(this.hash, attributeStackAddress.hash);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeStackAddress that = (AttributeStackAddress)o;
            return this.hash == that.hash;
        }

        public int hashCode() {
            return Objects.hash(this.hash);
        }
    }

    protected static class ConstructorTransformer
    extends MethodVisitor {
        private final String _internalClassName;
        private final int _methodIndex;

        protected ConstructorTransformer(MethodVisitor delegate, String internalClassName, int methodIndex) {
            super(589824, delegate);
            this._internalClassName = internalClassName;
            this._methodIndex = methodIndex;
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                AbstractQpidTransformer.generateSignature(this.mv, this._methodIndex, this._internalClassName, AbstractQpidTransformer.FIELD_SIGNATURE);
                AbstractQpidTransformer.generateHashCode(this.mv, this._internalClassName, AbstractQpidTransformer.FIELD_SIGNATURE, AbstractQpidTransformer.FIELD_HASHCODE);
            }
            super.visitInsn(opcode);
        }
    }
}

