/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.Objects;

public final class ClassUtils {
    private static final Double DOUBLE_DEFAULT = 0.0;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);

    private ClassUtils() {
    }

    public static <T> T defaultValue(Class<T> type) {
        Objects.requireNonNull(type);
        if (type.isPrimitive()) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            if (Character.TYPE == type) {
                return (T)Character.valueOf('\u0000');
            }
            if (Byte.TYPE == type) {
                return (T)Byte.valueOf((byte)0);
            }
            if (Short.TYPE == type) {
                return (T)Short.valueOf((short)0);
            }
            if (Integer.TYPE == type) {
                return (T)Integer.valueOf(0);
            }
            if (Long.TYPE == type) {
                return (T)Long.valueOf(0L);
            }
            if (Float.TYPE == type) {
                return (T)FLOAT_DEFAULT;
            }
            if (Double.TYPE == type) {
                return (T)DOUBLE_DEFAULT;
            }
        }
        return null;
    }
}

