/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.protocol.v1_0.MessageMetaDataType_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequenceSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValueSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationPropertiesSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DataSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeliveryAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.FooterSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.HeaderSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.PropertiesSection;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetaData_1_0
implements StorableMessageMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageMetaData_1_0.class);
    private static final MessageMetaDataType_1_0 TYPE = new MessageMetaDataType_1_0();
    public static final MessageMetaDataType.Factory<MessageMetaData_1_0> FACTORY = new MetaDataFactory();
    private static final byte VERSION_BYTE = 1;
    private final long _contentSize;
    private static final Symbol DELIVERY_TIME = Symbol.valueOf("x-opt-delivery-time");
    private static final Symbol NOT_VALID_BEFORE = Symbol.valueOf("x-qpid-not-valid-before");
    private HeaderSection _headerSection;
    private PropertiesSection _propertiesSection;
    private DeliveryAnnotationsSection _deliveryAnnotationsSection;
    private MessageAnnotationsSection _messageAnnotationsSection;
    private ApplicationPropertiesSection _applicationPropertiesSection;
    private FooterSection _footerSection;
    private final MessageHeader_1_0 _messageHeader = new MessageHeader_1_0();
    private final int _version;
    private final long _arrivalTime;

    public MessageMetaData_1_0(HeaderSection headerSection, DeliveryAnnotationsSection deliveryAnnotationsSection, MessageAnnotationsSection messageAnnotationsSection, PropertiesSection propertiesSection, ApplicationPropertiesSection applicationPropertiesSection, FooterSection footerSection, long arrivalTime, long contentSize) {
        this(headerSection, deliveryAnnotationsSection, messageAnnotationsSection, propertiesSection, applicationPropertiesSection, footerSection, arrivalTime, contentSize, 1);
    }

    public MessageMetaData_1_0(HeaderSection headerSection, DeliveryAnnotationsSection deliveryAnnotationsSection, MessageAnnotationsSection messageAnnotationsSection, PropertiesSection propertiesSection, ApplicationPropertiesSection applicationPropertiesSection, FooterSection footerSection, long arrivalTime, long contentSize, int version) {
        this._headerSection = headerSection;
        this._deliveryAnnotationsSection = deliveryAnnotationsSection;
        this._messageAnnotationsSection = messageAnnotationsSection;
        this._propertiesSection = propertiesSection;
        this._applicationPropertiesSection = applicationPropertiesSection;
        this._footerSection = footerSection;
        this._arrivalTime = arrivalTime;
        this._contentSize = contentSize;
        this._version = version;
    }

    private MessageMetaData_1_0(List<EncodingRetainingSection<?>> sections, long contentSize, int version, long arrivalTime) {
        EncodingRetainingSection<?> section;
        this._contentSize = contentSize;
        this._version = version;
        this._arrivalTime = arrivalTime;
        Iterator<EncodingRetainingSection<?>> sectIter = sections.iterator();
        EncodingRetainingSection<?> encodingRetainingSection = section = sectIter.hasNext() ? sectIter.next() : null;
        if (section instanceof HeaderSection) {
            this._headerSection = (HeaderSection)section;
            EncodingRetainingSection<?> encodingRetainingSection2 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof DeliveryAnnotationsSection) {
            this._deliveryAnnotationsSection = (DeliveryAnnotationsSection)section;
            EncodingRetainingSection<?> encodingRetainingSection3 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof MessageAnnotationsSection) {
            this._messageAnnotationsSection = (MessageAnnotationsSection)section;
            EncodingRetainingSection<?> encodingRetainingSection4 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof PropertiesSection) {
            this._propertiesSection = (PropertiesSection)section;
            EncodingRetainingSection<?> encodingRetainingSection5 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof ApplicationPropertiesSection) {
            this._applicationPropertiesSection = (ApplicationPropertiesSection)section;
            EncodingRetainingSection<?> encodingRetainingSection6 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof FooterSection) {
            this._footerSection = (FooterSection)section;
            section = sectIter.hasNext() ? sectIter.next() : null;
        }
    }

    public Properties getProperties() {
        return this._propertiesSection == null ? null : (Properties)this._propertiesSection.getValue();
    }

    public PropertiesSection getPropertiesSection() {
        return this._propertiesSection == null ? null : this._propertiesSection.copy();
    }

    public MessageMetaDataType getType() {
        return TYPE;
    }

    public int getStorableSize() {
        long size = 17L;
        if (this._headerSection != null) {
            size += this._headerSection.getEncodedSize();
        }
        if (this._deliveryAnnotationsSection != null) {
            size += this._deliveryAnnotationsSection.getEncodedSize();
        }
        if (this._messageAnnotationsSection != null) {
            size += this._messageAnnotationsSection.getEncodedSize();
        }
        if (this._propertiesSection != null) {
            size += this._propertiesSection.getEncodedSize();
        }
        if (this._applicationPropertiesSection != null) {
            size += this._applicationPropertiesSection.getEncodedSize();
        }
        if (this._footerSection != null) {
            size += this._footerSection.getEncodedSize();
        }
        return (int)size;
    }

    public void writeToBuffer(QpidByteBuffer dest) {
        dest.put((byte)1);
        dest.putLong(this._arrivalTime);
        dest.putLong(this._contentSize);
        if (this._headerSection != null) {
            this._headerSection.writeTo(dest);
        }
        if (this._deliveryAnnotationsSection != null) {
            this._deliveryAnnotationsSection.writeTo(dest);
        }
        if (this._messageAnnotationsSection != null) {
            this._messageAnnotationsSection.writeTo(dest);
        }
        if (this._propertiesSection != null) {
            this._propertiesSection.writeTo(dest);
        }
        if (this._applicationPropertiesSection != null) {
            this._applicationPropertiesSection.writeTo(dest);
        }
        if (this._footerSection != null) {
            this._footerSection.writeTo(dest);
        }
    }

    public int getContentSize() {
        return (int)this._contentSize;
    }

    public boolean isPersistent() {
        return this._headerSection != null && Boolean.TRUE.equals(((Header)this._headerSection.getValue()).getDurable());
    }

    public MessageHeader_1_0 getMessageHeader() {
        return this._messageHeader;
    }

    public synchronized void dispose() {
        if (this._headerSection != null) {
            this._headerSection.dispose();
            this._headerSection = null;
        }
        if (this._deliveryAnnotationsSection != null) {
            this._deliveryAnnotationsSection.dispose();
            this._deliveryAnnotationsSection = null;
        }
        if (this._messageAnnotationsSection != null) {
            this._messageAnnotationsSection.dispose();
            this._messageAnnotationsSection = null;
        }
        if (this._propertiesSection != null) {
            this._propertiesSection.dispose();
            this._propertiesSection = null;
        }
        if (this._applicationPropertiesSection != null) {
            this._applicationPropertiesSection.dispose();
            this._applicationPropertiesSection = null;
        }
        if (this._footerSection != null) {
            this._footerSection.dispose();
            this._footerSection = null;
        }
    }

    public void reallocate() {
        if (this._headerSection != null) {
            this._headerSection.reallocate();
        }
        if (this._deliveryAnnotationsSection != null) {
            this._deliveryAnnotationsSection.reallocate();
        }
        if (this._messageAnnotationsSection != null) {
            this._messageAnnotationsSection.reallocate();
        }
        if (this._propertiesSection != null) {
            this._propertiesSection.reallocate();
        }
        if (this._applicationPropertiesSection != null) {
            this._applicationPropertiesSection.reallocate();
        }
        if (this._footerSection != null) {
            this._footerSection.reallocate();
        }
    }

    public void clearEncodedForm() {
        if (this._headerSection != null) {
            this._headerSection.clearEncodedForm();
        }
        if (this._deliveryAnnotationsSection != null) {
            this._deliveryAnnotationsSection.clearEncodedForm();
        }
        if (this._messageAnnotationsSection != null) {
            this._messageAnnotationsSection.clearEncodedForm();
        }
        if (this._propertiesSection != null) {
            this._propertiesSection.clearEncodedForm();
        }
        if (this._applicationPropertiesSection != null) {
            this._applicationPropertiesSection.clearEncodedForm();
        }
        if (this._footerSection != null) {
            this._footerSection.clearEncodedForm();
        }
    }

    public HeaderSection getHeaderSection() {
        return this._headerSection == null ? null : this._headerSection.copy();
    }

    public DeliveryAnnotationsSection getDeliveryAnnotationsSection() {
        return this._deliveryAnnotationsSection == null ? null : this._deliveryAnnotationsSection.copy();
    }

    public MessageAnnotationsSection getMessageAnnotationsSection() {
        return this._messageAnnotationsSection == null ? null : this._messageAnnotationsSection.copy();
    }

    public ApplicationPropertiesSection getApplicationPropertiesSection() {
        return this._applicationPropertiesSection == null ? null : this._applicationPropertiesSection.copy();
    }

    public FooterSection getFooterSection() {
        return this._footerSection == null ? null : this._footerSection.copy();
    }

    public int getVersion() {
        return this._version;
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public class MessageHeader_1_0
    implements AMQMessageHeader {
        private final AtomicReference<String> _decodedUserId = new AtomicReference();

        public String getCorrelationId() {
            if (MessageMetaData_1_0.this._propertiesSection == null || ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getCorrelationId() == null) {
                return null;
            }
            return ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getCorrelationId().toString();
        }

        public long getExpiration() {
            UnsignedInteger ttl = MessageMetaData_1_0.this._headerSection == null ? null : ((Header)MessageMetaData_1_0.this._headerSection.getValue()).getTtl();
            return ttl == null ? 0L : ttl.longValue() + MessageMetaData_1_0.this.getArrivalTime();
        }

        public String getMessageId() {
            if (MessageMetaData_1_0.this._propertiesSection == null || ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getMessageId() == null) {
                return null;
            }
            return ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getMessageId().toString();
        }

        public String getMimeType() {
            if (MessageMetaData_1_0.this._propertiesSection == null || ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getContentType() == null) {
                return null;
            }
            return ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getContentType().toString();
        }

        public String getEncoding() {
            if (MessageMetaData_1_0.this._propertiesSection == null || ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getContentEncoding() == null) {
                return null;
            }
            return ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getContentEncoding().toString();
        }

        public byte getPriority() {
            if (MessageMetaData_1_0.this._headerSection == null || ((Header)MessageMetaData_1_0.this._headerSection.getValue()).getPriority() == null) {
                return 4;
            }
            return ((Header)MessageMetaData_1_0.this._headerSection.getValue()).getPriority().byteValue();
        }

        public long getTimestamp() {
            if (MessageMetaData_1_0.this._propertiesSection == null || ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getCreationTime() == null) {
                return 0L;
            }
            return ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getCreationTime().getTime();
        }

        public long getNotValidBefore() {
            Object annotation;
            long notValidBefore = MessageMetaData_1_0.this._messageAnnotationsSection != null && (annotation = ((Map)MessageMetaData_1_0.this._messageAnnotationsSection.getValue()).get(DELIVERY_TIME)) instanceof Number ? ((Number)annotation).longValue() : (MessageMetaData_1_0.this._messageAnnotationsSection != null && (annotation = ((Map)MessageMetaData_1_0.this._messageAnnotationsSection.getValue()).get(NOT_VALID_BEFORE)) instanceof Number ? ((Number)annotation).longValue() : 0L);
            return notValidBefore;
        }

        public String getType() {
            return this.getSubject();
        }

        public String getReplyTo() {
            if (MessageMetaData_1_0.this._propertiesSection == null || ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getReplyTo() == null) {
                return null;
            }
            return ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getReplyTo();
        }

        public String getAppId() {
            return null;
        }

        public String getGroupId() {
            if (MessageMetaData_1_0.this._propertiesSection == null || ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getGroupId() == null) {
                return null;
            }
            return ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getGroupId();
        }

        public String getUserId() {
            if (MessageMetaData_1_0.this._propertiesSection == null || ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getUserId() == null) {
                return null;
            }
            if (this._decodedUserId.get() == null) {
                Binary encodededUserId = ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getUserId();
                this._decodedUserId.set(new String(encodededUserId.getArray(), StandardCharsets.UTF_8));
            }
            return this._decodedUserId.get();
        }

        public Object getHeader(String name) {
            return MessageMetaData_1_0.this._applicationPropertiesSection == null ? null : ((Map)MessageMetaData_1_0.this._applicationPropertiesSection.getValue()).get(name);
        }

        public boolean containsHeaders(Set<String> names) {
            if (MessageMetaData_1_0.this._applicationPropertiesSection == null) {
                return false;
            }
            for (String key : names) {
                if (((Map)MessageMetaData_1_0.this._applicationPropertiesSection.getValue()).containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public Collection<String> getHeaderNames() {
            if (MessageMetaData_1_0.this._applicationPropertiesSection == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableCollection(((Map)MessageMetaData_1_0.this._applicationPropertiesSection.getValue()).keySet());
        }

        public boolean containsHeader(String name) {
            return MessageMetaData_1_0.this._applicationPropertiesSection != null && ((Map)MessageMetaData_1_0.this._applicationPropertiesSection.getValue()).containsKey(name);
        }

        public String getSubject() {
            return MessageMetaData_1_0.this._propertiesSection == null ? null : ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getSubject();
        }

        public String getTo() {
            return MessageMetaData_1_0.this._propertiesSection == null ? null : ((Properties)MessageMetaData_1_0.this._propertiesSection.getValue()).getTo();
        }

        public Map<String, Object> getHeadersAsMap() {
            return MessageMetaData_1_0.this._applicationPropertiesSection == null ? new HashMap<String, Object>() : new HashMap((Map)MessageMetaData_1_0.this._applicationPropertiesSection.getValue());
        }
    }

    private static class MetaDataFactory
    implements MessageMetaDataType.Factory<MessageMetaData_1_0> {
        private final AMQPDescribedTypeRegistry _typeRegistry = AMQPDescribedTypeRegistry.newInstance();

        private MetaDataFactory() {
            this._typeRegistry.registerTransportLayer();
            this._typeRegistry.registerMessagingLayer();
            this._typeRegistry.registerTransactionLayer();
            this._typeRegistry.registerSecurityLayer();
        }

        public MessageMetaData_1_0 createMetaData(QpidByteBuffer buf) {
            try {
                long arrivalTime;
                if (!buf.hasRemaining()) {
                    throw new ConnectionScopedRuntimeException("No metadata found");
                }
                byte versionByte = buf.get(buf.position());
                long contentSize = 0L;
                if (versionByte == 1) {
                    if (!buf.hasRemaining(17)) {
                        throw new ConnectionScopedRuntimeException("Cannot decode stored message meta data.");
                    }
                    buf.get();
                    arrivalTime = buf.getLong();
                    contentSize = buf.getLong();
                } else if (versionByte == 0) {
                    arrivalTime = System.currentTimeMillis();
                } else {
                    throw new ConnectionScopedRuntimeException(String.format("Unexpected version byte %d encountered at head of metadata. Unable to decode message.", versionByte));
                }
                SectionDecoderImpl sectionDecoder = new SectionDecoderImpl(this._typeRegistry.getSectionDecoderRegistry());
                List<EncodingRetainingSection<?>> sections = sectionDecoder.parseAll(buf);
                if (versionByte == 0) {
                    Iterator<EncodingRetainingSection<?>> iter = sections.iterator();
                    while (iter.hasNext()) {
                        EncodingRetainingSection<?> section = iter.next();
                        if (!(section instanceof DataSection) && !(section instanceof AmqpValueSection) && !(section instanceof AmqpSequenceSection)) continue;
                        contentSize += section.getEncodedSize();
                        iter.remove();
                        section.dispose();
                    }
                }
                return new MessageMetaData_1_0(sections, contentSize, versionByte & 0xFF, arrivalTime);
            }
            catch (AmqpErrorException e) {
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
        }
    }
}

