/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.store.StoreException;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

public class MapBinding
extends TupleBinding<Map<String, Object>> {
    private static final MapBinding INSTANCE = new MapBinding();

    public static MapBinding getInstance() {
        return INSTANCE;
    }

    public Map<String, Object> entryToObject(TupleInput input) {
        String json = input.readString();
        ObjectMapper mapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)true);
        try {
            Map value = (Map)mapper.readValue(json, Map.class);
            return value;
        }
        catch (JacksonException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public void objectToEntry(Map<String, Object> map, TupleOutput output) {
        try {
            StringWriter writer = new StringWriter();
            ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)true);
            objectMapper.writeValue((Writer)writer, map);
            output.writeString(writer.toString());
        }
        catch (JacksonException e) {
            throw new StoreException((Throwable)e);
        }
    }
}

