/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.BiConsumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.management.plugin.DojoHelper;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementControllerFactory;
import org.apache.qpid.server.management.plugin.filter.AuthenticationCheckFilter;
import org.apache.qpid.server.management.plugin.filter.ExceptionHandlingFilter;
import org.apache.qpid.server.management.plugin.filter.InteractiveAuthenticationFilter;
import org.apache.qpid.server.management.plugin.filter.LoggingFilter;
import org.apache.qpid.server.management.plugin.filter.MethodFilter;
import org.apache.qpid.server.management.plugin.filter.RedirectFilter;
import org.apache.qpid.server.management.plugin.filter.RewriteRequestForUncompressedJavascript;
import org.apache.qpid.server.management.plugin.servlet.ContentServlet;
import org.apache.qpid.server.management.plugin.servlet.FileServlet;
import org.apache.qpid.server.management.plugin.servlet.RootServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.ApiDocsServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.BrokerQueryServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.JsonValueServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.LogoutServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.MetaDataServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.QueueReportServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.RestServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.SaslServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.StructureServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.TimeZoneServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.VirtualHostQueryServlet;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.adapter.AbstractPluginAdapter;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.model.port.PortManager;
import org.apache.qpid.server.plugin.ContentFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.transport.PortBindFailureException;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.DaemonThreadFactory;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.eclipse.jetty.ee11.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee11.servlet.FilterHolder;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.rewrite.handler.CompactPathRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.CrossOriginHandler;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;

@ManagedObject(category=false, type="MANAGEMENT-HTTP")
public class HttpManagement
extends AbstractPluginAdapter<HttpManagement>
implements HttpManagementConfiguration<HttpManagement>,
PortManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpManagement.class);
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 60;
    public static final String TIME_OUT = "sessionTimeout";
    public static final String HTTP_BASIC_AUTHENTICATION_ENABLED = "httpBasicAuthenticationEnabled";
    public static final String HTTPS_BASIC_AUTHENTICATION_ENABLED = "httpsBasicAuthenticationEnabled";
    public static final String HTTP_SASL_AUTHENTICATION_ENABLED = "httpSaslAuthenticationEnabled";
    public static final String HTTPS_SASL_AUTHENTICATION_ENABLED = "httpsSaslAuthenticationEnabled";
    public static final String PLUGIN_TYPE = "MANAGEMENT-HTTP";
    public static final String DEFAULT_LOGOUT_URL = "/logout.html";
    public static final String DEFAULT_LOGIN_URL = "/index.html";
    private static final String OPERATIONAL_LOGGING_NAME = "Web";
    private static final String JSESSIONID_COOKIE_PREFIX = "JSESSIONID_";
    private static final String[] STATIC_FILE_TYPES = new String[]{"*.js", "*.css", "*.html", "*.png", "*.gif", "*.jpg", "*.jpeg", "*.json", "*.txt", "*.xsl", "*.svg"};
    private Server _server;
    @ManagedAttributeField
    private boolean _httpsSaslAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpSaslAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpsBasicAuthenticationEnabled;
    @ManagedAttributeField
    private boolean _httpBasicAuthenticationEnabled;
    @ManagedAttributeField
    private int _sessionTimeout;
    @ManagedAttributeField
    public Set<String> _corsAllowOrigins;
    @ManagedAttributeField
    public Set<String> _corsAllowMethods;
    @ManagedAttributeField
    public Set<String> _corsAllowHeaders;
    @ManagedAttributeField
    public Set<String> _allowedResponseHeaders;
    @ManagedAttributeField
    public boolean _corsAllowCredentials;
    @ManagedAttributeField
    private boolean _compressResponses;
    @ManagedAttributeField
    private boolean _useLegacyUriCompliance;
    private final Map<HttpPort<?>, ServerConnector> _portConnectorMap = new ConcurrentHashMap();
    private final Map<HttpPort<?>, SslContextFactory.Server> _sslContextFactoryMap = new ConcurrentHashMap();
    private final BrokerChangeListener _brokerChangeListener = new BrokerChangeListener();
    private final Thread.UncaughtExceptionHandler _uncaughtExceptionHandler = new JettyUncaughtExceptionHandler();
    private final ThreadGroup _threadGroup = new JettyThreadGroup("Jetty-ThreadGroup", this._uncaughtExceptionHandler);
    private volatile boolean _serveUncompressedDojo;
    private volatile Long _saslExchangeExpiry;
    private volatile ScheduledThreadPoolExecutor _jettyServerExecutor;
    private volatile ScheduledThreadPoolExecutor _jettySchedulerExecutor;

    @ManagedObjectFactoryConstructor
    public HttpManagement(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    protected void onOpen() {
        super.onOpen();
        this._serveUncompressedDojo = Boolean.TRUE.equals(this.getContextValue(Boolean.class, "qpid.httpManagement.serveUncompressedDojo"));
        this._saslExchangeExpiry = (Long)this.getContextValue(Long.class, "qpid.httpManagement.saslExchangeExpiry");
        this.getBroker().addChangeListener((ConfigurationChangeListener)this._brokerChangeListener);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> doStart() {
        Collection<HttpPort<?>> httpPorts = this.getEligibleHttpPorts(this.getBroker().getPorts());
        if (httpPorts.isEmpty()) {
            LOGGER.warn("HttpManagement plugin is configured but no suitable HTTP ports are available.");
        } else {
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.STARTUP((CharSequence)OPERATIONAL_LOGGING_NAME));
            this._server = this.createServer(httpPorts);
            try {
                this._server.start();
                this.logOperationalListenMessages();
            }
            catch (PortBindFailureException e) {
                this.getBroker().getEventLogger().message(PortMessages.BIND_FAILED((CharSequence)"HTTP", (Number)e.getAddress().getPort()));
                throw e;
            }
            catch (Exception e) {
                throw new ServerScopedRuntimeException("Failed to start HTTP management on ports : " + String.valueOf(httpPorts), (Throwable)e);
            }
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.READY((CharSequence)OPERATIONAL_LOGGING_NAME));
        }
        this.setState(State.ACTIVE);
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onClose() {
        this.getBroker().removeChangeListener((ConfigurationChangeListener)this._brokerChangeListener);
        if (this._server != null) {
            try {
                this.logOperationalShutdownMessage();
                this._server.stop();
            }
            catch (Exception e) {
                throw new ServerScopedRuntimeException("Failed to stop HTTP management", (Throwable)e);
            }
        }
        if (this._jettyServerExecutor != null) {
            this._jettyServerExecutor.shutdown();
        }
        if (this._jettySchedulerExecutor != null) {
            this._jettySchedulerExecutor.shutdown();
        }
        this.getBroker().getEventLogger().message(ManagementConsoleMessages.STOPPED((CharSequence)OPERATIONAL_LOGGING_NAME));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public int getSessionTimeout() {
        return this._sessionTimeout;
    }

    @Override
    public Set<String> getCorsAllowOrigins() {
        return this._corsAllowOrigins;
    }

    @Override
    public Set<String> getCorsAllowMethods() {
        return this._corsAllowMethods;
    }

    @Override
    public Set<String> getCorsAllowHeaders() {
        return this._corsAllowHeaders;
    }

    @Override
    public Set<String> getAllowedResponseHeaders() {
        return this._allowedResponseHeaders;
    }

    @Override
    public boolean getCorsAllowCredentials() {
        return this._corsAllowCredentials;
    }

    private Server createServer(Collection<HttpPort<?>> ports) {
        LOGGER.debug("Starting up web server on {}", ports);
        DaemonThreadFactory serverThreadFactory = new DaemonThreadFactory("Jetty-Server-Thread", this._uncaughtExceptionHandler, this._threadGroup);
        this._jettyServerExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)serverThreadFactory);
        this._jettyServerExecutor.setRemoveOnCancelPolicy(true);
        DaemonThreadFactory schedulerThreadFactory = new DaemonThreadFactory("Jetty-Scheduler-Thread", this._uncaughtExceptionHandler, this._threadGroup);
        this._jettySchedulerExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)schedulerThreadFactory);
        this._jettySchedulerExecutor.setRemoveOnCancelPolicy(true);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler((ScheduledExecutorService)this._jettySchedulerExecutor);
        Server server = new Server((ThreadPool)new ExecutorThreadPool((ThreadPoolExecutor)this._jettyServerExecutor), (Scheduler)scheduler, null);
        int lastPort = -1;
        for (HttpPort<?> port : ports) {
            ServerConnector connector = this.createConnector(port, server);
            connector.addBean((Object)new ConnectionTrackingListener());
            server.addConnector((Connector)connector);
            this._portConnectorMap.put(port, connector);
            lastPort = port.getPort();
        }
        ContextHandlerCollection contextCollection = new ContextHandlerCollection(new ContextHandler[0]);
        RewriteHandler rewriteHandler = new RewriteHandler();
        rewriteHandler.setHandler((Handler)contextCollection);
        rewriteHandler.addRule((Rule)new CompactPathRule());
        CrossOriginHandler corsHandler = new CrossOriginHandler();
        corsHandler.setHandler((Handler)rewriteHandler);
        corsHandler.setAllowedOriginPatterns(this.getCorsAllowOrigins());
        corsHandler.setAllowedMethods(this.getCorsAllowMethods());
        corsHandler.setAllowedHeaders(this.getCorsAllowHeaders());
        corsHandler.setAllowCredentials(this.getCorsAllowCredentials());
        ServletContextHandler root = new ServletContextHandler("/", 1);
        root.setHandler((Handler)corsHandler);
        server.setHandler((Handler)root);
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler(){

            protected void writeErrorHtmlBody(Request request, Writer writer, int code, String message, Throwable cause) throws IOException {
                String uri = request.getHttpURI().toString();
                this.writeErrorHtmlMessage(request, writer, code, message, cause, uri);
                for (int i = 0; i < 20; ++i) {
                    writer.write("<br/>                                                \n");
                }
            }
        };
        root.setErrorHandler((Request.Handler)errorHandler);
        root.getServletContext().setAttribute("Qpid.broker", (Object)this.getBroker());
        root.getServletContext().setAttribute("Qpid.managementConfiguration", (Object)this);
        root.addFilter(new FilterHolder((Filter)new ExceptionHandlingFilter()), "/*", EnumSet.allOf(DispatcherType.class));
        root.addFilter(new FilterHolder((Filter)new MethodFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        this.addFiltersAndServletsForRest(root);
        if (!Boolean.TRUE.equals(this.getContextValue(Boolean.class, "qpid.httpManagement.disableUserInterface"))) {
            this.addFiltersAndServletsForUserInterfaces(root);
        }
        root.getSessionHandler().getSessionCookieConfig().setName(JSESSIONID_COOKIE_PREFIX + lastPort);
        root.getSessionHandler().getSessionCookieConfig().setHttpOnly(true);
        root.getSessionHandler().setMaxInactiveInterval(this.getSessionTimeout());
        if (this._useLegacyUriCompliance) {
            server.getContainedBeans(ServletHandler.class).forEach(handler -> handler.setDecodeAmbiguousURIs(true));
        }
        return server;
    }

    private void addFiltersAndServletsForRest(ServletContextHandler root) {
        FilterHolder loggingFilter = new FilterHolder((Filter)new LoggingFilter());
        root.addFilter(loggingFilter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(loggingFilter, "/service/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder restAuthorizationFilter = new FilterHolder((Filter)new AuthenticationCheckFilter());
        restAuthorizationFilter.setInitParameter("allowed", "/service/sasl");
        root.addFilter(restAuthorizationFilter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(restAuthorizationFilter, "/service/*", EnumSet.of(DispatcherType.REQUEST));
        this.addRestServlet(root);
        ServletHolder queryServlet = new ServletHolder((Servlet)new BrokerQueryServlet());
        root.addServlet(queryServlet, "/api/latest/querybroker/*");
        root.addServlet(queryServlet, "/api/v9.1/querybroker/*");
        ServletHolder vhQueryServlet = new ServletHolder((Servlet)new VirtualHostQueryServlet());
        root.addServlet(vhQueryServlet, "/api/latest/queryvhost/*");
        root.addServlet(vhQueryServlet, "/api/v9.1/queryvhost/*");
        root.addServlet(new ServletHolder((Servlet)new StructureServlet()), "/service/structure");
        root.addServlet(new ServletHolder((Servlet)new QueueReportServlet()), "/service/queuereport/*");
        root.addServlet(new ServletHolder((Servlet)new MetaDataServlet()), "/service/metadata");
        root.addServlet(new ServletHolder((Servlet)new TimeZoneServlet()), "/service/timezones");
        Iterable contentFactories = new QpidServiceLoader().instancesOf(ContentFactory.class);
        contentFactories.forEach(f -> {
            ServletHolder metricsServlet = new ServletHolder((Servlet)new ContentServlet((ContentFactory)f));
            String path = f.getType().toLowerCase();
            root.addServlet(metricsServlet, "/" + path);
            root.addServlet(metricsServlet, "/" + path + "/*");
            if (((Boolean)this.getContextValue(Boolean.class, "qpid.httpManagement.enableMetricContentAuthentication")).booleanValue()) {
                root.addFilter(restAuthorizationFilter, "/" + path, EnumSet.of(DispatcherType.REQUEST));
                root.addFilter(restAuthorizationFilter, "/" + path + "/*", EnumSet.of(DispatcherType.REQUEST));
            }
        });
    }

    private void addFiltersAndServletsForUserInterfaces(ServletContextHandler root) {
        root.addFilter(new FilterHolder((Filter)new AuthenticationCheckFilter()), "/apidocs/*", EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new InteractiveAuthenticationFilter()), DEFAULT_LOGIN_URL, EnumSet.of(DispatcherType.REQUEST));
        root.addFilter(new FilterHolder((Filter)new InteractiveAuthenticationFilter()), "/", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder redirectFilter = new FilterHolder((Filter)new RedirectFilter());
        redirectFilter.setInitParameter("redirect-uri", DEFAULT_LOGIN_URL);
        root.addFilter(redirectFilter, "/login.html", EnumSet.of(DispatcherType.REQUEST));
        if (this._serveUncompressedDojo) {
            root.addFilter(RewriteRequestForUncompressedJavascript.class, "/dojo/dojo/*", EnumSet.of(DispatcherType.REQUEST));
            root.addFilter(RewriteRequestForUncompressedJavascript.class, "/dojo/dojox/*", EnumSet.of(DispatcherType.REQUEST));
        }
        this.addApiDocsServlets(root);
        root.addServlet(new ServletHolder((Servlet)new SaslServlet()), "/service/sasl");
        root.addServlet(new ServletHolder((Servlet)new RootServlet("/", "/apidocs/", "index.html")), "/");
        root.addServlet(new ServletHolder((Servlet)new LogoutServlet()), "/logout");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDojoPath(), true)), "/dojo/dojo/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDijitPath(), true)), "/dojo/dijit/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDojoxPath(), true)), "/dojo/dojox/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDgridPath(), true)), "/dojo/dgrid/*");
        root.addServlet(new ServletHolder((Servlet)new FileServlet(DojoHelper.getDstorePath(), true)), "/dojo/dstore/*");
        for (String pattern : STATIC_FILE_TYPES) {
            root.addServlet(new ServletHolder((Servlet)new FileServlet()), pattern);
        }
    }

    private void addApiDocsServlets(ServletContextHandler root) {
        ApiDocsServlet apiDocsServlet = new ApiDocsServlet();
        ServletHolder apiDocsServletHolder = new ServletHolder((Servlet)apiDocsServlet);
        String version = "v9.1";
        for (String path : new String[]{"/apidocs", "/apidocs/latest", "/apidocs/v9.1"}) {
            root.addServlet(apiDocsServletHolder, path);
            root.addServlet(apiDocsServletHolder, path + "/");
        }
        this.getModel().getSupportedCategories().stream().map(Class::getSimpleName).map(String::toLowerCase).forEach(name -> {
            root.addServlet(apiDocsServletHolder, "/apidocs/latest/" + name + "/");
            root.addServlet(apiDocsServletHolder, "/apidocs/v9.1/" + name + "/");
            root.addServlet(apiDocsServletHolder, "/apidocs/latest/" + name);
            root.addServlet(apiDocsServletHolder, "/apidocs/v9.1/" + name);
        });
    }

    public int getBoundPort(HttpPort httpPort) {
        NetworkConnector networkConnector = (NetworkConnector)this._portConnectorMap.get(httpPort);
        return networkConnector != null ? networkConnector.getLocalPort() : -1;
    }

    public int getNumberOfAcceptors(HttpPort httpPort) {
        ServerConnector serverConnector = this._portConnectorMap.get(httpPort);
        return serverConnector != null ? serverConnector.getAcceptors() : -1;
    }

    public int getNumberOfSelectors(HttpPort httpPort) {
        ServerConnector serverConnector = this._portConnectorMap.get(httpPort);
        return serverConnector != null ? serverConnector.getSelectorManager().getSelectorCount() : -1;
    }

    public SSLContext getSSLContext(HttpPort httpPort) {
        SslContextFactory.Server sslContextFactory = this.getSslContextFactory(httpPort);
        return sslContextFactory != null ? sslContextFactory.getSslContext() : null;
    }

    public boolean updateSSLContext(HttpPort httpPort) {
        SslContextFactory.Server sslContextFactory = this.getSslContextFactory(httpPort);
        if (sslContextFactory == null) {
            return false;
        }
        try {
            SSLContext sslContext = this.createSslContext(httpPort);
            sslContextFactory.reload(sslContextFactory1 -> {
                SslContextFactory.Server server = (SslContextFactory.Server)sslContextFactory1;
                server.setSslContext(sslContext);
                server.setNeedClientAuth(httpPort.getNeedClientAuth());
                server.setWantClientAuth(httpPort.getWantClientAuth());
            });
            return true;
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Unexpected exception on reload of ssl context factory", (Throwable)e);
        }
    }

    private SslContextFactory.Server getSslContextFactory(HttpPort httpPort) {
        return this._sslContextFactoryMap.get(httpPort);
    }

    private ServerConnector createConnector(final HttpPort<?> port, Server server) {
        ConnectionFactory[] connectionFactories;
        port.setPortManager((PortManager)this);
        if (port.getState() != State.ACTIVE) {
            port.startAsync();
        }
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
        httpConnectionFactory.getHttpConfiguration().setSendServerVersion(false);
        httpConnectionFactory.getHttpConfiguration().setSendXPoweredBy(false);
        HttpConfiguration.Customizer requestAttributeCustomizer = (request, responseHeaders) -> {
            HttpManagementUtil.getPortAttributeAction(port).performAction((Object)request);
            return request;
        };
        httpConnectionFactory.getHttpConfiguration().addCustomizer(requestAttributeCustomizer);
        httpConnectionFactory.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        if (this._useLegacyUriCompliance) {
            Set<UriCompliance.Violation> violations = Set.of(UriCompliance.Violation.AMBIGUOUS_PATH_SEPARATOR, UriCompliance.Violation.AMBIGUOUS_PATH_ENCODING);
            UriCompliance uriCompliance = UriCompliance.from(violations);
            httpConnectionFactory.getHttpConfiguration().setUriCompliance(uriCompliance);
        }
        Set transports = port.getTransports();
        SslContextFactory.Server sslContextFactory = null;
        if (!transports.contains(Transport.SSL)) {
            connectionFactories = new ConnectionFactory[]{httpConnectionFactory};
        } else if (transports.contains(Transport.SSL)) {
            sslContextFactory = this.createSslContextFactory(port);
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, httpConnectionFactory.getProtocol());
            if (port.getTransports().contains(Transport.TCP)) {
                sslConnectionFactory = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{sslConnectionFactory});
            }
            connectionFactories = new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory};
        } else {
            throw new IllegalArgumentException("Unexpected transport on port " + port.getName() + ":" + String.valueOf(transports));
        }
        ServerConnector connector = new ServerConnector(server, (Executor)((Object)new QBBTrackingThreadPool(port.getThreadPoolMaximum(), port.getThreadPoolMinimum(), this._uncaughtExceptionHandler, this._threadGroup)), null, null, port.getDesiredNumberOfAcceptors(), port.getDesiredNumberOfSelectors(), connectionFactories){

            public void open() throws IOException {
                try {
                    super.open();
                }
                catch (BindException e) {
                    HttpManagement.this._sslContextFactoryMap.remove(port);
                    InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                    throw new PortBindFailureException(addr);
                }
            }
        };
        connector.setAcceptQueueSize(port.getAcceptBacklogSize());
        String bindingAddress = port.getBindingAddress();
        if (bindingAddress != null && !bindingAddress.trim().isEmpty() && !bindingAddress.trim().equals("*")) {
            connector.setHost(bindingAddress.trim());
        }
        connector.setPort(port.getPort());
        if (transports.contains(Transport.SSL)) {
            connector.addBean((Object)new SslHandshakeListener(){

                public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
                    SSLEngine sslEngine = event.getSSLEngine();
                    String hostname = sslEngine.getPeerHost();
                    int port = sslEngine.getPeerPort();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.info("TLS handshake failed: host='{}', port={}", new Object[]{hostname, port, failure});
                    } else {
                        LOGGER.info("TLS handshake failed: host='{}', port={}: {}", new Object[]{hostname, port, String.valueOf(failure)});
                    }
                }
            });
        }
        int acceptors = connector.getAcceptors();
        int selectors = connector.getSelectorManager().getSelectorCount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created connector for http port {} with maxThreads={}, minThreads={}, acceptors={}, selectors={}, acceptBacklog={}", new Object[]{port.getName(), port.getThreadPoolMaximum(), port.getThreadPoolMinimum(), acceptors, selectors, port.getAcceptBacklogSize()});
        }
        int requiredNumberOfConnections = acceptors + 2 * selectors + 1;
        if (port.getThreadPoolMaximum() < requiredNumberOfConnections) {
            throw new IllegalConfigurationException(String.format("Insufficient number of threads is configured on http port '%s': max=%d < needed(acceptors=%d + selectors=2*%d + request=1)", port.getName(), port.getThreadPoolMaximum(), acceptors, selectors));
        }
        if (sslContextFactory != null) {
            this._sslContextFactoryMap.put(port, sslContextFactory);
        }
        return connector;
    }

    private SslContextFactory.Server createSslContextFactory(final HttpPort<?> port) {
        SslContextFactory.Server factory = new SslContextFactory.Server(){

            public void customize(SSLEngine sslEngine) {
                super.customize(sslEngine);
                if (port.getTlsCipherSuiteAllowList() != null && !port.getTlsCipherSuiteAllowList().isEmpty()) {
                    SSLParameters sslParameters = sslEngine.getSSLParameters();
                    sslParameters.setUseCipherSuitesOrder(true);
                    sslEngine.setSSLParameters(sslParameters);
                }
                SSLUtil.updateEnabledCipherSuites((SSLEngine)sslEngine, (List)port.getTlsCipherSuiteAllowList(), (List)port.getTlsCipherSuiteDenyList());
                SSLUtil.updateEnabledTlsProtocols((SSLEngine)sslEngine, (List)port.getTlsProtocolAllowList(), (List)port.getTlsProtocolDenyList());
            }
        };
        factory.setSslContext(this.createSslContext(port));
        if (port.getNeedClientAuth()) {
            factory.setNeedClientAuth(true);
        } else if (port.getWantClientAuth()) {
            factory.setWantClientAuth(true);
        }
        return factory;
    }

    private SSLContext createSslContext(HttpPort<?> port) {
        KeyStore keyStore = port.getKeyStore();
        if (keyStore == null) {
            throw new IllegalConfigurationException("Key store is not configured. Cannot start management on HTTPS port without keystore");
        }
        boolean needClientCert = port.getNeedClientAuth() || port.getWantClientAuth();
        Collection trustStores = port.getTrustStores();
        if (needClientCert && trustStores.isEmpty()) {
            throw new IllegalConfigurationException(String.format("Client certificate authentication is enabled on HTTPS port '%s' but no trust store defined", this.getName()));
        }
        SSLContext sslContext = SSLUtil.createSslContext((KeyStore)port.getKeyStore(), (Collection)trustStores, (String)port.getName());
        SSLSessionContext serverSessionContext = sslContext.getServerSessionContext();
        if (port.getTLSSessionCacheSize() > 0) {
            serverSessionContext.setSessionCacheSize(port.getTLSSessionCacheSize());
        }
        if (port.getTLSSessionTimeout() > 0) {
            serverSessionContext.setSessionTimeout(port.getTLSSessionTimeout());
        }
        return sslContext;
    }

    private void addRestServlet(ServletContextHandler root) {
        ManagementControllerFactory factory;
        Map<String, ManagementControllerFactory> factories = ManagementControllerFactory.loadFactories();
        long maxFileSize = (Long)this.getContextValue(Long.class, "maxHttpFileUploadSize");
        int maxRequestSize = (Integer)this.getContextValue(Integer.class, "maxHttpFileUploadSize");
        ArrayList<Object> supportedVersions = new ArrayList<Object>();
        supportedVersions.add("latest");
        String currentVersion = "9.1";
        ManagementController managementController = null;
        do {
            if ((factory = factories.get(currentVersion)) == null) continue;
            managementController = factory.createManagementController(this, managementController);
            RestServlet managementServlet = new RestServlet();
            Collection<String> categories = managementController.getCategories();
            for (String category : categories) {
                String name = category.toLowerCase();
                String path = managementController.getCategoryMapping(name);
                ServletHolder servletHolder = new ServletHolder(path, (Servlet)managementServlet);
                servletHolder.setInitParameter("qpid.controller.version", managementController.getVersion());
                servletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement("", maxFileSize, -1L, maxRequestSize));
                root.addServlet(servletHolder, path + (path.endsWith("/") ? "*" : "/*"));
                if (!"9.1".equals(managementController.getVersion())) continue;
                root.addServlet(servletHolder, "/api/latest/" + name + "/*");
            }
            supportedVersions.add("v" + currentVersion);
            currentVersion = factory.getPreviousVersion();
        } while (factory != null);
        root.getServletContext().setAttribute("qpid.controller.chain", (Object)managementController);
        Map supported = Map.of("supportedVersions", supportedVersions);
        ServletHolder versionsServletHolder = new ServletHolder((Servlet)new JsonValueServlet(supported));
        root.addServlet(versionsServletHolder, "/api");
        root.addServlet(versionsServletHolder, "/api/");
    }

    private void logOperationalListenMessages() {
        for (Map.Entry<HttpPort<?>, ServerConnector> portConnector : this._portConnectorMap.entrySet()) {
            HttpPort<?> port = portConnector.getKey();
            NetworkConnector connector = (NetworkConnector)portConnector.getValue();
            this.logOperationalListenMessages(port, connector.getLocalPort());
        }
    }

    private void logOperationalListenMessages(HttpPort<?> port, int localPort) {
        Set transports = port.getTransports();
        for (Transport transport : transports) {
            this.getBroker().getEventLogger().message(ManagementConsoleMessages.LISTENING((CharSequence)Protocol.HTTP.name(), (CharSequence)transport.name(), (Number)localPort));
        }
    }

    private void logOperationalShutdownMessage() {
        for (NetworkConnector networkConnector : this._portConnectorMap.values()) {
            this.logOperationalShutdownMessage(networkConnector.getLocalPort());
        }
    }

    private void logOperationalShutdownMessage(int localPort) {
        this.getBroker().getEventLogger().message(ManagementConsoleMessages.SHUTTING_DOWN((CharSequence)Protocol.HTTP.name(), (Number)localPort));
    }

    private Collection<HttpPort<?>> getEligibleHttpPorts(Collection<Port<?>> ports) {
        HashSet<HttpPort> httpPorts = new HashSet<HttpPort>();
        for (Port<?> port : ports) {
            if (State.ACTIVE != port.getDesiredState() || State.ERRORED == port.getState() || !port.getProtocols().contains(Protocol.HTTP)) continue;
            httpPorts.add((HttpPort)port);
        }
        return Collections.unmodifiableCollection(httpPorts);
    }

    @Override
    public boolean isHttpsSaslAuthenticationEnabled() {
        return this._httpsSaslAuthenticationEnabled;
    }

    @Override
    public boolean isHttpSaslAuthenticationEnabled() {
        return this._httpSaslAuthenticationEnabled;
    }

    @Override
    public boolean isHttpsBasicAuthenticationEnabled() {
        return this._httpsBasicAuthenticationEnabled;
    }

    @Override
    public boolean isHttpBasicAuthenticationEnabled() {
        return this._httpBasicAuthenticationEnabled;
    }

    @Override
    public boolean isUseLegacyUriCompliance() {
        return this._useLegacyUriCompliance;
    }

    @Override
    public boolean isCompressResponses() {
        return this._compressResponses;
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider(HttpServletRequest request) {
        HttpPort<?> port = this.getPort(request);
        return port == null ? null : port.getAuthenticationProvider();
    }

    public static Set<String> getAllAvailableCorsMethodCombinations() {
        List<String> methods = List.of("OPTIONS", "HEAD", "GET", "POST", "PUT", "DELETE");
        HashSet combinations = new HashSet();
        int n = methods.size();
        assert (n < 31) : "Too many combination to calculate";
        for (int i = 0; i < 1 << n; ++i) {
            HashSet<String> currentCombination = new HashSet<String>();
            for (int index = 0; index < n; ++index) {
                if ((i & 1 << index) == 0) continue;
                currentCombination.add(methods.get(index));
            }
            combinations.add(currentCombination);
        }
        HashSet<String> combinationsAsString = new HashSet<String>(combinations.size());
        ObjectMapper mapper = new ObjectMapper();
        for (Set set : combinations) {
            try {
                combinationsAsString.add(mapper.writeValueAsString((Object)set));
            }
            catch (JacksonException e) {
                throw new IllegalArgumentException("Unexpected exception generating JSON string", e);
            }
        }
        return Collections.unmodifiableSet(combinationsAsString);
    }

    @Override
    public HttpPort<?> getPort(HttpServletRequest request) {
        return HttpManagementUtil.getPort(request);
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        HttpManagementConfiguration updated = (HttpManagementConfiguration)proxyForValidation;
        if (changedAttributes.contains("name") && !this.getName().equals(updated.getName())) {
            throw new IllegalConfigurationException("Changing the name of http management plugin is not allowed");
        }
        if (changedAttributes.contains(TIME_OUT) && updated.getSessionTimeout() < 0) {
            throw new IllegalConfigurationException("Only positive integer value can be specified for the session time out attribute");
        }
    }

    @Override
    public long getSaslExchangeExpiry() {
        return this._saslExchangeExpiry;
    }

    private class BrokerChangeListener
    extends AbstractConfigurationChangeListener {
        private BrokerChangeListener() {
        }

        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (child instanceof HttpPort) {
                HttpPort port = (HttpPort)child;
                Server server = HttpManagement.this._server;
                if (server != null) {
                    ServerConnector connector = null;
                    try {
                        connector = HttpManagement.this.createConnector(port, server);
                        connector.addBean((Object)new ConnectionTrackingListener());
                        server.addConnector((Connector)connector);
                        connector.start();
                        HttpManagement.this._portConnectorMap.put(port, connector);
                        HttpManagement.this.logOperationalListenMessages(port, connector.getLocalPort());
                    }
                    catch (Exception e) {
                        if (connector != null) {
                            server.removeConnector((Connector)connector);
                        }
                        LOGGER.warn("HTTP management connector creation failed for http port {}", (Object)port, (Object)e);
                    }
                }
            }
        }

        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (child instanceof HttpPort) {
                HttpPort port = (HttpPort)child;
                Server server = HttpManagement.this._server;
                if (server != null) {
                    HttpManagement.this._sslContextFactoryMap.remove(port);
                    final ServerConnector connector = HttpManagement.this._portConnectorMap.remove(port);
                    if (connector != null) {
                        final int localPort = connector.getLocalPort();
                        final ConnectionTrackingListener tracker = (ConnectionTrackingListener)connector.getBean(ConnectionTrackingListener.class);
                        connector.close();
                        connector.setIdleTimeout(1L);
                        connector.getConnectedEndPoints().forEach(endPoint -> endPoint.setIdleTimeout(1L));
                        LOGGER.debug("Connector has {} connection(s)", (Object)tracker.getConnectionCount());
                        final TaskExecutor taskExecutor = HttpManagement.this.getBroker().getTaskExecutor();
                        tracker.getAllClosedFuture().whenCompleteAsync((BiConsumer)new BiConsumer<Void, Throwable>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void accept(Void unused, Throwable throwable) {
                                int connectionCount = tracker.getConnectionCount();
                                if (connectionCount == 0) {
                                    LOGGER.debug("Stopping connector for http port {}", (Object)localPort);
                                    try {
                                        connector.stop();
                                    }
                                    catch (Exception e) {
                                        LOGGER.warn("Failed to stop connector for http port {}", (Object)localPort, (Object)e);
                                    }
                                    finally {
                                        HttpManagement.this.logOperationalShutdownMessage(localPort);
                                        HttpManagement.this._server.removeConnector((Connector)connector);
                                    }
                                } else {
                                    LOGGER.debug("Connector still has {} connection(s)", (Object)tracker.getConnectionCount());
                                    connector.getConnectedEndPoints().forEach(endPoint -> endPoint.setIdleTimeout(1L));
                                    tracker.getAllClosedFuture().whenCompleteAsync((BiConsumer)this, (Executor)taskExecutor);
                                }
                            }
                        }, (Executor)taskExecutor);
                    }
                }
            }
        }
    }

    private static class JettyUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private JettyUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            LOGGER.warn("Uncaught exception in HTTP management thread", throwable);
            Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (defaultUncaughtExceptionHandler != null && this.isCritical(throwable)) {
                defaultUncaughtExceptionHandler.uncaughtException(thread, throwable);
            }
        }

        private boolean isCritical(Throwable throwable) {
            return throwable instanceof Error || throwable instanceof ServerScopedRuntimeException;
        }
    }

    private static class JettyThreadGroup
    extends ThreadGroup {
        private final Thread.UncaughtExceptionHandler _uncaughtExceptionHandler;

        JettyThreadGroup(String name, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            super(name);
            this._uncaughtExceptionHandler = uncaughtExceptionHandler;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (this._uncaughtExceptionHandler != null) {
                this._uncaughtExceptionHandler.uncaughtException(thread, throwable);
            } else {
                LOGGER.warn("Uncaught exception in HTTP management thread, no default uncaught exception handler provided", throwable);
            }
        }
    }

    private static class ConnectionTrackingListener
    implements Connection.Listener {
        private final Map<Connection, CompletableFuture<Void>> _closeFutures = new ConcurrentHashMap<Connection, CompletableFuture<Void>>();

        private ConnectionTrackingListener() {
        }

        public void onOpened(Connection connection) {
            this._closeFutures.put(connection, new CompletableFuture());
        }

        public void onClosed(Connection connection) {
            CompletableFuture<Void> closeFuture = this._closeFutures.remove(connection);
            if (closeFuture != null) {
                closeFuture.complete(null);
            }
        }

        public CompletableFuture<Void> getAllClosedFuture() {
            return CompletableFuture.allOf(this._closeFutures.values().toArray(new CompletableFuture[0]));
        }

        public int getConnectionCount() {
            return this._closeFutures.size();
        }
    }

    private static class QBBTrackingThreadPool
    extends QueuedThreadPool {
        private final ThreadFactory _threadFactory;

        public QBBTrackingThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, ThreadGroup threadGroup) {
            super(maxThreads, minThreads, 60000, null, threadGroup);
            ThreadFactory connectorThreadFactory = runnable -> {
                Thread thread = super.newThread(runnable);
                thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                return thread;
            };
            this._threadFactory = QpidByteBuffer.createQpidByteBufferTrackingThreadFactory((ThreadFactory)connectorThreadFactory);
        }

        public Thread newThread(Runnable runnable) {
            return this._threadFactory.newThread(runnable);
        }
    }
}

