/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.nifi.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.services.nifi.client.NiFiAuthType;
import org.apache.ranger.services.nifi.client.NiFiClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiConnectionMgr {
    private static final Logger LOG = LoggerFactory.getLogger(NiFiConnectionMgr.class);
    static final String INVALID_URL_MSG = "NiFi URL must be a valid URL of the form http(s)://<hostname>(:<port>)/nifi-api/resources";

    public static NiFiClient getNiFiClient(String serviceName, Map<String, String> configs) throws Exception {
        String url = configs.get("nifi.url");
        NiFiConnectionMgr.validateNotBlank(url, "NiFi URL is required for " + serviceName);
        NiFiConnectionMgr.validateUrl(url);
        String authTypeStr = configs.get("nifi.authentication");
        NiFiConnectionMgr.validateNotBlank(authTypeStr, "Authentication Type is required for " + serviceName);
        NiFiAuthType authType = NiFiAuthType.valueOf(authTypeStr);
        LOG.debug("NiFiAuthType is " + authType.name());
        SSLContext sslContext = null;
        if (authType == NiFiAuthType.SSL) {
            if (!url.startsWith("https")) {
                throw new IllegalArgumentException("Authentication Type of SSL requires an https URL");
            }
            String keystore = configs.get("nifi.ssl.keystore");
            String keystoreType = configs.get("nifi.ssl.keystoreType");
            String keystorePassword = configs.get("nifi.ssl.keystorePassword");
            String truststore = configs.get("nifi.ssl.truststore");
            String truststoreType = configs.get("nifi.ssl.truststoreType");
            String truststorePassword = configs.get("nifi.ssl.truststorePassword");
            String useDefaultSSLContext = configs.get("nifi.ssl.use.default.context");
            if (!StringUtils.isBlank((String)useDefaultSSLContext) && "true".equalsIgnoreCase(useDefaultSSLContext)) {
                if (!(StringUtils.isBlank((String)keystore) && StringUtils.isBlank((String)keystoreType) && StringUtils.isBlank((String)keystorePassword) && StringUtils.isBlank((String)truststore) && StringUtils.isBlank((String)truststoreType) && StringUtils.isBlank((String)truststorePassword))) {
                    throw new IllegalArgumentException("Keystore and Truststore configuration cannot be provided when using default SSL context");
                }
                sslContext = SSLContext.getDefault();
            } else {
                NiFiConnectionMgr.validateNotBlank(keystore, "Keystore is required for " + serviceName + " with Authentication Type of SSL");
                NiFiConnectionMgr.validateNotBlank(keystoreType, "Keystore Type is required for " + serviceName + " with Authentication Type of SSL");
                NiFiConnectionMgr.validateNotBlank(keystorePassword, "Keystore Password is required for " + serviceName + " with Authentication Type of SSL");
                NiFiConnectionMgr.validateNotBlank(truststore, "Truststore is required for " + serviceName + " with Authentication Type of SSL");
                NiFiConnectionMgr.validateNotBlank(truststoreType, "Truststore Type is required for " + serviceName + " with Authentication Type of SSL");
                NiFiConnectionMgr.validateNotBlank(truststorePassword, "Truststore Password is required for " + serviceName + " with Authentication Type of SSL");
                LOG.debug("Creating SSLContext for NiFi connection");
                sslContext = NiFiConnectionMgr.createSslContext(keystore.trim(), keystorePassword.trim().toCharArray(), keystoreType.trim(), truststore.trim(), truststorePassword.trim().toCharArray(), truststoreType.trim(), "TLS");
            }
        }
        return new NiFiClient(url.trim(), sslContext);
    }

    public static HashMap<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        NiFiClient client;
        try {
            client = NiFiConnectionMgr.getNiFiClient(serviceName, configs);
        }
        catch (Exception e) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            BaseClient.generateResponseDataMap((boolean)false, (String)"Error creating NiFi client", (String)e.getMessage(), null, null, ret);
            return ret;
        }
        return client.connectionTest();
    }

    private static void validateNotBlank(String input, String message) {
        if (input == null || input.trim().isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void validateUrl(String url) {
        try {
            URI nifiUri = new URI(url);
            if (!nifiUri.getPath().endsWith("nifi-api/resources")) {
                throw new IllegalArgumentException(INVALID_URL_MSG);
            }
        }
        catch (URISyntaxException urie) {
            throw new IllegalArgumentException(INVALID_URL_MSG);
        }
    }

    private static SSLContext createSslContext(String keystore, char[] keystorePasswd, String keystoreType, String truststore, char[] truststorePasswd, String truststoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            keyStore.load(keyStoreStream, keystorePasswd);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePasswd);
        KeyStore trustStore = KeyStore.getInstance(truststoreType);
        try (FileInputStream trustStoreStream = new FileInputStream(truststore);){
            trustStore.load(trustStoreStream, truststorePasswd);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }
}

