/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import java.io.IOException;
import java.util.UUID;

public final class QueryId
implements IdentifiedDataSerializable {
    private long memberIdHigh;
    private long memberIdLow;
    private long localIdHigh;
    private long localIdLow;

    public QueryId() {
    }

    public QueryId(long memberIdHigh, long memberIdLow, long localIdHigh, long localIdLow) {
        this.memberIdHigh = memberIdHigh;
        this.memberIdLow = memberIdLow;
        this.localIdHigh = localIdHigh;
        this.localIdLow = localIdLow;
    }

    public static QueryId create(UUID memberId) {
        UUID localId = UuidUtil.newUnsecureUUID();
        return new QueryId(memberId.getMostSignificantBits(), memberId.getLeastSignificantBits(), localId.getMostSignificantBits(), localId.getLeastSignificantBits());
    }

    public static QueryId parse(String input) {
        assert (input != null);
        int underscorePos = input.indexOf("_");
        if (underscorePos < 0) {
            throw new IllegalArgumentException("Query ID is malformed: " + input);
        }
        try {
            UUID memberId = UUID.fromString(input.substring(0, underscorePos));
            UUID localId = UUID.fromString(input.substring(underscorePos + 1));
            return new QueryId(memberId.getMostSignificantBits(), memberId.getLeastSignificantBits(), localId.getMostSignificantBits(), localId.getLeastSignificantBits());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Query ID is malformed: " + input, e);
        }
    }

    public UUID getMemberId() {
        return new UUID(this.memberIdHigh, this.memberIdLow);
    }

    public UUID getLocalId() {
        return new UUID(this.localIdHigh, this.localIdLow);
    }

    public long getMemberIdHigh() {
        return this.memberIdHigh;
    }

    public long getMemberIdLow() {
        return this.memberIdLow;
    }

    public long getLocalIdHigh() {
        return this.localIdHigh;
    }

    public long getLocalIdLow() {
        return this.localIdLow;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.memberIdHigh);
        out.writeLong(this.memberIdLow);
        out.writeLong(this.localIdHigh);
        out.writeLong(this.localIdLow);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.memberIdHigh = in.readLong();
        this.memberIdLow = in.readLong();
        this.localIdHigh = in.readLong();
        this.localIdLow = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryId other = (QueryId)o;
        return this.memberIdHigh == other.memberIdHigh && this.memberIdLow == other.memberIdLow && this.localIdHigh == other.localIdHigh && this.localIdLow == other.localIdLow;
    }

    public int hashCode() {
        int result = (int)(this.memberIdHigh ^ this.memberIdHigh >>> 32);
        result = 31 * result + (int)(this.memberIdLow ^ this.memberIdLow >>> 32);
        result = 31 * result + (int)(this.localIdHigh ^ this.localIdHigh >>> 32);
        result = 31 * result + (int)(this.localIdLow ^ this.localIdLow >>> 32);
        return result;
    }

    public String toString() {
        return this.getMemberId() + "_" + this.getLocalId();
    }
}

